/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.streaming.StreamingDelimiters;
import org.joda.time.DateTime;

public final class StorageUtil {
    private static Map<Byte, byte[]> TYPE_INDICATOR = new HashMap<Byte, byte[]>();
    public static final StreamingDelimiters DEFAULT_DELIMITERS;

    public static byte parseFieldDel(String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Null delimiter");
        }
        if ((delimiter = StorageUtil.parseSingleQuotedString(delimiter)).length() > 1 && delimiter.charAt(0) != '\\') {
            throw new IllegalArgumentException("Delimeter must be a single character " + delimiter);
        }
        int fieldDel = 9;
        if (delimiter.length() == 1) {
            fieldDel = (byte)delimiter.charAt(0);
        } else if (delimiter.charAt(0) == '\\') {
            switch (delimiter.charAt(1)) {
                case 't': {
                    fieldDel = 9;
                    break;
                }
                case 'x': {
                    fieldDel = Integer.valueOf(delimiter.substring(2), 16).byteValue();
                    break;
                }
                case 'u': {
                    fieldDel = Integer.valueOf(delimiter.substring(2)).byteValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown delimiter " + delimiter);
                }
            }
        }
        return (byte)fieldDel;
    }

    public static void putField(OutputStream out, Object field) throws IOException {
        StorageUtil.putField(out, field, DEFAULT_DELIMITERS, false);
    }

    public static void putField(OutputStream out, Object field, boolean includeTypeInformation) throws IOException {
        StorageUtil.putField(out, field, DEFAULT_DELIMITERS, includeTypeInformation);
    }

    public static void putField(OutputStream out, Object field, StreamingDelimiters delims, boolean includeTypeInformation) throws IOException {
        switch (DataType.findType(field)) {
            case 1: {
                out.write(delims.getNull());
                break;
            }
            case 5: {
                StorageUtil.writeField(out, ((Boolean)field).toString().getBytes(Charset.defaultCharset()), (byte)5, includeTypeInformation);
                break;
            }
            case 10: {
                StorageUtil.writeField(out, ((Integer)field).toString().getBytes(Charset.defaultCharset()), (byte)10, includeTypeInformation);
                break;
            }
            case 15: {
                StorageUtil.writeField(out, ((Long)field).toString().getBytes(Charset.defaultCharset()), (byte)15, includeTypeInformation);
                break;
            }
            case 20: {
                StorageUtil.writeField(out, ((Float)field).toString().getBytes(Charset.defaultCharset()), (byte)20, includeTypeInformation);
                break;
            }
            case 25: {
                StorageUtil.writeField(out, ((Double)field).toString().getBytes(Charset.defaultCharset()), (byte)25, includeTypeInformation);
                break;
            }
            case 65: {
                StorageUtil.writeField(out, ((BigInteger)field).toString().getBytes(Charset.defaultCharset()), (byte)65, includeTypeInformation);
                break;
            }
            case 70: {
                StorageUtil.writeField(out, ((BigDecimal)field).toString().getBytes(Charset.defaultCharset()), (byte)70, includeTypeInformation);
                break;
            }
            case 30: {
                StorageUtil.writeField(out, ((DateTime)field).toString().getBytes(Charset.defaultCharset()), (byte)30, includeTypeInformation);
                break;
            }
            case 50: {
                StorageUtil.writeField(out, ((DataByteArray)field).get(), (byte)50, includeTypeInformation);
                break;
            }
            case 55: {
                StorageUtil.writeField(out, ((String)field).getBytes(Charsets.UTF_8), (byte)55, includeTypeInformation);
                break;
            }
            case 100: {
                boolean mapHasNext = false;
                Map m = (Map)field;
                out.write(delims.getMapBegin());
                for (Map.Entry e : m.entrySet()) {
                    if (mapHasNext) {
                        out.write(delims.getFieldDelim());
                    } else {
                        mapHasNext = true;
                    }
                    StorageUtil.putField(out, e.getKey(), delims, includeTypeInformation);
                    out.write(delims.getMapKeyDelim());
                    StorageUtil.putField(out, e.getValue(), delims, includeTypeInformation);
                }
                out.write(delims.getMapEnd());
                break;
            }
            case 110: {
                boolean tupleHasNext = false;
                Tuple t = (Tuple)field;
                out.write(delims.getTupleBegin());
                for (int i = 0; i < t.size(); ++i) {
                    if (tupleHasNext) {
                        out.write(delims.getFieldDelim());
                    } else {
                        tupleHasNext = true;
                    }
                    StorageUtil.putField(out, t.get(i), delims, includeTypeInformation);
                    continue;
                }
                out.write(delims.getTupleEnd());
                break;
            }
            case 120: {
                boolean bagHasNext = false;
                out.write(delims.getBagBegin());
                Iterator<Tuple> tupleIter = ((DataBag)field).iterator();
                while (tupleIter.hasNext()) {
                    if (bagHasNext) {
                        out.write(delims.getFieldDelim());
                    } else {
                        bagHasNext = true;
                    }
                    StorageUtil.putField(out, tupleIter.next(), delims, includeTypeInformation);
                }
                out.write(delims.getBagEnd());
                break;
            }
            default: {
                int errCode = 2108;
                String msg = "Could not determine data type of field: " + field;
                throw new ExecException(msg, errCode, 4);
            }
        }
    }

    private static void writeField(OutputStream out, byte[] bytes, byte dataType, boolean includeTypeInformation) throws IOException {
        if (includeTypeInformation) {
            out.write(TYPE_INDICATOR.get(dataType));
        }
        out.write(bytes);
    }

    public static Tuple textToTuple(Text val, byte fieldDel) {
        return StorageUtil.bytesToTuple(val.getBytes(), 0, val.getLength(), fieldDel);
    }

    public static Tuple bytesToTuple(byte[] buf, int offset, int length, byte fieldDel) {
        int start = offset;
        ArrayList<Object> protoTuple = new ArrayList<Object>();
        for (int i = offset; i < length; ++i) {
            if (buf[i] != fieldDel) continue;
            StorageUtil.readField(protoTuple, buf, start, i);
            start = i + 1;
        }
        if (start <= length) {
            StorageUtil.readField(protoTuple, buf, start, length);
        }
        return TupleFactory.getInstance().newTupleNoCopy(protoTuple);
    }

    private static void readField(ArrayList<Object> protoTuple, byte[] buf, int start, int end) {
        if (start == end) {
            protoTuple.add(null);
        } else {
            protoTuple.add(new DataByteArray(buf, start, end));
        }
    }

    private static String parseSingleQuotedString(String delimiter) {
        int endIndex;
        int startIndex = 0;
        while (startIndex < delimiter.length() && delimiter.charAt(startIndex++) != '\'') {
        }
        for (endIndex = startIndex; endIndex < delimiter.length() && delimiter.charAt(endIndex) != '\''; ++endIndex) {
            if (delimiter.charAt(endIndex) != '\\') continue;
            ++endIndex;
        }
        return endIndex < delimiter.length() ? delimiter.substring(startIndex, endIndex) : delimiter;
    }

    static {
        TYPE_INDICATOR.put((byte)5, new byte[]{66});
        TYPE_INDICATOR.put((byte)10, new byte[]{73});
        TYPE_INDICATOR.put((byte)15, new byte[]{76});
        TYPE_INDICATOR.put((byte)20, new byte[]{70});
        TYPE_INDICATOR.put((byte)25, new byte[]{68});
        TYPE_INDICATOR.put((byte)50, new byte[]{65});
        TYPE_INDICATOR.put((byte)55, new byte[]{67});
        TYPE_INDICATOR.put((byte)30, new byte[]{84});
        TYPE_INDICATOR.put((byte)65, new byte[]{78});
        TYPE_INDICATOR.put((byte)70, new byte[]{69});
        DEFAULT_DELIMITERS = new StreamingDelimiters();
    }
}

