/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.ResourceNotFoundException;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.AstValidator;
import org.apache.pig.parser.LogicalPlanGenerator;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.PigMacro;
import org.apache.pig.parser.PigParserNode;
import org.apache.pig.parser.QueryLexer;
import org.apache.pig.parser.QueryParser;
import org.apache.pig.parser.QueryParserStringStream;
import org.apache.pig.parser.QueryParserUtils;
import org.apache.pig.parser.RegisterResolver;
import org.apache.pig.parser.SourceLocation;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.validator.BlackAndWhitelistFilter;
import org.apache.pig.validator.PigCommandFilter;

public class QueryParserDriver {
    private static final Log LOG = LogFactory.getLog(QueryParserDriver.class);
    private static final String MACRO_DEF = "MACRO_DEF";
    private static final String MACRO_INLINE = "MACRO_INLINE";
    private static final String IMPORT_DEF = "import";
    private static final String REGISTER_DEF = "register";
    private PigContext pigContext;
    private PigServer pigServer;
    private String scope;
    private Map<String, String> fileNameMap;
    private Map<String, Operator> operators;
    private String lastRel;
    private Set<String> importSeen;
    private Set<String> macroSeen;
    private static Map<String, FileLocalizer.FetchFileRet> fnameMap = new HashMap<String, FileLocalizer.FetchFileRet>();

    public QueryParserDriver(PigContext pigContext, String scope, Map<String, String> fileNameMap) {
        this.pigContext = pigContext;
        this.pigServer = null;
        this.scope = scope;
        this.fileNameMap = fileNameMap;
        this.importSeen = new HashSet<String>();
        this.macroSeen = new HashSet<String>();
    }

    private static Tree parseSchema(CommonTokenStream tokens) throws ParserException {
        QueryParser parser = QueryParserUtils.createParser(tokens);
        QueryParser.schema_return result = null;
        try {
            result = parser.schema();
        }
        catch (RecognitionException e) {
            String msg = parser.getErrorHeader(e) + " " + parser.getErrorMessage(e, parser.getTokenNames());
            throw new ParserException(msg);
        }
        catch (RuntimeException ex) {
            throw new ParserException(ex.getMessage());
        }
        Tree ast = (Tree)result.getTree();
        QueryParserDriver.checkError((BaseRecognizer)parser);
        return ast;
    }

    public LogicalSchema parseSchema(String input) throws ParserException {
        CommonTokenStream tokenStream = QueryParserDriver.tokenize(input, null);
        LogicalSchema schema = null;
        Tree ast = QueryParserDriver.parseSchema(tokenStream);
        try {
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
            AstValidator walker = new AstValidator((TreeNodeStream)nodes);
            ast = (Tree)walker.field_def_list().getTree();
            QueryParserDriver.checkError((BaseRecognizer)walker);
            LogicalPlanGenerator planGenerator = new LogicalPlanGenerator((TreeNodeStream)new CommonTreeNodeStream((Object)ast), this.pigContext, this.scope, this.fileNameMap);
            schema = planGenerator.field_def_list().schema;
            QueryParserDriver.checkError((BaseRecognizer)planGenerator);
        }
        catch (RecognitionException ex) {
            throw new ParserException(ex);
        }
        catch (Exception ex) {
            throw new ParserException(ex.getMessage(), ex);
        }
        return schema;
    }

    private static Tree parseConstant(CommonTokenStream tokens) throws ParserException {
        QueryParser parser = QueryParserUtils.createParser(tokens);
        QueryParser.literal_return result = null;
        try {
            result = parser.literal();
        }
        catch (RecognitionException e) {
            String msg = parser.getErrorHeader(e) + " " + parser.getErrorMessage(e, parser.getTokenNames());
            throw new ParserException(msg);
        }
        catch (RuntimeException ex) {
            throw new ParserException(ex.getMessage());
        }
        Tree ast = (Tree)result.getTree();
        QueryParserDriver.checkError((BaseRecognizer)parser);
        return ast;
    }

    public Object parseConstant(String input) throws ParserException {
        CommonTokenStream tokenStream = QueryParserDriver.tokenize(input, null);
        Object value = null;
        Tree ast = QueryParserDriver.parseConstant(tokenStream);
        try {
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
            AstValidator walker = new AstValidator((TreeNodeStream)nodes);
            ast = (Tree)walker.literal().getTree();
            QueryParserDriver.checkError((BaseRecognizer)walker);
            LogicalPlanGenerator planGenerator = new LogicalPlanGenerator((TreeNodeStream)new CommonTreeNodeStream((Object)ast), this.pigContext, this.scope, this.fileNameMap);
            value = planGenerator.literal().value;
            QueryParserDriver.checkError((BaseRecognizer)planGenerator);
        }
        catch (RecognitionException ex) {
            throw new ParserException(ex);
        }
        catch (Exception ex) {
            throw new ParserException(ex.getMessage(), ex);
        }
        return value;
    }

    public LogicalPlan parse(String query) throws ParserException {
        LogicalPlan plan = null;
        ScriptState ss = ScriptState.get();
        CommonTokenStream tokenStream = QueryParserDriver.tokenize(query, ss.getFileName());
        Tree ast = QueryParserDriver.parse(tokenStream);
        ast = this.expandMacro(ast);
        try {
            ast = QueryParserDriver.validateAst(ast);
            this.applyRegisters(ast);
            LogicalPlanGenerator planGenerator = new LogicalPlanGenerator((TreeNodeStream)new CommonTreeNodeStream((Object)ast), this.pigContext, this.scope, this.fileNameMap);
            planGenerator.query();
            QueryParserDriver.checkError((BaseRecognizer)planGenerator);
            plan = planGenerator.getLogicalPlan();
            this.operators = planGenerator.getOperators();
            this.lastRel = planGenerator.getLastRel();
        }
        catch (RecognitionException ex) {
            throw new ParserException(ex);
        }
        catch (Exception ex) {
            throw new ParserException(ex.getMessage(), ex);
        }
        return plan;
    }

    public Map<String, Operator> getOperators() {
        return this.operators;
    }

    static CommonTokenStream tokenize(String query, String source) throws ParserException {
        QueryParserStringStream input;
        try {
            input = new QueryParserStringStream(query, source);
        }
        catch (IOException ex) {
            throw new ParserException("Unexpected IOException: " + ex.getMessage());
        }
        QueryLexer lexer = new QueryLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        QueryParserDriver.checkError((BaseRecognizer)lexer);
        return tokens;
    }

    private static void checkError(BaseRecognizer recognizer) throws ParserException {
        int errorCount = recognizer.getNumberOfSyntaxErrors();
        if (0 < errorCount) {
            throw new ParserException("Encountered " + errorCount + " parsing errors in the query");
        }
    }

    static Tree parse(CommonTokenStream tokens) throws ParserException {
        QueryParser parser = QueryParserUtils.createParser(tokens);
        QueryParser.query_return result = null;
        try {
            result = parser.query();
        }
        catch (RecognitionException e) {
            String msg = parser.getErrorHeader(e) + " " + parser.getErrorMessage(e, parser.getTokenNames());
            SourceLocation location = new SourceLocation(null, e.line, e.charPositionInLine);
            throw new ParserException(msg, location);
        }
        catch (RuntimeException ex) {
            throw new ParserException(ex.getMessage());
        }
        Tree ast = (Tree)result.getTree();
        QueryParserDriver.checkError((BaseRecognizer)parser);
        return ast;
    }

    private static Tree validateAst(Tree ast) throws RecognitionException, ParserException {
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        AstValidator walker = new AstValidator((TreeNodeStream)nodes);
        AstValidator.query_return newResult = walker.query();
        Tree newAst = (Tree)newResult.getTree();
        QueryParserDriver.checkError((BaseRecognizer)walker);
        return newAst;
    }

    Tree expandMacro(Tree ast) throws ParserException {
        LOG.debug((Object)("Original macro AST:\n" + ast.toStringTree() + "\n"));
        while (this.expandImport(ast)) {
        }
        LOG.debug((Object)("macro AST after import:\n" + ast.toStringTree() + "\n"));
        ArrayList<CommonTree> macroNodes = new ArrayList<CommonTree>();
        ArrayList<CommonTree> inlineNodes = new ArrayList<CommonTree>();
        QueryParserDriver.traverse(ast, macroNodes, inlineNodes);
        HashMap<String, PigMacro> seen = new HashMap<String, PigMacro>();
        ArrayList<PigMacro> macroDefs = new ArrayList<PigMacro>();
        for (CommonTree t : macroNodes) {
            macroDefs.add(this.makeMacroDef(t, seen));
        }
        this.inlineMacro(inlineNodes, macroDefs);
        LOG.debug((Object)("Resulting macro AST:\n" + ast.toStringTree() + "\n"));
        return ast;
    }

    private void inlineMacro(List<CommonTree> inlineNodes, List<PigMacro> macroDefs) throws ParserException {
        for (CommonTree t : inlineNodes) {
            HashSet<String> macroStack = new HashSet<String>();
            CommonTree newTree = PigMacro.macroInline(t, macroDefs, macroStack, this.pigContext);
            ArrayList<CommonTree> nodes = new ArrayList<CommonTree>();
            this.traverseInline((Tree)newTree, nodes);
            if (nodes.isEmpty()) {
                QueryParserUtils.replaceNodeWithNodeList((Tree)t, newTree, null);
                continue;
            }
            this.inlineMacro(nodes, macroDefs);
        }
    }

    private void applyRegisters(Tree t) throws ExecException, ParserException {
        if (t.getText().equalsIgnoreCase(REGISTER_DEF)) {
            String path = t.getChild(0).getText();
            path = path.substring(1, path.length() - 1);
            try {
                if (t.getChildCount() == 5) {
                    new RegisterResolver(this.getPigServer()).parseRegister(path, t.getChild(2).getText(), t.getChild(4).getText());
                }
                new RegisterResolver(this.getPigServer()).parseRegister(path, null, null);
            }
            catch (IOException ioe) {
                throw new ParserException(ioe.getMessage());
            }
        } else {
            for (int i = 0; i < t.getChildCount(); ++i) {
                this.applyRegisters(t.getChild(i));
            }
        }
    }

    private PigServer getPigServer() throws ExecException {
        if (this.pigServer == null) {
            this.pigServer = new PigServer(this.pigContext, false);
        }
        return this.pigServer;
    }

    private void traverseInline(Tree t, List<CommonTree> nodes) {
        if (t.getText().equals(MACRO_INLINE)) {
            nodes.add((CommonTree)t);
        }
        int n = t.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree t0 = t.getChild(i);
            this.traverseInline(t0, nodes);
        }
    }

    private boolean expandImport(Tree ast) throws ParserException {
        ArrayList<CommonTree> nodes = new ArrayList<CommonTree>();
        QueryParserDriver.traverseImport(ast, nodes);
        if (nodes.isEmpty()) {
            return false;
        }
        BlackAndWhitelistFilter filter = new BlackAndWhitelistFilter(this.pigContext);
        try {
            filter.validate(PigCommandFilter.Command.IMPORT);
        }
        catch (FrontendException e) {
            throw new ParserException(e.getMessage());
        }
        for (CommonTree t : nodes) {
            this.macroImport(t);
        }
        return true;
    }

    static void traverseImport(Tree t, List<CommonTree> nodes) {
        if (t.getText().equalsIgnoreCase(IMPORT_DEF)) {
            nodes.add((CommonTree)t);
        }
        int n = t.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree t0 = t.getChild(i);
            QueryParserDriver.traverseImport(t0, nodes);
        }
    }

    static void traverse(Tree t, List<CommonTree> macroNodes, List<CommonTree> inlineNodes) {
        if (t.getText().equals(MACRO_DEF)) {
            macroNodes.add((CommonTree)t.getParent());
        } else if (t.getText().equals(MACRO_INLINE)) {
            inlineNodes.add((CommonTree)t);
        }
        int n = t.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree t0 = t.getChild(i);
            QueryParserDriver.traverse(t0, macroNodes, inlineNodes);
        }
    }

    private FileLocalizer.FetchFileRet getMacroFile(String fname) {
        FileLocalizer.FetchFileRet localFileRet;
        block8: {
            localFileRet = null;
            try {
                if (fnameMap.get(fname) != null) {
                    localFileRet = fnameMap.get(fname);
                    break block8;
                }
                try {
                    File localFile = QueryParserUtils.getFileFromImportSearchPath(fname);
                    localFileRet = localFile == null ? FileLocalizer.fetchFile(this.pigContext.getProperties(), fname) : new FileLocalizer.FetchFileRet(localFile.getCanonicalFile(), false);
                }
                catch (FileNotFoundException e) {
                    LOG.debug((Object)String.format("Macro file %s was not found", fname));
                }
                if (localFileRet == null) {
                    LOG.debug((Object)String.format("Attempting to load macro file %s as a resource", fname));
                    try {
                        localFileRet = FileLocalizer.fetchResource(fname);
                        LOG.debug((Object)String.format("Found macro file %s as resource", fname));
                    }
                    catch (ResourceNotFoundException e) {
                        LOG.debug((Object)String.format("Macro file %s was not found as resource either", fname));
                        LOG.error((Object)String.format("Failed to find macro file %s", fname));
                        throw new ExecException("file '" + fname + "' does not exist.", 101, 2);
                    }
                }
                fnameMap.put(fname, localFileRet);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to fetch macro file '" + fname + "'", e);
            }
        }
        return localFileRet;
    }

    private PigMacro makeMacroDef(CommonTree t, Map<String, PigMacro> seen) throws ParserException {
        String mn = t.getChild(0).getText();
        if (!this.macroSeen.add(mn)) {
            String msg = this.getErrorMessage(null, t, null, "Duplicated macro name '" + mn + "'");
            throw new ParserException(msg);
        }
        if (seen != null) {
            for (String s : seen.keySet()) {
                this.macroSeen.add(s);
            }
        }
        String fname = ((PigParserNode)t).getFileName();
        Tree defNode = t.getChild(1);
        ArrayList<String> params = new ArrayList<String>();
        Tree paramNode = defNode.getChild(0);
        int n = paramNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            params.add(paramNode.getChild(i).getText());
        }
        ArrayList<String> returns = new ArrayList<String>();
        Tree retNode = defNode.getChild(1);
        int m = retNode.getChildCount();
        for (int i = 0; i < m; ++i) {
            returns.add(retNode.getChild(i).getText());
        }
        Tree bodyNode = defNode.getChild(2);
        String body = bodyNode.getChild(0).getText();
        body = body.substring(1, body.length() - 1);
        if (!fname.isEmpty()) {
            FileLocalizer.FetchFileRet localFileRet = this.getMacroFile(fname);
            fname = localFileRet.file.getAbsolutePath();
        }
        PigMacro pm = new PigMacro(mn, fname, params, returns, body, seen);
        try {
            pm.validate();
        }
        catch (IOException e) {
            String msg = this.getErrorMessage(null, t, "Invalid macro definition: ", e.getMessage());
            throw new ParserException(msg);
        }
        PigParserNode pnode = (PigParserNode)bodyNode.getChild(0);
        pm.setStartLine(pnode.getStartLine());
        seen.put(mn, pm);
        Tree defineNode = t.getParent();
        Tree stmtNode = defineNode.getParent();
        stmtNode.deleteChild(defineNode.getChildIndex());
        return pm;
    }

    private void macroImport(CommonTree t) throws ParserException {
        String fname = t.getChild(0).getText();
        if (!this.importSeen.add(fname = QueryParserUtils.removeQuotes(fname))) {
            LOG.debug((Object)("Ignoring duplicated import " + fname));
            t.getParent().deleteChild(t.getChildIndex());
            return;
        }
        Tree macroAST = null;
        if (this.pigContext.macros.containsKey(fname)) {
            macroAST = this.pigContext.macros.get(fname);
        } else {
            FileLocalizer.FetchFileRet localFileRet = this.getMacroFile(fname);
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(localFileRet.file));
            }
            catch (FileNotFoundException e) {
                String msg = this.getErrorMessage(fname, t, "Failed to import file '" + fname + "'", e.getMessage());
                throw new ParserException(msg);
            }
            StringBuilder sb = new StringBuilder();
            String line = null;
            try {
                line = in.readLine();
                while (line != null) {
                    sb.append(line).append("\n");
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                String msg = this.getErrorMessage(fname, t, "Failed to read file '" + fname + "'", e.getMessage());
                throw new ParserException(msg);
            }
            String macroText = null;
            try {
                in.close();
                in = new BufferedReader(new StringReader(sb.toString()));
                macroText = this.pigContext.doParamSubstitution(in);
            }
            catch (IOException e) {
                String msg = this.getErrorMessage(fname, t, "Parameter sustitution failed for macro.", e.getMessage());
                throw new ParserException(msg);
            }
            CommonTokenStream tokenStream = QueryParserDriver.tokenize(macroText, fname);
            try {
                macroAST = QueryParserDriver.parse(tokenStream);
                this.pigContext.macros.put(fname, macroAST);
            }
            catch (RuntimeException ex) {
                throw new ParserException(ex.getMessage());
            }
        }
        QueryParserUtils.replaceNodeWithNodeList((Tree)t, (CommonTree)macroAST, fname);
    }

    private String getErrorMessage(String importFile, CommonTree t, String header, String reason) {
        ScriptState ss;
        StringBuilder sb = new StringBuilder();
        PigParserNode node = (PigParserNode)t;
        String file = node.getFileName();
        sb.append("<");
        if (file == null && (ss = ScriptState.get()) != null) {
            file = ss.getFileName();
        }
        if (!file.isEmpty() && !file.equals(importFile)) {
            sb.append("at ").append(file).append(", ");
        }
        sb.append("line ").append(t.getLine()).append("> ").append(header);
        if (reason != null) {
            sb.append(". Reason: ").append(reason);
        }
        return sb.toString();
    }

    public String getLastRel() {
        return this.lastRel;
    }
}

