/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool;

import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandleImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionPoolConnection;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.hbase.shim.spi.HBaseConnection;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HBaseConnectionPool
implements Closeable {
    private final Set<HBaseConnectionPoolConnection> availableConnections;
    private final Set<HBaseConnectionPoolConnection> inUseConnections;
    private final HBaseShim hBaseShim;
    private final Properties connectionProps;
    private final LogChannelInterface logChannelInterface;

    public HBaseConnectionPool(HBaseShim hBaseShim, Properties connectionProps, LogChannelInterface logChannelInterface) {
        this.hBaseShim = hBaseShim;
        this.connectionProps = connectionProps;
        this.logChannelInterface = logChannelInterface;
        this.availableConnections = new HashSet<HBaseConnectionPoolConnection>();
        this.inUseConnections = new HashSet<HBaseConnectionPoolConnection>();
    }

    private HBaseConnectionPoolConnection findBestMatch(String sourceTable) {
        HBaseConnectionPoolConnection match = null;
        for (HBaseConnectionPoolConnection availableConnection : this.availableConnections) {
            String availableConnectionSourceTable = availableConnection.getSourceTable();
            if (sourceTable == null) {
                if (availableConnectionSourceTable != null) continue;
                return availableConnection;
            }
            if (availableConnectionSourceTable == null) {
                match = availableConnection;
                continue;
            }
            if (!sourceTable.equals(availableConnectionSourceTable)) continue;
            return availableConnection;
        }
        if (match == null && this.availableConnections.size() > 0) {
            return this.availableConnections.iterator().next();
        }
        return match;
    }

    private HBaseConnectionPoolConnection findBestMatch(String targetTable, Properties targetTableProps) {
        HBaseConnectionPoolConnection match = null;
        for (HBaseConnectionPoolConnection availableConnection : this.availableConnections) {
            String availableConnectionTargetTable = availableConnection.getTargetTable();
            if (targetTable == null) {
                if (availableConnectionTargetTable != null) continue;
                return availableConnection;
            }
            if (availableConnectionTargetTable == null) {
                match = availableConnection;
                continue;
            }
            if (!targetTable.equals(availableConnectionTargetTable)) continue;
            Properties availableConnectionTargetTableProperties = availableConnection.getTargetTableProperties();
            if (!(targetTableProps == null ? availableConnectionTargetTableProperties == null : targetTableProps.equals(availableConnectionTargetTableProperties))) continue;
            return availableConnection;
        }
        if (match == null && this.availableConnections.size() > 0) {
            return this.availableConnections.iterator().next();
        }
        return match;
    }

    private HBaseConnectionPoolConnection findBestMatch() {
        HBaseConnectionPoolConnection match = null;
        for (HBaseConnectionPoolConnection availableConnection : this.availableConnections) {
            String sourceTable = availableConnection.getSourceTable();
            String targetTable = availableConnection.getTargetTable();
            if (targetTable == null) {
                if (sourceTable == null) {
                    return availableConnection;
                }
                match = availableConnection;
                continue;
            }
            if (sourceTable != null || match != null) continue;
            match = availableConnection;
        }
        if (match == null && this.availableConnections.size() > 0) {
            return this.availableConnections.iterator().next();
        }
        return match;
    }

    private HBaseConnectionPoolConnection create() throws IOException {
        HBaseConnection hBaseConnection = this.hBaseShim.getHBaseConnection();
        try {
            ArrayList messages = new ArrayList();
            hBaseConnection.configureConnection(this.connectionProps, messages);
            if (this.logChannelInterface != null) {
                for (String message : messages) {
                    this.logChannelInterface.logBasic(message);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new HBaseConnectionPoolConnection(hBaseConnection);
    }

    public synchronized HBaseConnectionHandle getConnectionHandle(String sourceTable) throws IOException {
        HBaseConnectionPoolConnection result = this.findBestMatch(sourceTable);
        if (result != null) {
            this.availableConnections.remove((Object)result);
        } else {
            result = this.create();
        }
        if (sourceTable != null && !sourceTable.equals(result.getSourceTable())) {
            try {
                result.newSourceTableInternal(sourceTable);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.inUseConnections.add(result);
        return new HBaseConnectionHandleImpl(this, result);
    }

    public synchronized HBaseConnectionHandle getConnectionHandle(String targetTable, Properties targetTableProps) throws IOException {
        HBaseConnectionPoolConnection result = this.findBestMatch(targetTable, targetTableProps);
        if (result != null) {
            this.availableConnections.remove((Object)result);
        } else {
            result = this.create();
        }
        boolean targetTableDifferent = targetTable != null && !targetTable.equals(result.getTargetTable());
        boolean propsDifferent = false;
        Properties resultTargetTableProperties = result.getTargetTableProperties();
        propsDifferent = targetTableProps == null ? resultTargetTableProperties != null : targetTableProps.equals(resultTargetTableProperties);
        if (targetTableDifferent || propsDifferent) {
            try {
                result.newTargetTableInternal(targetTable, targetTableProps);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.inUseConnections.add(result);
        return new HBaseConnectionHandleImpl(this, result);
    }

    public synchronized HBaseConnectionHandle getConnectionHandle() throws IOException {
        HBaseConnectionPoolConnection result = this.findBestMatch();
        if (result != null) {
            this.availableConnections.remove((Object)result);
        } else {
            result = this.create();
        }
        this.inUseConnections.add(result);
        return new HBaseConnectionHandleImpl(this, result);
    }

    protected synchronized void releaseConnection(HBaseConnectionPoolConnection hBaseConnection) {
        this.inUseConnections.remove((Object)hBaseConnection);
        this.availableConnections.add(hBaseConnection);
    }

    @Override
    public synchronized void close() throws IOException {
        for (HBaseConnectionPoolConnection inUseConnection : this.inUseConnections) {
            try {
                inUseConnection.closeInternal();
            }
            catch (Exception e) {
                this.logChannelInterface.logError(e.getMessage(), (Throwable)e);
            }
        }
        for (HBaseConnectionPoolConnection availableConnection : this.availableConnections) {
            try {
                availableConnection.closeInternal();
            }
            catch (Exception e) {
                this.logChannelInterface.logError(e.getMessage(), (Throwable)e);
            }
        }
        this.inUseConnections.clear();
        this.availableConnections.clear();
    }
}

