/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.background;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.libraries.designtime.swing.background.ProgressFeed;
import org.pentaho.reporting.libraries.designtime.swing.background.WaitDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.WaitDialogMonitorThread;

public class BackgroundCancellableProcessHelper {
    private BackgroundCancellableProcessHelper() {
    }

    public static void executeProcessWithCancelDialog(Thread workerThread, CancelListener cancelListener, Component parent) {
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog(workerThread, cancelListener, parent, null, null);
    }

    public static void executeProcessWithCancelDialog(Thread workerThread, CancelListener cancelListener, Component parent, String message) {
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog(workerThread, cancelListener, parent, message, null);
    }

    public static void executeProcessWithCancelDialog(Thread workerThread, CancelListener cancelListener, Component parent, String message, ProgressFeed progressFeed) {
        WaitDialog waitDialog;
        if (workerThread == null) {
            throw new IllegalArgumentException();
        }
        if (message == null) {
            message = Messages.getInstance().getString("BackgroundCancellableProcessHelper.DefaultMessage");
        }
        workerThread.start();
        CreateWaitDialogTask dialogTask = new CreateWaitDialogTask(parent, cancelListener != null, progressFeed != null, message);
        if (SwingUtilities.isEventDispatchThread()) {
            dialogTask.run();
            waitDialog = dialogTask.getWaitDialog();
        } else {
            try {
                SwingUtilities.invokeAndWait(dialogTask);
            }
            catch (Exception e) {
                dialogTask.run();
            }
            waitDialog = dialogTask.getWaitDialog();
        }
        if (cancelListener != null) {
            waitDialog.addCancelListener(cancelListener);
        }
        if (workerThread.isAlive()) {
            WaitDialogMonitorThread monitorThread = new WaitDialogMonitorThread(workerThread, waitDialog, progressFeed);
            monitorThread.start();
            waitDialog.setVisible(true);
        }
    }

    protected static Window getWindowAncestor(Component component) {
        while (!(component instanceof Window)) {
            if (component == null) {
                return null;
            }
            component = component.getParent();
        }
        return (Window)component;
    }

    private static class CreateWaitDialogTask
    implements Runnable {
        private Component parent;
        private boolean allowCancel;
        private boolean showProgress;
        private String message;
        private WaitDialog waitDialog;

        private CreateWaitDialogTask(Component parent, boolean allowCancel, boolean showProgress, String message) {
            this.parent = parent;
            this.allowCancel = allowCancel;
            this.showProgress = showProgress;
            this.message = message;
        }

        public WaitDialog getWaitDialog() {
            return this.waitDialog;
        }

        @Override
        public void run() {
            Window w = BackgroundCancellableProcessHelper.getWindowAncestor(this.parent);
            this.waitDialog = w instanceof Frame ? new WaitDialog((Frame)w) : (w instanceof Dialog ? new WaitDialog((Dialog)w) : new WaitDialog());
            if (this.message != null) {
                this.waitDialog.setMessage(this.message);
            }
            this.waitDialog.setShowCancelButton(this.allowCancel);
            this.waitDialog.setShowProgressbar(this.showProgress);
            this.waitDialog.reinitComponents();
        }
    }
}

