/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.background;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;

public class WaitDialog
extends JDialog {
    private static final int PADDING = 8;
    private static final Log logger = LogFactory.getLog(WaitDialog.class);
    private List<CancelListener> cancelListeners = new ArrayList<CancelListener>();
    private JLabel message;
    private JProgressBar progressBar;
    private JPanel contentPane;
    private boolean showProgressbar;
    private boolean showCancelButton;

    public WaitDialog() {
        this.init();
    }

    public WaitDialog(Dialog parent) {
        super(parent);
        this.init();
    }

    public WaitDialog(Frame parent) {
        super(parent);
        this.init();
    }

    public void addCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }

    public void removeCancelListener(CancelListener listener) {
        this.cancelListeners.remove(listener);
    }

    private void init() {
        logger.debug((Object)"Initializing the Wait Dialog");
        this.setModal(true);
        this.setTitle(Messages.getInstance().getString("WaitDialog.TITLE"));
        this.message = new JLabel(Messages.getInstance().getString("WaitDialog.MESSAGE"));
        this.progressBar = new JProgressBar(0, 1000);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(8, 8));
        this.setContentPane(this.contentPane);
    }

    public void reinitComponents() {
        this.contentPane.removeAll();
        JPanel contentPanel = new JPanel(new FlowLayout(1));
        contentPanel.add(this.message);
        this.contentPane.add((Component)contentPanel, "Center");
        JPanel progressPanel = new JPanel(new FlowLayout(1));
        progressPanel.add(this.progressBar);
        this.contentPane.add((Component)progressPanel, "North");
        if (this.showCancelButton) {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 8, 8));
            JButton cancelButton = new JButton(new CancelActionListener());
            buttonPanel.add(cancelButton);
            this.contentPane.add((Component)buttonPanel, "South");
        }
        this.contentPane.invalidate();
        this.pack();
        LibSwingUtil.centerDialogInParent(this);
    }

    public void showDialog(boolean showCancel, boolean showProgress) {
        this.showCancelButton = showCancel;
        this.showProgressbar = showProgress;
        this.progressBar.setIndeterminate(!showProgress);
    }

    public boolean isShowProgressbar() {
        return this.showProgressbar;
    }

    public void setShowProgressbar(boolean showProgressbar) {
        this.showProgressbar = showProgressbar;
    }

    public boolean isShowCancelButton() {
        return this.showCancelButton;
    }

    public void setShowCancelButton(boolean showCancelButton) {
        this.showCancelButton = showCancelButton;
    }

    public double getProgress() {
        return this.progressBar.getPercentComplete();
    }

    public void setProgress(double p) {
        this.progressBar.setValue((int)(Math.max(Math.min(1.0, p), 0.0) * 1000.0));
    }

    public void updateProgress(double p) {
        SwingUtilities.invokeLater(new UpdateProgressTask(p));
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public void exit() {
        SwingUtilities.invokeLater(new DisposeTask());
    }

    private class UpdateProgressTask
    implements Runnable {
        private double progress;

        private UpdateProgressTask(double progress) {
            this.progress = progress;
        }

        @Override
        public void run() {
            try {
                WaitDialog.this.setProgress(this.progress);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class DisposeTask
    implements Runnable {
        private DisposeTask() {
        }

        @Override
        public void run() {
            WaitDialog.this.setVisible(false);
            WaitDialog.this.dispose();
        }
    }

    private class CancelActionListener
    extends AbstractAction {
        private CancelActionListener() {
            this.putValue("Name", Messages.getInstance().getString("WaitDialog.CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CancelEvent event = new CancelEvent(this);
            for (CancelListener cancelListener : WaitDialog.this.cancelListeners) {
                try {
                    if (cancelListener == null) continue;
                    logger.debug((Object)("Passing cancel action along to cancel listener [" + cancelListener + "]"));
                    cancelListener.cancelProcessing(event);
                }
                catch (Throwable ignored) {
                    logger.warn((Object)Messages.getInstance().formatMessage("WaitDialog.CANCEL_EXCEPTION", ignored.getLocalizedMessage()));
                }
            }
        }
    }
}

