/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.JsonUnmarshallerContextImpl;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidJsonUnmarshaller;
import com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import com.amazonaws.util.ValidationUtils;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private final JsonFactory jsonFactory;
    public boolean needsConnectionLeftOpen = false;
    private boolean isPayloadJson = true;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> simpleTypeUnmarshallers;

    @Deprecated
    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        this(responseUnmarshaller, SdkJsonProtocolFactory.DEFAULT_SCALAR_UNMARSHALLERS, SdkJsonProtocolFactory.DEFAULT_FACTORY);
    }

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> simpleTypeUnmarshallers, JsonFactory jsonFactory) {
        this.responseUnmarshaller = responseUnmarshaller != null ? responseUnmarshaller : new VoidJsonUnmarshaller();
        this.simpleTypeUnmarshallers = ValidationUtils.assertNotNull(simpleTypeUnmarshallers, "simple type unmarshallers");
        this.jsonFactory = ValidationUtils.assertNotNull(jsonFactory, "JSONFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace((Object)"Parsing service response JSON");
        String CRC32Checksum = response.getHeaders().get("x-amz-crc32");
        CRC32ChecksumCalculatingInputStream crc32ChecksumInputStream = null;
        JsonParser jsonParser = null;
        if (this.shouldParsePayloadAsJson()) {
            if (CRC32Checksum != null) {
                crc32ChecksumInputStream = new CRC32ChecksumCalculatingInputStream(response.getContent());
                jsonParser = this.jsonFactory.createParser((InputStream)crc32ChecksumInputStream);
            } else {
                jsonParser = this.jsonFactory.createParser(response.getContent());
            }
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            JsonUnmarshallerContextImpl unmarshallerContext = new JsonUnmarshallerContextImpl(jsonParser, this.simpleTypeUnmarshallers, response);
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            if (CRC32Checksum != null) {
                long serverSideCRC = Long.parseLong(CRC32Checksum);
                long clientSideCRC = crc32ChecksumInputStream.getCRC32Checksum();
                if (clientSideCRC != serverSideCRC) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            awsResponse.setResult(result);
            Map<String, String> metadata = ((JsonUnmarshallerContext)unmarshallerContext).getMetadata();
            metadata.put("AWS_REQUEST_ID", response.getHeaders().get("x-amzn-RequestId"));
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            if (this.shouldParsePayloadAsJson()) {
                try {
                    jsonParser.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing json parser", (Throwable)e);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    public void setNeedsConnectionLeftOpen(boolean needsConnectionLeftOpen) {
        this.needsConnectionLeftOpen = needsConnectionLeftOpen;
    }

    public void setIsPayloadJson(boolean parsePayloadAsJson) {
        this.isPayloadJson = parsePayloadAsJson;
    }

    private boolean shouldParsePayloadAsJson() {
        return !this.needsConnectionLeftOpen && this.isPayloadJson;
    }
}

