/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.security;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;

public class DataSourceLoginService
extends MappedLoginService {
    private static final Logger LOG = Log.getLogger(DataSourceLoginService.class);
    private String _jndiName = "javax.sql.DataSource/default";
    private DataSource _datasource;
    private Server _server;
    private String _userTableName = "users";
    private String _userTableKey = "id";
    private String _userTableUserField = "username";
    private String _userTablePasswordField = "pwd";
    private String _roleTableName = "roles";
    private String _roleTableKey = "id";
    private String _roleTableRoleField = "role";
    private String _userRoleTableName = "user_roles";
    private String _userRoleTableUserKey = "user_id";
    private String _userRoleTableRoleKey = "role_id";
    private int _cacheMs = 30000;
    private String _userSql;
    private String _roleSql;
    private boolean _createTables = false;

    public DataSourceLoginService() {
    }

    public DataSourceLoginService(String name) {
        this.setName(name);
    }

    public DataSourceLoginService(String name, IdentityService identityService) {
        this.setName(name);
        this.setIdentityService(identityService);
    }

    public void setJndiName(String jndi) {
        this._jndiName = jndi;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public void setCreateTables(boolean createTables) {
        this._createTables = createTables;
    }

    public boolean getCreateTables() {
        return this._createTables;
    }

    public void setUserTableName(String name) {
        this._userTableName = name;
    }

    public String getUserTableName() {
        return this._userTableName;
    }

    public String getUserTableKey() {
        return this._userTableKey;
    }

    public void setUserTableKey(String tableKey) {
        this._userTableKey = tableKey;
    }

    public String getUserTableUserField() {
        return this._userTableUserField;
    }

    public void setUserTableUserField(String tableUserField) {
        this._userTableUserField = tableUserField;
    }

    public String getUserTablePasswordField() {
        return this._userTablePasswordField;
    }

    public void setUserTablePasswordField(String tablePasswordField) {
        this._userTablePasswordField = tablePasswordField;
    }

    public String getRoleTableName() {
        return this._roleTableName;
    }

    public void setRoleTableName(String tableName) {
        this._roleTableName = tableName;
    }

    public String getRoleTableKey() {
        return this._roleTableKey;
    }

    public void setRoleTableKey(String tableKey) {
        this._roleTableKey = tableKey;
    }

    public String getRoleTableRoleField() {
        return this._roleTableRoleField;
    }

    public void setRoleTableRoleField(String tableRoleField) {
        this._roleTableRoleField = tableRoleField;
    }

    public String getUserRoleTableName() {
        return this._userRoleTableName;
    }

    public void setUserRoleTableName(String roleTableName) {
        this._userRoleTableName = roleTableName;
    }

    public String getUserRoleTableUserKey() {
        return this._userRoleTableUserKey;
    }

    public void setUserRoleTableUserKey(String roleTableUserKey) {
        this._userRoleTableUserKey = roleTableUserKey;
    }

    public String getUserRoleTableRoleKey() {
        return this._userRoleTableRoleKey;
    }

    public void setUserRoleTableRoleKey(String roleTableRoleKey) {
        this._userRoleTableRoleKey = roleTableRoleKey;
    }

    public void setCacheMs(int ms) {
        this._cacheMs = ms;
    }

    public int getCacheMs() {
        return this._cacheMs;
    }

    protected void loadUsers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UserIdentity loadUser(String userName) {
        Connection connection = null;
        try {
            this.initDb();
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement(this._userSql);
            statement.setObject(1, userName);
            ResultSet rs = statement.executeQuery();
            if (!rs.next()) return null;
            int key = rs.getInt(this._userTableKey);
            String credentials = rs.getString(this._userTablePasswordField);
            statement.close();
            statement = connection.prepareStatement(this._roleSql);
            statement.setInt(1, key);
            rs = statement.executeQuery();
            ArrayList<String> roles = new ArrayList<String>();
            while (rs.next()) {
                roles.add(rs.getString(this._roleTableRoleField));
            }
            statement.close();
            UserIdentity userIdentity = this.putUser(userName, (Credential)new Password(credentials), roles.toArray(new String[roles.size()]));
            return userIdentity;
        }
        catch (NamingException e) {
            LOG.warn("No datasource for " + this._jndiName, (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LOG.warn("Problem loading user info for " + userName, (Throwable)e);
            return null;
        }
        finally {
            if (connection != null) {
                try {
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (SQLException x) {
                        LOG.warn("Problem closing connection", (Throwable)x);
                        connection = null;
                    }
                }
                catch (Throwable throwable) {
                    connection = null;
                    throw throwable;
                }
            }
        }
    }

    public void initDb() throws NamingException, SQLException {
        if (this._datasource != null) {
            return;
        }
        InitialContext ic = new InitialContext();
        assert (ic != null);
        if (this._server != null) {
            try {
                this._datasource = (DataSource)NamingEntryUtil.lookup(this._server, this._jndiName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (this._datasource == null) {
            this._datasource = (DataSource)NamingEntryUtil.lookup(null, this._jndiName);
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTableName + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTableName + " r, " + this._userRoleTableName + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
        this.prepareTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTables() throws NamingException, SQLException {
        Connection connection = null;
        boolean autocommit = true;
        if (this._createTables) {
            try {
                connection = this.getConnection();
                autocommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                DatabaseMetaData metaData = connection.getMetaData();
                String tableName = metaData.storesLowerCaseIdentifiers() ? this._userTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._userTableName.toUpperCase(Locale.ENGLISH) : this._userTableName);
                ResultSet result = metaData.getTables(null, null, tableName, null);
                if (!result.next()) {
                    connection.createStatement().executeUpdate("create table " + this._userTableName + "(" + this._userTableKey + " integer," + this._userTableUserField + " varchar(100) not null unique," + this._userTablePasswordField + " varchar(20) not null, primary key(" + this._userTableKey + "))");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created table " + this._userTableName, new Object[0]);
                    }
                }
                result.close();
                tableName = metaData.storesLowerCaseIdentifiers() ? this._roleTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._roleTableName.toUpperCase(Locale.ENGLISH) : this._roleTableName);
                result = metaData.getTables(null, null, tableName, null);
                if (!result.next()) {
                    String str = "create table " + this._roleTableName + " (" + this._roleTableKey + " integer, " + this._roleTableRoleField + " varchar(100) not null unique, primary key(" + this._roleTableKey + "))";
                    connection.createStatement().executeUpdate(str);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created table " + this._roleTableName, new Object[0]);
                    }
                }
                result.close();
                tableName = metaData.storesLowerCaseIdentifiers() ? this._userRoleTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._userRoleTableName.toUpperCase(Locale.ENGLISH) : this._userRoleTableName);
                result = metaData.getTables(null, null, tableName, null);
                if (!result.next()) {
                    connection.createStatement().executeUpdate("create table " + this._userRoleTableName + " (" + this._userRoleTableUserKey + " integer, " + this._userRoleTableRoleKey + " integer, " + "primary key (" + this._userRoleTableUserKey + ", " + this._userRoleTableRoleKey + "))");
                    connection.createStatement().executeUpdate("create index indx_user_role on " + this._userRoleTableName + "(" + this._userRoleTableUserKey + ")");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created table " + this._userRoleTableName + " and index", new Object[0]);
                    }
                }
                result.close();
                connection.commit();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.setAutoCommit(autocommit);
                        connection.close();
                    }
                    catch (SQLException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Prepare tables", (Throwable)e);
                        }
                    }
                    finally {
                        connection = null;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("createTables false", new Object[0]);
        }
    }

    private Connection getConnection() throws NamingException, SQLException {
        this.initDb();
        return this._datasource.getConnection();
    }
}

