/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment;

import java.util.Hashtable;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public class Preferences {
    public static void loadDefaults() {
        if (Application.session.mount("$PREFERENCES").size() == 0) {
            Application.session.mount("$PREFERENCES").add(new Hashtable());
            Preferences.set("window.height", new Integer(600));
            Preferences.set("window.width", new Integer(800));
            Preferences.set("explorer.navigator.datasources.name.width", new Integer(30));
            Preferences.set("explorer.navigator.datasources.url.width", new Integer(250));
            Preferences.set("explorer.navigator.datasources.status.width", new Integer(30));
        }
        QueryBuilder.autoJoin = Preferences.getBoolean("querybuilder.auto-join", true);
        QueryBuilder.autoAlias = Preferences.getBoolean("querybuilder.auto-alias", true);
        QueryBuilder.useAlwaysQuote = Preferences.getBoolean("querybuilder.use-quote", true);
        QueryBuilder.loadObjectsAtOnce = Preferences.getBoolean("querybuilder.load-objects-at-once", true);
        QueryBuilder.selectAllColumns = Preferences.getBoolean("querybuilder.select-all-columns", true);
    }

    private static Hashtable get() {
        return (Hashtable)Application.session.mount("$PREFERENCES").get(0);
    }

    public static void set(String key, Object value) {
        Preferences.get().put(key, value);
    }

    public static boolean getBoolean(String key) {
        return (Boolean)Preferences.get().get(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (!Preferences.get().containsKey(key)) {
            Preferences.set(key, new Boolean(defaultValue));
        }
        return Preferences.getBoolean(key);
    }

    public static int getInteger(String key) {
        return (Integer)Preferences.get().get(key);
    }

    public static int getInteger(String key, int defaultValue) {
        if (!Preferences.get().containsKey(key)) {
            Preferences.set(key, new Integer(defaultValue));
        }
        return Preferences.getInteger(key);
    }

    public static String getString(String key) {
        return Preferences.get().get(key).toString();
    }

    public static String getString(String key, String defaultValue) {
        if (!Preferences.get().containsKey(key)) {
            Preferences.set(key, defaultValue);
        }
        return Preferences.getString(key);
    }
}

