/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.editor;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.editor.BuildBasePane;
import nickyb.sqleonardo.environment.ctrl.editor.BuildDelete;
import nickyb.sqleonardo.environment.ctrl.editor.BuildInsert;
import nickyb.sqleonardo.environment.ctrl.editor.BuildUpdate;
import nickyb.sqleonardo.environment.ctrl.editor.MaskBrowser;
import nickyb.sqleonardo.environment.ctrl.editor._BuildOwner;
import nickyb.sqleonardo.environment.mdi.ClientCommandEditor;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class DialogCommand
extends AbstractDialogConfirm
implements _BuildOwner {
    private String keycah;
    private QueryTokens.Table querytoken;
    private int step = 0;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private CommandButton btnBack;
    private MaskBrowser browser;
    private JTabbedPane tabs;

    public DialogCommand(String keycah, QueryTokens.Table querytoken) {
        super((Component)Application.window, "command", 640, 480);
        this.keycah = keycah;
        this.querytoken = querytoken;
        this.tabs = new JTabbedPane(3);
        this.tabs.addTab("delete", new BuildDelete(this));
        this.tabs.addTab("insert", new BuildInsert(this));
        this.tabs.addTab("update", new BuildUpdate(this));
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.browser = new MaskBrowser();
        this.cardPanel.add("first", this.browser);
        this.cardPanel.add("last", this.tabs);
        this.getContentPane().add(this.cardPanel);
        this.btnBack = this.insertButton(1, "< back");
    }

    protected void setBarEnabled(boolean b) {
        super.setBarEnabled(b);
        this.btnBack.setEnabled(this.step != 0);
    }

    protected void onOpen() {
        if (this.querytoken != null) {
            this.loadBuilders();
            this.showLast();
        } else {
            this.loadBrowser();
            this.showFirst();
        }
    }

    protected boolean onConfirm() {
        if (this.step == 0) {
            this.querytoken = this.browser.getSelectedItem();
            if (this.querytoken != null) {
                this.loadBuilders();
                this.showLast();
            } else {
                Application.alert("SQLeonardo", "Nothing selected!");
            }
        } else {
            int idx = this.tabs.getSelectedIndex();
            ClientCommandEditor client = (ClientCommandEditor)Application.window.getClient("command editor");
            client.getControl().append(((BuildBasePane)this.tabs.getComponentAt(idx)).getSyntax());
        }
        return false;
    }

    private void showFirst() {
        this.step = 0;
        this.btnBack.setEnabled(false);
        this.btnConfirm.setText("next >");
        this.cardLayout.show(this.cardPanel, "first");
    }

    private void showLast() {
        this.step = 1;
        this.btnBack.setEnabled(true);
        this.btnConfirm.setText("paste");
        this.cardLayout.show(this.cardPanel, "last");
    }

    public String getIdentifierQuoteString() {
        return ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
    }

    public String getTable() {
        return SQLFormatter.ensureQuotes(this.querytoken.getIdentifier(), this.getIdentifierQuoteString(), !QueryBuilder.useAlwaysQuote);
    }

    private void loadBrowser() {
        try {
            this.browser.setConnection(ConnectionAssistant.getHandler(this.keycah));
        }
        catch (SQLException e) {
            Application.println(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuilders() {
        ((BuildBasePane)this.tabs.getComponentAt(0)).clear();
        ((BuildBasePane)this.tabs.getComponentAt(1)).clear();
        ((BuildBasePane)this.tabs.getComponentAt(2)).clear();
        try {
            ConnectionHandler ch = ConnectionAssistant.getHandler(this.keycah);
            DatabaseMetaData dbmetadata = ch.get().getMetaData();
            String catalog = this.querytoken.getSchema() == null ? null : dbmetadata.getConnection().getCatalog();
            ResultSet rsColumns = dbmetadata.getColumns(catalog, this.querytoken.getSchema(), this.querytoken.getName(), "%");
            while (rsColumns.next()) {
                QueryTokens.Column qColumn = new QueryTokens.Column(null, rsColumns.getString(4));
                ((BuildBasePane)this.tabs.getComponentAt(0)).add(qColumn);
                ((BuildBasePane)this.tabs.getComponentAt(1)).add(qColumn);
                ((BuildBasePane)this.tabs.getComponentAt(2)).add(qColumn);
            }
            rsColumns.close();
        }
        catch (SQLException e) {
            Application.println(e, false);
        }
        finally {
            ((BuildBasePane)this.tabs.getComponentAt(0)).fireQueryChanged();
            ((BuildBasePane)this.tabs.getComponentAt(1)).fireQueryChanged();
            ((BuildBasePane)this.tabs.getComponentAt(2)).fireQueryChanged();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.btnBack) {
            this.loadBrowser();
            this.showFirst();
        } else {
            super.actionPerformed(ae);
        }
    }
}

