/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class QueryModelTreeCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon queryIcon;
    static ImageIcon whereIcon;
    static ImageIcon fromIcon;
    static ImageIcon selectIcon;
    static ImageIcon orderByIcon;
    static ImageIcon havingIcon;
    static ImageIcon fieldIcon;
    static ImageIcon expressionIcon;
    static ImageIcon groupByIcon;
    static ImageIcon tableIcon;
    static ImageIcon customFolderIcon;

    public QueryModelTreeCellRenderer() {
        Font f;
        if (queryIcon == null) {
            queryIcon = new ImageIcon(this.getClass().getResource("/images/page_white_database.png"));
        }
        if (whereIcon == null) {
            whereIcon = new ImageIcon(this.getClass().getResource("/images/filter.png"));
        }
        if (fromIcon == null) {
            fromIcon = new ImageIcon(this.getClass().getResource("/images/table_relationship.png"));
        }
        if (selectIcon == null) {
            selectIcon = new ImageIcon(this.getClass().getResource("/images/layout.png"));
        }
        if (tableIcon == null) {
            tableIcon = new ImageIcon(this.getClass().getResource("/images/database_table.png"));
        }
        if (orderByIcon == null) {
            orderByIcon = new ImageIcon(this.getClass().getResource("/images/table_sort.png"));
        }
        if (groupByIcon == null) {
            groupByIcon = new ImageIcon(this.getClass().getResource("/images/chart_organisation.png"));
        }
        if (havingIcon == null) {
            havingIcon = new ImageIcon(this.getClass().getResource("/images/filter.png"));
        }
        if (fieldIcon == null) {
            fieldIcon = new ImageIcon(this.getClass().getResource("/images/textfield.png"));
        }
        if (expressionIcon == null) {
            expressionIcon = new ImageIcon(this.getClass().getResource("/images/sum.png"));
        }
        if (customFolderIcon == null) {
            customFolderIcon = new ImageIcon(this.getClass().getResource("/images/bullet_pink.png"));
        }
        if ((f = this.getFont()) != null) {
            this.setFont(new Font(f.getName(), 0, f.getSize()));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel jlabel = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        jlabel.setForeground(Color.BLACK);
        ImageIcon icon = this.getElementIcon(value);
        jlabel.setIcon(icon);
        jlabel.setToolTipText(null);
        return jlabel;
    }

    protected ImageIcon getElementIcon(Object value) {
        if (value instanceof BrowserItems.ClauseTreeItem && (value.toString().equals("SELECT") || value.toString().equals("SELECT DISTINCT"))) {
            return selectIcon;
        }
        if (value instanceof BrowserItems.AbstractQueryTreeItem && !(value instanceof BrowserItems.ConditionQueryTreeItem)) {
            return queryIcon;
        }
        if (value instanceof BrowserItems.FromTreeItem) {
            return fromIcon;
        }
        if (value instanceof BrowserItems.ClauseTreeItem && value.toString().equals("ORDER BY")) {
            return orderByIcon;
        }
        if (value instanceof BrowserItems.ClauseTreeItem && value.toString().equals("GROUP BY")) {
            return groupByIcon;
        }
        if (value instanceof BrowserItems.ClauseTreeItem && value.toString().equals("HAVING")) {
            return havingIcon;
        }
        if (value instanceof BrowserItems.ClauseTreeItem && value.toString().equals("WHERE")) {
            return whereIcon;
        }
        if (value instanceof BrowserItems.DefaultTreeItem && ((BrowserItems.DefaultTreeItem)value).isQueryToken()) {
            if (((BrowserItems.DefaultTreeItem)value).getUserObject() instanceof QueryTokens.DefaultExpression) {
                return expressionIcon;
            }
            if (((BrowserItems.DefaultTreeItem)value).getUserObject() instanceof QueryTokens.Column) {
                return fieldIcon;
            }
            if (((BrowserItems.DefaultTreeItem)value).getUserObject() instanceof QueryTokens._TableReference) {
                return tableIcon;
            }
        }
        return customFolderIcon;
    }
}

