/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.olap4j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinitionManager;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.ConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.LimitRowsCheckBoxActionListener;
import org.pentaho.reporting.ui.datasources.jdbc.ui.NamedDataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.QueryLanguageListCellRenderer;
import org.pentaho.reporting.ui.datasources.olap4j.Messages;
import org.pentaho.reporting.ui.datasources.olap4j.Olap4JPreviewWorker;
import org.pentaho.reporting.ui.datasources.olap4j.OlapConnectionPanel;

public abstract class Olap4JDataSourceEditor
extends CommonDialog {
    protected static final Log logger = LogFactory.getLog(Olap4JDataSourceEditor.class);
    private JList queryNameList;
    private JTextField queryNameTextField;
    private JTextArea queryTextArea;
    private NamedDataSourceDialogModel dialogModel;
    private JSpinner maxPreviewRowsSpinner;
    private DataPreviewDialog previewDialog;
    private OlapConnectionPanel connectionComponent;
    private DesignTimeContext context;
    private RSyntaxTextArea globalScriptTextArea;
    private SmartComboBox<ScriptEngineFactory> globalLanguageField;
    private RSyntaxTextArea queryScriptTextArea;
    private SmartComboBox<ScriptEngineFactory> queryLanguageField;
    private QueryLanguageListCellRenderer queryLanguageListCellRenderer;
    private GlobalTemplateAction globalTemplateAction;
    private QueryTemplateAction queryTemplateAction;

    public Olap4JDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public Olap4JDataSourceEditor(DesignTimeContext context, Dialog owner) {
        super(owner);
        this.init(context);
    }

    public Olap4JDataSourceEditor(DesignTimeContext context, Frame owner) {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext designTimeContext) {
        this.setModal(true);
        this.context = designTimeContext;
        QueryNameTextFieldDocumentListener updateHandler = new QueryNameTextFieldDocumentListener();
        this.globalTemplateAction = new GlobalTemplateAction();
        this.queryTemplateAction = new QueryTemplateAction();
        this.dialogModel = new NamedDataSourceDialogModel(new JdbcConnectionDefinitionManager("org/pentaho/reporting/ui/datasources/olap4j/Settings"));
        this.dialogModel.addPropertyChangeListener("connectionSelected", (PropertyChangeListener)new ConfirmEnableHandler());
        this.dialogModel.getQueries().addListDataListener((ListDataListener)updateHandler);
        this.connectionComponent = new OlapConnectionPanel((DataSourceDialogModel)this.dialogModel, designTimeContext);
        this.connectionComponent.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.maxPreviewRowsSpinner = new JSpinner(new SpinnerNumberModel(10000, 1, Integer.MAX_VALUE, 1));
        this.queryNameTextField = new JTextField();
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.setEnabled(this.dialogModel.isQuerySelected());
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)updateHandler));
        this.queryTextArea = new JTextArea((String)null);
        this.queryTextArea.setWrapStyleWord(true);
        this.queryTextArea.setLineWrap(true);
        this.queryTextArea.setRows(10);
        this.queryTextArea.setColumns(50);
        this.queryTextArea.setEnabled(this.dialogModel.isQuerySelected());
        this.queryTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryDocumentListener()));
        this.queryNameList = new JList(this.dialogModel.getQueries());
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QuerySelectedHandler());
        this.globalScriptTextArea = new RSyntaxTextArea();
        this.globalScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.globalLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.globalLanguageField.setRenderer((ListCellRenderer)new QueryLanguageListCellRenderer());
        this.globalLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        this.queryScriptTextArea = new RSyntaxTextArea();
        this.queryScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.queryScriptTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryScriptDocumentListener()));
        this.queryLanguageListCellRenderer = new QueryLanguageListCellRenderer();
        this.queryLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.queryLanguageField.setRenderer((ListCellRenderer)this.queryLanguageListCellRenderer);
        this.queryLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        super.init();
    }

    private void updateComponents() {
        ScriptEngineFactory globalLanguage = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        this.globalScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)globalLanguage));
        this.queryLanguageListCellRenderer.setDefaultValue(globalLanguage);
        ScriptEngineFactory queryScriptLanguage = (ScriptEngineFactory)this.queryLanguageField.getSelectedItem();
        if (queryScriptLanguage == null) {
            this.queryScriptTextArea.setSyntaxEditingStyle(this.globalScriptTextArea.getSyntaxEditingStyle());
        } else {
            this.queryScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)queryScriptLanguage));
        }
        boolean querySelected = this.dialogModel.isQuerySelected();
        this.queryScriptTextArea.setEnabled(querySelected);
        this.queryLanguageField.setEnabled(querySelected);
        this.queryTemplateAction.update();
        if (!querySelected) {
            this.queryTemplateAction.setEnabled(false);
        }
        this.globalTemplateAction.update();
    }

    private JPanel createQueryScriptTab() {
        JPanel queryHeader2 = new JPanel(new BorderLayout());
        queryHeader2.add((Component)new JLabel(Messages.getString("Olap4JDataSourceEditor.QueryScript", new Object[0])), "Center");
        queryHeader2.add((Component)new JButton(this.queryTemplateAction), "East");
        JPanel queryScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        queryScriptHeader.add(new JLabel(Messages.getString("Olap4JDataSourceEditor.QueryScriptLanguage", new Object[0])));
        queryScriptHeader.add((Component)this.queryLanguageField);
        queryScriptHeader.add(queryHeader2);
        JPanel queryScriptContentHolder = new JPanel(new BorderLayout());
        queryScriptContentHolder.add((Component)queryScriptHeader, "North");
        queryScriptContentHolder.add((Component)new RTextScrollPane(700, 300, (RTextArea)this.queryScriptTextArea, true), "Center");
        return queryScriptContentHolder;
    }

    private JPanel createGlobalScriptTab() {
        JPanel globalHeader2 = new JPanel(new BorderLayout());
        globalHeader2.add((Component)new JLabel(Messages.getString("Olap4JDataSourceEditor.GlobalScript", new Object[0])), "Center");
        globalHeader2.add((Component)new JButton(this.globalTemplateAction), "East");
        JPanel globalScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        globalScriptHeader.add(new JLabel(Messages.getString("Olap4JDataSourceEditor.GlobalScriptLanguage", new Object[0])));
        globalScriptHeader.add((Component)this.globalLanguageField);
        globalScriptHeader.add(globalHeader2);
        JPanel globalScriptContentHolder = new JPanel(new BorderLayout());
        globalScriptContentHolder.add((Component)globalScriptHeader, "North");
        globalScriptContentHolder.add((Component)new RTextScrollPane(700, 600, (RTextArea)this.globalScriptTextArea, true), "Center");
        return globalScriptContentHolder;
    }

    protected Component createContentPane() {
        JPanel queryContentPanel = new JPanel(new BorderLayout());
        queryContentPanel.add("North", this.createQueryListPanel());
        queryContentPanel.add("Center", this.createQueryDetailsPanel());
        JPanel dialogContent = new JPanel(new BorderLayout());
        dialogContent.add("West", (Component)((Object)this.connectionComponent));
        dialogContent.add("Center", queryContentPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("Olap4JDataSourceEditor.DataSource", new Object[0]), dialogContent);
        tabbedPane.addTab(Messages.getString("Olap4JDataSourceEditor.GlobalScripting", new Object[0]), this.createGlobalScriptTab());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add("South", this.createPreviewButtonsPanel());
        contentPane.add("Center", tabbedPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return contentPane;
    }

    private JPanel createPreviewButtonsPanel() {
        JPanel previewButtonsPanel = new JPanel(new FlowLayout(2));
        previewButtonsPanel.add(new JCheckBox((Action)new LimitRowsCheckBoxActionListener(this.maxPreviewRowsSpinner)));
        previewButtonsPanel.add(this.maxPreviewRowsSpinner);
        PreviewAction thePreviewAction = new PreviewAction();
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)thePreviewAction);
        previewButtonsPanel.add(new JButton(thePreviewAction));
        return previewButtonsPanel;
    }

    private JPanel createQueryDetailsPanel() {
        JPanel queryNamePanel = new JPanel(new BorderLayout());
        queryNamePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        queryNamePanel.add((Component)new JLabel(Messages.getString("Olap4JDataSourceEditor.QueryNameLabel", new Object[0])), "North");
        queryNamePanel.add((Component)this.queryNameTextField, "South");
        JPanel queryControlsPanel = new JPanel(new BorderLayout());
        queryControlsPanel.add((Component)new JLabel(Messages.getString("Olap4JDataSourceEditor.QueryLabel", new Object[0])), "West");
        JPanel queryPanel = new JPanel(new BorderLayout());
        queryPanel.add((Component)queryControlsPanel, "North");
        queryPanel.add((Component)new JScrollPane(this.queryTextArea), "Center");
        queryPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        JTabbedPane queryScriptTabPane = new JTabbedPane();
        queryScriptTabPane.addTab(Messages.getString("Olap4JDataSourceEditor.StaticQuery", new Object[0]), queryPanel);
        queryScriptTabPane.addTab(Messages.getString("Olap4JDataSourceEditor.QueryScripting", new Object[0]), this.createQueryScriptTab());
        JPanel queryDetailsPanel = new JPanel(new BorderLayout());
        queryDetailsPanel.add("North", queryNamePanel);
        queryDetailsPanel.add("Center", queryScriptTabPane);
        return queryDetailsPanel;
    }

    private JPanel createQueryListPanel() {
        RemoveQueryAction queryRemoveAction = new RemoveQueryAction();
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)queryRemoveAction);
        JPanel theQueryButtonsPanel = new JPanel(new FlowLayout(2, 5, 5));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)new AddQueryAction()));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)queryRemoveAction));
        JPanel theQueryControlsPanel = new JPanel(new BorderLayout());
        theQueryControlsPanel.add((Component)new JLabel(Messages.getString("Olap4JDataSourceEditor.AvailableQueriesLabel", new Object[0])), "West");
        theQueryControlsPanel.add((Component)theQueryButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        queryListPanel.add("North", theQueryControlsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    public DataFactory performConfiguration(AbstractNamedMDXDataFactory dataFactory, String selectedQueryName) {
        this.dialogModel.clear();
        this.connectionComponent.setRoleField(null);
        if (dataFactory != null) {
            this.globalScriptTextArea.setText(dataFactory.getGlobalScript());
            this.setGlobalScriptingLanguage(dataFactory.getGlobalScriptLanguage());
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                String query = dataFactory.getQuery(queryName);
                String scriptLanguage = dataFactory.getScriptingLanguage(queryName);
                String script = dataFactory.getScript(queryName);
                this.dialogModel.addQuery(queryName, query, scriptLanguage, script);
            }
            this.dialogModel.setSelectedQuery(selectedQueryName);
            OlapConnectionProvider currentJNDISource = dataFactory.getConnectionProvider();
            JdbcConnectionDefinition definition = this.getConnectionPanel().createConnectionDefinition(currentJNDISource);
            this.getDialogModel().addConnection(definition);
            this.getDialogModel().getConnections().setSelectedItem(definition);
            this.getDialogModel().setJdbcUserField(dataFactory.getJdbcUserField());
            this.getDialogModel().setJdbcPasswordField(dataFactory.getJdbcPasswordField());
            this.connectionComponent.setRoleField(dataFactory.getRoleField());
        }
        if (!this.performEdit()) {
            return null;
        }
        return this.createDataFactory();
    }

    private void setGlobalScriptingLanguage(String lang) {
        this.setScriptingLanguage(lang, (JComboBox)this.globalLanguageField);
    }

    protected void setScriptingLanguage(String lang, JComboBox languageField) {
        if (lang == null) {
            languageField.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = languageField.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScriptEngineFactory elementAt = (ScriptEngineFactory)model.getElementAt(i);
            if (elementAt == null || !elementAt.getNames().contains(lang)) continue;
            languageField.setSelectedItem(elementAt);
            return;
        }
    }

    private String getGlobalScriptingLanguage() {
        ScriptEngineFactory selectedValue = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        if (selectedValue == null) {
            return null;
        }
        return selectedValue.getLanguageName();
    }

    protected OlapConnectionProvider createConnectionProvider() {
        JndiConnectionProvider connectionProvider;
        JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)this.getDialogModel().getConnections().getSelectedItem();
        if (connectionDefinition instanceof JndiConnectionDefinition) {
            JndiConnectionDefinition jcd = (JndiConnectionDefinition)connectionDefinition;
            JndiConnectionProvider provider = new JndiConnectionProvider();
            provider.setConnectionPath(jcd.getJndiName());
            provider.setUsername(jcd.getUsername());
            provider.setPassword(jcd.getPassword());
            connectionProvider = provider;
        } else if (connectionDefinition instanceof DriverConnectionDefinition) {
            DriverConnectionDefinition dcd = (DriverConnectionDefinition)connectionDefinition;
            DriverConnectionProvider provider = new DriverConnectionProvider();
            provider.setDriver(dcd.getDriverClass());
            provider.setUrl(dcd.getConnectionString());
            Properties properties = dcd.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                provider.setProperty(key, properties.getProperty(key));
            }
            connectionProvider = provider;
        } else {
            throw new IllegalStateException();
        }
        return connectionProvider;
    }

    protected void configureQueries(AbstractNamedMDXDataFactory dataFactory) {
        dataFactory.setGlobalScriptLanguage(this.getGlobalScriptingLanguage());
        if (!StringUtils.isEmpty((String)this.globalScriptTextArea.getText())) {
            dataFactory.setGlobalScript(this.globalScriptTextArea.getText());
        }
        DataSetComboBoxModel queries = this.dialogModel.getQueries();
        for (int i = 0; i < queries.getSize(); ++i) {
            DataSetQuery query = queries.getQuery(i);
            dataFactory.setQuery(query.getQueryName(), (String)query.getQuery(), query.getScriptLanguage(), query.getScript());
        }
    }

    protected abstract AbstractNamedMDXDataFactory createDataFactory();

    protected String getQueryName() {
        return this.queryNameTextField.getText();
    }

    protected void setQueryName(String queryName) {
        this.queryNameTextField.setText(queryName);
    }

    protected NamedDataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    protected OlapConnectionPanel getConnectionPanel() {
        return this.connectionComponent;
    }

    protected boolean validateInputs(boolean onConfirm) {
        return this.dialogModel.isConnectionSelected();
    }

    private class QueryScriptDocumentListener
    extends DocumentChangeHandler {
        private QueryScriptDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            DataSetQuery query = Olap4JDataSourceEditor.this.dialogModel.getQueries().getSelectedQuery();
            if (query != null) {
                query.setScript(Olap4JDataSourceEditor.this.queryScriptTextArea.getText());
            }
        }
    }

    private class UpdateScriptLanguageHandler
    implements ActionListener,
    ListSelectionListener {
        private UpdateScriptLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = Olap4JDataSourceEditor.this.dialogModel.getQueries().getSelectedQuery();
            if (query != null) {
                ScriptEngineFactory selectedItem = (ScriptEngineFactory)Olap4JDataSourceEditor.this.queryLanguageField.getSelectedItem();
                if (selectedItem != null) {
                    query.setScriptLanguage(selectedItem.getLanguageName());
                } else {
                    query.setScriptLanguage(null);
                }
            }
            Olap4JDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Olap4JDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryTemplateAction
    extends AbstractAction {
        private URL resource;

        private QueryTemplateAction() {
            this.putValue("Name", Messages.getString("Olap4JDataSourceEditor.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)Olap4JDataSourceEditor.this.queryScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)Olap4JDataSourceEditor.this), Messages.getString("Olap4JDataSourceEditor.OverwriteScript", new Object[0]), Messages.getString("Olap4JDataSourceEditor.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try (InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");){
                StringWriter w = new StringWriter();
                IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                Olap4JDataSourceEditor.this.queryScriptTextArea.insert(w.toString(), 0);
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = Olap4JDataSourceEditor.this.queryScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = Olap4JDataSourceEditor.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/query-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class GlobalTemplateAction
    extends AbstractAction {
        private URL resource;

        private GlobalTemplateAction() {
            this.putValue("Name", Messages.getString("Olap4JDataSourceEditor.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)Olap4JDataSourceEditor.this.globalScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)Olap4JDataSourceEditor.this), Messages.getString("Olap4JDataSourceEditor.OverwriteScript", new Object[0]), Messages.getString("Olap4JDataSourceEditor.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try (InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");){
                StringWriter w = new StringWriter();
                IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                Olap4JDataSourceEditor.this.globalScriptTextArea.setText(w.toString());
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = Olap4JDataSourceEditor.this.globalScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = Olap4JDataSourceEditor.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/global-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class QueryNameTextFieldDocumentListener
    extends DocumentChangeHandler
    implements ListDataListener {
        private boolean inUpdate;

        private QueryNameTextFieldDocumentListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (this.inUpdate) {
                return;
            }
            if (e.getIndex0() != -1) {
                return;
            }
            NamedDataSourceDialogModel dialogModel = Olap4JDataSourceEditor.this.getDialogModel();
            try {
                this.inUpdate = true;
                DataSetQuery selectedQuery = dialogModel.getQueries().getSelectedQuery();
                if (selectedQuery == null) {
                    Olap4JDataSourceEditor.this.setQueryName(null);
                    Olap4JDataSourceEditor.this.queryTextArea.setText(null);
                    Olap4JDataSourceEditor.this.queryScriptTextArea.setText(null);
                    Olap4JDataSourceEditor.this.queryLanguageField.setSelectedItem(null);
                    return;
                }
                Olap4JDataSourceEditor.this.setQueryName(selectedQuery.getQueryName());
                Olap4JDataSourceEditor.this.queryTextArea.setText((String)selectedQuery.getQuery());
                Olap4JDataSourceEditor.this.queryScriptTextArea.setText(selectedQuery.getScript());
                Olap4JDataSourceEditor.this.setScriptingLanguage(selectedQuery.getScriptLanguage(), (JComboBox)Olap4JDataSourceEditor.this.queryLanguageField);
            }
            finally {
                this.inUpdate = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleChange(DocumentEvent e) {
            if (this.inUpdate) {
                return;
            }
            NamedDataSourceDialogModel dialogModel = Olap4JDataSourceEditor.this.getDialogModel();
            DataSetQuery item = (DataSetQuery)dialogModel.getQueries().getSelectedItem();
            if (item == null) {
                return;
            }
            try {
                this.inUpdate = true;
                item.setQueryName(Olap4JDataSourceEditor.this.getQueryName());
                dialogModel.getQueries().fireItemChanged((Object)item);
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    private class RemoveQueryAction
    extends AbstractAction
    implements PropertyChangeListener {
        protected RemoveQueryAction() {
            URL resource = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/olap4j/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("Olap4JDataSourceEditor.RemoveQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("Olap4JDataSourceEditor.RemoveQuery.Description", new Object[0]));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NamedDataSourceDialogModel dialogModel = Olap4JDataSourceEditor.this.getDialogModel();
            this.setEnabled(dialogModel.isQuerySelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamedDataSourceDialogModel dialogModel = Olap4JDataSourceEditor.this.getDialogModel();
            DataSetComboBoxModel queries = dialogModel.getQueries();
            queries.removeElement(queries.getSelectedItem());
            queries.setSelectedItem(null);
            Olap4JDataSourceEditor.this.queryNameList.clearSelection();
        }
    }

    private class AddQueryAction
    extends AbstractAction {
        protected AddQueryAction() {
            URL resource = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/olap4j/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("Olap4JDataSourceEditor.AddQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("Olap4JDataSourceEditor.AddQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = Olap4JDataSourceEditor.this.dialogModel.generateQueryName();
            Olap4JDataSourceEditor.this.dialogModel.addQuery(queryName, "", null, null);
            Olap4JDataSourceEditor.this.queryNameList.setSelectedValue(queryName, true);
        }
    }

    private class ConfirmEnableHandler
    implements PropertyChangeListener {
        private ConfirmEnableHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Olap4JDataSourceEditor.this.validateInputs(false);
        }
    }

    private class QuerySelectedHandler
    implements ListSelectionListener {
        private QuerySelectedHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Olap4JDataSourceEditor.this.getDialogModel().getQueries().setSelectedItem(Olap4JDataSourceEditor.this.queryNameList.getSelectedValue());
            boolean querySelected = Olap4JDataSourceEditor.this.queryNameList.getSelectedIndex() != -1;
            Olap4JDataSourceEditor.this.queryNameTextField.setEnabled(querySelected);
            Olap4JDataSourceEditor.this.queryTextArea.setEnabled(Olap4JDataSourceEditor.this.dialogModel.isQuerySelected());
            Olap4JDataSourceEditor.this.queryScriptTextArea.setEnabled(Olap4JDataSourceEditor.this.dialogModel.isQuerySelected());
            Olap4JDataSourceEditor.this.queryLanguageField.setEnabled(Olap4JDataSourceEditor.this.dialogModel.isQuerySelected());
        }
    }

    private class PreviewAction
    extends AbstractAction
    implements PropertyChangeListener {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("Olap4JDataSourceEditor.Preview.Name", new Object[0]));
            this.setEnabled(Olap4JDataSourceEditor.this.dialogModel.isConnectionSelected() && Olap4JDataSourceEditor.this.dialogModel.isQuerySelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(Olap4JDataSourceEditor.this.dialogModel.isConnectionSelected() && Olap4JDataSourceEditor.this.dialogModel.isQuerySelected());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)Olap4JDataSourceEditor.this.dialogModel.getConnections().getSelectedItem();
            if (connectionDefinition == null) {
                return;
            }
            try {
                String query = Olap4JDataSourceEditor.this.queryNameTextField.getText();
                Integer theMaxRows = 0;
                if (Olap4JDataSourceEditor.this.maxPreviewRowsSpinner.isEnabled()) {
                    theMaxRows = (Integer)Olap4JDataSourceEditor.this.maxPreviewRowsSpinner.getValue();
                }
                if (Olap4JDataSourceEditor.this.previewDialog == null) {
                    Olap4JDataSourceEditor.this.previewDialog = new DataPreviewDialog((Dialog)((Object)Olap4JDataSourceEditor.this));
                }
                AbstractNamedMDXDataFactory dataFactory = Olap4JDataSourceEditor.this.createDataFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)Olap4JDataSourceEditor.this.context);
                Olap4JPreviewWorker worker = new Olap4JPreviewWorker((AbstractMDXDataFactory)dataFactory, query, 0, theMaxRows);
                Olap4JDataSourceEditor.this.previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)Olap4JDataSourceEditor.this), (String)Messages.getString("Olap4JDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("Olap4JDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)((Object)factoryException));
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)Olap4JDataSourceEditor.this), (String)Messages.getString("Olap4JDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("Olap4JDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)e);
            }
        }
    }

    private class QueryDocumentListener
    extends DocumentChangeHandler {
        private QueryDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            NamedDataSourceDialogModel dialogModel = Olap4JDataSourceEditor.this.getDialogModel();
            DataSetQuery item = dialogModel.getQueries().getSelectedQuery();
            if (item == null) {
                return;
            }
            item.setQuery((Object)Olap4JDataSourceEditor.this.queryTextArea.getText());
            dialogModel.getQueries().fireItemChanged((Object)item);
        }
    }
}

