/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.olap4j;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.ConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.olap4j.Messages;
import org.pentaho.reporting.ui.datasources.olap4j.Olap4JSecurityDialog;

public class OlapConnectionPanel
extends ConnectionPanel {
    private Olap4JSecurityDialog securityDialog;
    private String roleField;

    public OlapConnectionPanel(DataSourceDialogModel aDialogModel, DesignTimeContext designTimeContext) {
        super(aDialogModel, designTimeContext);
        this.initPanel();
    }

    public JdbcConnectionDefinition createConnectionDefinition(OlapConnectionProvider currentJNDISource) {
        DataSourceDialogModel dialogModel = this.getDialogModel();
        if (currentJNDISource instanceof DriverConnectionProvider) {
            DriverConnectionProvider dcp = (DriverConnectionProvider)currentJNDISource;
            DefaultComboBoxModel model = dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                DriverConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof DriverConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (DriverConnectionDefinition)definition).getUsername(), (Object)dcp.getProperty("JdbcUser")) || !ObjectUtilities.equal((Object)dcd.getPassword(), (Object)dcp.getProperty("JdbcPassword")) || !ObjectUtilities.equal((Object)dcd.getConnectionString(), (Object)dcp.getProperty("Jdbc")) || !ObjectUtilities.equal((Object)dcd.getDriverClass(), (Object)dcp.getProperty("JdbcDrivers")) || !ObjectUtilities.equal((Object)dcd.getName(), (Object)dcp.getProperty("::pentaho-reporting::name"))) continue;
                return definition;
            }
            String customName = dcp.getProperty("::pentaho-reporting::name");
            if (customName == null) {
                customName = Messages.getString("Olap4JDataSourceEditor.CustomConnection", new Object[0]);
            }
            String[] strings = dcp.getPropertyNames();
            Properties p = new Properties();
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                p.put(string, dcp.getProperty(string));
            }
            return new DriverConnectionDefinition(customName, dcp.getDriver(), dcp.getUrl(), dcp.getProperty("user"), dcp.getProperty("password"), dcp.getProperty("::pentaho-reporting::hostname"), dcp.getProperty("::pentaho-reporting::database-name"), dcp.getProperty("::pentaho-reporting::database-type"), dcp.getProperty("::pentaho-reporting::port"), p);
        }
        if (currentJNDISource instanceof JndiConnectionProvider) {
            JndiConnectionProvider jcp = (JndiConnectionProvider)currentJNDISource;
            DefaultComboBoxModel model = dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                JndiConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof JndiConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (JndiConnectionDefinition)definition).getJndiName(), (Object)jcp.getConnectionPath())) continue;
                return dcd;
            }
            return new JndiConnectionDefinition(Messages.getString("Olap4JDataSourceEditor.CustomConnection", new Object[0]), jcp.getConnectionPath(), null, jcp.getUsername(), jcp.getPassword());
        }
        return null;
    }

    public String getRoleField() {
        return this.roleField;
    }

    public void setRoleField(String roleField) {
        this.roleField = roleField;
    }

    protected Action createEditSecurityAction() {
        return new EditSecurityAction();
    }

    private class EditSecurityAction
    extends AbstractAction {
        private EditSecurityAction() {
            this.putValue("Name", Messages.getString("ConnectionPanel.EditSecurityAction.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignTimeContext designTimeContext = OlapConnectionPanel.this.getDesignTimeContext();
            DataSourceDialogModel dialogModel = OlapConnectionPanel.this.getDialogModel();
            if (OlapConnectionPanel.this.securityDialog == null) {
                Window window = LibSwingUtil.getWindowAncestor((Component)((Object)OlapConnectionPanel.this));
                if (window instanceof Frame) {
                    OlapConnectionPanel.this.securityDialog = new Olap4JSecurityDialog((Frame)window, designTimeContext);
                } else if (window instanceof Dialog) {
                    OlapConnectionPanel.this.securityDialog = new Olap4JSecurityDialog((Dialog)window, designTimeContext);
                } else {
                    OlapConnectionPanel.this.securityDialog = new Olap4JSecurityDialog(designTimeContext);
                }
            }
            OlapConnectionPanel.this.securityDialog.setRoleField(OlapConnectionPanel.this.roleField);
            OlapConnectionPanel.this.securityDialog.setJdbcPasswordField(dialogModel.getJdbcPasswordField());
            OlapConnectionPanel.this.securityDialog.setJdbcUserField(dialogModel.getJdbcUserField());
            if (OlapConnectionPanel.this.securityDialog.performEdit()) {
                OlapConnectionPanel.this.roleField = OlapConnectionPanel.this.securityDialog.getRoleField();
                dialogModel.setJdbcUserField(OlapConnectionPanel.this.securityDialog.getJdbcUserField());
                dialogModel.setJdbcPasswordField(OlapConnectionPanel.this.securityDialog.getJdbcPasswordField());
            }
        }
    }
}

