/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.olap4j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinitionManager;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.SimpleDataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.olap4j.OlapConnectionPanel;

public abstract class SimpleOlap4JDataSourceEditor
extends CommonDialog {
    private boolean confirmed;
    private SimpleDataSourceDialogModel dialogModel;
    private OlapConnectionPanel connectionComponent;

    public SimpleOlap4JDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public SimpleOlap4JDataSourceEditor(DesignTimeContext context, Dialog owner) {
        super(owner);
        this.init(context);
    }

    public SimpleOlap4JDataSourceEditor(DesignTimeContext context, Frame owner) {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext designTimeContext) {
        this.setModal(true);
        this.dialogModel = new SimpleDataSourceDialogModel(new JdbcConnectionDefinitionManager("org/pentaho/reporting/ui/datasources/olap4j/Settings"));
        this.connectionComponent = new OlapConnectionPanel((DataSourceDialogModel)this.dialogModel, designTimeContext);
        this.connectionComponent.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        ConfirmEnabledHandler confirmAction = new ConfirmEnabledHandler();
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)confirmAction);
        super.init();
    }

    protected Component createContentPane() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add("Center", (Component)((Object)this.connectionComponent));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return contentPanel;
    }

    public DataFactory performConfiguration(AbstractMDXDataFactory dataFactory) {
        this.dialogModel.clear();
        this.connectionComponent.setRoleField(null);
        this.confirmed = false;
        if (dataFactory != null) {
            OlapConnectionProvider currentJNDISource = dataFactory.getConnectionProvider();
            JdbcConnectionDefinition definition = this.getConnectionPanel().createConnectionDefinition(currentJNDISource);
            this.getDialogModel().addConnection(definition);
            this.getDialogModel().getConnections().setSelectedItem(definition);
            this.getDialogModel().setJdbcUserField(dataFactory.getJdbcUserField());
            this.getDialogModel().setJdbcPasswordField(dataFactory.getJdbcPasswordField());
            this.connectionComponent.setRoleField(dataFactory.getRoleField());
        }
        if (!this.performEdit()) {
            return null;
        }
        AbstractMDXDataFactory factory = this.createDataFactory();
        if (factory == null) {
            return null;
        }
        factory.setJdbcUserField(this.getDialogModel().getJdbcUserField());
        factory.setJdbcPasswordField(this.getDialogModel().getJdbcPasswordField());
        factory.setRoleField(this.connectionComponent.getRoleField());
        return factory;
    }

    protected abstract AbstractMDXDataFactory createDataFactory();

    protected SimpleDataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    protected OlapConnectionPanel getConnectionPanel() {
        return this.connectionComponent;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    private class ConfirmEnabledHandler
    implements PropertyChangeListener {
        private ConfirmEnabledHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SimpleDataSourceDialogModel dialogModel = SimpleOlap4JDataSourceEditor.this.getDialogModel();
            SimpleOlap4JDataSourceEditor.this.getConfirmAction().setEnabled(dialogModel.isConnectionSelected());
        }
    }
}

