/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.extension.ExtensionPointPluginType;
import org.pentaho.di.core.logging.ConsoleLoggingEventListener;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingPluginInterface;
import org.pentaho.di.core.logging.LoggingPluginType;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;

public class KettleClientEnvironment {
    private static Class<?> PKG = Const.class;
    private static KettleClientEnvironment instance = null;
    private static Boolean initialized;
    private ClientType client;
    private String clientID = null;

    public static synchronized void init() throws KettleException {
        KettleClientEnvironment.init(Arrays.asList(LoggingPluginType.getInstance(), ValueMetaPluginType.getInstance(), DatabasePluginType.getInstance(), ExtensionPointPluginType.getInstance(), TwoWayPasswordEncoderPluginType.getInstance()));
    }

    public static synchronized void init(List<PluginTypeInterface> pluginsToLoad) throws KettleException {
        if (initialized != null) {
            return;
        }
        if (instance == null) {
            instance = new KettleClientEnvironment();
        }
        KettleClientEnvironment.createKettleHome();
        EnvUtil.environmentInit();
        KettleLogStore.init();
        if (!"Y".equalsIgnoreCase(System.getProperty("KETTLE_DISABLE_CONSOLE_LOGGING", "N"))) {
            KettleLogStore.getAppender().addLoggingEventListener(new ConsoleLoggingEventListener());
        }
        pluginsToLoad.forEach(PluginRegistry::addPluginType);
        PluginRegistry.init(true);
        List<PluginInterface> logginPlugins = PluginRegistry.getInstance().getPlugins(LoggingPluginType.class);
        KettleClientEnvironment.initLogginPlugins(logginPlugins);
        String passwordEncoderPluginID = Const.NVL(EnvUtil.getSystemProperty("KETTLE_PASSWORD_ENCODER_PLUGIN"), "Kettle");
        Encr.init(passwordEncoderPluginID);
        initialized = new Boolean(true);
    }

    public static boolean isInitialized() {
        return initialized != null;
    }

    public static void createKettleHome() {
        String directory = Const.getKettleDirectory();
        File dir = new File(directory);
        try {
            dir.mkdirs();
            KettleClientEnvironment.createDefaultKettleProperties(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initLogginPlugins(List<PluginInterface> logginPlugins) throws KettlePluginException {
        for (PluginInterface plugin : logginPlugins) {
            LoggingPluginInterface loggingPlugin = (LoggingPluginInterface)PluginRegistry.getInstance().loadClass(plugin);
            loggingPlugin.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createDefaultKettleProperties(String directory) {
        String kpFile = directory + Const.FILE_SEPARATOR + "kettle.properties";
        File file = new File(kpFile);
        if (file.exists()) return;
        FileOutputStream out = null;
        out = new FileOutputStream(file);
        out.write(Const.getKettlePropertiesFileHeader().getBytes());
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            System.err.println(BaseMessages.getString(PKG, "Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", "kettle.properties", kpFile));
            System.err.println(e.getStackTrace());
        }
        return;
        catch (IOException e) {
            try {
                System.err.println(BaseMessages.getString(PKG, "Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", "kettle.properties", kpFile));
                System.err.println(e.getStackTrace());
                if (out == null) return;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    System.err.println(BaseMessages.getString(PKG, "Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", "kettle.properties", kpFile));
                    System.err.println(e2.getStackTrace());
                }
                throw throwable;
            }
            try {
                out.close();
                return;
            }
            catch (IOException e3) {
                System.err.println(BaseMessages.getString(PKG, "Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", "kettle.properties", kpFile));
                System.err.println(e3.getStackTrace());
            }
            return;
        }
    }

    public void setClient(ClientType client) {
        this.client = client;
    }

    public void setClientID(String id) {
        this.clientID = id;
    }

    public ClientType getClient() {
        return this.client;
    }

    public static KettleClientEnvironment getInstance() {
        if (instance == null) {
            instance = new KettleClientEnvironment();
        }
        return instance;
    }

    public static enum ClientType {
        SPOON,
        PAN,
        KITCHEN,
        CARTE,
        DI_SERVER,
        OTHER;


        public String getID() {
            if (this != OTHER) {
                return this.name();
            }
            return instance.clientID;
        }
    }
}

