/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.util.DatabaseUtil;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;

public class ConnectionPoolUtil {
    public static final String DEFAULT_AUTO_COMMIT = "defaultAutoCommit";
    public static final String DEFAULT_READ_ONLY = "defaultReadOnly";
    public static final String DEFAULT_TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    public static final String DEFAULT_CATALOG = "defaultCatalog";
    public static final String INITIAL_SIZE = "initialSize";
    public static final String MAX_ACTIVE = "maxActive";
    public static final String MAX_IDLE = "maxIdle";
    public static final String MIN_IDLE = "minIdle";
    public static final String MAX_WAIT = "maxWait";
    public static final String VALIDATION_QUERY = "validationQuery";
    public static final String TEST_ON_BORROW = "testOnBorrow";
    public static final String TEST_ON_RETURN = "testOnReturn";
    public static final String TEST_WHILE_IDLE = "testWhileIdle";
    public static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    public static final String POOL_PREPARED_STATEMENTS = "poolPreparedStatements";
    public static final String MAX_OPEN_PREPARED_STATEMENTS = "maxOpenPreparedStatements";
    public static final String ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED = "accessToUnderlyingConnectionAllowed";
    public static final String REMOVE_ABANDONED = "removeAbandoned";
    public static final String REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    public static final String LOG_ABANDONED = "logAbandoned";
    private static Class<?> PKG = Database.class;
    private static ConcurrentMap<String, BasicDataSource> dataSources = new ConcurrentHashMap<String, BasicDataSource>();
    private static final ReentrantLock lock = new ReentrantLock();
    public static final int defaultInitialNrOfConnections = 5;
    public static final int defaultMaximumNrOfConnections = 10;

    private static boolean isDataSourceRegistered(DatabaseMeta dbMeta, String partitionId) throws KettleDatabaseException {
        try {
            String name = ConnectionPoolUtil.getDataSourceName(dbMeta, partitionId);
            return dataSources.containsKey(name);
        }
        catch (Exception e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.UnableToCheckIfConnectionPoolExists.Exception", new String[0]), e);
        }
    }

    public static Connection getConnection(LogChannelInterface log, DatabaseMeta dbMeta, String partitionId) throws Exception {
        return ConnectionPoolUtil.getConnection(log, dbMeta, partitionId, dbMeta.getInitialPoolSize(), dbMeta.getMaximumPoolSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(LogChannelInterface log, DatabaseMeta dbMeta, String partitionId, int initialSize, int maximumSize) throws Exception {
        lock.lock();
        try {
            if (!ConnectionPoolUtil.isDataSourceRegistered(dbMeta, partitionId)) {
                ConnectionPoolUtil.addPoolableDataSource(log, dbMeta, partitionId, initialSize, maximumSize);
            }
        }
        finally {
            lock.unlock();
        }
        BasicDataSource ds = (BasicDataSource)dataSources.get(ConnectionPoolUtil.getDataSourceName(dbMeta, partitionId));
        return ds.getConnection();
    }

    private static String getDataSourceName(DatabaseMeta dbMeta, String partitionId) {
        return dbMeta.getName() + Const.NVL(dbMeta.getDatabaseName(), "") + Const.NVL(dbMeta.getHostname(), "") + Const.NVL(dbMeta.getDatabasePortNumberString(), "") + Const.NVL(partitionId, "");
    }

    private static Properties environmentSubstitute(Properties properties, DatabaseMeta databaseMeta) {
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            properties.put(string, databaseMeta.environmentSubstitute(value));
        }
        return properties;
    }

    @VisibleForTesting
    static void configureDataSource(BasicDataSource ds, DatabaseMeta databaseMeta, String partitionId, int initialSize, int maximumSize) throws KettleDatabaseException {
        Properties connectionPoolProperties = new Properties(databaseMeta.getConnectionPoolingProperties());
        connectionPoolProperties = ConnectionPoolUtil.environmentSubstitute(connectionPoolProperties, databaseMeta);
        ConnectionPoolUtil.setPoolProperties(ds, connectionPoolProperties, initialSize, maximumSize);
        ConnectionPoolUtil.setCredentials(ds, databaseMeta, partitionId);
        String url = databaseMeta.environmentSubstitute(databaseMeta.getURL(partitionId));
        ds.setUrl(url);
        String clazz = databaseMeta.getDriverClass();
        if (databaseMeta.getDatabaseInterface() != null) {
            ds.setDriverClassLoader(databaseMeta.getDatabaseInterface().getClass().getClassLoader());
        }
        ds.setDriverClassName(clazz);
    }

    private static void setCredentials(BasicDataSource ds, DatabaseMeta databaseMeta, String partitionId) throws KettleDatabaseException {
        String userName = databaseMeta.environmentSubstitute(databaseMeta.getUsername());
        String password = databaseMeta.environmentSubstitute(databaseMeta.getPassword());
        password = Encr.decryptPasswordOptionallyEncrypted(password);
        ds.addConnectionProperty("user", Const.NVL(userName, ""));
        ds.addConnectionProperty("password", Const.NVL(password, ""));
    }

    private static void setPoolProperties(BasicDataSource ds, Properties properties, int initialSize, int maxSize) {
        ds.setInitialSize(initialSize);
        ds.setMaxActive(maxSize);
        String value = properties.getProperty(DEFAULT_AUTO_COMMIT);
        if (!Utils.isEmpty(value)) {
            ds.setDefaultAutoCommit(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(DEFAULT_READ_ONLY))) {
            ds.setDefaultReadOnly(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(DEFAULT_TRANSACTION_ISOLATION))) {
            ds.setDefaultTransactionIsolation(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(DEFAULT_CATALOG))) {
            ds.setDefaultCatalog(value);
        }
        if (!Utils.isEmpty(value = properties.getProperty(INITIAL_SIZE))) {
            ds.setInitialSize(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(MAX_ACTIVE))) {
            ds.setMaxActive(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(MAX_IDLE))) {
            ds.setMaxIdle(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(MIN_IDLE))) {
            ds.setMinIdle(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(MAX_WAIT))) {
            ds.setMaxWait(Long.valueOf(value).longValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(VALIDATION_QUERY))) {
            ds.setValidationQuery(value);
        }
        if (!Utils.isEmpty(value = properties.getProperty(TEST_ON_BORROW))) {
            ds.setTestOnBorrow(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(TEST_ON_RETURN))) {
            ds.setTestOnReturn(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(TEST_WHILE_IDLE))) {
            ds.setTestWhileIdle(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(TIME_BETWEEN_EVICTION_RUNS_MILLIS))) {
            ds.setTimeBetweenEvictionRunsMillis(Long.valueOf(value).longValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(POOL_PREPARED_STATEMENTS))) {
            ds.setPoolPreparedStatements(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(MAX_OPEN_PREPARED_STATEMENTS))) {
            ds.setMaxOpenPreparedStatements(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED))) {
            ds.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(REMOVE_ABANDONED))) {
            ds.setRemoveAbandoned(Boolean.valueOf(value).booleanValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(REMOVE_ABANDONED_TIMEOUT))) {
            ds.setRemoveAbandonedTimeout(Integer.valueOf(value).intValue());
        }
        if (!Utils.isEmpty(value = properties.getProperty(LOG_ABANDONED))) {
            ds.setLogAbandoned(Boolean.valueOf(value).booleanValue());
        }
    }

    private static void testDataSource(DataSource ds) throws KettleDatabaseException {
        Connection conn = null;
        try {
            conn = ds.getConnection();
        }
        catch (Throwable e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.UnableToPreLoadConnectionToConnectionPool.Exception", new String[0]), e);
        }
        finally {
            DatabaseUtil.closeSilently(conn);
        }
    }

    private static void addPoolableDataSource(LogChannelInterface log, DatabaseMeta databaseMeta, String partitionId, int initialSize, int maximumSize) throws KettleDatabaseException {
        if (log.isBasic()) {
            log.logBasic(BaseMessages.getString(PKG, "Database.CreatingConnectionPool", databaseMeta.getName()));
        }
        BasicDataSource ds = new BasicDataSource();
        ConnectionPoolUtil.configureDataSource(ds, databaseMeta, partitionId, initialSize, maximumSize);
        ConnectionPoolUtil.testDataSource((DataSource)ds);
        dataSources.put(ConnectionPoolUtil.getDataSourceName(databaseMeta, partitionId), ds);
        if (log.isBasic()) {
            log.logBasic(BaseMessages.getString(PKG, "Database.CreatedConnectionPool", databaseMeta.getName()));
        }
    }

    protected static String buildPoolName(DatabaseMeta dbMeta, String partitionId) {
        return dbMeta.getName() + Const.NVL(dbMeta.getDatabaseName(), "") + Const.NVL(dbMeta.getHostname(), "") + Const.NVL(dbMeta.getDatabasePortNumberString(), "") + Const.NVL(partitionId, "");
    }
}

