/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.compatibility.Row;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class RowMeta
implements RowMetaInterface {
    public static final String XML_META_TAG = "row-meta";
    public static final String XML_DATA_TAG = "row-data";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final RowMetaCache cache;
    private List<ValueMetaInterface> valueMetaList;

    public RowMeta() {
        this(new ArrayList<ValueMetaInterface>(), new RowMetaCache());
    }

    private RowMeta(RowMeta rowMeta, Integer targetType) throws KettlePluginException {
        this(new ArrayList<ValueMetaInterface>(rowMeta.valueMetaList.size()), new RowMetaCache(rowMeta.cache));
        for (ValueMetaInterface valueMetaInterface : rowMeta.valueMetaList) {
            this.valueMetaList.add(ValueMetaFactory.cloneValueMeta(valueMetaInterface, targetType == null ? valueMetaInterface.getType() : targetType.intValue()));
        }
    }

    private RowMeta(List<ValueMetaInterface> valueMetaList, RowMetaCache rowMetaCache) {
        this.cache = rowMetaCache;
        this.valueMetaList = valueMetaList;
    }

    @Override
    public RowMeta clone() {
        this.lock.readLock().lock();
        try {
            RowMeta rowMeta = new RowMeta(this, null);
            return rowMeta;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public RowMetaInterface cloneToType(int targetType) throws KettleValueException {
        this.lock.readLock().lock();
        try {
            RowMeta rowMeta = new RowMeta(this, targetType);
            return rowMeta;
        }
        catch (KettlePluginException e) {
            throw new KettleValueException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.lock.readLock().lock();
        try {
            boolean notFirst = false;
            for (ValueMetaInterface valueMeta : this.valueMetaList) {
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                buffer.append("[").append(valueMeta.toString()).append("]");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ValueMetaInterface> getValueMetaList() {
        ArrayList<ValueMetaInterface> copy;
        this.lock.readLock().lock();
        try {
            copy = new ArrayList<ValueMetaInterface>(this.valueMetaList);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableList(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueMetaList(List<ValueMetaInterface> valueMetaList) {
        this.lock.writeLock().lock();
        try {
            this.valueMetaList = valueMetaList;
            this.cache.invalidate();
            int len = valueMetaList.size();
            for (int i = 0; i < len; ++i) {
                ValueMetaInterface valueMeta = valueMetaList.get(i);
                this.cache.storeMapping(valueMeta.getName(), i);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.valueMetaList.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.valueMetaList.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean exists(ValueMetaInterface meta) {
        return meta != null && this.searchValueMeta(meta.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueMeta(ValueMetaInterface meta) {
        if (meta != null) {
            this.lock.writeLock().lock();
            try {
                ValueMetaInterface newMeta = !this.exists(meta) ? meta : this.renameValueMetaIfInRow(meta, null);
                int index = this.valueMetaList.size();
                this.valueMetaList.add(newMeta);
                this.cache.storeMapping(newMeta.getName(), index);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueMeta(int index, ValueMetaInterface meta) {
        if (meta != null) {
            this.lock.writeLock().lock();
            try {
                ValueMetaInterface newMeta = !this.exists(meta) ? meta : this.renameValueMetaIfInRow(meta, null);
                this.valueMetaList.add(index, newMeta);
                this.cache.invalidate();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public ValueMetaInterface getValueMeta(int index) {
        this.lock.readLock().lock();
        try {
            if (index >= 0 && index < this.valueMetaList.size()) {
                ValueMetaInterface valueMetaInterface = this.valueMetaList.get(index);
                return valueMetaInterface;
            }
            ValueMetaInterface valueMetaInterface = null;
            return valueMetaInterface;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueMeta(int index, ValueMetaInterface valueMeta) {
        if (valueMeta != null) {
            this.lock.writeLock().lock();
            try {
                ValueMetaInterface old = this.valueMetaList.get(index);
                ValueMetaInterface newMeta = valueMeta;
                int existsIndex = this.indexOfValue(valueMeta.getName());
                if (existsIndex >= 0 && existsIndex != index) {
                    newMeta = this.renameValueMetaIfInRow(valueMeta, null);
                }
                this.valueMetaList.set(index, newMeta);
                this.cache.replaceMapping(old.getName(), newMeta.getName(), index);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public String getString(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getString(dataRow[index]);
    }

    @Override
    public Long getInteger(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getInteger(dataRow[index]);
    }

    @Override
    public Double getNumber(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getNumber(dataRow[index]);
    }

    @Override
    public Date getDate(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getDate(dataRow[index]);
    }

    @Override
    public BigDecimal getBigNumber(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getBigNumber(dataRow[index]);
    }

    @Override
    public Boolean getBoolean(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getBoolean(dataRow[index]);
    }

    @Override
    public byte[] getBinary(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.getValueMeta(index);
        return meta.getBinary(dataRow[index]);
    }

    @Override
    public boolean isNull(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return true;
        }
        return this.getValueMeta(index).isNull(dataRow[index]);
    }

    @Override
    public Object[] cloneRow(Object[] objects) throws KettleValueException {
        return this.cloneRow(objects, (Object[])objects.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] cloneRow(Object[] objects, Object[] newObjects) throws KettleValueException {
        this.lock.readLock().lock();
        try {
            List<Integer> list = this.cache.getOrCreateValuesThatNeedRealClone(this.valueMetaList);
            for (Integer i : list) {
                ValueMetaInterface valueMeta = this.valueMetaList.get(i);
                newObjects[i.intValue()] = valueMeta.cloneValueData(objects[i]);
            }
            Object[] objectArray = newObjects;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public String getString(Object[] dataRow, String valueName, String defaultValue) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getString(dataRow, index);
    }

    @Override
    public Long getInteger(Object[] dataRow, String valueName, Long defaultValue) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getInteger(dataRow, index);
    }

    @Override
    public Date getDate(Object[] dataRow, String valueName, Date defaultValue) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getDate(dataRow, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOfValue(String valueName) {
        if (valueName == null) {
            return -1;
        }
        this.lock.readLock().lock();
        try {
            int n;
            Integer index = this.cache.findAndCompare(valueName, this.valueMetaList);
            for (int i = 0; index == null && i < this.valueMetaList.size(); ++i) {
                if (!valueName.equalsIgnoreCase(this.valueMetaList.get(i).getName())) continue;
                index = i;
                this.cache.storeMapping(valueName, index);
            }
            if (index == null) {
                n = -1;
                return n;
            }
            n = index;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueMetaInterface searchValueMeta(String valueName) {
        this.lock.readLock().lock();
        try {
            Integer index = this.indexOfValue(valueName);
            if (index < 0) {
                ValueMetaInterface valueMetaInterface = null;
                return valueMetaInterface;
            }
            ValueMetaInterface valueMetaInterface = this.valueMetaList.get(index);
            return valueMetaInterface;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addRowMeta(RowMetaInterface rowMeta) {
        for (int i = 0; i < rowMeta.size(); ++i) {
            this.addValueMeta(rowMeta.getValueMeta(i));
        }
    }

    @Override
    public void mergeRowMeta(RowMetaInterface r) {
        this.mergeRowMeta(r, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeRowMeta(RowMetaInterface r, String originStepName) {
        this.lock.writeLock().lock();
        try {
            for (int x = 0; x < r.size(); ++x) {
                ValueMetaInterface field = r.getValueMeta(x);
                if (this.searchValueMeta(field.getName()) == null) {
                    this.addValueMeta(field);
                    continue;
                }
                this.addValueMeta(this.renameValueMetaIfInRow(field, originStepName));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ValueMetaInterface renameValueMetaIfInRow(ValueMetaInterface valueMeta, String originStep) {
        int index = 1;
        String name = valueMeta.getName() + "_" + index;
        while (this.searchValueMeta(name) != null) {
            name = valueMeta.getName() + "_" + ++index;
        }
        ValueMetaInterface copy = valueMeta.clone();
        copy.setName(name);
        if (originStep != null) {
            copy.setOrigin(originStep);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getFieldNames() {
        this.lock.readLock().lock();
        try {
            String[] retval = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                String valueName = this.getValueMeta(i).getName();
                retval[i] = valueName == null ? "" : valueName;
            }
            String[] stringArray = retval;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(DataOutputStream outputStream, Object[] data) throws KettleFileException {
        block6: {
            this.lock.readLock().lock();
            try {
                for (int i = 0; i < this.size(); ++i) {
                    this.getValueMeta(i).writeData(outputStream, data[i]);
                }
                if (this.size() != 0) break block6;
                try {
                    outputStream.writeBoolean(true);
                }
                catch (IOException e) {
                    throw new KettleFileException("Error writing marker flag", e);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    public void writeMeta(DataOutputStream outputStream) throws KettleFileException {
        this.lock.readLock().lock();
        try {
            try {
                outputStream.writeInt(this.size());
            }
            catch (IOException e) {
                throw new KettleFileException("Unable to write nr of metadata values", e);
            }
            for (int i = 0; i < this.size(); ++i) {
                this.getValueMeta(i).writeMeta(outputStream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public RowMeta(DataInputStream inputStream) throws KettleFileException, SocketTimeoutException {
        this();
        int nr;
        try {
            nr = inputStream.readInt();
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (EOFException e) {
            throw new KettleEOFException("End of file while reading the number of metadata values in the row metadata", e);
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to read nr of metadata values: " + e.toString(), e);
        }
        for (int i = 0; i < nr; ++i) {
            try {
                int type = inputStream.readInt();
                ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta(type);
                valueMeta.readMetaData(inputStream);
                this.addValueMeta(valueMeta);
                continue;
            }
            catch (EOFException e) {
                throw new KettleEOFException(e);
            }
            catch (Exception e) {
                throw new KettleFileException(this.toString() + " : Unable to read row metadata from input stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] readData(DataInputStream inputStream) throws KettleFileException, SocketTimeoutException {
        this.lock.readLock().lock();
        try {
            Object[] data = new Object[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                data[i] = this.getValueMeta(i).readData(inputStream);
            }
            if (this.size() == 0) {
                try {
                    inputStream.readBoolean();
                }
                catch (EOFException e) {
                    throw new KettleEOFException(e);
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new KettleFileException(this.toString() + " : Unable to read the marker flag data from input stream", e);
                }
            }
            Object[] objectArray = data;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.valueMetaList.clear();
            this.cache.invalidate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeValueMeta(String valueName) throws KettleValueException {
        this.lock.writeLock().lock();
        try {
            int index = this.indexOfValue(valueName);
            if (index < 0) {
                throw new KettleValueException("Unable to find value metadata with name '" + valueName + "', so I can't delete it.");
            }
            this.removeValueMeta(index);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeValueMeta(int index) {
        this.lock.writeLock().lock();
        try {
            this.valueMetaList.remove(index);
            this.cache.invalidate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringMeta() {
        StringBuilder buffer = new StringBuilder();
        this.lock.readLock().lock();
        try {
            boolean notFirst = false;
            for (ValueMetaInterface valueMeta : this.valueMetaList) {
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                buffer.append("[").append(valueMeta.toStringMeta()).append("]");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(Object[] row) throws KettleValueException {
        this.lock.readLock().lock();
        try {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append("[");
                buffer.append(this.getString(row, i));
                buffer.append("]");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getFieldNamesAndTypes(int maxlen) {
        this.lock.readLock().lock();
        try {
            int size = this.size();
            String[] retval = new String[size];
            for (int i = 0; i < size; ++i) {
                ValueMetaInterface v = this.getValueMeta(i);
                retval[i] = Const.rightPad(v.getName(), maxlen) + "   (" + v.getTypeDesc() + ")";
            }
            String[] stringArray = retval;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, Object[] rowData2, int[] fieldnrs) throws KettleValueException {
        this.lock.readLock().lock();
        try {
            for (int fieldnr : fieldnrs) {
                ValueMetaInterface valueMeta = this.getValueMeta(fieldnr);
                int cmp = valueMeta.compare(rowData1[fieldnr], rowData2[fieldnr]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object[] rowData1, Object[] rowData2, int[] fieldnrs) throws KettleValueException {
        this.lock.readLock().lock();
        try {
            for (int fieldnr : fieldnrs) {
                ValueMetaInterface valueMeta = this.getValueMeta(fieldnr);
                int cmp = valueMeta.compare(rowData1[fieldnr], rowData2[fieldnr]);
                if (cmp == 0) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, Object[] rowData2, int[] fieldnrs1, int[] fieldnrs2) throws KettleValueException {
        int len = fieldnrs1.length < fieldnrs2.length ? fieldnrs1.length : fieldnrs2.length;
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < len; ++i) {
                ValueMetaInterface valueMeta = this.getValueMeta(fieldnrs1[i]);
                int cmp = valueMeta.compare(rowData1[fieldnrs1[i]], rowData2[fieldnrs2[i]]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, RowMetaInterface rowMeta2, Object[] rowData2, int[] fieldnrs1, int[] fieldnrs2) throws KettleValueException {
        int len = fieldnrs1.length < fieldnrs2.length ? fieldnrs1.length : fieldnrs2.length;
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < len; ++i) {
                ValueMetaInterface valueMeta2;
                ValueMetaInterface valueMeta1 = this.getValueMeta(fieldnrs1[i]);
                int cmp = valueMeta1.compare(rowData1[fieldnrs1[i]], valueMeta2 = rowMeta2.getValueMeta(fieldnrs2[i]), rowData2[fieldnrs2[i]]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, Object[] rowData2) throws KettleValueException {
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                ValueMetaInterface valueMeta = this.getValueMeta(i);
                int cmp = valueMeta.compare(rowData1[i], rowData2[i]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int oldXORHashCode(Object[] rowData) throws KettleValueException {
        int hash = 0;
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                ValueMetaInterface valueMeta = this.getValueMeta(i);
                hash ^= valueMeta.hashCode(rowData[i]);
            }
            int n = hash;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int hashCode(Object[] rowData) throws KettleValueException {
        return Arrays.hashCode(rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertedValuesHashCode(Object[] rowData) throws KettleValueException {
        if (rowData == null) {
            return 0;
        }
        int result = 1;
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < rowData.length; ++i) {
                result = 31 * result + this.getValueMeta(i).hashCode();
            }
            int n = result;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static byte[] extractData(RowMetaInterface metadata, Object[] row) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            metadata.writeData(dataOutputStream, row);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing row to byte array", e);
        }
    }

    public static Object[] getRow(RowMetaInterface metadata, byte[] data) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return metadata.readData(dataInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error de-serializing row of data from byte array", e);
        }
    }

    public static Row createOriginalRow(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        Row row = new Row();
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            Object valueData = rowData[i];
            Value value = valueMeta.createOriginalValue(valueData);
            row.addValue(value);
        }
        return row;
    }

    @Override
    public String getMetaXML() throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(XML_META_TAG).append(">");
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                xml.append(this.getValueMeta(i).getMetaXML());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        xml.append("</").append(XML_META_TAG).append(">");
        return xml.toString();
    }

    public RowMeta(Node node) throws KettleException {
        this();
        int nrValues = XMLHandler.countNodes(node, "value-meta");
        for (int i = 0; i < nrValues; ++i) {
            this.addValueMeta(new ValueMeta(XMLHandler.getSubNodeByNr(node, "value-meta", i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataXML(Object[] rowData) throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(XML_DATA_TAG).append(">");
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                xml.append(this.getValueMeta(i).getDataXML(rowData[i]));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        xml.append("</").append(XML_DATA_TAG).append(">");
        return xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getRow(Node node) throws KettleException {
        this.lock.readLock().lock();
        try {
            Object[] rowData = RowDataUtil.allocateRowData(this.size());
            for (int i = 0; i < this.size(); ++i) {
                Node valueDataNode = XMLHandler.getSubNodeByNr(node, "value-data", i);
                rowData[i] = this.getValueMeta(i).getValue(valueDataNode);
            }
            Object[] objectArray = rowData;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    static class RowMetaCache {
        @VisibleForTesting
        final Map<String, Integer> mapping;
        @VisibleForTesting
        List<Integer> needRealClone;

        RowMetaCache() {
            this(new ConcurrentHashMap<String, Integer>(), null);
        }

        RowMetaCache(RowMetaCache rowMetaCache) {
            this(new ConcurrentHashMap<String, Integer>(rowMetaCache.mapping), (List<Integer>)(rowMetaCache.needRealClone == null ? null : new ArrayList<Integer>(rowMetaCache.needRealClone)));
        }

        RowMetaCache(Map<String, Integer> mapping, List<Integer> needRealClone) {
            this.mapping = mapping;
            this.needRealClone = needRealClone;
        }

        synchronized void invalidate() {
            this.mapping.clear();
            this.needRealClone = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeMapping(String name, int index) {
            if (Utils.isEmpty(name)) {
                return;
            }
            RowMetaCache rowMetaCache = this;
            synchronized (rowMetaCache) {
                this.mapping.put(name.toLowerCase(), index);
                this.needRealClone = null;
            }
        }

        synchronized void replaceMapping(String old, String current, int index) {
            if (!Utils.isEmpty(old)) {
                this.mapping.remove(old.toLowerCase());
            }
            this.storeMapping(current, index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Integer findAndCompare(String name, List<? extends ValueMetaInterface> metas) {
            if (Utils.isEmpty(name)) {
                return null;
            }
            RowMetaCache rowMetaCache = this;
            synchronized (rowMetaCache) {
                ValueMetaInterface value;
                name = name.toLowerCase();
                Integer index = this.mapping.get(name);
                if (index != null && !name.equalsIgnoreCase((value = metas.get(index)).getName())) {
                    this.mapping.remove(name);
                    index = null;
                }
                return index;
            }
        }

        synchronized List<Integer> getOrCreateValuesThatNeedRealClone(List<ValueMetaInterface> values) {
            if (this.needRealClone == null) {
                int len = values.size();
                this.needRealClone = new ArrayList<Integer>(len);
                for (int i = 0; i < len; ++i) {
                    ValueMetaInterface valueMeta = values.get(i);
                    if (!valueMeta.requiresRealClone()) continue;
                    this.needRealClone.add(i);
                }
            }
            return this.needRealClone;
        }
    }
}

