/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.util.Utils;

public class ValueMetaInternetAddress
extends ValueMetaDate {
    @Override
    public int compare(Object data1, Object data2) throws KettleValueException {
        InetAddress inet1 = this.getInternetAddress(data1);
        InetAddress inet2 = this.getInternetAddress(data2);
        int cmp = 0;
        if (inet1 == null) {
            cmp = inet2 == null ? 0 : -1;
        } else if (inet2 == null) {
            cmp = 1;
        } else {
            BigInteger bigint1 = new BigInteger(inet1.getAddress());
            BigInteger bigint2 = new BigInteger(inet2.getAddress());
            cmp = bigint1.compareTo(bigint2);
        }
        if (this.isSortedDescending()) {
            return -cmp;
        }
        return cmp;
    }

    public ValueMetaInternetAddress() {
        this((String)null);
    }

    public ValueMetaInternetAddress(String name) {
        super(name, 10);
    }

    public InetAddress getInternetAddress(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 10: {
                switch (this.storageType) {
                    case 0: {
                        return (InetAddress)object;
                    }
                    case 1: {
                        return (InetAddress)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (InetAddress)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToInternetAddress((String)object);
                    }
                    case 1: {
                        return this.convertStringToInternetAddress((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToInternetAddress((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToInternetAddress((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToInternetAddress((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToInternetAddress((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToInternetAddress((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToInternetAddress((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToInternetAddress((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToInternetAddress((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToInternetAddress((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToInternetAddress((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 4: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a boolean to a Internet address.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a binary value to Internet address.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a serializable value to Internet address.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    @Override
    public Date getDate(Object object) throws KettleValueException {
        throw new KettleValueException(this.toStringMeta() + ": it's not possible to convert from Internet Address to a date");
    }

    @Override
    public Long getInteger(Object object) throws KettleValueException {
        InetAddress address = this.getInternetAddress(object);
        if (address == null) {
            return null;
        }
        long total = 0L;
        byte[] addr = address.getAddress();
        if (addr.length > 8) {
            throw new KettleValueException("Unable to convert Internet Address v6 to an Integer: " + this.getString(object) + " (The precision is too high to be contained in a long integer value)");
        }
        for (int i = 0; i < addr.length; ++i) {
            total += (long)(addr[i] & 0xFF) * (long)Math.pow(256.0, addr.length - 1 - i);
        }
        return total;
    }

    @Override
    public Double getNumber(Object object) throws KettleValueException {
        Long l = this.getInteger(object);
        if (l == null) {
            return null;
        }
        return Long.valueOf(l).doubleValue();
    }

    @Override
    public BigDecimal getBigNumber(Object object) throws KettleValueException {
        Long l = this.getInteger(object);
        if (l == null) {
            return null;
        }
        return BigDecimal.valueOf(l);
    }

    @Override
    public Boolean getBoolean(Object object) throws KettleValueException {
        throw new KettleValueException(this.toStringMeta() + ": it's not possible to convert from an Internet Address to a Boolean");
    }

    @Override
    public String getString(Object object) throws KettleValueException {
        return this.convertInternetAddressToString(this.getInternetAddress(object));
    }

    @Override
    public byte[] getBinaryString(Object object) throws KettleValueException {
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertStringToBinaryString(this.getString(object));
            }
            case 1: {
                return this.convertStringToBinaryString(this.getString(this.convertStringToInternetAddress(this.convertBinaryStringToString((byte[])object))));
            }
            case 2: {
                return this.convertStringToBinaryString(this.convertInternetAddressToString((InetAddress)this.index[(Integer)object]));
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
    }

    protected InetAddress convertBigNumberToInternetAddress(BigDecimal bd) throws KettleValueException {
        if (bd == null) {
            return null;
        }
        return this.convertIntegerToInternetAddress(bd.longValue());
    }

    protected InetAddress convertNumberToInternetAddress(Double d) throws KettleValueException {
        if (d == null) {
            return null;
        }
        long nanos = d.longValue();
        return this.convertIntegerToInternetAddress(nanos);
    }

    protected InetAddress convertIntegerToInternetAddress(Long l) throws KettleValueException {
        if (l == null) {
            return null;
        }
        byte[] addr = (double)l.longValue() >= Math.pow(256.0, 4.0) ? new byte[16] : new byte[4];
        for (int i = 0; i < addr.length; ++i) {
            long mask = 255 << i * 8;
            addr[addr.length - 1 - i] = (byte)((l & mask) >> 8 * i);
        }
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (Exception e) {
            throw new KettleValueException("Unable to convert an Integer to an internet address", e);
        }
    }

    protected synchronized InetAddress convertStringToInternetAddress(String string) throws KettleValueException {
        if (Utils.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert string [" + string + "] to an internet address", e);
        }
    }

    protected synchronized String convertInternetAddressToString(InetAddress inetAddress) throws KettleValueException {
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    @Override
    public Object convertDataFromString(String pol, ValueMetaInterface convertMeta, String nullIf, String ifNull, int trim_type) throws KettleValueException {
        String null_value = nullIf;
        if (null_value == null) {
            switch (convertMeta.getType()) {
                case 4: {
                    null_value = "";
                    break;
                }
                case 2: {
                    null_value = "";
                    break;
                }
                case 6: {
                    null_value = "";
                    break;
                }
                case 1: {
                    null_value = "";
                    break;
                }
                case 5: {
                    null_value = "";
                    break;
                }
                case 3: {
                    null_value = "";
                    break;
                }
                case 8: {
                    null_value = "";
                    break;
                }
                default: {
                    null_value = "";
                }
            }
        }
        if (!Utils.isEmpty(ifNull) && (Utils.isEmpty(pol) || pol.equalsIgnoreCase(Const.rightPad(new StringBuilder(null_value), pol.length())))) {
            pol = ifNull;
        }
        if (Utils.isEmpty(pol)) {
            return null;
        }
        if (!Utils.isEmpty(null_value) ? null_value.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad(new StringBuilder(null_value), pol.length())) : Const.onlySpaces(pol)) {
            return null;
        }
        switch (trim_type) {
            case 1: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    @Override
    public Object convertData(ValueMetaInterface meta2, Object data2) throws KettleValueException {
        switch (meta2.getType()) {
            case 2: {
                return this.convertStringToInternetAddress(meta2.getString(data2));
            }
            case 5: {
                return this.convertIntegerToInternetAddress(meta2.getInteger(data2));
            }
            case 1: {
                return this.convertNumberToInternetAddress(meta2.getNumber(data2));
            }
            case 6: {
                return this.convertBigNumberToInternetAddress(meta2.getBigNumber(data2));
            }
        }
        throw new KettleValueException(meta2.toStringMeta() + " : can't be converted to an Internet Address");
    }

    @Override
    public Object cloneValueData(Object object) throws KettleValueException {
        InetAddress inetAddress = this.getInternetAddress(object);
        if (inetAddress == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(inetAddress.getAddress());
        }
        catch (Exception e) {
            throw new KettleValueException("Unable to clone Internet Address", e);
        }
    }

    @Override
    public ValueMetaInterface getValueFromSQLType(DatabaseMeta databaseMeta, String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException {
        try {
            String columnTypeName;
            int type = rm.getColumnType(index);
            if (type == 1111 && "INET".equalsIgnoreCase(columnTypeName = rm.getColumnTypeName(index))) {
                ValueMetaInternetAddress valueMeta = new ValueMetaInternetAddress(name);
                this.getOriginalColumnMetadata(valueMeta, rm, index, ignoreLength);
                return valueMeta;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error evaluating Internet address value metadata", e);
        }
    }

    @Override
    public Object getValueFromResultSet(DatabaseInterface databaseInterface, ResultSet resultSet, int index) throws KettleDatabaseException {
        try {
            return this.convertStringToInternetAddress(resultSet.getString(index + 1));
        }
        catch (Exception e) {
            throw new KettleDatabaseException(this.toStringMeta() + " : Unable to get Internet Address from resultset at index " + index, e);
        }
    }

    @Override
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws KettleDatabaseException {
        try {
            preparedStatement.setObject(index, (Object)this.getString(data), 1111);
        }
        catch (Exception e) {
            throw new KettleDatabaseException(this.toStringMeta() + " : Unable to set Internet address value on prepared statement on index " + index, e);
        }
    }

    @Override
    public String getDatabaseColumnTypeDefinition(DatabaseInterface databaseInterface, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = null;
        if (databaseInterface instanceof PostgreSQLDatabaseMeta) {
            retval = add_fieldname ? this.getName() + " " : "";
            retval = retval + "INET";
            if (add_cr) {
                retval = retval + Const.CR;
            }
        }
        return retval;
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws KettleValueException {
        return InetAddress.class;
    }
}

