/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;

public class SftpFileSystemWindows
extends SftpFileSystem {
    private static final LogChannelInterface log = new LogChannel("SftpFileSystemWindows");
    private static final String WHO_AMI_GROUPS_FO_LIST = "Whoami /GROUPS /FO LIST";
    private static final String WHO_AMI = "Whoami ";
    private static final String ICACLS = "icacls ";
    private static final String VER = "ver";
    private static final String GROUP_NAME = "Group Name:";
    private static final String WINDOWS = "WINDOWS";
    private static final String N_DELIMITER = "\\n";
    private static final String RN_DELIMITER = "\r\n";
    private static final String WINDOWS_PATH_DELIMITER = "/";
    private Session session;
    private List<String> userGroups;
    private Boolean windows;

    public SftpFileSystemWindows(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super(rootName, session, fileSystemOptions);
        this.session = session;
    }

    public List<String> getUserGroups() throws JSchException, IOException {
        if (this.userGroups == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand(WHO_AMI_GROUPS_FO_LIST, output);
            if (code != 0) {
                throw new JSchException("Could not get the groups  of the current user (error code: " + code + ")");
            }
            this.userGroups = this.getUserGroups(output.toString());
            this.userGroups.add(this.getUser());
        }
        return this.userGroups;
    }

    private List<String> getUserGroups(String commandOutput) {
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        while ((startIndex = StringUtils.indexOfIgnoreCase((String)commandOutput, (String)GROUP_NAME, (int)startIndex)) >= 0) {
            int endIndex = StringUtils.indexOfIgnoreCase((String)commandOutput, (String)RN_DELIMITER, (int)(startIndex += GROUP_NAME.length()));
            if (endIndex < 0) {
                return result;
            }
            result.add(commandOutput.substring(startIndex, endIndex).toUpperCase().trim());
        }
        return result;
    }

    public String getUser() throws JSchException, IOException {
        StringBuilder output = new StringBuilder();
        int code = this.executeCommand(WHO_AMI, output);
        if (code != 0) {
            throw new JSchException("Could not get user name on remote host (error code: " + code + ")");
        }
        return output.toString().trim().toUpperCase();
    }

    public Map<String, String> getFilePermission(String path) throws JSchException, IOException {
        String[] strings;
        String windowsAbsPath;
        if (path.startsWith(WINDOWS_PATH_DELIMITER)) {
            path = path.substring(WINDOWS_PATH_DELIMITER.length());
            windowsAbsPath = path.substring(0, 1) + ":" + path.substring(1);
        } else {
            windowsAbsPath = path;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder output = new StringBuilder();
        int code = this.executeCommand(ICACLS + windowsAbsPath, output);
        if (code != 0) {
            return result;
        }
        String outputString = output.toString();
        int indexOf = outputString.indexOf(windowsAbsPath);
        if (indexOf > -1) {
            outputString = outputString.substring(indexOf + windowsAbsPath.length());
        }
        for (String string : strings = outputString.toUpperCase().split(N_DELIMITER)) {
            int index = string.indexOf(":");
            if (index <= -1) continue;
            result.put(string.substring(0, index).trim(), string.substring(index + 1).trim());
        }
        return result;
    }

    public boolean isRemoteHostWindows() throws JSchException, IOException {
        if (this.windows == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand(VER, output);
            this.windows = code == 0 && output.toString().toUpperCase().contains(WINDOWS);
        }
        return this.windows;
    }

    private void ensureSession() throws FileSystemException {
        block4: {
            Session session;
            if (this.session != null && this.session.isConnected()) break block4;
            this.doCloseCommunicationLink();
            UserAuthenticationData authData = null;
            try {
                GenericFileName e = (GenericFileName)this.getRootName();
                authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.getFileSystemOptions(), (UserAuthenticationData.Type[])SftpFileProvider.AUTHENTICATOR_TYPES);
                session = SftpClientFactory.createConnection((String)e.getHostName(), (int)e.getPort(), (char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)e.getUserName())), (char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)e.getPassword())), (FileSystemOptions)this.getFileSystemOptions());
            }
            catch (Exception var7) {
                try {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)var7);
                }
                catch (Throwable throwable) {
                    UserAuthenticatorUtils.cleanup(authData);
                    throw throwable;
                }
            }
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
            this.session = session;
        }
    }

    private int executeCommand(String command, StringBuilder output) throws JSchException, IOException {
        int read;
        this.ensureSession();
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(command);
        channel.setInputStream((InputStream)null);
        InputStreamReader stream = new InputStreamReader(channel.getInputStream());
        channel.setErrStream((OutputStream)System.err, true);
        channel.connect();
        char[] buffer = new char[128];
        while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
            output.append(buffer, 0, read);
        }
        stream.close();
        while (!channel.isClosed()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exc) {
                log.logMinimal("Warning: Error session closing. " + exc.getMessage());
            }
        }
        channel.disconnect();
        return channel.getExitStatus();
    }
}

