/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.auth.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.auth.core.AuthenticationConsumer;
import org.pentaho.di.core.auth.core.AuthenticationConsumerFactory;
import org.pentaho.di.core.auth.core.AuthenticationFactoryException;
import org.pentaho.di.core.auth.core.AuthenticationPerformer;
import org.pentaho.di.core.auth.core.AuthenticationPerformerFactory;
import org.pentaho.di.core.auth.core.AuthenticationProvider;
import org.pentaho.di.core.auth.core.impl.DefaultAuthenticationConsumerFactory;
import org.pentaho.di.core.auth.core.impl.DefaultAuthenticationPerformerFactory;
import org.pentaho.di.i18n.BaseMessages;

public class AuthenticationManager {
    private static final Class<?> PKG = AuthenticationManager.class;
    private final Map<Class<?>, Map<Class<?>, Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>>>> factoryMap = new HashMap();
    private AuthenticationPerformerFactory authenticationPerformerFactory = new DefaultAuthenticationPerformerFactory();
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        List<AuthenticationProvider> list = this.authenticationProviders;
        synchronized (list) {
            this.authenticationProviders.add(authenticationProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        List<AuthenticationProvider> list = this.authenticationProviders;
        synchronized (list) {
            return this.authenticationProviders.remove(authenticationProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, CreateArgType, ConsumedType> void registerConsumerFactory(AuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> factory) throws AuthenticationFactoryException {
        Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> createTypeMap;
        if (!factory.getConsumedType().isInterface() && !AuthenticationProvider.class.isAssignableFrom(factory.getConsumedType())) {
            throw new AuthenticationFactoryException(BaseMessages.getString(PKG, (String)"AuthenticationManager.ConsumedTypeError", (Object[])new Object[]{factory}));
        }
        Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> map = createTypeMap = this.getRelevantConsumerFactoryMap(factory.getReturnType(), factory.getCreateArgType());
        synchronized (map) {
            createTypeMap.put(factory.getConsumedType(), factory);
        }
    }

    public <ReturnType, ConsumedType> void registerConsumerClass(Class<? extends AuthenticationConsumer<? extends ReturnType, ? extends ConsumedType>> consumerClass) throws AuthenticationFactoryException {
        this.registerConsumerFactory(new DefaultAuthenticationConsumerFactory(consumerClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, CreateArgType, ConsumedType> List<AuthenticationPerformer<ReturnType, CreateArgType>> getSupportedAuthenticationPerformers(Class<ReturnType> returnType, Class<CreateArgType> createArgType) {
        ArrayList<AuthenticationProvider> authenticationProviders;
        Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> createTypeMap;
        Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> map = createTypeMap = this.getRelevantConsumerFactoryMap(returnType, createArgType);
        synchronized (map) {
            createTypeMap = new HashMap(createTypeMap);
        }
        List<AuthenticationProvider> list = this.authenticationProviders;
        synchronized (list) {
            authenticationProviders = new ArrayList<AuthenticationProvider>(this.authenticationProviders);
        }
        ArrayList<AuthenticationPerformer<ReturnType, CreateArgType>> result = new ArrayList<AuthenticationPerformer<ReturnType, CreateArgType>>();
        for (Map.Entry<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> entry : createTypeMap.entrySet()) {
            for (AuthenticationProvider provider : authenticationProviders) {
                AuthenticationPerformer<?, ?> authenticationPerformer = this.authenticationPerformerFactory.create(provider, entry.getValue());
                if (authenticationPerformer == null || authenticationPerformer.getDisplayName() == null) continue;
                result.add(authenticationPerformer);
            }
        }
        Collections.sort(result, new Comparator<AuthenticationPerformer<ReturnType, CreateArgType>>(){

            @Override
            public int compare(AuthenticationPerformer<ReturnType, CreateArgType> o1, AuthenticationPerformer<ReturnType, CreateArgType> o2) {
                return o1.getDisplayName().toUpperCase().compareTo(o2.getDisplayName().toUpperCase());
            }
        });
        return result;
    }

    public <ReturnType, CreateArgType, ConsumedType> AuthenticationPerformer<ReturnType, CreateArgType> getAuthenticationPerformer(Class<ReturnType> returnType, Class<CreateArgType> createArgType, String providerId) {
        List<AuthenticationPerformer<ReturnType, CreateArgType>> performers = this.getSupportedAuthenticationPerformers(returnType, createArgType);
        for (AuthenticationPerformer<ReturnType, CreateArgType> candidatePerformer : performers) {
            if (!candidatePerformer.getAuthenticationProvider().getId().equals(providerId)) continue;
            return candidatePerformer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ReturnType, CreateArgType> Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> getRelevantConsumerFactoryMap(Class<ReturnType> returnType, Class<CreateArgType> createArgType) {
        Map<Class<?>, Map<Class<?>, Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>>>> map = this.factoryMap;
        synchronized (map) {
            Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>> createTypeMap;
            Map<Class<?>, Map<Class<?>, AuthenticationConsumerFactory<?, ?, ?>>> returnTypeMap = this.factoryMap.get(returnType);
            if (returnTypeMap == null) {
                returnTypeMap = new HashMap();
                this.factoryMap.put(returnType, returnTypeMap);
            }
            if ((createTypeMap = returnTypeMap.get(createArgType)) == null) {
                createTypeMap = new HashMap();
                returnTypeMap.put(createArgType, createTypeMap);
            }
            return createTypeMap;
        }
    }

    protected void setAuthenticationPerformerFactory(AuthenticationPerformerFactory authenticationPerformerFactory) {
        this.authenticationPerformerFactory = authenticationPerformerFactory;
    }
}

