/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.w3c.dom.Node;

public abstract class BaseLogTable {
    public static final String XML_TAG = "field";
    public static String PROP_LOG_TABLE_CONNECTION_NAME = "_LOG_TABLE_CONNECTION_NAME";
    public static String PROP_LOG_TABLE_SCHEMA_NAME = "_LOG_TABLE_SCHEMA_NAME";
    public static String PROP_LOG_TABLE_TABLE_NAME = "_LOG_TABLE_TABLE_NAME";
    public static String PROP_LOG_TABLE_FIELD_ID = "_LOG_TABLE_FIELD_ID";
    public static String PROP_LOG_TABLE_FIELD_NAME = "_LOG_TABLE_FIELD_NAME";
    public static String PROP_LOG_TABLE_FIELD_ENABLED = "_LOG_TABLE_FIELD_ENABLED";
    public static String PROP_LOG_TABLE_FIELD_SUBJECT = "_LOG_TABLE_FIELD_SUBJECT";
    public static String PROP_LOG_TABLE_INTERVAL = "LOG_TABLE_INTERVAL";
    public static String PROP_LOG_TABLE_SIZE_LIMIT = "LOG_TABLE_SIZE_LIMIT";
    public static String PROP_LOG_TABLE_TIMEOUT_DAYS = "_LOG_TABLE_TIMEOUT_IN_DAYS";
    protected VariableSpace space;
    protected HasDatabasesInterface databasesInterface;
    protected String connectionName;
    protected String schemaName;
    protected String tableName;
    protected String timeoutInDays;
    protected List<LogTableField> fields;

    public BaseLogTable(VariableSpace space, HasDatabasesInterface databasesInterface, String connectionName, String schemaName, String tableName) {
        this.space = space;
        this.databasesInterface = databasesInterface;
        this.connectionName = connectionName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fields = new ArrayList<LogTableField>();
    }

    public void replaceMeta(BaseLogTable baseLogTable) {
        this.space = baseLogTable.space;
        this.databasesInterface = baseLogTable.databasesInterface;
        this.connectionName = baseLogTable.connectionName;
        this.schemaName = baseLogTable.schemaName;
        this.tableName = baseLogTable.tableName;
        this.timeoutInDays = baseLogTable.timeoutInDays;
        this.fields.clear();
        for (LogTableField field : baseLogTable.fields) {
            try {
                this.fields.add((LogTableField)field.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Clone problem with the base log table", e);
            }
        }
    }

    public String toString() {
        if (this.isDefined()) {
            return this.getDatabaseMeta().getName() + "-" + this.getActualTableName();
        }
        return super.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void saveToRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_CONNECTION_NAME, this.getConnectionName());
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_SCHEMA_NAME, this.getSchemaName());
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_TABLE_NAME, this.getTableName());
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_TIMEOUT_DAYS, this.getTimeoutInDays());
        for (int i = 0; i < this.getFields().size(); ++i) {
            LogTableField field = this.getFields().get(i);
            attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_ID + i, field.getId());
            attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_NAME + i, field.getFieldName());
            attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_ENABLED + i, field.isEnabled());
            if (!field.isSubjectAllowed()) continue;
            attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_SUBJECT + i, field.getSubject() == null ? null : field.getSubject().toString());
        }
    }

    public void loadFromRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        String tableNameFromRepository;
        String schemaNameFromRepository;
        String connectionNameFromRepository = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_CONNECTION_NAME);
        if (connectionNameFromRepository != null) {
            this.connectionName = connectionNameFromRepository;
        }
        if ((schemaNameFromRepository = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_SCHEMA_NAME)) != null) {
            this.schemaName = schemaNameFromRepository;
        }
        if ((tableNameFromRepository = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_TABLE_NAME)) != null) {
            this.tableName = tableNameFromRepository;
        }
        this.timeoutInDays = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_TIMEOUT_DAYS);
        for (int i = 0; i < this.getFields().size(); ++i) {
            LogTableField field;
            String id = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_ID + i);
            if (id == null || (field = this.findField(id)) == null) continue;
            field.setFieldName(attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_NAME + i));
            field.setEnabled(attributeInterface.getAttributeBoolean(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_ENABLED + i));
            if (!field.isSubjectAllowed()) continue;
            field.setSubject((Object)attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_FIELD_SUBJECT + i));
        }
    }

    public abstract String getLogTableCode();

    public abstract String getConnectionNameVariable();

    public abstract String getSchemaNameVariable();

    public abstract String getTableNameVariable();

    public DatabaseMeta getDatabaseMeta() {
        String name = this.getActualConnectionName();
        if (name == null) {
            return null;
        }
        if (this.databasesInterface == null) {
            return null;
        }
        return this.databasesInterface.findDatabase(name);
    }

    public String getActualConnectionName() {
        String name = this.space.environmentSubstitute(this.connectionName);
        if (Utils.isEmpty((CharSequence)name)) {
            name = this.space.getVariable(this.getConnectionNameVariable());
        }
        if (Utils.isEmpty((CharSequence)name)) {
            return null;
        }
        return name;
    }

    public String getActualSchemaName() {
        if (!Utils.isEmpty((CharSequence)this.schemaName)) {
            return this.space.environmentSubstitute(this.schemaName);
        }
        String name = this.space.getVariable(this.getSchemaNameVariable());
        if (Utils.isEmpty((CharSequence)name)) {
            return null;
        }
        return name;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getActualTableName() {
        if (!Utils.isEmpty((CharSequence)this.tableName)) {
            return this.space.environmentSubstitute(this.tableName);
        }
        String name = this.space.getVariable(this.getTableNameVariable());
        if (Utils.isEmpty((CharSequence)name)) {
            return null;
        }
        return name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getQuotedSchemaTableCombination() {
        return this.getDatabaseMeta().getQuotedSchemaTableCombination(this.getActualSchemaName(), this.getActualTableName());
    }

    public List<LogTableField> getFields() {
        return this.fields;
    }

    public void setFields(List<LogTableField> fields) {
        this.fields = fields;
    }

    public LogTableField findField(String id) {
        for (LogTableField field : this.fields) {
            if (!field.getId().equals(id)) continue;
            return field;
        }
        return null;
    }

    public Object getSubject(String id) {
        LogTableField field = this.findField(id);
        if (field == null) {
            return null;
        }
        return field.getSubject();
    }

    public String getSubjectString(String id) {
        LogTableField field = this.findField(id);
        if (field == null) {
            return null;
        }
        if (field.getSubject() == null) {
            return null;
        }
        return field.getSubject().toString();
    }

    public boolean containsKeyField() {
        for (LogTableField field : this.fields) {
            if (!field.isKey()) continue;
            return true;
        }
        return false;
    }

    public LogTableField getLogDateField() {
        for (LogTableField field : this.fields) {
            if (!field.isLogDateField()) continue;
            return field;
        }
        return null;
    }

    public LogTableField getKeyField() {
        for (LogTableField field : this.fields) {
            if (!field.isKey()) continue;
            return field;
        }
        return null;
    }

    public LogTableField getLogField() {
        for (LogTableField field : this.fields) {
            if (!field.isLogField()) continue;
            return field;
        }
        return null;
    }

    public LogTableField getStatusField() {
        for (LogTableField field : this.fields) {
            if (!field.isStatusField()) continue;
            return field;
        }
        return null;
    }

    public LogTableField getErrorsField() {
        for (LogTableField field : this.fields) {
            if (!field.isErrorsField()) continue;
            return field;
        }
        return null;
    }

    public LogTableField getNameField() {
        for (LogTableField field : this.fields) {
            if (!field.isNameField()) continue;
            return field;
        }
        return null;
    }

    protected String getFieldsXML() {
        StringBuilder retval = new StringBuilder();
        for (LogTableField field : this.fields) {
            retval.append("        ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"id", (String)field.getId()));
            retval.append("          ").append(XMLHandler.addTagValue((String)"enabled", (boolean)field.isEnabled()));
            retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)field.getFieldName()));
            if (field.isSubjectAllowed()) {
                retval.append("          ").append(XMLHandler.addTagValue((String)"subject", field.getSubject() == null ? null : field.getSubject().toString()));
            }
            retval.append("        ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        }
        return retval.toString();
    }

    public void loadFieldsXML(Node node) {
        int nr = XMLHandler.countNodes((Node)node, (String)XML_TAG);
        for (int i = 0; i < nr; ++i) {
            Node fieldNode = XMLHandler.getSubNodeByNr((Node)node, (String)XML_TAG, (int)i);
            String id = XMLHandler.getTagValue((Node)fieldNode, (String)"id");
            LogTableField field = this.findField(id);
            if (field == null && i < this.fields.size()) {
                field = this.fields.get(i);
            }
            if (field == null) continue;
            field.setFieldName(XMLHandler.getTagValue((Node)fieldNode, (String)"name"));
            field.setEnabled("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fieldNode, (String)"enabled")));
        }
    }

    public boolean isDefined() {
        return this.getDatabaseMeta() != null && !Utils.isEmpty((CharSequence)this.getActualTableName());
    }

    public String getTimeoutInDays() {
        return this.timeoutInDays;
    }

    public void setTimeoutInDays(String timeoutInDays) {
        this.timeoutInDays = timeoutInDays;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    protected String getLogBuffer(VariableSpace space, String logChannelId, LogStatus status, String limit) {
        int nrLines;
        String defaultLimit;
        StringBuffer buffer = KettleLogStore.getAppender().getBuffer(logChannelId, true);
        if (Utils.isEmpty((CharSequence)limit) && !Utils.isEmpty((CharSequence)(defaultLimit = space.getVariable("KETTLE_LOG_SIZE_LIMIT", null)))) {
            limit = defaultLimit;
        }
        int n = nrLines = Utils.isEmpty((CharSequence)limit) ? -1 : Const.toInt((String)space.environmentSubstitute(limit), (int)-1);
        if (nrLines > 0) {
            int start = buffer.length() - 1;
            for (int i = 0; i < nrLines && start > 0; ++i) {
                start = buffer.lastIndexOf(Const.CR, start - 1);
            }
            if (start > 0) {
                buffer.delete(0, start + Const.CR.length());
            }
        }
        return buffer.append(Const.CR + status.getStatus().toUpperCase() + Const.CR).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BaseLogTable)) {
            return false;
        }
        BaseLogTable blt = (BaseLogTable)obj;
        String cName = this.getActualConnectionName();
        String sName = this.getActualSchemaName();
        String tName = this.getActualTableName();
        return (cName == null ? blt.getActualConnectionName() == null : cName.equals(blt.getActualConnectionName())) && (sName == null ? blt.getActualSchemaName() == null : sName.equals(blt.getActualSchemaName())) && (tName == null ? blt.getActualTableName() == null : tName.equals(blt.getActualTableName()));
    }

    public void setAllGlobalParametersToNull() {
        boolean clearGlobalVariables = Boolean.valueOf(System.getProperties().getProperty("KETTLE_GLOBAL_LOG_VARIABLES_CLEAR_ON_EXPORT", "false"));
        if (clearGlobalVariables) {
            this.schemaName = this.isGlobalParameter(this.schemaName) ? null : this.schemaName;
            this.connectionName = this.isGlobalParameter(this.connectionName) ? null : this.connectionName;
            this.tableName = this.isGlobalParameter(this.tableName) ? null : this.tableName;
            this.timeoutInDays = this.isGlobalParameter(this.timeoutInDays) ? null : this.timeoutInDays;
        }
    }

    protected boolean isGlobalParameter(String parameter) {
        if (parameter == null) {
            return false;
        }
        if (parameter.startsWith("${") && parameter.endsWith("}")) {
            return System.getProperty(parameter.substring(2, parameter.length() - 1)) != null;
        }
        return false;
    }
}

