/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.annotations.EnginePlugin;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.api.Engine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=Engine.class)
@PluginAnnotationType(value=EnginePlugin.class)
public class EnginePluginType
extends BasePluginType
implements PluginTypeInterface {
    private static EnginePluginType enginePluginType;

    private EnginePluginType() {
        super(EnginePlugin.class, "ENGINE_PLUGIN", "Engine Plugin");
    }

    public static EnginePluginType getInstance() {
        if (enginePluginType == null) {
            enginePluginType = new EnginePluginType();
        }
        return enginePluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String xmlFile = "kettle-engines.xml";
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(xmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + xmlFile);
            }
            if (inputStream == null) {
                return;
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node repsNode = XMLHandler.getSubNode((Node)document, (String)"engines");
            List repsNodes = XMLHandler.getNodes((Node)repsNode, (String)"engine");
            for (Node repNode : repsNodes) {
                this.registerPluginFromXmlResource(repNode, "./", ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle extension points XML config file: " + xmlFile, (Throwable)e);
        }
    }

    protected void registerXmlPlugins() throws KettlePluginException {
    }

    protected String extractCategory(Annotation annotation) {
        return null;
    }

    protected String extractDesc(Annotation annotation) {
        return ((EnginePlugin)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((EnginePlugin)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((EnginePlugin)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((EnginePlugin)annotation).isSeparateClassLoaderNeeded();
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return ((EnginePlugin)annotation).documentationUrl();
    }

    protected String extractCasesUrl(Annotation annotation) {
        return ((EnginePlugin)annotation).casesUrl();
    }

    protected String extractForumUrl(Annotation annotation) {
        return ((EnginePlugin)annotation).forumUrl();
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((EnginePlugin)annotation).classLoaderGroup();
    }
}

