/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.ExtensionDataInterface;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.trans.BasePartitioner;
import org.pentaho.di.trans.SlaveStepCopyPartitionDistribution;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.RowHandler;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.mapping.Mapping;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.metastore.api.IMetaStore;

public class BaseStep
implements VariableSpace,
StepInterface,
LoggingObjectInterface,
ExtensionDataInterface {
    private static Class<?> PKG = BaseStep.class;
    protected VariableSpace variables = new Variables();
    private TransMeta transMeta;
    private StepMeta stepMeta;
    private String stepname;
    protected LogChannelInterface log;
    private String containerObjectId;
    private Trans trans;
    private Object statusCountersLock = new Object();
    @Deprecated
    public long linesRead;
    @Deprecated
    public long linesWritten;
    @Deprecated
    public long linesInput;
    @Deprecated
    public long linesOutput;
    @Deprecated
    public long linesUpdated;
    @Deprecated
    public long linesSkipped;
    @Deprecated
    public long linesRejected;
    private boolean distributed;
    private String rowDistributionCode;
    private RowDistributionInterface rowDistribution;
    private long errors;
    private StepMeta[] nextSteps;
    private StepMeta[] prevSteps;
    private int currentInputRowSetNr;
    private int currentOutputRowSetNr;
    private List<RowSet> inputRowSets;
    private List<RowSet> outputRowSets;
    private List<RemoteStep> remoteInputSteps;
    private List<RemoteStep> remoteOutputSteps;
    private RowSet errorRowSet;
    private AtomicBoolean running;
    private AtomicBoolean stopped;
    private AtomicBoolean paused;
    private boolean init;
    private int stepcopy;
    private Date start_time;
    private Date stop_time;
    public boolean first;
    public boolean terminator;
    public List<Object[]> terminator_rows;
    private StepMetaInterface stepMetaInterface;
    private StepDataInterface stepDataInterface;
    protected List<RowListener> rowListeners;
    private final Map<String, ResultFile> resultFiles;
    private final ReentrantReadWriteLock resultFilesLock;
    private RowMetaInterface inputReferenceRow;
    private boolean partitioned;
    private String partitionID;
    private int repartitioning;
    private Map<String, BlockingRowSet> partitionTargets;
    private RowMetaInterface inputRowMeta;
    private StepPartitioningMeta nextStepPartitioningMeta;
    private RowMetaInterface errorRowMeta = null;
    private RowMetaInterface previewRowMeta;
    private boolean checkTransRunning;
    private int slaveNr;
    private int clusterSize;
    private int uniqueStepNrAcrossSlaves;
    private int uniqueStepCountAcrossSlaves;
    private boolean remoteOutputStepsInitialized;
    private boolean remoteInputStepsInitialized;
    private RowSet[] partitionNrRowSetList;
    private List<ServerSocket> serverSockets;
    private static int NR_OF_ROWS_IN_BLOCK = 500;
    private int blockPointer;
    private boolean clusteredPartitioningFirst;
    private boolean clusteredPartitioning;
    private boolean usingThreadPriorityManagment;
    private List<StepListener> stepListeners;
    private SocketRepository socketRepository;
    private int upperBufferBoundary;
    private int lowerBufferBoundary;
    private Long maxErrors = -1L;
    private int maxPercentErrors = -1;
    private long minRowsForMaxErrorPercent = -1L;
    protected long deadLockCounter;
    protected Repository repository;
    protected IMetaStore metaStore;
    protected Map<String, Object> extensionDataMap;
    private RowHandler rowHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        this.stepMeta = stepMeta;
        this.stepDataInterface = stepDataInterface;
        this.stepcopy = copyNr;
        this.transMeta = transMeta;
        this.trans = trans;
        this.stepname = stepMeta.getName();
        this.socketRepository = trans.getSocketRepository();
        if (stepMeta.getName() == null) {
            throw new RuntimeException("A step in transformation [" + transMeta.toString() + "] doesn't have a name.  A step should always have a name to identify it by.");
        }
        this.log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)this, (LoggingObjectInterface)trans);
        this.first = true;
        this.clusteredPartitioningFirst = true;
        this.running = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.paused = new AtomicBoolean(false);
        this.init = false;
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRead = 0L;
            this.linesWritten = 0L;
            this.linesUpdated = 0L;
            this.linesSkipped = 0L;
            this.linesRejected = 0L;
            this.linesInput = 0L;
            this.linesOutput = 0L;
        }
        this.inputRowSets = null;
        this.outputRowSets = null;
        this.nextSteps = null;
        this.terminator = stepMeta.hasTerminator();
        this.terminator_rows = this.terminator ? new ArrayList<Object[]>() : null;
        this.start_time = null;
        this.stop_time = null;
        this.distributed = stepMeta.isDistributes();
        this.rowDistribution = stepMeta.getRowDistribution();
        if (this.distributed) {
            if (this.rowDistribution != null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.CustomRowDistributionActivated", (String[])new String[]{this.rowDistributionCode}));
                }
            } else if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.DistributionActivated", (String[])new String[0]));
            }
        } else if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.DistributionDeactivated", (String[])new String[0]));
        }
        this.rowListeners = new ArrayList<RowListener>();
        this.resultFiles = new HashMap<String, ResultFile>();
        this.resultFilesLock = new ReentrantReadWriteLock();
        this.repartitioning = 0;
        this.partitionTargets = new Hashtable<String, BlockingRowSet>();
        this.serverSockets = new ArrayList<ServerSocket>();
        this.extensionDataMap = new HashMap<String, Object>();
        this.checkTransRunning = false;
        this.blockPointer = 0;
        this.stepListeners = Collections.synchronizedList(new ArrayList());
        this.dispatch();
        this.upperBufferBoundary = (int)((double)transMeta.getSizeRowset() * 0.99);
        this.lowerBufferBoundary = (int)((double)transMeta.getSizeRowset() * 0.01);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        StepErrorMeta stepErrorMeta;
        RemoteStep copy;
        int i;
        block32: {
            block34: {
                block35: {
                    sdi.setStatus(BaseStepData.StepExecutionStatus.STATUS_INIT);
                    String slaveNr = this.transMeta.getVariable("Internal.Slave.Transformation.Number");
                    String clusterSize = this.transMeta.getVariable("Internal.Cluster.Size");
                    boolean master = "Y".equalsIgnoreCase(this.transMeta.getVariable("Internal.Cluster.Master"));
                    if (!(Utils.isEmpty((CharSequence)slaveNr) || Utils.isEmpty((CharSequence)clusterSize) || master)) {
                        this.slaveNr = Integer.parseInt(slaveNr);
                        this.clusterSize = Integer.parseInt(clusterSize);
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.ReleasedServerSocketOnPort", (String[])new String[]{slaveNr, clusterSize}));
                        }
                    } else {
                        this.slaveNr = 0;
                        this.clusterSize = 0;
                    }
                    SlaveStepCopyPartitionDistribution partitionDistribution = this.transMeta.getSlaveStepCopyPartitionDistribution();
                    if (!this.stepMeta.isPartitioned()) break block34;
                    if (partitionDistribution == null || partitionDistribution.getDistribution().isEmpty()) break block35;
                    String slaveServerName = this.getVariable("Internal.Slave.Server.Name");
                    int stepCopyNr = this.stepcopy;
                    PartitionSchema partitionSchema = this.stepMeta.getStepPartitioningMeta().getPartitionSchema();
                    int partitionNr = partitionDistribution.getPartition(slaveServerName, partitionSchema.getName(), stepCopyNr);
                    if (partitionNr < 0) break block32;
                    String partitionNrString = new DecimalFormat("000").format(partitionNr);
                    this.setVariable("Internal.Step.Partition.Number", partitionNrString);
                    if (partitionDistribution.getOriginalPartitionSchemas() != null) {
                        String partitionSchemaName = this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getName();
                        for (PartitionSchema originalPartitionSchema : partitionDistribution.getOriginalPartitionSchemas()) {
                            String slavePartitionSchemaName = TransSplitter.createSlavePartitionSchemaName(originalPartitionSchema.getName());
                            if (!slavePartitionSchemaName.equals(partitionSchemaName)) continue;
                            PartitionSchema schema = (PartitionSchema)originalPartitionSchema.clone();
                            if (schema.isDynamicallyDefined()) {
                                schema.expandPartitionsDynamically(this.clusterSize, this);
                            }
                            String partID = schema.getPartitionIDs().get(partitionNr);
                            this.setVariable("Internal.Step.Partition.ID", partID);
                            break block32;
                        }
                    }
                    break block32;
                }
                int partitionNr = this.stepcopy;
                String partitionNrString = new DecimalFormat("000").format(partitionNr);
                this.setVariable("Internal.Step.Partition.Number", partitionNrString);
                List<String> partitionIDList = this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getPartitionIDs();
                if (partitionIDList.size() <= 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.UnableToRetrievePartitionId", (String[])new String[]{this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getName()}));
                    return false;
                }
                String partitionID = partitionIDList.get(partitionNr);
                this.setVariable("Internal.Step.Partition.ID", partitionID);
                break block32;
            }
            if (!Utils.isEmpty((CharSequence)this.partitionID)) {
                this.setVariable("Internal.Step.Partition.ID", this.partitionID);
            }
        }
        this.uniqueStepNrAcrossSlaves = this.slaveNr * this.getStepMeta().getCopies() + this.stepcopy;
        int n = this.uniqueStepCountAcrossSlaves = this.clusterSize <= 1 ? this.getStepMeta().getCopies() : this.clusterSize * this.getStepMeta().getCopies();
        if (this.uniqueStepCountAcrossSlaves == 0) {
            this.uniqueStepCountAcrossSlaves = 1;
        }
        this.setVariable("Internal.Step.Unique.Number", Integer.toString(this.uniqueStepNrAcrossSlaves));
        this.setVariable("Internal.Step.Unique.Count", Integer.toString(this.uniqueStepCountAcrossSlaves));
        this.setVariable("Internal.Step.CopyNr", Integer.toString(this.stepcopy));
        try {
            this.remoteOutputSteps = new ArrayList<RemoteStep>();
            for (i = 0; i < this.stepMeta.getRemoteOutputSteps().size(); ++i) {
                RemoteStep remoteStep = this.stepMeta.getRemoteOutputSteps().get(i);
                if (this.getCopy() != remoteStep.getSourceStepCopyNr()) continue;
                copy = (RemoteStep)remoteStep.clone();
                try {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.SelectedRemoteOutputStepToServer", (Object[])new Object[]{copy, copy.getTargetStep(), copy.getTargetStepCopyNr(), copy.getPort()}));
                    }
                    copy.openServerSocket(this);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.OpenedServerSocketConnectionTo", (Object[])new Object[]{copy}));
                    }
                }
                catch (Exception e) {
                    this.logError("Unable to open server socket during step initialisation: " + copy.toString(), e);
                    throw e;
                }
                this.remoteOutputSteps.add(copy);
            }
        }
        catch (Exception e) {
            Iterator<RemoteStep> remoteStep = this.remoteOutputSteps.iterator();
            while (true) {
                if (!remoteStep.hasNext()) {
                    return false;
                }
                RemoteStep remoteStep2 = remoteStep.next();
                if (remoteStep2.getServerSocket() == null) continue;
                try {
                    ServerSocket serverSocket = remoteStep2.getServerSocket();
                    this.getTrans().getSocketRepository().releaseSocket(serverSocket.getLocalPort());
                }
                catch (IOException e1) {
                    this.logError("Unable to close server socket after error during step initialisation", e);
                }
            }
        }
        try {
            this.remoteInputSteps = new ArrayList<RemoteStep>();
            if (this.stepMeta.isPartitioned() && this.getClusterSize() > 1 || this.stepMeta.getCopies() > 1) {
                for (i = 0; i < this.stepMeta.getRemoteInputSteps().size(); ++i) {
                    RemoteStep remoteStep = this.stepMeta.getRemoteInputSteps().get(i);
                    if (remoteStep.getTargetStepCopyNr() != this.stepcopy) continue;
                    copy = (RemoteStep)remoteStep.clone();
                    this.remoteInputSteps.add(copy);
                }
            } else {
                for (RemoteStep remoteStep : this.stepMeta.getRemoteInputSteps()) {
                    copy = (RemoteStep)remoteStep.clone();
                    this.remoteInputSteps.add(copy);
                }
            }
        }
        catch (Exception e) {
            this.logError("Unable to initialize remote input steps during step initialisation", e);
            return false;
        }
        if ((stepErrorMeta = this.stepMeta.getStepErrorMeta()) == null) return true;
        boolean envSubFailed = false;
        try {
            this.maxErrors = !Utils.isEmpty((CharSequence)stepErrorMeta.getMaxErrors()) ? Long.valueOf(this.trans.environmentSubstitute(stepErrorMeta.getMaxErrors())) : -1L;
        }
        catch (NumberFormatException nfe) {
            this.log.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.NumberFormatException", (String[])new String[]{BaseMessages.getString(PKG, (String)"BaseStep.Property.MaxErrors.Name", (String[])new String[0]), this.stepname, stepErrorMeta.getMaxErrors() != null ? stepErrorMeta.getMaxErrors() : ""}));
            envSubFailed = true;
        }
        try {
            this.minRowsForMaxErrorPercent = !Utils.isEmpty((CharSequence)stepErrorMeta.getMinPercentRows()) ? Long.valueOf(this.trans.environmentSubstitute(stepErrorMeta.getMinPercentRows())) : -1L;
        }
        catch (NumberFormatException nfe) {
            this.log.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.NumberFormatException", (String[])new String[]{BaseMessages.getString(PKG, (String)"BaseStep.Property.MinRowsForErrorsPercentCalc.Name", (String[])new String[0]), this.stepname, stepErrorMeta.getMinPercentRows() != null ? stepErrorMeta.getMinPercentRows() : ""}));
            envSubFailed = true;
        }
        try {
            this.maxPercentErrors = !Utils.isEmpty((CharSequence)stepErrorMeta.getMaxPercentErrors()) ? Integer.valueOf(this.trans.environmentSubstitute(stepErrorMeta.getMaxPercentErrors())) : -1;
        }
        catch (NumberFormatException nfe) {
            this.log.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.NumberFormatException", (String[])new String[]{BaseMessages.getString(PKG, (String)"BaseStep.Property.MaxPercentErrors.Name", (String[])new String[0]), this.stepname, stepErrorMeta.getMaxPercentErrors() != null ? stepErrorMeta.getMaxPercentErrors() : ""}));
            return false;
        }
        if (!envSubFailed) return true;
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        sdi.setStatus(BaseStepData.StepExecutionStatus.STATUS_DISPOSED);
    }

    @Override
    public void cleanup() {
        List<RemoteStep> remoteOutputSteps;
        for (ServerSocket serverSocket : this.serverSockets) {
            try {
                this.socketRepository.releaseSocket(serverSocket.getLocalPort());
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.ReleasedServerSocketOnPort", (Object[])new Object[]{serverSocket.getLocalPort()}));
            }
            catch (IOException e) {
                this.logError("Cleanup: Unable to release server socket (" + serverSocket.getLocalPort() + ")", e);
            }
        }
        List<RemoteStep> remoteInputSteps = this.getRemoteInputSteps();
        if (remoteInputSteps != null) {
            BaseStep.cleanupRemoteSteps(remoteInputSteps);
        }
        if ((remoteOutputSteps = this.getRemoteOutputSteps()) != null) {
            BaseStep.cleanupRemoteSteps(remoteOutputSteps);
        }
    }

    static void cleanupRemoteSteps(List<RemoteStep> remoteSteps) {
        for (RemoteStep remoteStep : remoteSteps) {
            remoteStep.cleanup();
        }
    }

    @Override
    public long getProcessed() {
        if (this.getLinesRead() > this.getLinesWritten()) {
            return this.getLinesRead();
        }
        return this.getLinesWritten();
    }

    public void setCopy(int cop) {
        this.stepcopy = cop;
    }

    @Override
    public int getCopy() {
        return this.stepcopy;
    }

    @Override
    public long getErrors() {
        return this.errors;
    }

    @Override
    public void setErrors(long e) {
        this.errors = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return --this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesRead(long newLinesReadValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRead = newLinesReadValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesInput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesInput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesInput(long newLinesInputValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesInput = newLinesInputValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesOutput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesOutput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesOutput(long newLinesOutputValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesOutput = newLinesOutputValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return --this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesWritten(long newLinesWrittenValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesWritten = newLinesWrittenValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesUpdated() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesUpdated() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesUpdated(long newLinesUpdatedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesUpdated = newLinesUpdatedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesRejected() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesRejected() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinesRejected(long newLinesRejectedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRejected = newLinesRejectedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLinesSkipped() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesSkipped() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesSkipped(long newLinesSkippedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesSkipped = newLinesSkippedValue;
        }
    }

    @Override
    public String getStepname() {
        return this.stepname;
    }

    public void setStepname(String stepname) {
        this.stepname = stepname;
    }

    public Trans getDispatcher() {
        return this.trans;
    }

    public String getStatusDescription() {
        return this.getStatus().getDescription();
    }

    public StepMetaInterface getStepMetaInterface() {
        return this.stepMetaInterface;
    }

    public void setStepMetaInterface(StepMetaInterface stepMetaInterface) {
        this.stepMetaInterface = stepMetaInterface;
    }

    public StepDataInterface getStepDataInterface() {
        return this.stepDataInterface;
    }

    public void setStepDataInterface(StepDataInterface stepDataInterface) {
        this.stepDataInterface = stepDataInterface;
    }

    @Override
    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void setStepMeta(StepMeta stepMeta) {
        this.stepMeta = stepMeta;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    @Override
    public Trans getTrans() {
        return this.trans;
    }

    @Override
    public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        this.getRowHandler().putRow(rowMeta, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePutRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseStep.Log.StopPuttingARow", (String[])new String[0]));
            }
            this.stopAll();
            return;
        }
        if (!this.checkTransRunning) {
            while (!this.trans.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
            this.checkTransRunning = true;
        }
        List<RowListener> e = this.rowListeners;
        synchronized (e) {
            for (int i = 0; i < this.rowListeners.size(); ++i) {
                RowListener rowListener = this.rowListeners.get(i);
                rowListener.rowWrittenEvent(rowMeta, row);
            }
        }
        if (this.terminator && this.terminator_rows != null) {
            try {
                this.terminator_rows.add(rowMeta.cloneRow(row));
            }
            catch (KettleValueException e2) {
                throw new KettleStepException("Unable to clone row while adding rows to the terminator rows.", (Throwable)e2);
            }
        }
        if (this.outputRowSets.isEmpty()) {
            this.incrementLinesWritten();
            return;
        }
        switch (this.repartitioning) {
            case 0: {
                this.noPartitioning(rowMeta, row);
                break;
            }
            case 2: {
                this.specialPartitioning(rowMeta, row);
                break;
            }
            case 1: {
                this.mirrorPartitioning(rowMeta, row);
                break;
            }
            default: {
                throw new KettleStepException("Internal error: invalid repartitioning type: " + this.repartitioning);
            }
        }
    }

    private void mirrorPartitioning(RowMetaInterface rowMeta, Object[] row) {
        for (int r = 0; r < this.outputRowSets.size(); ++r) {
            RowSet rowSet = this.outputRowSets.get(r);
            this.putRowToRowSet(rowSet, rowMeta, row);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void specialPartitioning(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        int partitionNr;
        List<StepMeta> nextSteps;
        if (this.nextStepPartitioningMeta == null && (nextSteps = this.transMeta.findNextSteps(this.stepMeta)).size() > 0) {
            this.nextStepPartitioningMeta = nextSteps.get(0).getStepPartitioningMeta();
        }
        try {
            partitionNr = this.nextStepPartitioningMeta.getPartition(rowMeta, row);
        }
        catch (KettleException e) {
            throw new KettleStepException("Unable to convert a value to integer while calculating the partition number", (Throwable)e);
        }
        RowSet selectedRowSet = null;
        if (this.clusteredPartitioningFirst) {
            this.clusteredPartitioningFirst = false;
            boolean bl = this.clusteredPartitioning = this.transMeta.getSlaveStepCopyPartitionDistribution() != null && !this.transMeta.getSlaveStepCopyPartitionDistribution().getDistribution().isEmpty();
        }
        if (this.clusteredPartitioning) {
            if (this.partitionNrRowSetList == null) {
                this.partitionNrRowSetList = new RowSet[this.outputRowSets.size()];
                SlaveStepCopyPartitionDistribution distribution = this.transMeta.getSlaveStepCopyPartitionDistribution();
                String string = TransSplitter.createPartitionSchemaNameFromTarget(this.nextStepPartitioningMeta.getPartitionSchema().getName());
                for (RowSet outputRowSet : this.outputRowSets) {
                    int partNr = distribution.getPartition(outputRowSet.getRemoteSlaveServerName(), string, outputRowSet.getDestinationStepCopy());
                    if (partNr < 0) {
                        throw new KettleStepException("Unable to find partition using rowset data, slave=" + outputRowSet.getRemoteSlaveServerName() + ", partition schema=" + this.nextStepPartitioningMeta.getPartitionSchema().getName() + ", copy=" + outputRowSet.getDestinationStepCopy());
                    }
                    this.partitionNrRowSetList[partNr] = outputRowSet;
                }
            }
            if (partitionNr >= this.partitionNrRowSetList.length) {
                String rowsets = "";
                for (RowSet rowSet : this.partitionNrRowSetList) {
                    rowsets = rowsets + "[" + rowSet.toString() + "] ";
                }
                throw new KettleStepException("Internal error: the referenced partition nr '" + partitionNr + "' is higher than the maximum of '" + (this.partitionNrRowSetList.length - 1) + ".  The available row sets are: {" + rowsets + "}");
            }
            selectedRowSet = this.partitionNrRowSetList[partitionNr];
            if (selectedRowSet == null) {
                this.logBasic(BaseMessages.getString(PKG, (String)"BaseStep.TargetRowsetIsNotAvailable", (Object[])new Object[]{partitionNr}));
            } else {
                this.putRowToRowSet(selectedRowSet, rowMeta, row);
                this.incrementLinesWritten();
                if (this.log.isRowLevel()) {
                    try {
                        this.logRowlevel("Partitioned #" + partitionNr + " to " + selectedRowSet + ", row=" + rowMeta.getString(row));
                    }
                    catch (KettleValueException e) {
                        throw new KettleStepException((Throwable)e);
                    }
                }
            }
        } else {
            void var6_13;
            int partCount = ((BasePartitioner)this.nextStepPartitioningMeta.getPartitioner()).getNrPartitions();
            boolean bl = false;
            while (var6_13 < this.nextSteps.length) {
                selectedRowSet = this.outputRowSets.get(partitionNr + var6_13 * partCount);
                if (selectedRowSet == null) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"BaseStep.TargetRowsetIsNotAvailable", (Object[])new Object[]{partitionNr}));
                } else {
                    this.putRowToRowSet(selectedRowSet, rowMeta, row);
                    this.incrementLinesWritten();
                    if (this.log.isRowLevel()) {
                        try {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"BaseStep.PartitionedToRow", (Object[])new Object[]{partitionNr, selectedRowSet, rowMeta.getString(row)}));
                        }
                        catch (KettleValueException e) {
                            throw new KettleStepException((Throwable)e);
                        }
                    }
                }
                ++var6_13;
            }
        }
    }

    private void noPartitioning(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        if (this.distributed) {
            if (this.rowDistribution != null) {
                this.rowDistribution.distributeRow(rowMeta, row, this);
                this.incrementLinesWritten();
            } else {
                RowSet rs = this.outputRowSets.get(this.currentOutputRowSetNr);
                if (this.isUsingThreadPriorityManagment() && !rs.isDone() && rs.size() >= this.upperBufferBoundary && !this.isStopped()) {
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.putRowToRowSet(rs, rowMeta, row);
                this.incrementLinesWritten();
                if (this.outputRowSets.size() > 1) {
                    ++this.currentOutputRowSetNr;
                    if (this.currentOutputRowSetNr >= this.outputRowSets.size()) {
                        this.currentOutputRowSetNr = 0;
                    }
                }
            }
        } else {
            for (int i = 1; i < this.outputRowSets.size(); ++i) {
                RowSet rs = this.outputRowSets.get(i);
                if (this.isUsingThreadPriorityManagment() && !rs.isDone() && rs.size() >= this.upperBufferBoundary && !this.isStopped()) {
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    this.putRowToRowSet(rs, rowMeta, rowMeta.cloneRow(row));
                    this.incrementLinesWritten();
                    continue;
                }
                catch (KettleValueException e) {
                    throw new KettleStepException("Unable to clone row while copying rows to multiple target steps", (Throwable)e);
                }
            }
            RowSet rs = this.outputRowSets.get(0);
            this.putRowToRowSet(rs, rowMeta, row);
            this.incrementLinesWritten();
        }
    }

    private void putRowToRowSet(RowSet rs, RowMetaInterface rowMeta, Object[] row) {
        RowMetaInterface metaFromRs = rs.getRowMeta();
        RowMetaInterface toBeSent = metaFromRs == null ? rowMeta.clone() : metaFromRs;
        while (!rs.putRow(toBeSent, row)) {
            if (!this.isStopped()) continue;
            return;
        }
    }

    public void putRowTo(RowMetaInterface rowMeta, Object[] row, RowSet rowSet) throws KettleStepException {
        this.getRowHandler().putRowTo(rowMeta, row, rowSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePutRowTo(RowMetaInterface rowMeta, Object[] row, RowSet rowSet) throws KettleStepException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        List<RowListener> e = this.rowListeners;
        synchronized (e) {
            for (int i = 0; i < this.rowListeners.size(); ++i) {
                RowListener rowListener = this.rowListeners.get(i);
                rowListener.rowWrittenEvent(rowMeta, row);
            }
        }
        if (this.terminator && this.terminator_rows != null) {
            try {
                this.terminator_rows.add(rowMeta.cloneRow(row));
            }
            catch (KettleValueException e2) {
                throw new KettleStepException("Unable to clone row while adding rows to the terminator buffer", (Throwable)e2);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseStep.Log.StopPuttingARow", (String[])new String[0]));
            }
            this.stopAll();
            return;
        }
        while (!rowSet.putRow(rowMeta, row) && !this.isStopped()) {
        }
        this.incrementLinesWritten();
    }

    public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
        this.getRowHandler().putError(rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePutError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
        if (this.trans.isSafeModeEnabled() && rowMeta.size() > row.length) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"BaseStep.Exception.MetadataDoesntMatchDataRowSize", (String[])new String[]{Integer.toString(rowMeta.size()), Integer.toString(row != null ? row.length : 0)}));
        }
        StepErrorMeta stepErrorMeta = this.stepMeta.getStepErrorMeta();
        if (this.errorRowMeta == null) {
            this.errorRowMeta = rowMeta.clone();
            RowMetaInterface add = stepErrorMeta.getErrorRowMeta(nrErrors, errorDescriptions, fieldNames, errorCodes);
            this.errorRowMeta.addRowMeta(add);
        }
        Object[] errorRowData = RowDataUtil.allocateRowData((int)this.errorRowMeta.size());
        if (row != null) {
            System.arraycopy(row, 0, errorRowData, 0, rowMeta.size());
        }
        stepErrorMeta.addErrorRowData(errorRowData, rowMeta.size(), nrErrors, errorDescriptions, fieldNames, errorCodes);
        List<RowListener> list = this.rowListeners;
        synchronized (list) {
            for (int i = 0; i < this.rowListeners.size(); ++i) {
                RowListener rowListener = this.rowListeners.get(i);
                rowListener.errorRowWrittenEvent(rowMeta, row);
            }
        }
        if (this.errorRowSet != null) {
            while (!this.errorRowSet.putRow(this.errorRowMeta, errorRowData) && !this.isStopped()) {
            }
            this.incrementLinesRejected();
        }
        this.verifyRejectionRates();
    }

    private void verifyRejectionRates() {
        int pct;
        StepErrorMeta stepErrorMeta = this.stepMeta.getStepErrorMeta();
        if (stepErrorMeta == null) {
            return;
        }
        if (this.maxErrors > 0L && this.getLinesRejected() > this.maxErrors) {
            this.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.TooManyRejectedRows", (String[])new String[]{Long.toString(this.maxErrors), Long.toString(this.getLinesRejected())}));
            this.setErrors(1L);
            this.stopAll();
        }
        if (this.maxPercentErrors > 0 && this.getLinesRejected() > 0L && (this.minRowsForMaxErrorPercent <= 0L || this.getLinesRead() >= this.minRowsForMaxErrorPercent) && (pct = (int)Math.ceil(100.0 * (double)this.getLinesRejected() / (double)this.getLinesRead())) > this.maxPercentErrors) {
            this.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.MaxPercentageRejectedReached", (String[])new String[]{Integer.toString(pct), Long.toString(this.getLinesRejected()), Long.toString(this.getLinesRead())}));
            this.setErrors(1L);
            this.stopAll();
        }
    }

    private RowSet currentInputStream() {
        return this.inputRowSets.get(this.currentInputRowSetNr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextInputStream() {
        List<RowSet> list = this.inputRowSets;
        synchronized (list) {
            this.blockPointer = 0;
            int streams = this.inputRowSets.size();
            if (streams == 0) {
                return;
            }
            if (streams == 1) {
                this.currentInputRowSetNr = 0;
            }
            ++this.currentInputRowSetNr;
            if (this.currentInputRowSetNr >= this.inputRowSets.size()) {
                this.currentInputRowSetNr = 0;
            }
        }
    }

    protected void waitUntilTransformationIsStarted() {
        if (!this.checkTransRunning) {
            while (!this.trans.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.checkTransRunning = true;
        }
    }

    @Override
    public Object[] getRow() throws KettleException {
        return this.getRowHandler().getRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] handleGetRow() throws KettleException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseStep.Log.StopLookingForMoreRows", (String[])new String[0]));
            }
            this.stopAll();
            return null;
        }
        this.waitUntilTransformationIsStarted();
        this.openRemoteInputStepSocketsOnce();
        if (this.inputRowSets.isEmpty()) {
            return null;
        }
        RowSet inputRowSet = null;
        Object[] row = null;
        if (this.blockPointer >= NR_OF_ROWS_IN_BLOCK) {
            for (int r = 0; r < this.inputRowSets.size() && row == null; ++r) {
                this.nextInputStream();
                inputRowSet = this.currentInputStream();
                row = inputRowSet.getRowImmediate();
            }
            if (row != null) {
                this.incrementLinesRead();
            }
        } else {
            inputRowSet = this.currentInputStream();
        }
        if (this.isUsingThreadPriorityManagment() && !inputRowSet.isDone() && inputRowSet.size() <= this.lowerBufferBoundary && !this.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (row == null && !this.isStopped()) {
            row = inputRowSet.getRowWait(1L, TimeUnit.MILLISECONDS);
            if (row != null) {
                this.incrementLinesRead();
                ++this.blockPointer;
                continue;
            }
            if (inputRowSet.isDone()) {
                row = inputRowSet.getRowWait(1L, TimeUnit.MILLISECONDS);
                if (row == null) {
                    this.inputRowSets.remove(this.currentInputRowSetNr);
                    if (this.inputRowSets.isEmpty()) {
                        return null;
                    }
                } else {
                    this.incrementLinesRead();
                }
            }
            this.nextInputStream();
            inputRowSet = this.currentInputStream();
        }
        while (row == null && !this.stopped.get()) {
            if (this.inputRowSets.isEmpty()) {
                return null;
            }
            this.nextInputStream();
            inputRowSet = this.currentInputStream();
            row = this.getRowFrom(inputRowSet);
        }
        if (this.inputRowMeta == null || this.prevSteps.length > 1) {
            this.inputRowMeta = inputRowSet.getRowMeta();
        }
        if (row != null) {
            if (this.trans.isSafeModeEnabled()) {
                BaseStep.safeModeChecking(inputRowSet.getRowMeta(), this.inputRowMeta);
                if (row.length < this.inputRowMeta.size()) {
                    throw new KettleException("Safe mode check noticed that the length of the row data is smaller (" + row.length + ") than the row metadata size (" + this.inputRowMeta.size() + ")");
                }
            }
            List<RowListener> list = this.rowListeners;
            synchronized (list) {
                for (int i = 0; i < this.rowListeners.size(); ++i) {
                    RowListener rowListener = this.rowListeners.get(i);
                    rowListener.rowReadEvent(this.inputRowMeta, row);
                }
            }
        }
        this.verifyRejectionRates();
        return row;
    }

    public void setRowHandler(RowHandler rowHandler) {
        Preconditions.checkNotNull((Object)rowHandler);
        this.rowHandler = rowHandler;
    }

    public RowHandler getRowHandler() {
        if (this.rowHandler == null) {
            this.rowHandler = new DefaultRowHandler();
        }
        return this.rowHandler;
    }

    protected void openRemoteInputStepSocketsOnce() throws KettleStepException {
        if (!this.remoteInputSteps.isEmpty() && !this.remoteInputStepsInitialized) {
            for (RemoteStep remoteStep : this.remoteInputSteps) {
                try {
                    BlockingRowSet rowSet = remoteStep.openReaderSocket(this);
                    this.inputRowSets.add((RowSet)rowSet);
                }
                catch (Exception e) {
                    throw new KettleStepException("Error opening reader socket to remote step '" + remoteStep + "'", (Throwable)e);
                }
            }
            this.remoteInputStepsInitialized = true;
        }
    }

    protected void openRemoteOutputStepSocketsOnce() throws KettleStepException {
        if (!this.remoteOutputSteps.isEmpty() && !this.remoteOutputStepsInitialized) {
            for (int c = 0; c < this.outputRowSets.size(); ++c) {
                RowSet rowSet = this.outputRowSets.get(c);
                rowSet.setRemoteSlaveServerName(this.getVariable("Internal.Slave.Server.Name"));
                if (this.getVariable("Internal.Slave.Server.Name") != null) continue;
                throw new KettleStepException("Variable 'Internal.Slave.Server.Name' is not defined.");
            }
            for (int i = 0; i < this.remoteOutputSteps.size(); ++i) {
                RemoteStep remoteStep = this.remoteOutputSteps.get(i);
                try {
                    if (remoteStep.getTargetSlaveServerName() == null) {
                        throw new KettleStepException("The target slave server name is not defined for remote output step: " + remoteStep);
                    }
                    BlockingRowSet rowSet = remoteStep.openWriterSocket();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.OpenedWriterSocketToRemoteStep", (Object[])new Object[]{remoteStep}));
                    }
                    this.outputRowSets.add((RowSet)rowSet);
                    continue;
                }
                catch (IOException e) {
                    throw new KettleStepException("Error opening writer socket to remote step '" + remoteStep + "'", (Throwable)e);
                }
            }
            this.remoteOutputStepsInitialized = true;
        }
    }

    protected void safeModeChecking(RowMetaInterface row) throws KettleRowException {
        if (row == null) {
            return;
        }
        if (this.inputReferenceRow == null) {
            this.inputReferenceRow = row.clone();
            Object[] fieldnames = row.getFieldNames();
            Arrays.sort(fieldnames);
            for (int i = 0; i < fieldnames.length - 1; ++i) {
                if (!((String)fieldnames[i]).equals(fieldnames[i + 1])) continue;
                throw new KettleRowException(BaseMessages.getString(PKG, (String)"BaseStep.SafeMode.Exception.DoubleFieldnames", (String[])new String[]{fieldnames[i]}));
            }
        } else {
            BaseStep.safeModeChecking(this.inputReferenceRow, row);
        }
    }

    @Override
    public void identifyErrorOutput() {
        if (this.stepMeta.isDoingErrorHandling()) {
            StepErrorMeta stepErrorMeta = this.stepMeta.getStepErrorMeta();
            boolean stop = false;
            for (int rowsetNr = 0; rowsetNr < this.outputRowSets.size() && !stop; ++rowsetNr) {
                RowSet outputRowSet = this.outputRowSets.get(rowsetNr);
                if (!outputRowSet.getDestinationStepName().equalsIgnoreCase(stepErrorMeta.getTargetStep().getName())) continue;
                this.errorRowSet = outputRowSet;
                this.outputRowSets.remove(rowsetNr);
                stop = true;
            }
        }
    }

    public static void safeModeChecking(RowMetaInterface referenceRowMeta, RowMetaInterface rowMeta) throws KettleRowException {
        if (referenceRowMeta.size() != rowMeta.size()) {
            throw new KettleRowException(BaseMessages.getString(PKG, (String)"BaseStep.SafeMode.Exception.VaryingSize", (String[])new String[]{"" + referenceRowMeta.size(), "" + rowMeta.size(), rowMeta.toString()}));
        }
        for (int i = 0; i < referenceRowMeta.size(); ++i) {
            ValueMetaInterface referenceValue = referenceRowMeta.getValueMeta(i);
            ValueMetaInterface compareValue = rowMeta.getValueMeta(i);
            if (!referenceValue.getName().equalsIgnoreCase(compareValue.getName())) {
                throw new KettleRowException(BaseMessages.getString(PKG, (String)"BaseStep.SafeMode.Exception.MixingLayout", (String[])new String[]{"" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()}));
            }
            if (referenceValue.getType() != compareValue.getType()) {
                throw new KettleRowException(BaseMessages.getString(PKG, (String)"BaseStep.SafeMode.Exception.MixingTypes", (String[])new String[]{"" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()}));
            }
            if (referenceValue.getStorageType() == compareValue.getStorageType()) continue;
            throw new KettleRowException(BaseMessages.getString(PKG, (String)"BaseStep.SafeMode.Exception.MixingStorageTypes", (String[])new String[]{"" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()}));
        }
    }

    public Object[] getRowFrom(RowSet rowSet) throws KettleStepException {
        return this.getRowHandler().getRowFrom(rowSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] handleGetRowFrom(RowSet rowSet) throws KettleStepException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (!this.checkTransRunning) {
            while (!this.trans.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
            this.checkTransRunning = true;
        }
        Object[] rowData = null;
        if (this.isUsingThreadPriorityManagment() && !rowSet.isDone() && rowSet.size() <= this.lowerBufferBoundary && !this.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        rowData = rowSet.getRow();
        while (rowData == null && !rowSet.isDone() && !this.stopped.get()) {
            rowData = rowSet.getRow();
        }
        if (rowData == null && rowSet.isDone()) {
            rowData = rowSet.getRow();
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseStep.Log.StopLookingForMoreRows", (String[])new String[0]));
            }
            this.stopAll();
            return null;
        }
        if (rowData == null && rowSet.isDone() && (rowData = rowSet.getRow()) == null) {
            this.inputRowSets.remove(rowSet);
            return null;
        }
        this.incrementLinesRead();
        List<RowListener> list = this.rowListeners;
        synchronized (list) {
            for (int i = 0; i < this.rowListeners.size(); ++i) {
                RowListener rowListener = this.rowListeners.get(i);
                rowListener.rowReadEvent(rowSet.getRowMeta(), rowData);
            }
        }
        return rowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyInputDeadLock() throws KettleStepException {
        RowSet inputFull = null;
        RowSet inputEmpty = null;
        List<RowSet> list = this.getInputRowSets();
        synchronized (list) {
            for (RowSet rowSet : this.getInputRowSets()) {
                if (rowSet.size() == this.transMeta.getSizeRowset()) {
                    inputFull = rowSet;
                    continue;
                }
                if (rowSet.size() != 0) continue;
                inputEmpty = rowSet;
            }
        }
        if (inputFull != null && inputEmpty != null) {
            for (StepMetaDataCombi combi : this.trans.getSteps()) {
                int inputSize = 0;
                int totalSize = combi.step.getInputRowSets().size() * this.transMeta.getSizeRowset();
                List<RowSet> list2 = combi.step.getInputRowSets();
                synchronized (list2) {
                    for (RowSet rowSet : this.getInputRowSets()) {
                        inputSize += rowSet.size();
                    }
                }
                if (inputSize <= 0 || inputSize != totalSize || combi.step.getOutputRowSets().size() <= 1) continue;
                RowSet outputFull = null;
                RowSet outputEmpty = null;
                List<RowSet> list3 = combi.step.getOutputRowSets();
                synchronized (list3) {
                    for (RowSet rowSet : combi.step.getOutputRowSets()) {
                        if (rowSet.size() == this.transMeta.getSizeRowset()) {
                            outputFull = rowSet;
                            continue;
                        }
                        if (rowSet.size() != 0) continue;
                        outputEmpty = rowSet;
                    }
                }
                if (outputFull == null || outputEmpty == null || !this.transMeta.findPrevious(this.stepMeta, combi.stepMeta)) continue;
                throw new KettleStepException("A deadlock was detected between steps '" + combi.stepname + "' and '" + this.stepname + "'.  The steps are both waiting for each other because a series of row set buffers filled up.");
            }
        }
    }

    public RowSet findInputRowSet(String sourceStep) throws KettleStepException {
        StepMeta sourceStepMeta = this.transMeta.findStep(sourceStep);
        if (sourceStepMeta == null) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"BaseStep.Exception.SourceStepToReadFromDoesntExist", (String[])new String[]{sourceStep}));
        }
        if (sourceStepMeta.getCopies() > 1) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"BaseStep.Exception.SourceStepToReadFromCantRunInMultipleCopies", (String[])new String[]{sourceStep, Integer.toString(sourceStepMeta.getCopies())}));
        }
        return this.findInputRowSet(sourceStep, 0, this.getStepname(), this.getCopy());
    }

    public RowSet findInputRowSet(String from, int fromcopy, String to, int tocopy) {
        List<StepInterface> baseSteps;
        for (RowSet rs : this.inputRowSets) {
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        StepMeta mappingStep = this.transMeta.findStep(from);
        if (mappingStep != null && mappingStep.isMapping() && (baseSteps = this.trans.findBaseSteps(from)).size() == 1) {
            MappingOutput[] outputs;
            Mapping mapping = (Mapping)baseSteps.get(0);
            for (MappingOutput output : outputs = mapping.getMappingTrans().findMappingOutput()) {
                for (RowSet rs : output.getOutputRowSets()) {
                    if (!rs.getDestinationStepName().equalsIgnoreCase(to)) continue;
                    return rs;
                }
            }
        }
        return null;
    }

    public RowSet findOutputRowSet(String targetStep) throws KettleStepException {
        StepMeta targetStepMeta = this.transMeta.findStep(targetStep);
        if (targetStepMeta == null) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"BaseStep.Exception.TargetStepToWriteToDoesntExist", (String[])new String[]{targetStep}));
        }
        if (targetStepMeta.getCopies() > 1) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"BaseStep.Exception.TargetStepToWriteToCantRunInMultipleCopies", (String[])new String[]{targetStep, Integer.toString(targetStepMeta.getCopies())}));
        }
        return this.findOutputRowSet(this.getStepname(), this.getCopy(), targetStep, 0);
    }

    public RowSet findOutputRowSet(String from, int fromcopy, String to, int tocopy) {
        List<StepInterface> baseSteps;
        for (RowSet rs : this.outputRowSets) {
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        StepMeta mappingStep = this.transMeta.findStep(to);
        if (mappingStep != null && mappingStep.isMapping() && (baseSteps = this.trans.findBaseSteps(to)).size() == 1) {
            MappingInput[] inputs;
            Mapping mapping = (Mapping)baseSteps.get(0);
            for (MappingInput input : inputs = mapping.getMappingTrans().findMappingInput()) {
                for (RowSet rs : input.getInputRowSets()) {
                    if (!rs.getOriginStepName().equalsIgnoreCase(from)) continue;
                    return rs;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputDone() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"BaseStep.Log.OutputDone", (String[])new String[]{String.valueOf(this.outputRowSets.size())}));
        }
        List<RowSet> list = this.outputRowSets;
        synchronized (list) {
            for (int i = 0; i < this.outputRowSets.size(); ++i) {
                RowSet rs = this.outputRowSets.get(i);
                rs.setDone();
            }
            if (this.errorRowSet != null) {
                this.errorRowSet.setDone();
            }
        }
    }

    public void dispatch() {
        RowSet rowSet;
        int c;
        int nrCopies;
        int dispatchType;
        boolean repartitioning;
        int nextCopies;
        int prevCopies;
        int i;
        if (this.transMeta == null) {
            return;
        }
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.StartingBuffersAllocation", (String[])new String[0]));
        }
        List<StepMeta> previousSteps = this.transMeta.findPreviousSteps(stepMeta, true);
        List<StepMeta> succeedingSteps = this.transMeta.findNextSteps(stepMeta);
        int nrInput = previousSteps.size();
        int nrOutput = succeedingSteps.size();
        this.inputRowSets = new ArrayList<RowSet>();
        this.outputRowSets = new ArrayList<RowSet>();
        this.errorRowSet = null;
        this.prevSteps = new StepMeta[nrInput];
        this.nextSteps = new StepMeta[nrOutput];
        this.currentInputRowSetNr = 0;
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.StepInfo", (String[])new String[]{String.valueOf(nrInput), String.valueOf(nrOutput)}));
        }
        for (i = 0; i < previousSteps.size(); ++i) {
            this.prevSteps[i] = previousSteps.get(i);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.GotPreviousStep", (String[])new String[]{this.stepname, String.valueOf(i), this.prevSteps[i].getName()}));
            }
            prevCopies = this.prevSteps[i].getCopies();
            nextCopies = stepMeta.getCopies();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.InputRowInfo", (String[])new String[]{String.valueOf(prevCopies), String.valueOf(nextCopies)}));
            }
            repartitioning = this.prevSteps[i].isPartitioned() ? !this.prevSteps[i].getStepPartitioningMeta().equals(stepMeta.getStepPartitioningMeta()) : stepMeta.isPartitioned();
            if (prevCopies == 1 && nextCopies == 1) {
                dispatchType = 1;
                nrCopies = 1;
            } else if (prevCopies == 1 && nextCopies > 1) {
                dispatchType = 2;
                nrCopies = 1;
            } else if (prevCopies > 1 && nextCopies == 1) {
                dispatchType = 3;
                nrCopies = prevCopies;
            } else if (prevCopies == nextCopies && !repartitioning) {
                dispatchType = 4;
                nrCopies = 1;
            } else {
                dispatchType = 5;
                nrCopies = prevCopies;
            }
            for (c = 0; c < nrCopies; ++c) {
                rowSet = null;
                switch (dispatchType) {
                    case 1: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), 0, this.stepname, 0);
                        break;
                    }
                    case 2: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), 0, this.stepname, this.getCopy());
                        break;
                    }
                    case 3: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), c, this.stepname, 0);
                        break;
                    }
                    case 4: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), this.getCopy(), this.stepname, this.getCopy());
                        break;
                    }
                    case 5: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), c, this.stepname, this.getCopy());
                        break;
                    }
                }
                if (rowSet != null) {
                    this.inputRowSets.add(rowSet);
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.FoundInputRowset", (String[])new String[]{rowSet.getName()}));
                    continue;
                }
                if (this.prevSteps[i].isMapping() || stepMeta.isMapping()) continue;
                this.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.UnableToFindInputRowset", (String[])new String[0]));
                this.setErrors(1L);
                this.stopAll();
                return;
            }
        }
        for (i = 0; i < nrOutput; ++i) {
            this.nextSteps[i] = succeedingSteps.get(i);
            prevCopies = stepMeta.getCopies();
            nextCopies = this.nextSteps[i].getCopies();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.OutputRowInfo", (String[])new String[]{String.valueOf(prevCopies), String.valueOf(nextCopies)}));
            }
            repartitioning = stepMeta.isPartitioned() ? !stepMeta.getStepPartitioningMeta().equals(this.nextSteps[i].getStepPartitioningMeta()) : this.nextSteps[i].isPartitioned();
            if (prevCopies == 1 && nextCopies == 1) {
                dispatchType = 1;
                nrCopies = 1;
            } else if (prevCopies == 1 && nextCopies > 1) {
                dispatchType = 2;
                nrCopies = nextCopies;
            } else if (prevCopies > 1 && nextCopies == 1) {
                dispatchType = 3;
                nrCopies = 1;
            } else if (prevCopies == nextCopies && !repartitioning) {
                dispatchType = 4;
                nrCopies = 1;
            } else {
                dispatchType = 5;
                nrCopies = nextCopies;
            }
            for (c = 0; c < nrCopies; ++c) {
                rowSet = null;
                switch (dispatchType) {
                    case 1: {
                        rowSet = this.trans.findRowSet(this.stepname, 0, this.nextSteps[i].getName(), 0);
                        break;
                    }
                    case 2: {
                        rowSet = this.trans.findRowSet(this.stepname, 0, this.nextSteps[i].getName(), c);
                        break;
                    }
                    case 3: {
                        rowSet = this.trans.findRowSet(this.stepname, this.getCopy(), this.nextSteps[i].getName(), 0);
                        break;
                    }
                    case 4: {
                        rowSet = this.trans.findRowSet(this.stepname, this.getCopy(), this.nextSteps[i].getName(), this.getCopy());
                        break;
                    }
                    case 5: {
                        rowSet = this.trans.findRowSet(this.stepname, this.getCopy(), this.nextSteps[i].getName(), c);
                        break;
                    }
                }
                if (rowSet != null) {
                    this.outputRowSets.add(rowSet);
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.FoundOutputRowset", (String[])new String[]{rowSet.getName()}));
                    continue;
                }
                if (stepMeta.isMapping() || this.nextSteps[i].isMapping()) continue;
                this.logError(BaseMessages.getString(PKG, (String)"BaseStep.Log.UnableToFindOutputRowset", (String[])new String[0]));
                this.setErrors(1L);
                this.stopAll();
                return;
            }
        }
        if (stepMeta.getTargetStepPartitioningMeta() != null) {
            this.nextStepPartitioningMeta = stepMeta.getTargetStepPartitioningMeta();
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.FinishedDispatching", (String[])new String[0]));
        }
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    public int getNextClassNr() {
        int ret = this.trans.class_nr++;
        return ret;
    }

    public boolean outputIsDone() {
        int nrstopped = 0;
        for (RowSet rs : this.outputRowSets) {
            if (!rs.isDone()) continue;
            ++nrstopped;
        }
        return nrstopped >= this.outputRowSets.size();
    }

    @Override
    public void stopAll() {
        this.stopped.set(true);
        this.trans.stopAll();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public boolean isPaused() {
        return this.paused.get();
    }

    @Override
    public void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    @Override
    public void setRunning(boolean running) {
        this.running.set(running);
    }

    @Override
    public void pauseRunning() {
        this.setPaused(true);
    }

    @Override
    public void resumeRunning() {
        this.setPaused(false);
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    public void setPaused(AtomicBoolean paused) {
        this.paused = paused;
    }

    public boolean isInitialising() {
        return this.init;
    }

    @Override
    public void markStart() {
        Calendar cal = Calendar.getInstance();
        this.start_time = cal.getTime();
        this.setInternalVariables();
    }

    public void setInternalVariables() {
        this.setVariable("Internal.Step.Name", this.stepname);
        this.setVariable("Internal.Step.CopyNr", Integer.toString(this.getCopy()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markStop() {
        Calendar cal = Calendar.getInstance();
        this.stop_time = cal.getTime();
        List<StepListener> list = this.stepListeners;
        synchronized (list) {
            for (StepListener stepListener : this.stepListeners) {
                stepListener.stepFinished(this.trans, this.stepMeta, this);
            }
        }
        this.setRunning(false);
    }

    @Override
    public long getRuntime() {
        long lapsed;
        if (this.start_time != null && this.stop_time == null) {
            Calendar cal = Calendar.getInstance();
            long now = cal.getTimeInMillis();
            long st = this.start_time.getTime();
            lapsed = now - st;
        } else {
            lapsed = this.start_time != null && this.stop_time != null ? this.stop_time.getTime() - this.start_time.getTime() : 0L;
        }
        return lapsed;
    }

    public RowMetaAndData buildLog(String sname, int copynr, long lines_read, long lines_written, long lines_updated, long lines_skipped, long errors, Date start_date, Date end_date) {
        RowMeta r = new RowMeta();
        Object[] data = new Object[9];
        int nr = 0;
        r.addValueMeta((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.Stepname", (String[])new String[0])));
        data[nr] = sname;
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.Copy", (String[])new String[0])));
        data[++nr] = new Double(copynr);
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesReaded", (String[])new String[0])));
        data[++nr] = new Double(lines_read);
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesWritten", (String[])new String[0])));
        data[++nr] = new Double(lines_written);
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesUpdated", (String[])new String[0])));
        data[++nr] = new Double(lines_updated);
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesSkipped", (String[])new String[0])));
        data[++nr] = new Double(lines_skipped);
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.Errors", (String[])new String[0])));
        data[++nr] = new Double(errors);
        r.addValueMeta((ValueMetaInterface)new ValueMetaDate("start_date"));
        data[++nr] = start_date;
        r.addValueMeta((ValueMetaInterface)new ValueMetaDate("end_date"));
        data[++nr] = end_date;
        ++nr;
        return new RowMetaAndData((RowMetaInterface)r, data);
    }

    public static final RowMetaInterface getLogFields(String comm) {
        RowMeta r = new RowMeta();
        ValueMetaString sname = new ValueMetaString(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.Stepname", (String[])new String[0]));
        sname.setLength(256);
        r.addValueMeta((ValueMetaInterface)sname);
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.Copy", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesReaded", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesWritten", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesUpdated", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.LinesSkipped", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaNumber(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.Errors", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaDate(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.StartDate", (String[])new String[0])));
        r.addValueMeta((ValueMetaInterface)new ValueMetaDate(BaseMessages.getString(PKG, (String)"BaseStep.ColumnName.EndDate", (String[])new String[0])));
        for (int i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(comm);
        }
        return r;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(50);
        if (!Utils.isEmpty((CharSequence)this.getTrans().getMappingStepName())) {
            string.append('[').append(this.trans.toString()).append(']').append('.');
        }
        if (!Utils.isEmpty((CharSequence)this.partitionID)) {
            string.append(this.stepname).append('.').append(this.partitionID);
        } else if (this.clusterSize > 1) {
            string.append(this.stepname).append('.').append(this.slaveNr).append('.').append(Integer.toString(this.getCopy()));
        } else {
            string.append(this.stepname).append('.').append(Integer.toString(this.getCopy()));
        }
        return string.toString();
    }

    @Override
    public int rowsetOutputSize() {
        int size = 0;
        for (int i = 0; i < this.outputRowSets.size(); ++i) {
            size += this.outputRowSets.get(i).size();
        }
        return size;
    }

    @Override
    public int rowsetInputSize() {
        int size = 0;
        for (int i = 0; i < this.inputRowSets.size(); ++i) {
            size += this.inputRowSets.get(i).size();
        }
        return size;
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
    }

    @Deprecated
    public void stopRunning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSummary() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            long li = this.getLinesInput();
            long lo = this.getLinesOutput();
            long lr = this.getLinesRead();
            long lw = this.getLinesWritten();
            long lu = this.getLinesUpdated();
            long lj = this.getLinesRejected();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || this.errors > 0L) {
                this.logBasic(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lw), String.valueOf(this.errors + lj)}));
            } else {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseStep.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lw), String.valueOf(this.errors + lj)}));
            }
        }
    }

    @Override
    public String getStepID() {
        if (this.stepMeta != null) {
            return this.stepMeta.getStepID();
        }
        return null;
    }

    @Override
    public List<RowSet> getInputRowSets() {
        return this.inputRowSets;
    }

    public void setInputRowSets(List<RowSet> inputRowSets) {
        this.inputRowSets = inputRowSets;
    }

    @Override
    public List<RowSet> getOutputRowSets() {
        return this.outputRowSets;
    }

    public void setOutputRowSets(List<RowSet> outputRowSets) {
        this.outputRowSets = outputRowSets;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        this.rowListeners.add(rowListener);
    }

    @Override
    public void removeRowListener(RowListener rowListener) {
        this.rowListeners.remove(rowListener);
    }

    @Override
    public List<RowListener> getRowListeners() {
        return this.rowListeners;
    }

    public void addResultFile(ResultFile resultFile) {
        ReentrantReadWriteLock.WriteLock lock = this.resultFilesLock.writeLock();
        lock.lock();
        try {
            this.resultFiles.put(resultFile.getFile().toString(), resultFile);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Map<String, ResultFile> getResultFiles() {
        ReentrantReadWriteLock.ReadLock lock = this.resultFilesLock.readLock();
        lock.lock();
        try {
            HashMap<String, ResultFile> hashMap = new HashMap<String, ResultFile>(this.resultFiles);
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public BaseStepData.StepExecutionStatus getStatus() {
        if (this.isRunning()) {
            if (this.isStopped()) {
                return BaseStepData.StepExecutionStatus.STATUS_HALTING;
            }
            if (this.isPaused()) {
                return BaseStepData.StepExecutionStatus.STATUS_PAUSED;
            }
            return BaseStepData.StepExecutionStatus.STATUS_RUNNING;
        }
        if (this.trans.isInitializing()) {
            if (this.isInitialising()) {
                return BaseStepData.StepExecutionStatus.STATUS_INIT;
            }
            return BaseStepData.StepExecutionStatus.STATUS_IDLE;
        }
        if (this.isStopped()) {
            return BaseStepData.StepExecutionStatus.STATUS_STOPPED;
        }
        StepDataInterface sdi = this.trans.getStepDataInterface(this.stepname, this.stepcopy);
        if (sdi != null) {
            if (sdi.getStatus() == BaseStepData.StepExecutionStatus.STATUS_DISPOSED) {
                return BaseStepData.StepExecutionStatus.STATUS_FINISHED;
            }
            return sdi.getStatus();
        }
        return BaseStepData.StepExecutionStatus.STATUS_EMPTY;
    }

    @Override
    public String getPartitionID() {
        return this.partitionID;
    }

    @Override
    public void setPartitionID(String partitionID) {
        this.partitionID = partitionID;
    }

    public Map<String, BlockingRowSet> getPartitionTargets() {
        return this.partitionTargets;
    }

    public void setPartitionTargets(Map<String, BlockingRowSet> partitionTargets) {
        this.partitionTargets = partitionTargets;
    }

    public int getRepartitioning() {
        return this.repartitioning;
    }

    @Override
    public void setRepartitioning(int repartitioning) {
        this.repartitioning = repartitioning;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Override
    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    protected boolean checkFeedback(long lines) {
        return this.getTransMeta().isFeedbackShown() && lines > 0L && this.getTransMeta().getFeedbackSize() > 0 && lines % (long)this.getTransMeta().getFeedbackSize() == 0L;
    }

    public RowMetaInterface getInputRowMeta() {
        return this.inputRowMeta;
    }

    public void setInputRowMeta(RowMetaInterface rowMeta) {
        this.inputRowMeta = rowMeta;
    }

    public RowMetaInterface getErrorRowMeta() {
        return this.errorRowMeta;
    }

    public void setErrorRowMeta(RowMetaInterface errorRowMeta) {
        this.errorRowMeta = errorRowMeta;
    }

    public RowMetaInterface getPreviewRowMeta() {
        return this.previewRowMeta;
    }

    public void setPreviewRowMeta(RowMetaInterface previewRowMeta) {
        this.previewRowMeta = previewRowMeta;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.environmentSubstitute(variableName)))) {
            return ValueMetaString.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public String getTypeId() {
        return this.getStepID();
    }

    public int getSlaveNr() {
        return this.slaveNr;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public int getUniqueStepNrAcrossSlaves() {
        return this.uniqueStepNrAcrossSlaves;
    }

    public int getUniqueStepCountAcrossSlaves() {
        return this.uniqueStepCountAcrossSlaves;
    }

    public List<ServerSocket> getServerSockets() {
        return this.serverSockets;
    }

    public void setServerSockets(List<ServerSocket> serverSockets) {
        this.serverSockets = serverSockets;
    }

    @Override
    public void setUsingThreadPriorityManagment(boolean usingThreadPriorityManagment) {
        this.usingThreadPriorityManagment = usingThreadPriorityManagment;
    }

    @Override
    public boolean isUsingThreadPriorityManagment() {
        return this.usingThreadPriorityManagment;
    }

    @Override
    public void initBeforeStart() throws KettleStepException {
        this.openRemoteOutputStepSocketsOnce();
    }

    public List<StepListener> getStepListeners() {
        return this.stepListeners;
    }

    public void setStepListeners(List<StepListener> stepListeners) {
        this.stepListeners = Collections.synchronizedList(stepListeners);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        return false;
    }

    @Override
    public boolean canProcessOneRow() {
        switch (this.inputRowSets.size()) {
            case 0: {
                return false;
            }
            case 1: {
                RowSet set = this.inputRowSets.get(0);
                if (set.isDone()) {
                    return false;
                }
                return set.size() > 0;
            }
        }
        boolean allDone = true;
        for (RowSet rowSet : this.inputRowSets) {
            if (!rowSet.isDone()) {
                allDone = false;
            }
            if (rowSet.size() <= 0) continue;
            return true;
        }
        return !allDone;
    }

    @Override
    public void addStepListener(StepListener stepListener) {
        this.stepListeners.add(stepListener);
    }

    @Override
    public boolean isMapping() {
        return this.stepMeta.isMapping();
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public String getObjectName() {
        return this.getStepname();
    }

    @Override
    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public String getFilename() {
        return null;
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public ObjectId getObjectId() {
        if (this.stepMeta == null) {
            return null;
        }
        return this.stepMeta.getObjectId();
    }

    public ObjectRevision getObjectRevision() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.STEP;
    }

    public LoggingObjectInterface getParent() {
        return this.trans;
    }

    public RepositoryDirectory getRepositoryDirectory() {
        return null;
    }

    public String getObjectCopy() {
        return Integer.toString(this.stepcopy);
    }

    public LogLevel getLogLevel() {
        return this.log != null ? this.log.getLogLevel() : null;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.log.setLogLevel(logLevel);
    }

    public static void closeQuietly(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setCarteObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public void batchComplete() throws KettleException {
    }

    public List<RemoteStep> getRemoteInputSteps() {
        return this.remoteInputSteps;
    }

    public List<RemoteStep> getRemoteOutputSteps() {
        return this.remoteOutputSteps;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    @Override
    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    @Override
    public int getCurrentOutputRowSetNr() {
        return this.currentOutputRowSetNr;
    }

    @Override
    public void setCurrentOutputRowSetNr(int index) {
        this.currentOutputRowSetNr = index;
    }

    @Override
    public int getCurrentInputRowSetNr() {
        return this.currentInputRowSetNr;
    }

    @Override
    public void setCurrentInputRowSetNr(int index) {
        this.currentInputRowSetNr = index;
    }

    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    private class DefaultRowHandler
    implements RowHandler {
        private DefaultRowHandler() {
        }

        @Override
        public Object[] getRow() throws KettleException {
            return BaseStep.this.handleGetRow();
        }

        @Override
        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            BaseStep.this.handlePutRow(rowMeta, row);
        }

        @Override
        public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
            BaseStep.this.handlePutError(rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
        }

        @Override
        public Object[] getRowFrom(RowSet rowSet) throws KettleStepException {
            return BaseStep.this.handleGetRowFrom(rowSet);
        }

        @Override
        public void putRowTo(RowMetaInterface rowMeta, Object[] row, RowSet rowSet) throws KettleStepException {
            BaseStep.this.handlePutRowTo(rowMeta, row, rowSet);
        }
    }
}

