/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessoutput;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.accessoutput.AccessOutputData;
import org.pentaho.di.trans.steps.accessoutput.AccessOutputMeta;

public class AccessOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = AccessOutput.class;
    public static final int COMMIT_SIZE = 500;
    private AccessOutputMeta meta;
    private AccessOutputData data;

    public AccessOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AccessOutputMeta)smi;
        this.data = (AccessOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first && this.meta.isDoNotOpenNewFileInit()) {
            try {
                if (!this.openFile()) {
                    return false;
                }
            }
            catch (Exception e) {
                this.logError("An error occurred intialising this step: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        try {
            this.writeToTable(r);
            this.putRow(this.data.outputRowMeta, r);
            if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesOutput());
            }
        }
        catch (KettleException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeToTable(Object[] rowData) throws KettleValueException {
        block10: {
            if (rowData == null) {
                if (!this.log.isDetailed()) return false;
                this.logDetailed("Last line inserted: stop");
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta();
                try {
                    String realTablename = this.environmentSubstitute(this.meta.getTablename());
                    this.data.table = this.data.db.getTable(realTablename);
                    if (this.data.table == null) {
                        if (!this.meta.isTableCreated()) {
                            this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.Error.TableDoesNotExist", (String[])new String[]{realTablename}));
                            this.setErrors(1L);
                            this.stopAll();
                            return false;
                        }
                        this.data.createTable(realTablename, this.data.outputRowMeta);
                        break block10;
                    }
                    if (this.meta.isTableTruncated()) {
                        this.data.truncateTable();
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.Exception.UnexpectedErrorCreatingTable", (String[])new String[]{e.toString()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
        }
        Object[] columnValues = AccessOutputMeta.createObjectsForRow(this.data.outputRowMeta, rowData);
        try {
            this.data.rows.add(columnValues);
            if (this.meta.getCommitSize() > 0) {
                if (this.data.rows.size() < this.meta.getCommitSize()) return true;
                this.data.addRowsToTable(this.data.rows);
                this.data.rows.clear();
                return true;
            }
            this.data.addRowToTable(columnValues);
            return true;
        }
        catch (IOException e) {
            this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.Exception.UnexpectedErrorWritingRow", (String[])new String[]{this.data.outputRowMeta.getString(rowData)}));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AccessOutputMeta)smi;
        this.data = (AccessOutputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isDoNotOpenNewFileInit()) {
                try {
                    return this.openFile();
                }
                catch (Exception e) {
                    this.logError("An error occurred intialising this step: " + e.getMessage());
                    this.stopAll();
                    this.setErrors(1L);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean openFile() throws Exception {
        FileObject fileObject;
        File file;
        this.data.oneFileOpened = true;
        String realFilename = this.environmentSubstitute(this.meta.getFilename());
        if (this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"AccessOutput.log.WritingToFile", (String[])new String[]{realFilename}));
        }
        if (!(file = FileUtils.toFile((URL)(fileObject = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this.getTransMeta())).getURL())).exists()) {
            if (!this.meta.isFileCreated()) {
                this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.InitError.FileDoesNotExist", (String[])new String[]{realFilename}));
                return false;
            }
            this.data.createDatabase(file);
        } else {
            this.data.openDatabase(file);
        }
        if (this.meta.isAddToResultFiles()) {
            ResultFile resultFile = new ResultFile(0, fileObject, this.getTransMeta().getName(), this.toString());
            resultFile.setComment("This file was created with an access output step");
            this.addResultFile(resultFile);
        }
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AccessOutputMeta)smi;
        this.data = (AccessOutputData)sdi;
        if (this.data.oneFileOpened) {
            try {
                if (this.data.table != null) {
                    this.data.addRowsToTable(this.data.rows);
                }
                this.data.rows.clear();
                if (this.data.db != null) {
                    this.data.closeDatabase();
                }
            }
            catch (IOException e) {
                this.logError("Error closing the database: " + e.toString());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        super.dispose(smi, sdi);
    }
}

