/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessoutput;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.accessoutput.AccessOutput;
import org.pentaho.di.trans.steps.accessoutput.AccessOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class AccessOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = AccessOutputMeta.class;
    private String filename;
    private boolean fileCreated;
    private String tablename;
    private boolean tableCreated;
    private boolean tableTruncated;
    private int commitSize;
    private boolean addToResultFilenames;
    private boolean doNotOpeNnewFileInit;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        AccessOutputMeta retval = (AccessOutputMeta)super.clone();
        return retval;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public boolean truncateTable() {
        return this.tableTruncated;
    }

    public void setTableTruncated(boolean truncateTable) {
        this.tableTruncated = truncateTable;
    }

    private void readData(Node stepnode, List<DatabaseMeta> databases) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.tableTruncated = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"truncate"));
            this.fileCreated = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"create_file"));
            this.tableCreated = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"create_table"));
            this.commitSize = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"commit_size"), (int)500);
            String addToResultFiles = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResultFiles) ? true : "Y".equalsIgnoreCase(addToResultFiles);
            this.doNotOpeNnewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"do_not_open_newfile_init"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fileCreated = true;
        this.tableCreated = true;
        this.tableTruncated = false;
        this.commitSize = 500;
        this.doNotOpeNnewFileInit = false;
        this.addToResultFilenames = true;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tablename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"truncate", (boolean)this.tableTruncated));
        retval.append("    ").append(XMLHandler.addTagValue((String)"create_file", (boolean)this.fileCreated));
        retval.append("    ").append(XMLHandler.addTagValue((String)"create_table", (boolean)this.tableCreated));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commit_size", (int)this.commitSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpeNnewFileInit));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.tableTruncated = rep.getStepAttributeBoolean(id_step, "truncate");
            this.fileCreated = rep.getStepAttributeBoolean(id_step, "create_file");
            this.tableCreated = rep.getStepAttributeBoolean(id_step, "create_table");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit_size");
            String addToResultFiles = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResultFiles) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.doNotOpeNnewFileInit = rep.getStepAttributeBoolean(id_step, "do_not_open_newfile_init");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "truncate", this.tableTruncated);
            rep.saveStepAttribute(id_transformation, id_step, "create_file", this.fileCreated);
            rep.saveStepAttribute(id_transformation, id_step, "create_table", this.tableCreated);
            rep.saveStepAttribute(id_transformation, id_step, "commit_size", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "do_not_open_newfile_init", this.doNotOpeNnewFileInit);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AccessOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AccessOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AccessOutputData();
    }

    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realFilename = space.environmentSubstitute(this.filename);
        File file = new File(realFilename);
        Database db = null;
        try {
            RowMetaInterface layout;
            String realTablename;
            if (!file.exists() || !file.isFile()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.FileDoesNotExist", (String[])new String[]{realFilename}));
            }
            db = Database.open((File)file);
            Table table = db.getTable(realTablename = space.environmentSubstitute(this.tablename));
            if (table == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.TableDoesNotExist", (String[])new String[]{realTablename}));
            }
            RowMetaInterface rowMetaInterface = layout = AccessOutputMeta.getLayout(table);
            return rowMetaInterface;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (IOException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.ErrorClosingDatabase", (String[])new String[0]), (Throwable)e);
            }
        }
    }

    public static final RowMetaInterface getLayout(Table table) throws SQLException, KettleStepException {
        RowMeta row = new RowMeta();
        List columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ValueMetaInterface v;
            Column column = (Column)columns.get(i);
            int valtype = 2;
            int length = -1;
            int precision = -1;
            int type = column.getType().getSQLType();
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    valtype = 2;
                    length = column.getLength();
                    break;
                }
                case 2005: {
                    valtype = 2;
                    length = 9999999;
                    break;
                }
                case -5: {
                    valtype = 5;
                    precision = 0;
                    length = 15;
                    break;
                }
                case 4: {
                    valtype = 5;
                    precision = 0;
                    length = 9;
                    break;
                }
                case 5: {
                    valtype = 5;
                    precision = 0;
                    length = 4;
                    break;
                }
                case -6: {
                    valtype = 5;
                    precision = 0;
                    length = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    valtype = 1;
                    length = column.getLength();
                    precision = column.getPrecision();
                    if (length >= 126) {
                        length = -1;
                    }
                    if (precision >= 126) {
                        precision = -1;
                    }
                    if (type == 8 || type == 6 || type == 7) {
                        if (precision == 0) {
                            precision = -1;
                        }
                    } else if (precision == 0 && length < 18 && length > 0) {
                        valtype = 5;
                    }
                    if (length <= 18 && precision <= 18) break;
                    valtype = 6;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    valtype = 3;
                    break;
                }
                case -7: 
                case 16: {
                    valtype = 4;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    valtype = 8;
                    break;
                }
                default: {
                    valtype = 2;
                    length = column.getLength();
                }
            }
            try {
                v = ValueMetaFactory.createValueMeta((String)column.getName(), (int)valtype);
            }
            catch (KettlePluginException e) {
                throw new KettleStepException((Throwable)e);
            }
            v.setLength(length, precision);
            row.addValueMeta(v);
        }
        return row;
    }

    public static final List<Column> getColumns(RowMetaInterface row) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface value = row.getValueMeta(i);
            Column column = new Column();
            column.setName(value.getName());
            int length = value.getLength();
            switch (value.getType()) {
                case 5: {
                    if (length < 3) {
                        column.setType(DataType.BYTE);
                        length = DataType.BYTE.getFixedSize();
                        break;
                    }
                    if (length < 5) {
                        column.setType(DataType.INT);
                        length = DataType.INT.getFixedSize();
                        break;
                    }
                    column.setType(DataType.LONG);
                    length = DataType.LONG.getFixedSize();
                    break;
                }
                case 1: {
                    column.setType(DataType.DOUBLE);
                    length = DataType.DOUBLE.getFixedSize();
                    break;
                }
                case 3: {
                    column.setType(DataType.SHORT_DATE_TIME);
                    length = DataType.SHORT_DATE_TIME.getFixedSize();
                    break;
                }
                case 2: {
                    if (length < 255) {
                        column.setType(DataType.TEXT);
                        length *= DataType.TEXT.getUnitSize();
                        break;
                    }
                    column.setType(DataType.MEMO);
                    length *= DataType.MEMO.getUnitSize();
                    break;
                }
                case 8: {
                    column.setType(DataType.BINARY);
                    break;
                }
                case 4: {
                    column.setType(DataType.BOOLEAN);
                    length = DataType.BOOLEAN.getFixedSize();
                    break;
                }
                case 6: {
                    column.setType(DataType.NUMERIC);
                    length = DataType.NUMERIC.getFixedSize();
                    break;
                }
            }
            if (length >= 0) {
                column.setLength((short)length);
            }
            if (value.getPrecision() >= 1 && value.getPrecision() <= 28) {
                column.setPrecision((byte)value.getPrecision());
            }
            list.add(column);
        }
        return list;
    }

    public static Object[] createObjectsForRow(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        Object[] values = new Object[rowMeta.size()];
        block9: for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            Object valueData = rowData[i];
            if (valueData == null || valueMeta == null) {
                values[i] = null;
                continue;
            }
            int length = valueMeta.getLength();
            switch (valueMeta.getType()) {
                case 5: {
                    if (length < 3) {
                        values[i] = new Byte(valueMeta.getInteger(valueData).byteValue());
                        continue block9;
                    }
                    if (length < 5) {
                        values[i] = new Short(valueMeta.getInteger(valueData).shortValue());
                        continue block9;
                    }
                    values[i] = valueMeta.getInteger(valueData);
                    continue block9;
                }
                case 1: {
                    values[i] = valueMeta.getNumber(valueData);
                    continue block9;
                }
                case 3: {
                    values[i] = valueMeta.getDate(valueData);
                    continue block9;
                }
                case 2: {
                    values[i] = valueMeta.getString(valueData);
                    continue block9;
                }
                case 8: {
                    values[i] = valueMeta.getBinary(valueData);
                    continue block9;
                }
                case 4: {
                    values[i] = valueMeta.getBoolean(valueData);
                    continue block9;
                }
                case 6: {
                    values[i] = valueMeta.getNumber(valueData);
                    continue block9;
                }
            }
        }
        return values;
    }

    public boolean isFileCreated() {
        return this.fileCreated;
    }

    public void setFileCreated(boolean fileCreated) {
        this.fileCreated = fileCreated;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isTableCreated() {
        return this.tableCreated;
    }

    public void setTableCreated(boolean tableCreated) {
        this.tableCreated = tableCreated;
    }

    public boolean isTableTruncated() {
        return this.tableTruncated;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpeNnewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpeNnewFileInit = doNotOpenNewFileInit;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"jackcess-1.1.13.jar", "commons-collections-3.1.jar", "commons-logging.jar", "commons-lang-2.2.jar", "commons-dbcp-1.2.1.jar", "commons-pool-1.3.jar"};
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!Utils.isEmpty((CharSequence)this.filename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename), (VariableSpace)space);
                this.filename = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

