/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.clonerow;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.clonerow.CloneRowData;
import org.pentaho.di.trans.steps.clonerow.CloneRowMeta;

public class CloneRow
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CloneRowMeta.class;
    private CloneRowMeta meta;
    private CloneRowData data;

    public CloneRow(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CloneRowMeta)smi;
        this.data = (CloneRowData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            String realnumfield;
            String realflagfield;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.data.NrPrevFields = this.getInputRowMeta().size();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            boolean bl = this.data.addInfosToRow = this.meta.isAddCloneFlag() || this.meta.isAddCloneNum();
            if (this.meta.isAddCloneFlag() && Utils.isEmpty((CharSequence)(realflagfield = this.environmentSubstitute(this.meta.getCloneFlagField())))) {
                this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneFlagFieldMissing", (String[])new String[0]));
                throw new KettleException(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneFlagFieldMissing", (String[])new String[0]));
            }
            if (this.meta.isAddCloneNum() && Utils.isEmpty((CharSequence)(realnumfield = this.environmentSubstitute(this.meta.getCloneNumField())))) {
                this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneNumFieldMissing", (String[])new String[0]));
                throw new KettleException(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneNumFieldMissing", (String[])new String[0]));
            }
            if (this.meta.isNrCloneInField()) {
                String cloneinfieldname = this.meta.getNrCloneField();
                if (Utils.isEmpty((CharSequence)cloneinfieldname)) {
                    this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Error.NrCloneInFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CloneRow.Error.NrCloneInFieldMissing", (String[])new String[0]));
                }
                if (this.data.indexOfNrCloneField < 0) {
                    this.data.indexOfNrCloneField = this.getInputRowMeta().indexOfValue(cloneinfieldname);
                    if (this.data.indexOfNrCloneField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Log.ErrorFindingField", (String[])new String[0]) + "[" + cloneinfieldname + "]");
                        throw new KettleException(BaseMessages.getString(PKG, (String)"CloneRow.Exception.CouldnotFindField", (String[])new String[]{cloneinfieldname}));
                    }
                }
            } else {
                String nrclonesString = this.environmentSubstitute(this.meta.getNrClones());
                this.data.nrclones = Const.toInt((String)nrclonesString, (int)0);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"CloneRow.Log.NrClones", (String[])new String[]{"" + this.data.nrclones}));
                }
            }
        }
        Object[] outputRowData = r;
        if (this.data.addInfosToRow) {
            outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            int rowIndex = this.data.NrPrevFields;
            if (this.meta.isAddCloneFlag()) {
                outputRowData[rowIndex] = false;
                ++rowIndex;
            }
            if (this.meta.isAddCloneNum()) {
                outputRowData[rowIndex] = 0L;
            }
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.meta.isNrCloneInField()) {
            Long nrCloneFieldValue = this.getInputRowMeta().getInteger(r, this.data.indexOfNrCloneField);
            if (nrCloneFieldValue == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"CloneRow.Log.NrClonesIsNull", (String[])new String[0]));
            }
            this.data.nrclones = nrCloneFieldValue;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"CloneRow.Log.NrClones", (String[])new String[]{"" + this.data.nrclones}));
            }
        }
        int i = 0;
        while ((long)i < this.data.nrclones && !this.isStopped()) {
            outputRowData = (Object[])r.clone();
            if (this.data.addInfosToRow) {
                outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
                int rowIndex = this.data.NrPrevFields;
                if (this.meta.isAddCloneFlag()) {
                    outputRowData[rowIndex] = true;
                    ++rowIndex;
                }
                if (this.meta.isAddCloneNum()) {
                    Long clonenum = new Long(i + 1);
                    outputRowData[rowIndex] = clonenum;
                }
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            ++i;
        }
        if (this.log.isDetailed() && this.checkFeedback(this.getLinesRead())) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"CloneRow.Log.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CloneRowMeta)smi;
        this.data = (CloneRowData)sdi;
        return super.init(smi, sdi);
    }
}

