/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputField;

public abstract class BaseFileInputStepMeta<A extends AdditionalOutputFields, I extends InputFiles<? extends BaseFileInputField>>
extends BaseStepMeta {
    private static Class<?> PKG = BaseFileInputStepMeta.class;
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    public static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    @InjectionDeep
    public I inputFiles;
    @InjectionDeep
    public ErrorHandling errorHandling = new ErrorHandling();
    @InjectionDeep
    public A additionalOutputFields;

    @Override
    public Object clone() {
        BaseFileInputStepMeta retval = (BaseFileInputStepMeta)super.clone();
        retval.inputFiles = (InputFiles)((InputFiles)this.inputFiles).clone();
        retval.errorHandling = (ErrorHandling)this.errorHandling.clone();
        retval.additionalOutputFields = (AdditionalOutputFields)((AdditionalOutputFields)this.additionalOutputFields).clone();
        return retval;
    }

    public void inputFiles_fileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            ((InputFiles)this.inputFiles).fileRequired[i] = BaseFileInputStepMeta.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] inputFiles_includeSubFolders() {
        return ((InputFiles)this.inputFiles).includeSubFolders;
    }

    public void inputFiles_includeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            ((InputFiles)this.inputFiles).includeSubFolders[i] = BaseFileInputStepMeta.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public static String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public FileInputList getFileInputList(VariableSpace space) {
        ((InputFiles)this.inputFiles).fileMask = this.normalizeAllocation(((InputFiles)this.inputFiles).fileMask, ((InputFiles)this.inputFiles).fileName.length);
        ((InputFiles)this.inputFiles).excludeFileMask = this.normalizeAllocation(((InputFiles)this.inputFiles).excludeFileMask, ((InputFiles)this.inputFiles).fileName.length);
        ((InputFiles)this.inputFiles).fileRequired = this.normalizeAllocation(((InputFiles)this.inputFiles).fileRequired, ((InputFiles)this.inputFiles).fileName.length);
        ((InputFiles)this.inputFiles).includeSubFolders = this.normalizeAllocation(((InputFiles)this.inputFiles).includeSubFolders, ((InputFiles)this.inputFiles).fileName.length);
        return FileInputList.createFileList((VariableSpace)space, (String[])((InputFiles)this.inputFiles).fileName, (String[])((InputFiles)this.inputFiles).fileMask, (String[])((InputFiles)this.inputFiles).excludeFileMask, (String[])((InputFiles)this.inputFiles).fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    public boolean[] includeSubFolderBoolean() {
        int len = ((InputFiles)this.inputFiles).fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(((InputFiles)this.inputFiles).includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    private String[] normalizeAllocation(String[] oldAllocation, int length) {
        String[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new String[length];
            for (int i = 0; i < oldAllocation.length; ++i) {
                newAllocation[i] = oldAllocation[i];
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] textFiles = FileInputList.createFilePathList((VariableSpace)transMeta, (String[])((InputFiles)this.inputFiles).fileName, (String[])((InputFiles)this.inputFiles).fileMask, (String[])((InputFiles)this.inputFiles).excludeFileMask, (String[])((InputFiles)this.inputFiles).fileRequired, (boolean[])this.includeSubFolderBoolean());
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public abstract String getEncoding();

    public static class AdditionalOutputFields
    implements Cloneable {
        @Injection(name="FILE_SHORT_FILE_FIELDNAME")
        public String shortFilenameField;
        @Injection(name="FILE_EXTENSION_FIELDNAME")
        public String extensionField;
        @Injection(name="FILE_PATH_FIELDNAME")
        public String pathField;
        @Injection(name="FILE_SIZE_FIELDNAME")
        public String sizeField;
        @Injection(name="FILE_HIDDEN_FIELDNAME")
        public String hiddenField;
        @Injection(name="FILE_LAST_MODIFICATION_FIELDNAME")
        public String lastModificationField;
        @Injection(name="FILE_URI_FIELDNAME")
        public String uriField;
        @Injection(name="FILE_ROOT_URI_FIELDNAME")
        public String rootUriField;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void normalize() {
            if (StringUtils.isBlank((String)this.shortFilenameField)) {
                this.shortFilenameField = null;
            }
            if (StringUtils.isBlank((String)this.extensionField)) {
                this.extensionField = null;
            }
            if (StringUtils.isBlank((String)this.pathField)) {
                this.pathField = null;
            }
            if (StringUtils.isBlank((String)this.sizeField)) {
                this.sizeField = null;
            }
            if (StringUtils.isBlank((String)this.hiddenField)) {
                this.hiddenField = null;
            }
            if (StringUtils.isBlank((String)this.lastModificationField)) {
                this.lastModificationField = null;
            }
            if (StringUtils.isBlank((String)this.uriField)) {
                this.uriField = null;
            }
            if (StringUtils.isBlank((String)this.rootUriField)) {
                this.rootUriField = null;
            }
        }
    }

    public static class ErrorHandling
    implements Cloneable {
        @Injection(name="IGNORE_ERRORS")
        public boolean errorIgnored;
        @Injection(name="FILE_ERROR_FIELD")
        public String fileErrorField;
        @Injection(name="FILE_ERROR_MESSAGE_FIELD")
        public String fileErrorMessageField;
        @Injection(name="SKIP_BAD_FILES")
        public boolean skipBadFiles;
        @Injection(name="WARNING_FILES_TARGET_DIR")
        public String warningFilesDestinationDirectory;
        @Injection(name="WARNING_FILES_EXTENTION")
        public String warningFilesExtension;
        @Injection(name="ERROR_FILES_TARGET_DIR")
        public String errorFilesDestinationDirectory;
        @Injection(name="ERROR_FILES_EXTENTION")
        public String errorFilesExtension;
        @Injection(name="LINE_NR_FILES_TARGET_DIR")
        public String lineNumberFilesDestinationDirectory;
        @Injection(name="LINE_NR_FILES_EXTENTION")
        public String lineNumberFilesExtension;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class InputFiles<F extends BaseFileInputField>
    implements Cloneable {
        @Injection(name="FILENAME", group="FILENAME_LINES")
        public String[] fileName = new String[0];
        @Injection(name="FILEMASK", group="FILENAME_LINES")
        public String[] fileMask = new String[0];
        @Injection(name="EXCLUDE_FILEMASK", group="FILENAME_LINES")
        public String[] excludeFileMask = new String[0];
        @Injection(name="FILE_REQUIRED", group="FILENAME_LINES")
        public String[] fileRequired = new String[0];
        @Injection(name="INCLUDE_SUBFOLDERS", group="FILENAME_LINES")
        public String[] includeSubFolders = new String[0];
        @Injection(name="ACCEPT_FILE_NAMES")
        public boolean acceptingFilenames;
        @Injection(name="ACCEPT_FILE_STEP")
        public String acceptingStepName;
        @Injection(name="PASS_THROUGH_FIELDS")
        public boolean passingThruFields;
        @Injection(name="ACCEPT_FILE_FIELD")
        public String acceptingField;
        @InjectionDeep
        public F[] inputFields;
        @Injection(name="ADD_FILES_TO_RESULT")
        public boolean isaddresult;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void setFileRequired(String[] fileRequiredin) {
            for (int i = 0; i < fileRequiredin.length; ++i) {
                this.fileRequired[i] = BaseFileInputStepMeta.getRequiredFilesCode(fileRequiredin[i]);
            }
        }

        public void setIncludeSubFolders(String[] includeSubFoldersin) {
            for (int i = 0; i < includeSubFoldersin.length; ++i) {
                this.includeSubFolders[i] = BaseFileInputStepMeta.getRequiredFilesCode(includeSubFoldersin[i]);
            }
        }
    }
}

