/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.formula;

import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.formula.FormulaData;
import org.pentaho.di.trans.steps.formula.FormulaMeta;
import org.pentaho.di.trans.steps.formula.FormulaMetaFunction;
import org.pentaho.di.trans.steps.formula.RowForumulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;

public class Formula
extends BaseStep
implements StepInterface {
    private FormulaMeta meta;
    private FormulaData data;

    public Formula(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FormulaMeta)smi;
        this.data = (FormulaData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.context = new RowForumulaContext(this.data.outputRowMeta);
            this.data.parser = new FormulaParser();
            this.data.replaceIndex = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                FormulaMetaFunction fn = this.meta.getFormula()[i];
                if (!Utils.isEmpty((CharSequence)fn.getReplaceField())) {
                    this.data.replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                this.data.replaceIndex[i] = -1;
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + r);
        }
        Object[] outputRowData = this.calcFields(this.getInputRowMeta(), r);
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.log.isRowLevel()) {
            this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + r);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] calcFields(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        try {
            FormulaMetaFunction fn;
            int i;
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            int tempIndex = rowMeta.size();
            this.data.context.setRowData(outputRowData);
            if (this.data.formulas == null) {
                this.data.formulas = new org.pentaho.reporting.libraries.formula.Formula[this.meta.getFormula().length];
                for (i = 0; i < this.meta.getFormula().length; ++i) {
                    fn = this.meta.getFormula()[i];
                    if (Utils.isEmpty((CharSequence)fn.getFieldName())) {
                        throw new KettleException("Unable to find field name for formula [" + Const.NVL((String)fn.getFormula(), (String)"") + "]");
                    }
                    this.data.formulas[i] = this.data.createFormula(this.meta.getFormula()[i].getFormula());
                }
            }
            for (i = 0; i < this.meta.getFormula().length; ++i) {
                Object formulaResult;
                fn = this.meta.getFormula()[i];
                if (Utils.isEmpty((CharSequence)fn.getFieldName())) continue;
                if (this.data.formulas[i] == null) {
                    this.data.formulas[i] = this.data.createFormula(this.meta.getFormula()[i].getFormula());
                }
                if ((formulaResult = this.data.formulas[i].evaluate()) instanceof LibFormulaErrorValue) {
                    throw new KettleException("Error calculate formula. Formula " + fn.getFormula() + " output field: " + fn.getFieldName() + ", error is: " + formulaResult.toString());
                }
                if (this.data.returnType[i] < 0) {
                    if (formulaResult instanceof String) {
                        this.data.returnType[i] = 0;
                        fn.setNeedDataConversion(fn.getValueType() != 2);
                    } else if (formulaResult instanceof Integer) {
                        this.data.returnType[i] = 2;
                        fn.setNeedDataConversion(fn.getValueType() != 5);
                    } else if (formulaResult instanceof Long) {
                        this.data.returnType[i] = 3;
                        fn.setNeedDataConversion(fn.getValueType() != 5);
                    } else if (formulaResult instanceof Date) {
                        this.data.returnType[i] = 4;
                        fn.setNeedDataConversion(fn.getValueType() != 3);
                    } else if (formulaResult instanceof BigDecimal) {
                        this.data.returnType[i] = 5;
                        fn.setNeedDataConversion(fn.getValueType() != 6);
                    } else if (formulaResult instanceof Number) {
                        this.data.returnType[i] = 1;
                        fn.setNeedDataConversion(fn.getValueType() != 1);
                    } else if (formulaResult instanceof byte[]) {
                        this.data.returnType[i] = 6;
                        if (fn.getValueType() != 8) {
                            throw new KettleValueException("Please specify a Binary type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Boolean) {
                        this.data.returnType[i] = 7;
                        if (fn.getValueType() != 4) {
                            throw new KettleValueException("Please specify a Boolean type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else {
                        this.data.returnType[i] = 0;
                        fn.setNeedDataConversion(fn.getValueType() != 2);
                    }
                }
                int realIndex = this.data.replaceIndex[i] < 0 ? tempIndex++ : this.data.replaceIndex[i];
                outputRowData[realIndex] = this.getReturnValue(formulaResult, this.data.returnType[i], realIndex, fn);
            }
            return outputRowData;
        }
        catch (Throwable e) {
            throw new KettleValueException(e);
        }
    }

    protected Object getReturnValue(Object formulaResult, int returnType, int realIndex, FormulaMetaFunction fn) throws KettleException {
        if (formulaResult == null) {
            return null;
        }
        Object value = null;
        switch (returnType) {
            case 0: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult.toString();
                break;
            }
            case 1: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = new Double(((Number)formulaResult).doubleValue());
                break;
            }
            case 2: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = new Long(((Integer)formulaResult).intValue());
                break;
            }
            case 3: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 4: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 5: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 6: {
                value = formulaResult;
                break;
            }
            case 7: {
                value = formulaResult;
            }
        }
        return value;
    }

    private Object convertDataToTargetValueMeta(int i, Object formulaResult) throws KettleException {
        if (formulaResult == null) {
            return formulaResult;
        }
        ValueMetaInterface target = this.data.outputRowMeta.getValueMeta(i);
        ValueMetaInterface actual = ValueMetaFactory.guessValueMetaInterface((Object)formulaResult);
        Object value = target.convertData(actual, formulaResult);
        return value;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FormulaMeta)smi;
        this.data = (FormulaData)sdi;
        if (super.init(smi, sdi)) {
            this.data.returnType = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                this.data.returnType[i] = -1;
            }
            return true;
        }
        return false;
    }
}

