/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getsubfolders;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFolders;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFoldersData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class GetSubFoldersMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetSubFoldersMeta.class;
    public static final String[] RequiredFoldersDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFoldersCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    private String[] folderName;
    private String[] folderRequired;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String dynamicFoldernameField;
    private boolean isFoldernameDynamic;
    private long rowLimit;

    public String getRequiredFilesDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return RequiredFoldersDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFoldersCode[1])) {
            return RequiredFoldersDesc[1];
        }
        return RequiredFoldersDesc[0];
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setDynamicFoldernameField(String dynamicFoldernameField) {
        this.dynamicFoldernameField = dynamicFoldernameField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getDynamicFoldernameField() {
        return this.dynamicFoldernameField;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFoldernameDynamic() {
        return this.isFoldernameDynamic;
    }

    public void setFolderField(boolean isFoldernameDynamic) {
        this.isFoldernameDynamic = isFoldernameDynamic;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public String[] getFolderRequired() {
        return this.folderRequired;
    }

    public String getRequiredFoldersCode(String tt) {
        if (tt == null) {
            return RequiredFoldersCode[0];
        }
        if (tt.equals(RequiredFoldersDesc[1])) {
            return RequiredFoldersCode[1];
        }
        return RequiredFoldersCode[0];
    }

    public void setFolderRequired(String[] folderRequiredin) {
        this.folderRequired = new String[folderRequiredin.length];
        for (int i = 0; i < folderRequiredin.length; ++i) {
            this.folderRequired[i] = this.getRequiredFoldersCode(folderRequiredin[i]);
        }
    }

    public String[] getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String[] folderName) {
        this.folderName = folderName;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        GetSubFoldersMeta retval = (GetSubFoldersMeta)super.clone();
        int nrfiles = this.folderName.length;
        retval.allocate(nrfiles);
        System.arraycopy(this.folderName, 0, retval.folderName, 0, nrfiles);
        System.arraycopy(this.folderRequired, 0, retval.folderRequired, 0, nrfiles);
        return retval;
    }

    public void allocate(int nrfiles) {
        this.folderName = new String[nrfiles];
        this.folderRequired = new String[nrfiles];
    }

    @Override
    public void setDefault() {
        int nrfiles = 0;
        this.isFoldernameDynamic = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFoldernameField = "";
        this.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            this.folderName[i] = "folderName" + (i + 1);
            this.folderRequired[i] = NO;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString folderName = new ValueMetaString("folderName");
        folderName.setLength(500);
        folderName.setPrecision(-1);
        folderName.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)folderName);
        ValueMetaString short_folderName = new ValueMetaString("short_folderName");
        short_folderName.setLength(500);
        short_folderName.setPrecision(-1);
        short_folderName.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)short_folderName);
        ValueMetaString path = new ValueMetaString("path");
        path.setLength(500);
        path.setPrecision(-1);
        path.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)path);
        ValueMetaBoolean ishidden = new ValueMetaBoolean("ishidden");
        ishidden.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)ishidden);
        ValueMetaBoolean isreadable = new ValueMetaBoolean("isreadable");
        isreadable.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)isreadable);
        ValueMetaBoolean iswriteable = new ValueMetaBoolean("iswriteable");
        iswriteable.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)iswriteable);
        ValueMetaDate lastmodifiedtime = new ValueMetaDate("lastmodifiedtime");
        lastmodifiedtime.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)lastmodifiedtime);
        ValueMetaString uri = new ValueMetaString("uri");
        uri.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)uri);
        ValueMetaString rooturi = new ValueMetaString("rooturi");
        rooturi.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)rooturi);
        ValueMetaInteger childrens = new ValueMetaInteger(space.environmentSubstitute("childrens"));
        childrens.setLength(10, 0);
        childrens.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)childrens);
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"foldername_dynamic", (boolean)this.isFoldernameDynamic));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"foldername_field", (String)this.dynamicFoldernameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.folderName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.folderName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.folderRequired[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.isFoldernameDynamic = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"foldername_dynamic"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.dynamicFoldernameField = XMLHandler.getTagValue((Node)stepnode, (String)"foldername_field");
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                Node folderNamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node folderRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                this.folderName[i] = XMLHandler.getNodeValue((Node)folderNamenode);
                this.folderRequired[i] = XMLHandler.getNodeValue((Node)folderRequirednode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            this.dynamicFoldernameField = rep.getStepAttributeString(id_step, "foldername_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.isFoldernameDynamic = rep.getStepAttributeBoolean(id_step, "foldername_dynamic");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                this.folderName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.folderRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "foldername_dynamic", this.isFoldernameDynamic);
            rep.saveStepAttribute(id_transformation, id_step, "foldername_field", this.dynamicFoldernameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (int i = 0; i < this.folderName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.folderName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.folderRequired[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public FileInputList getFolderList(VariableSpace space) {
        return FileInputList.createFolderList((VariableSpace)space, (String[])this.folderName, (String[])this.folderRequired);
    }

    public FileInputList getDynamicFolderList(VariableSpace space, String[] folderName, String[] folderRequired) {
        return FileInputList.createFolderList((VariableSpace)space, (String[])folderName, (String[])folderRequired);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.isFoldernameDynamic) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.InputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.InputErrorKo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            cr = Utils.isEmpty((CharSequence)this.dynamicFoldernameField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.FolderFieldnameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.FolderFieldnameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            FileInputList fileList = this.getFolderList(transMeta);
            if (fileList.nrOfFiles() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.ExpectedFoldersError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetSubFolders(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetSubFoldersData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.isFoldernameDynamic) {
                for (int i = 0; i < this.folderName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.folderName[i]), (VariableSpace)space);
                    this.folderName[i] = resourceNamingInterface.nameResource(fileObject, space, true);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

