/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNone;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.CurrentDirectoryResolver;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.HasRepositoryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutor;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorData;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorParameters;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobExecutorMeta
extends BaseStepMeta
implements StepMetaInterface,
HasRepositoryInterface {
    private static Class<?> PKG = JobExecutorMeta.class;
    private String jobName;
    private String fileName;
    private String directoryPath;
    private ObjectId jobObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private String groupSize;
    private String groupField;
    private String groupTime;
    private JobExecutorParameters parameters = new JobExecutorParameters();
    private String executionResultTargetStep;
    private StepMeta executionResultTargetStepMeta;
    private String executionTimeField;
    private String executionResultField;
    private String executionNrErrorsField;
    private String executionLinesReadField;
    private String executionLinesWrittenField;
    private String executionLinesInputField;
    private String executionLinesOutputField;
    private String executionLinesRejectedField;
    private String executionLinesUpdatedField;
    private String executionLinesDeletedField;
    private String executionFilesRetrievedField;
    private String executionExitStatusField;
    private String executionLogTextField;
    private String executionLogChannelIdField;
    private String resultRowsTargetStep;
    private StepMeta resultRowsTargetStepMeta;
    private String[] resultRowsField = new String[0];
    private int[] resultRowsType;
    private int[] resultRowsLength;
    private int[] resultRowsPrecision;
    private String resultFilesTargetStep;
    private StepMeta resultFilesTargetStepMeta;
    private String resultFilesFileNameField;
    private Repository repository;
    private IMetaStore metaStore;

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"job_object_id", this.jobObjectId == null ? null : this.jobObjectId.toString()));
        if (this.repository != null && this.jobObjectId != null) {
            try {
                RepositoryObject objectInformation = this.repository.getObjectInformation(this.jobObjectId, RepositoryObjectType.TRANSFORMATION);
                if (objectInformation != null) {
                    this.jobName = objectInformation.getName();
                    this.directoryPath = objectInformation.getRepositoryDirectory().getPath();
                }
            }
            catch (KettleException objectInformation) {
                // empty catch block
            }
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"job_name", (String)this.jobName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory_path", (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"group_size", (String)this.groupSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"group_field", (String)this.groupField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"group_time", (String)this.groupTime));
        retval.append(this.parameters.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_result_target_step", this.executionResultTargetStepMeta == null ? null : this.executionResultTargetStepMeta.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_time_field", (String)this.executionTimeField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_result_field", (String)this.executionResultField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_errors_field", (String)this.executionNrErrorsField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_read_field", (String)this.executionLinesReadField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_written_field", (String)this.executionLinesWrittenField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_input_field", (String)this.executionLinesInputField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_output_field", (String)this.executionLinesOutputField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_rejected_field", (String)this.executionLinesRejectedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_updated_field", (String)this.executionLinesUpdatedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_lines_deleted_field", (String)this.executionLinesDeletedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_files_retrieved_field", (String)this.executionFilesRetrievedField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_exit_status_field", (String)this.executionExitStatusField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_log_text_field", (String)this.executionLogTextField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execution_log_channelid_field", (String)this.executionLogChannelIdField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"result_rows_target_step", this.resultRowsTargetStepMeta == null ? null : this.resultRowsTargetStepMeta.getName()));
        for (int i = 0; i < this.resultRowsField.length; ++i) {
            retval.append("    ").append(XMLHandler.openTag((String)"result_rows_field")).append(Const.CR);
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.resultRowsField[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.resultRowsType[i])));
            retval.append("      ").append(XMLHandler.addTagValue((String)"length", (int)this.resultRowsLength[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"precision", (int)this.resultRowsPrecision[i]));
            retval.append("    ").append(XMLHandler.closeTag((String)"result_rows_field")).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"result_files_target_step", this.resultFilesTargetStepMeta == null ? null : this.resultFilesTargetStepMeta.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"result_files_file_name_field", (String)this.resultFilesFileNameField));
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String method = XMLHandler.getTagValue((Node)stepnode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String jobId = XMLHandler.getTagValue((Node)stepnode, (String)"job_object_id");
            this.jobObjectId = Utils.isEmpty((CharSequence)jobId) ? null : new StringObjectId(jobId);
            this.jobName = XMLHandler.getTagValue((Node)stepnode, (String)"job_name");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)"directory_path");
            this.groupSize = XMLHandler.getTagValue((Node)stepnode, (String)"group_size");
            this.groupField = XMLHandler.getTagValue((Node)stepnode, (String)"group_field");
            this.groupTime = XMLHandler.getTagValue((Node)stepnode, (String)"group_time");
            Node mappingParametersNode = XMLHandler.getSubNode((Node)stepnode, (String)"parameters");
            this.parameters = new JobExecutorParameters(mappingParametersNode);
            this.executionResultTargetStep = XMLHandler.getTagValue((Node)stepnode, (String)"execution_result_target_step");
            this.executionTimeField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_time_field");
            this.executionResultField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_result_field");
            this.executionNrErrorsField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_errors_field");
            this.executionLinesReadField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_read_field");
            this.executionLinesWrittenField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_written_field");
            this.executionLinesInputField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_input_field");
            this.executionLinesOutputField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_output_field");
            this.executionLinesRejectedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_rejected_field");
            this.executionLinesUpdatedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_updated_field");
            this.executionLinesDeletedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_lines_deleted_field");
            this.executionFilesRetrievedField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_files_retrieved_field");
            this.executionExitStatusField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_exit_status_field");
            this.executionLogTextField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_log_text_field");
            this.executionLogChannelIdField = XMLHandler.getTagValue((Node)stepnode, (String)"execution_log_channelid_field");
            this.resultRowsTargetStep = XMLHandler.getTagValue((Node)stepnode, (String)"result_rows_target_step");
            int nrFields = XMLHandler.countNodes((Node)stepnode, (String)"result_rows_field");
            this.resultRowsField = new String[nrFields];
            this.resultRowsType = new int[nrFields];
            this.resultRowsLength = new int[nrFields];
            this.resultRowsPrecision = new int[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"result_rows_field", (int)i);
                this.resultRowsField[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"name");
                this.resultRowsType[i] = ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fieldNode, (String)"type"));
                this.resultRowsLength[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fieldNode, (String)"length"), (int)-1);
                this.resultRowsPrecision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fieldNode, (String)"precision"), (int)-1);
            }
            this.resultFilesTargetStep = XMLHandler.getTagValue((Node)stepnode, (String)"result_files_target_step");
            this.resultFilesFileNameField = XMLHandler.getTagValue((Node)stepnode, (String)"result_files_file_name_field");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobExecutorMeta.Exception.ErrorLoadingJobExecutorDetailsFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        String method = rep.getStepAttributeString(id_step, "specification_method");
        this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
        String jobId = rep.getStepAttributeString(id_step, "job_object_id");
        this.jobObjectId = Utils.isEmpty((CharSequence)jobId) ? null : new StringObjectId(jobId);
        this.jobName = rep.getStepAttributeString(id_step, "job_name");
        this.fileName = rep.getStepAttributeString(id_step, "filename");
        this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
        this.groupSize = rep.getStepAttributeString(id_step, "group_size");
        this.groupField = rep.getStepAttributeString(id_step, "group_field");
        this.groupTime = rep.getStepAttributeString(id_step, "group_time");
        this.parameters = new JobExecutorParameters(rep, id_step);
        this.executionResultTargetStep = rep.getStepAttributeString(id_step, "execution_result_target_step");
        this.executionResultField = rep.getStepAttributeString(id_step, "execution_result_field");
        this.executionTimeField = rep.getStepAttributeString(id_step, "execution_time_field");
        this.executionNrErrorsField = rep.getStepAttributeString(id_step, "execution_errors_field");
        this.executionLinesReadField = rep.getStepAttributeString(id_step, "execution_lines_read_field");
        this.executionLinesWrittenField = rep.getStepAttributeString(id_step, "execution_lines_written_field");
        this.executionLinesInputField = rep.getStepAttributeString(id_step, "execution_lines_input_field");
        this.executionLinesOutputField = rep.getStepAttributeString(id_step, "execution_lines_output_field");
        this.executionLinesRejectedField = rep.getStepAttributeString(id_step, "execution_lines_rejected_field");
        this.executionLinesUpdatedField = rep.getStepAttributeString(id_step, "execution_lines_updated_field");
        this.executionLinesDeletedField = rep.getStepAttributeString(id_step, "execution_lines_deleted_field");
        this.executionFilesRetrievedField = rep.getStepAttributeString(id_step, "execution_files_retrieved_field");
        this.executionExitStatusField = rep.getStepAttributeString(id_step, "execution_exit_status_field");
        this.executionLogTextField = rep.getStepAttributeString(id_step, "execution_log_text_field");
        this.executionLogChannelIdField = rep.getStepAttributeString(id_step, "execution_log_channelid_field");
        this.resultRowsTargetStep = rep.getStepAttributeString(id_step, "result_rows_target_step");
        int nrFields = rep.countNrStepAttributes(id_step, "result_rows_field_name");
        this.resultRowsField = new String[nrFields];
        this.resultRowsType = new int[nrFields];
        this.resultRowsLength = new int[nrFields];
        this.resultRowsPrecision = new int[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            this.resultRowsField[i] = rep.getStepAttributeString(id_step, i, "result_rows_field_name");
            this.resultRowsType[i] = ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "result_rows_field_type"));
            this.resultRowsLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "result_rows_field_length");
            this.resultRowsPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "result_rows_field_precision");
        }
        this.resultFilesTargetStep = rep.getStepAttributeString(id_step, "result_files_target_step");
        this.resultFilesFileNameField = rep.getStepAttributeString(id_step, "result_files_file_name_field");
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
        rep.saveStepAttribute(id_transformation, id_step, "job_object_id", this.jobObjectId == null ? null : this.jobObjectId.toString());
        rep.saveStepAttribute(id_transformation, id_step, "filename", this.fileName);
        rep.saveStepAttribute(id_transformation, id_step, "job_name", this.jobName);
        rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.directoryPath);
        rep.saveStepAttribute(id_transformation, id_step, "group_size", this.groupSize);
        rep.saveStepAttribute(id_transformation, id_step, "group_field", this.groupField);
        rep.saveStepAttribute(id_transformation, id_step, "group_time", this.groupTime);
        this.parameters.saveRep(rep, metaStore, id_transformation, id_step);
        rep.saveStepAttribute(id_transformation, id_step, "execution_result_target_step", this.executionResultTargetStepMeta == null ? null : this.executionResultTargetStepMeta.getName());
        rep.saveStepAttribute(id_transformation, id_step, "execution_time_field", this.executionTimeField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_result_field", this.executionResultField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_errors_field", this.executionNrErrorsField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_read_field", this.executionLinesReadField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_written_field", this.executionLinesWrittenField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_input_field", this.executionLinesInputField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_output_field", this.executionLinesOutputField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_rejected_field", this.executionLinesRejectedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_updated_field", this.executionLinesUpdatedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_lines_deleted_field", this.executionLinesDeletedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_files_retrieved_field", this.executionFilesRetrievedField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_exit_status_field", this.executionExitStatusField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_log_text_field", this.executionLogTextField);
        rep.saveStepAttribute(id_transformation, id_step, "execution_log_channelid_field", this.executionLogChannelIdField);
        rep.saveStepAttribute(id_transformation, id_step, "result_rows_target_step", this.resultRowsTargetStepMeta == null ? null : this.resultRowsTargetStepMeta.getName());
        for (int i = 0; i < this.resultRowsField.length; ++i) {
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_name", this.resultRowsField[i]);
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_type", ValueMetaFactory.getValueMetaName((int)this.resultRowsType[i]));
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_length", this.resultRowsLength[i]);
            rep.saveStepAttribute(id_transformation, id_step, i, "result_rows_field_precision", this.resultRowsPrecision[i]);
        }
        rep.saveStepAttribute(id_transformation, id_step, "result_files_target_step", this.resultFilesTargetStepMeta == null ? null : this.resultFilesTargetStepMeta.getName());
        rep.saveStepAttribute(id_transformation, id_step, "result_files_file_name_field", this.resultFilesFileNameField);
    }

    @Override
    public void setDefault() {
        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
        this.parameters = new JobExecutorParameters();
        this.parameters.setInheritingAllVariables(true);
        this.groupSize = "1";
        this.groupField = "";
        this.groupTime = "";
        this.executionTimeField = "ExecutionTime";
        this.executionResultField = "ExecutionResult";
        this.executionNrErrorsField = "ExecutionNrErrors";
        this.executionLinesReadField = "ExecutionLinesRead";
        this.executionLinesWrittenField = "ExecutionLinesWritten";
        this.executionLinesInputField = "ExecutionLinesInput";
        this.executionLinesOutputField = "ExecutionLinesOutput";
        this.executionLinesRejectedField = "ExecutionLinesRejected";
        this.executionLinesUpdatedField = "ExecutionLinesUpdated";
        this.executionLinesDeletedField = "ExecutionLinesDeleted";
        this.executionFilesRetrievedField = "ExecutionFilesRetrieved";
        this.executionExitStatusField = "ExecutionExitStatus";
        this.executionLogTextField = "ExecutionLogText";
        this.executionLogChannelIdField = "ExecutionLogChannelId";
        this.resultFilesFileNameField = "FileName";
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        row.clear();
        if (nextStep != null && this.resultRowsTargetStepMeta != null && nextStep.equals(this.resultRowsTargetStepMeta)) {
            for (int i = 0; i < this.resultRowsField.length; ++i) {
                ValueMetaNone value;
                try {
                    value = ValueMetaFactory.createValueMeta((String)this.resultRowsField[i], (int)this.resultRowsType[i], (int)this.resultRowsLength[i], (int)this.resultRowsPrecision[i]);
                }
                catch (KettlePluginException e) {
                    value = new ValueMetaNone(this.resultRowsField[i]);
                    value.setLength(this.resultRowsLength[i], this.resultRowsPrecision[i]);
                }
                row.addValueMeta((ValueMetaInterface)value);
            }
        } else if (nextStep != null && this.resultFilesTargetStepMeta != null && nextStep.equals(this.resultFilesTargetStepMeta)) {
            if (!Utils.isEmpty((CharSequence)this.resultFilesFileNameField)) {
                ValueMetaString value = new ValueMetaString("filename", 255, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
        } else if (nextStep != null && this.executionResultTargetStepMeta != null && nextStep.equals(this.executionResultTargetStepMeta)) {
            ValueMetaInteger value;
            if (!Utils.isEmpty((CharSequence)this.executionTimeField)) {
                value = new ValueMetaInteger(this.executionTimeField, 15, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionResultField)) {
                value = new ValueMetaBoolean(this.executionResultField);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionNrErrorsField)) {
                value = new ValueMetaInteger(this.executionNrErrorsField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesReadField)) {
                value = new ValueMetaInteger(this.executionLinesReadField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesWrittenField)) {
                value = new ValueMetaInteger(this.executionLinesWrittenField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesInputField)) {
                value = new ValueMetaInteger(this.executionLinesInputField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesOutputField)) {
                value = new ValueMetaInteger(this.executionLinesOutputField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesRejectedField)) {
                value = new ValueMetaInteger(this.executionLinesRejectedField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesUpdatedField)) {
                value = new ValueMetaInteger(this.executionLinesUpdatedField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesDeletedField)) {
                value = new ValueMetaInteger(this.executionLinesDeletedField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionFilesRetrievedField)) {
                value = new ValueMetaInteger(this.executionFilesRetrievedField, 9, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionExitStatusField)) {
                value = new ValueMetaInteger(this.executionExitStatusField, 3, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLogTextField)) {
                value = new ValueMetaString(this.executionLogTextField);
                value.setLargeTextField(true);
                row.addValueMeta((ValueMetaInterface)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLogChannelIdField)) {
                value = new ValueMetaString(this.executionLogChannelIdField, 50, 0);
                row.addValueMeta((ValueMetaInterface)value);
            }
        }
    }

    public String[] getInfoSteps() {
        String[] infoSteps = this.getStepIOMeta().getInfoStepnames();
        return infoSteps.length == 0 ? null : infoSteps;
    }

    public String[] getTargetSteps() {
        ArrayList<String> targetSteps = new ArrayList<String>();
        if (!Utils.isEmpty((CharSequence)this.resultFilesTargetStep)) {
            targetSteps.add(this.resultFilesTargetStep);
        }
        if (!Utils.isEmpty((CharSequence)this.resultRowsTargetStep)) {
            targetSteps.add(this.resultRowsTargetStep);
        }
        if (targetSteps.isEmpty()) {
            return null;
        }
        return targetSteps.toArray(new String[targetSteps.size()]);
    }

    public static final synchronized JobMeta loadJobMeta(JobExecutorMeta executorMeta, Repository rep, VariableSpace space) throws KettleException {
        return JobExecutorMeta.loadJobMeta(executorMeta, rep, null, space);
    }

    /*
     * Unable to fully structure code
     */
    public static final synchronized JobMeta loadJobMeta(JobExecutorMeta executorMeta, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        mappingJobMeta = null;
        r = new CurrentDirectoryResolver();
        tmpSpace = r.resolveCurrentDirectory(executorMeta.getSpecificationMethod(), space, rep, executorMeta.getParentStepMeta(), executorMeta.getFileName());
        switch (1.$SwitchMap$org$pentaho$di$core$ObjectLocationSpecificationMethod[executorMeta.getSpecificationMethod().ordinal()]) {
            case 1: {
                realFilename = tmpSpace.environmentSubstitute(executorMeta.getFileName());
                try {
                    if (rep == null) ** GOTO lbl26
                    realFilename = r.normalizeSlashes(realFilename);
                    try {
                        dirStr = realFilename.substring(0, realFilename.lastIndexOf("/"));
                        tmpFilename = realFilename.substring(realFilename.lastIndexOf("/") + 1);
                        dir = rep.findDirectory(dirStr);
                        mappingJobMeta = rep.loadJob(tmpFilename, dir, null, null);
                    }
                    catch (KettleException ke) {
                        if (!realFilename.endsWith("kjb")) ** GOTO lbl26
                        try {
                            tmpFilename = realFilename.substring(realFilename.lastIndexOf("/") + 1, realFilename.indexOf(".kjb"));
                            dirStr = realFilename.substring(0, realFilename.lastIndexOf("/"));
                            dir = rep.findDirectory(dirStr);
                            mappingJobMeta = rep.loadJob(tmpFilename, dir, null, null);
                        }
                        catch (KettleException tmpFilename) {
                            // empty catch block
                        }
                    }
lbl26:
                    // 5 sources

                    if (mappingJobMeta != null) break;
                    mappingJobMeta = new JobMeta(tmpSpace, realFilename, rep, metaStore, null);
                    LogChannel.GENERAL.logDetailed("Loading job from repository", new Object[]{"Job was loaded from XML file [" + realFilename + "]"});
                    break;
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(JobExecutorMeta.PKG, (String)"JobExecutorMeta.Exception.UnableToLoadJob", (String[])new String[0]), (Throwable)e);
                }
            }
            case 2: {
                realJobname = tmpSpace.environmentSubstitute(executorMeta.getJobName());
                realDirectory = tmpSpace.environmentSubstitute(executorMeta.getDirectoryPath());
                if (rep != null) {
                    if (Utils.isEmpty((CharSequence)realJobname) || Utils.isEmpty((CharSequence)realDirectory) || (repdir = rep.findDirectory(realDirectory = r.normalizeSlashes(realDirectory))) == null) break;
                    try {
                        mappingJobMeta = rep.loadJob(realJobname, repdir, null, null);
                        LogChannel.GENERAL.logDetailed("Loading job from repository", new Object[]{"Executor job [" + realJobname + "] was loaded from the repository"});
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Unable to load job [" + realJobname + "]", (Throwable)e);
                    }
                }
                try {
                    mappingJobMeta = new JobMeta(tmpSpace, realDirectory + "/" + realJobname, rep, metaStore, null);
                    break;
                }
                catch (KettleException ke) {
                    try {
                        mappingJobMeta = new JobMeta(tmpSpace, realDirectory + "/" + realJobname + "." + "kjb", rep, metaStore, null);
                        break;
                    }
                    catch (KettleException ke2) {
                        throw new KettleException(BaseMessages.getString(JobExecutorMeta.PKG, (String)"JobExecutorMeta.Exception.UnableToLoadJob", (String[])new String[]{realJobname}) + realDirectory);
                    }
                }
            }
            case 3: {
                mappingJobMeta = rep.loadJob(executorMeta.getJobObjectId(), null);
                break;
            }
        }
        mappingJobMeta.copyVariablesFrom(space);
        mappingJobMeta.setRepository(rep);
        mappingJobMeta.setMetaStore(metaStore);
        mappingJobMeta.setFilename(mappingJobMeta.getFilename());
        return mappingJobMeta;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"JobExecutorMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JobExecutorMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JobExecutorMeta.CheckResult.StepReceivingFieldsFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JobExecutorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new JobExecutor(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.fileName);
        String realTransname = transMeta.environmentSubstitute(this.jobName);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        } else if (!Utils.isEmpty((CharSequence)realTransname)) {
            reference.getEntries().add(new ResourceEntry(realTransname, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            JobMeta executorJobMeta = JobExecutorMeta.loadJobMeta(this, repository, space);
            String proposedNewFilename = executorJobMeta.exportResources(executorJobMeta, definitions, resourceNamingInterface, repository, metaStore);
            String newFilename = "${Internal.Transformation.Filename.Directory}/" + proposedNewFilename;
            executorJobMeta.setFilename(newFilename);
            executorJobMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
            this.fileName = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutorMeta.Exception.UnableToLoadJob", (String[])new String[]{this.fileName}));
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new JobExecutorData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, true, false, true, false);
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.executionResultTargetStepMeta, BaseMessages.getString(PKG, (String)"JobExecutorMeta.ResultStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.resultRowsTargetStepMeta, BaseMessages.getString(PKG, (String)"JobExecutorMeta.ResultRowsStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.resultFilesTargetStepMeta, BaseMessages.getString(PKG, (String)"JobExecutorMeta.ResultFilesStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
        }
        return this.ioMeta;
    }

    @Override
    public void handleStreamSelection(StreamInterface stream) {
        List<StreamInterface> targets = this.getStepIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        StepMeta step = targets.get(index).getStepMeta();
        switch (index) {
            case 0: {
                this.setExecutionResultTargetStepMeta(step);
                break;
            }
            case 1: {
                this.setResultRowsTargetStepMeta(step);
                break;
            }
            case 2: {
                this.setResultFilesTargetStepMeta(step);
                break;
            }
        }
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.executionResultTargetStepMeta = StepMeta.findStep(steps, this.executionResultTargetStep);
        this.resultRowsTargetStepMeta = StepMeta.findStep(steps, this.resultRowsTargetStep);
        this.resultFilesTargetStepMeta = StepMeta.findStep(steps, this.resultFilesTargetStep);
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }

    @Override
    public boolean hasRepositoryReferences() {
        return this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
    }

    @Override
    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = RepositoryImportLocation.getRepositoryImportLocation().findDirectory(this.directoryPath);
        this.jobObjectId = repository.getTransformationID(this.jobName, repositoryDirectoryInterface);
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public JobExecutorParameters getMappingParameters() {
        return this.parameters;
    }

    public void setMappingParameters(JobExecutorParameters mappingParameters) {
        this.parameters = mappingParameters;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public ObjectId getJobObjectId() {
        return this.jobObjectId;
    }

    public void setJobObjectId(ObjectId jobObjectId) {
        this.jobObjectId = jobObjectId;
    }

    public JobExecutorParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(JobExecutorParameters parameters) {
        this.parameters = parameters;
    }

    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    public void setExecutionTimeField(String executionTimeField) {
        this.executionTimeField = executionTimeField;
    }

    public String getExecutionResultField() {
        return this.executionResultField;
    }

    public void setExecutionResultField(String executionResultField) {
        this.executionResultField = executionResultField;
    }

    public String getExecutionNrErrorsField() {
        return this.executionNrErrorsField;
    }

    public void setExecutionNrErrorsField(String executionNrErrorsField) {
        this.executionNrErrorsField = executionNrErrorsField;
    }

    public String getExecutionLinesReadField() {
        return this.executionLinesReadField;
    }

    public void setExecutionLinesReadField(String executionLinesReadField) {
        this.executionLinesReadField = executionLinesReadField;
    }

    public String getExecutionLinesWrittenField() {
        return this.executionLinesWrittenField;
    }

    public void setExecutionLinesWrittenField(String executionLinesWrittenField) {
        this.executionLinesWrittenField = executionLinesWrittenField;
    }

    public String getExecutionLinesInputField() {
        return this.executionLinesInputField;
    }

    public void setExecutionLinesInputField(String executionLinesInputField) {
        this.executionLinesInputField = executionLinesInputField;
    }

    public String getExecutionLinesOutputField() {
        return this.executionLinesOutputField;
    }

    public void setExecutionLinesOutputField(String executionLinesOutputField) {
        this.executionLinesOutputField = executionLinesOutputField;
    }

    public String getExecutionLinesRejectedField() {
        return this.executionLinesRejectedField;
    }

    public void setExecutionLinesRejectedField(String executionLinesRejectedField) {
        this.executionLinesRejectedField = executionLinesRejectedField;
    }

    public String getExecutionLinesUpdatedField() {
        return this.executionLinesUpdatedField;
    }

    public void setExecutionLinesUpdatedField(String executionLinesUpdatedField) {
        this.executionLinesUpdatedField = executionLinesUpdatedField;
    }

    public String getExecutionLinesDeletedField() {
        return this.executionLinesDeletedField;
    }

    public void setExecutionLinesDeletedField(String executionLinesDeletedField) {
        this.executionLinesDeletedField = executionLinesDeletedField;
    }

    public String getExecutionFilesRetrievedField() {
        return this.executionFilesRetrievedField;
    }

    public void setExecutionFilesRetrievedField(String executionFilesRetrievedField) {
        this.executionFilesRetrievedField = executionFilesRetrievedField;
    }

    public String getExecutionExitStatusField() {
        return this.executionExitStatusField;
    }

    public void setExecutionExitStatusField(String executionExitStatusField) {
        this.executionExitStatusField = executionExitStatusField;
    }

    public String getExecutionLogTextField() {
        return this.executionLogTextField;
    }

    public void setExecutionLogTextField(String executionLogTextField) {
        this.executionLogTextField = executionLogTextField;
    }

    public String getExecutionLogChannelIdField() {
        return this.executionLogChannelIdField;
    }

    public void setExecutionLogChannelIdField(String executionLogChannelIdField) {
        this.executionLogChannelIdField = executionLogChannelIdField;
    }

    public String getResultRowsTargetStep() {
        return this.resultRowsTargetStep;
    }

    public void setResultRowsTargetStep(String resultRowsTargetStep) {
        this.resultRowsTargetStep = resultRowsTargetStep;
    }

    public String[] getResultRowsField() {
        return this.resultRowsField;
    }

    public void setResultRowsField(String[] resultRowsField) {
        this.resultRowsField = resultRowsField;
    }

    public int[] getResultRowsType() {
        return this.resultRowsType;
    }

    public void setResultRowsType(int[] resultRowsType) {
        this.resultRowsType = resultRowsType;
    }

    public int[] getResultRowsLength() {
        return this.resultRowsLength;
    }

    public void setResultRowsLength(int[] resultRowsLength) {
        this.resultRowsLength = resultRowsLength;
    }

    public int[] getResultRowsPrecision() {
        return this.resultRowsPrecision;
    }

    public void setResultRowsPrecision(int[] resultRowsPrecision) {
        this.resultRowsPrecision = resultRowsPrecision;
    }

    public String getResultFilesTargetStep() {
        return this.resultFilesTargetStep;
    }

    public void setResultFilesTargetStep(String resultFilesTargetStep) {
        this.resultFilesTargetStep = resultFilesTargetStep;
    }

    public StepMeta getResultRowsTargetStepMeta() {
        return this.resultRowsTargetStepMeta;
    }

    public void setResultRowsTargetStepMeta(StepMeta resultRowsTargetStepMeta) {
        this.resultRowsTargetStepMeta = resultRowsTargetStepMeta;
    }

    public StepMeta getResultFilesTargetStepMeta() {
        return this.resultFilesTargetStepMeta;
    }

    public void setResultFilesTargetStepMeta(StepMeta resultFilesTargetStepMeta) {
        this.resultFilesTargetStepMeta = resultFilesTargetStepMeta;
    }

    public String getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public String getGroupTime() {
        return this.groupTime;
    }

    public void setGroupTime(String groupTime) {
        this.groupTime = groupTime;
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public String getExecutionResultTargetStep() {
        return this.executionResultTargetStep;
    }

    public void setExecutionResultTargetStep(String executionResultTargetStep) {
        this.executionResultTargetStep = executionResultTargetStep;
    }

    public StepMeta getExecutionResultTargetStepMeta() {
        return this.executionResultTargetStepMeta;
    }

    public void setExecutionResultTargetStepMeta(StepMeta executionResultTargetStepMeta) {
        this.executionResultTargetStepMeta = executionResultTargetStepMeta;
    }

    public String getResultFilesFileNameField() {
        return this.resultFilesFileNameField;
    }

    public void setResultFilesFileNameField(String resultFilesFileNameField) {
        this.resultFilesFileNameField = resultFilesFileNameField;
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"JobExecutorMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isJobDefined() {
        return !Utils.isEmpty((CharSequence)this.fileName) || this.jobObjectId != null || !Utils.isEmpty((CharSequence)this.directoryPath) && !Utils.isEmpty((CharSequence)this.jobName);
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isJobDefined()};
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return JobExecutorMeta.loadJobMeta(this, rep, metaStore, space);
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    @Override
    public boolean cleanAfterHopFromRemove() {
        this.setExecutionResultTargetStepMeta(null);
        this.setResultRowsTargetStepMeta(null);
        this.setResultFilesTargetStepMeta(null);
        return true;
    }
}

