/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.pentaho.di.compatibility.Row;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.compatibility.ValueUsedListener;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.JavaScriptUtils;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesAddedFunctions;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMetaMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesModData;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;

public class ScriptValuesMod
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ScriptValuesMetaMod.class;
    private ScriptValuesMetaMod meta;
    private ScriptValuesModData data;
    public static final int SKIP_TRANSFORMATION = 1;
    public static final int ABORT_TRANSFORMATION = -1;
    public static final int ERROR_TRANSFORMATION = -2;
    public static final int CONTINUE_TRANSFORMATION = 0;
    private boolean bWithTransStat = false;
    private boolean bRC = false;
    private int iTranStat = 0;
    private boolean bFirstRun = false;
    private ScriptValuesScript[] jsScripts;
    private String strTransformScript = "";
    private String strStartScript = "";
    private String strEndScript = "";
    public Script script;

    public ScriptValuesMod(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void determineUsedFields(RowMetaInterface row) {
        String valname;
        int i;
        int nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValueMeta(i).getName().toUpperCase();
            if (this.strTransformScript.toUpperCase().indexOf(valname) < 0) continue;
            ++nr;
        }
        this.data.fields_used = new int[nr];
        this.data.values_used = new Value[nr];
        nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValueMeta(i).getName();
            if (this.strTransformScript.indexOf(valname) < 0) continue;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UsedValueName", (String[])new String[]{String.valueOf(i), valname}));
            }
            this.data.fields_used[nr] = i;
            ++nr;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UsingValuesFromInputStream", (String[])new String[]{String.valueOf(this.data.fields_used.length)}));
        }
    }

    private boolean addValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.determineUsedFields(rowMeta);
            this.data.replaceIndex = new int[this.meta.getFieldname().length];
            for (int i = 0; i < this.meta.getFieldname().length; ++i) {
                if (this.meta.getReplace()[i]) {
                    this.data.replaceIndex[i] = rowMeta.indexOfValue(this.meta.getFieldname()[i]);
                    if (this.data.replaceIndex[i] >= 0) continue;
                    if (Utils.isEmpty((CharSequence)this.meta.getFieldname()[i])) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{this.meta.getFieldname()[i]}));
                    }
                    this.data.replaceIndex[i] = rowMeta.indexOfValue(this.meta.getRename()[i]);
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{this.meta.getRename()[i]}));
                }
                this.data.replaceIndex[i] = -1;
            }
            this.data.cx = ContextFactory.getGlobal().enterContext();
            try {
                String optimizationLevelAsString = this.environmentSubstitute(this.meta.getOptimizationLevel());
                if (!Utils.isEmpty((CharSequence)Const.trim((String)optimizationLevelAsString))) {
                    this.data.cx.setOptimizationLevel(Integer.parseInt(optimizationLevelAsString.trim()));
                    this.logBasic(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Optimization.Level", (String[])new String[]{this.environmentSubstitute(this.meta.getOptimizationLevel())}));
                } else {
                    this.data.cx.setOptimizationLevel(Integer.parseInt("9"));
                    this.logBasic(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Optimization.UsingDefault", (String[])new String[]{"9"}));
                }
            }
            catch (NumberFormatException nfe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.NumberFormatException", (String[])new String[]{this.environmentSubstitute(this.meta.getOptimizationLevel())}));
            }
            catch (IllegalArgumentException iae) {
                throw new KettleException(iae.getMessage());
            }
            this.data.scope = this.data.cx.initStandardObjects(null, false);
            this.bFirstRun = true;
            Scriptable jsvalue = Context.toObject((Object)this, (Scriptable)this.data.scope);
            this.data.scope.put("_step_", this.data.scope, (Object)jsvalue);
            for (int i = 0; i < this.meta.getNumberOfJSScripts(); ++i) {
                Scriptable jsR = Context.toObject((Object)this.jsScripts[i].getScript(), (Scriptable)this.data.scope);
                this.data.scope.put(this.jsScripts[i].getScriptName(), this.data.scope, (Object)jsR);
            }
            this.data.scope.put("_TransformationName_", this.data.scope, (Object)this.getTransMeta().getName());
            try {
                if (this.meta.isCompatible()) {
                    Row v2Row = RowMeta.createOriginalRow((RowMetaInterface)rowMeta, (Object[])row);
                    Scriptable jsV2Row = Context.toObject((Object)v2Row, (Scriptable)this.data.scope);
                    this.data.scope.put("row", this.data.scope, (Object)jsV2Row);
                } else {
                    Scriptable jsrow = Context.toObject((Object)row, (Scriptable)this.data.scope);
                    this.data.scope.put("row", this.data.scope, (Object)jsrow);
                }
                for (int i = 0; i < this.data.fields_used.length; ++i) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.fields_used[i]);
                    Object valueData = row[this.data.fields_used[i]];
                    if (this.meta.isCompatible()) {
                        this.data.values_used[i] = valueMeta.createOriginalValue(valueData);
                        Scriptable jsarg = Context.toObject((Object)this.data.values_used[i], (Scriptable)this.data.scope);
                        this.data.scope.put(valueMeta.getName(), this.data.scope, (Object)jsarg);
                        continue;
                    }
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData);
                    Scriptable jsarg = normalStorageValueData != null ? Context.toObject((Object)normalStorageValueData, (Scriptable)this.data.scope) : null;
                    this.data.scope.put(valueMeta.getName(), this.data.scope, (Object)jsarg);
                }
                Scriptable jsrowMeta = Context.toObject((Object)rowMeta, (Scriptable)this.data.scope);
                this.data.scope.put("rowMeta", this.data.scope, (Object)jsrowMeta);
                try {
                    if (this.meta.getAddClasses() != null) {
                        for (int i = 0; i < this.meta.getAddClasses().length; ++i) {
                            Object jsOut = Context.javaToJS((Object)this.meta.getAddClasses()[i].getAddObject(), (Scriptable)this.data.scope);
                            ScriptableObject.putProperty((Scriptable)this.data.scope, (String)this.meta.getAddClasses()[i].getJSName(), (Object)jsOut);
                        }
                    }
                }
                catch (Exception e) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotAttachAdditionalScripts", (String[])new String[0]), (Throwable)e);
                }
                try {
                    Context.javaToJS(ScriptValuesAddedFunctions.class, (Scriptable)this.data.scope);
                    ((ScriptableObject)this.data.scope).defineFunctionProperties(ScriptValuesAddedFunctions.jsFunctionList, ScriptValuesAddedFunctions.class, 2);
                }
                catch (Exception ex) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotAddDefaultFunctions", (String[])new String[0]), (Throwable)ex);
                }
                try {
                    this.data.scope.put("SKIP_TRANSFORMATION", this.data.scope, (Object)1);
                    this.data.scope.put("ABORT_TRANSFORMATION", this.data.scope, (Object)-1);
                    this.data.scope.put("ERROR_TRANSFORMATION", this.data.scope, (Object)-2);
                    this.data.scope.put("CONTINUE_TRANSFORMATION", this.data.scope, (Object)0);
                }
                catch (Exception ex) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotAddDefaultConstants", (String[])new String[0]), (Throwable)ex);
                }
                try {
                    if (this.strStartScript != null && this.strStartScript.length() > 0) {
                        Script startScript = this.data.cx.compileString(this.strStartScript, "trans_Start", 1, null);
                        startScript.exec(this.data.cx, this.data.scope);
                        if (this.log.isDetailed()) {
                            this.logDetailed("Start Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No starting Script found!");
                    }
                }
                catch (Exception es) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.ErrorProcessingStartScript", (String[])new String[0]), (Throwable)es);
                }
                this.data.script = this.data.cx.compileString(this.strTransformScript, "script", 1, null);
            }
            catch (Exception e) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.CouldNotCompileJavascript", (String[])new String[0]), (Throwable)e);
            }
        }
        Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)this.data.outputRowMeta.size());
        int outputIndex = rowMeta.size();
        final Hashtable usedRowValues = this.meta.isCompatible() ? new Hashtable() : null;
        try {
            Object valueData;
            ValueMetaInterface valueMeta;
            try {
                if (this.meta.isCompatible()) {
                    Row v2Row = RowMeta.createOriginalRow((RowMetaInterface)rowMeta, (Object[])row);
                    Scriptable jsV2Row = Context.toObject((Object)v2Row, (Scriptable)this.data.scope);
                    this.data.scope.put("row", this.data.scope, (Object)jsV2Row);
                    v2Row.getUsedValueListeners().add(new ValueUsedListener(){

                        public void valueIsUsed(int index, Value value) {
                            usedRowValues.put(index, value);
                        }
                    });
                } else {
                    Scriptable jsrow = Context.toObject((Object)row, (Scriptable)this.data.scope);
                    this.data.scope.put("row", this.data.scope, (Object)jsrow);
                }
                for (int i = 0; i < this.data.fields_used.length; ++i) {
                    valueMeta = rowMeta.getValueMeta(this.data.fields_used[i]);
                    valueData = row[this.data.fields_used[i]];
                    if (this.meta.isCompatible()) {
                        this.data.values_used[i] = valueMeta.createOriginalValue(valueData);
                        Scriptable jsarg = Context.toObject((Object)this.data.values_used[i], (Scriptable)this.data.scope);
                        this.data.scope.put(valueMeta.getName(), this.data.scope, (Object)jsarg);
                        continue;
                    }
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData);
                    Scriptable jsarg = normalStorageValueData != null ? Context.toObject((Object)normalStorageValueData, (Scriptable)this.data.scope) : null;
                    this.data.scope.put(valueMeta.getName(), this.data.scope, (Object)jsarg);
                }
                Scriptable jsrowMeta = Context.toObject((Object)rowMeta, (Scriptable)this.data.scope);
                this.data.scope.put("rowMeta", this.data.scope, (Object)jsrowMeta);
            }
            catch (Exception e) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UnexpectedeError", (String[])new String[0]), (Throwable)e);
            }
            this.data.script.exec(this.data.cx, this.data.scope);
            if (this.bFirstRun) {
                this.bFirstRun = false;
                Object tran_stat = this.data.scope.get("trans_Status", this.data.scope);
                if (tran_stat != ScriptableObject.NOT_FOUND) {
                    this.bWithTransStat = true;
                    if (this.log.isDetailed()) {
                        this.logDetailed("tran_Status found. Checking transformation status while script execution.");
                    }
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("No tran_Status found. Transformation status checking not available.");
                    }
                    this.bWithTransStat = false;
                }
            }
            this.iTranStat = this.bWithTransStat ? (int)Context.toNumber((Object)this.data.scope.get("trans_Status", this.data.scope)) : 0;
            if (this.iTranStat == 0) {
                int i;
                this.bRC = true;
                for (i = 0; i < this.meta.getFieldname().length; ++i) {
                    Object result = this.data.scope.get(this.meta.getFieldname()[i], this.data.scope);
                    valueData = this.getValueFromJScript(result, i);
                    if (this.data.replaceIndex[i] < 0) {
                        outputRow[outputIndex++] = valueData;
                        continue;
                    }
                    outputRow[this.data.replaceIndex[i]] = valueData;
                }
                if (this.meta.isCompatible()) {
                    for (i = 0; i < this.data.values_used.length; ++i) {
                        valueMeta = rowMeta.getValueMeta(this.data.fields_used[i]);
                        outputRow[this.data.fields_used[i]] = valueMeta.getValueData(this.data.values_used[i]);
                    }
                    for (Integer index : usedRowValues.keySet()) {
                        Value value = (Value)usedRowValues.get(index);
                        ValueMetaInterface valueMeta2 = rowMeta.getValueMeta(index.intValue());
                        outputRow[index.intValue()] = valueMeta2.getValueData(value);
                    }
                }
                this.putRow(this.data.outputRowMeta, outputRow);
            } else {
                switch (this.iTranStat) {
                    case 1: {
                        this.bRC = true;
                        break;
                    }
                    case -1: {
                        if (this.data.cx != null) {
                            Context.exit();
                        }
                        this.stopAll();
                        this.setOutputDone();
                        this.bRC = false;
                        break;
                    }
                    case -2: {
                        if (this.data.cx != null) {
                            Context.exit();
                        }
                        this.setErrors(1L);
                        this.stopAll();
                        this.bRC = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.JavascriptError", (String[])new String[0]), (Throwable)e);
        }
        return this.bRC;
    }

    public Object getValueFromJScript(Object result, int i) throws KettleValueException {
        String fieldName = this.meta.getFieldname()[i];
        if (!Utils.isEmpty((CharSequence)fieldName)) {
            try {
                return result == null ? null : JavaScriptUtils.convertFromJs(result, this.meta.getType()[i], fieldName);
            }
            catch (Exception e) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.JavascriptError", (String[])new String[0]), (Throwable)e);
            }
        }
        throw new KettleValueException("No name was specified for result value #" + (i + 1));
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.data.outputRowMeta;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ScriptValuesMetaMod)smi;
        this.data = (ScriptValuesModData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            try {
                if (this.data.cx != null) {
                    if (this.strEndScript != null && this.strEndScript.length() > 0) {
                        Script endScript = this.data.cx.compileString(this.strEndScript, "trans_End", 1, null);
                        endScript.exec(this.data.cx, this.data.scope);
                        if (this.log.isDetailed()) {
                            this.logDetailed("End Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No end Script found!");
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.UnexpectedeError", (String[])new String[0]) + " : " + e.toString());
                this.logError(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.ErrorStackTrace", (String[])new String[0]) + Const.CR + Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
            }
            if (this.data.cx != null) {
                Context.exit();
            }
            this.setOutputDone();
            return false;
        }
        try {
            this.addValues(this.getInputRowMeta(), r);
        }
        catch (KettleValueException e) {
            String location = null;
            if (e.getCause() instanceof EvaluatorException) {
                EvaluatorException ee = (EvaluatorException)e.getCause();
                location = "--> " + ee.lineNumber() + ":" + ee.columnNumber();
            }
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage() + Const.CR + location, null, "SCR-001");
                this.bRC = true;
            }
            throw e;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ScriptValuesMod.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return this.bRC;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ScriptValuesMetaMod)smi;
        this.data = (ScriptValuesModData)sdi;
        if (super.init(smi, sdi)) {
            this.jsScripts = this.meta.getJSScripts();
            block5: for (int j = 0; j < this.jsScripts.length; ++j) {
                switch (this.jsScripts[j].getScriptType()) {
                    case 0: {
                        this.strTransformScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                    case 1: {
                        this.strStartScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                    case 2: {
                        this.strEndScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            if (this.data.cx != null) {
                Context.exit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }
}

