/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.lineage.FieldnameLineage;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValues;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SelectValues.Injection.", groups={"FIELDS", "REMOVES", "METAS"})
public class SelectValuesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SelectValuesMeta.class;
    public static final int UNDEFINED = -2;
    @InjectionDeep
    private SelectField[] selectFields = new SelectField[0];
    @Injection(name="SELECT_UNSPECIFIED")
    private boolean selectingAndSortingUnspecifiedFields;
    @Injection(name="REMOVE_NAME", group="REMOVES")
    private String[] deleteName = new String[0];
    @InjectionDeep
    private SelectMetadataChange[] meta = new SelectMetadataChange[0];

    public String[] getDeleteName() {
        return this.deleteName;
    }

    public void setDeleteName(String[] deleteName) {
        this.deleteName = deleteName == null ? new String[]{} : deleteName;
    }

    public void setSelectName(String[] selectName) {
        this.resizeSelectFields(selectName.length);
        for (int i = 0; i < this.selectFields.length; ++i) {
            this.selectFields[i].setName(selectName[i]);
        }
    }

    public String[] getSelectName() {
        String[] selectName = new String[this.selectFields.length];
        for (int i = 0; i < selectName.length; ++i) {
            selectName[i] = this.selectFields[i].getName();
        }
        return selectName;
    }

    public void setSelectRename(String[] selectRename) {
        if (selectRename.length > this.selectFields.length) {
            this.resizeSelectFields(selectRename.length);
        }
        for (int i = 0; i < this.selectFields.length; ++i) {
            if (i < selectRename.length) {
                this.selectFields[i].setRename(selectRename[i]);
                continue;
            }
            this.selectFields[i].setRename(null);
        }
    }

    public String[] getSelectRename() {
        String[] selectRename = new String[this.selectFields.length];
        for (int i = 0; i < selectRename.length; ++i) {
            selectRename[i] = this.selectFields[i].getRename();
        }
        return selectRename;
    }

    public void setSelectLength(int[] selectLength) {
        if (selectLength.length > this.selectFields.length) {
            this.resizeSelectFields(selectLength.length);
        }
        for (int i = 0; i < this.selectFields.length; ++i) {
            if (i < selectLength.length) {
                this.selectFields[i].setLength(selectLength[i]);
                continue;
            }
            this.selectFields[i].setLength(-2);
        }
    }

    public int[] getSelectLength() {
        int[] selectLength = new int[this.selectFields.length];
        for (int i = 0; i < selectLength.length; ++i) {
            selectLength[i] = this.selectFields[i].getLength();
        }
        return selectLength;
    }

    public void setSelectPrecision(int[] selectPrecision) {
        if (selectPrecision.length > this.selectFields.length) {
            this.resizeSelectFields(selectPrecision.length);
        }
        for (int i = 0; i < this.selectFields.length; ++i) {
            if (i < selectPrecision.length) {
                this.selectFields[i].setPrecision(selectPrecision[i]);
                continue;
            }
            this.selectFields[i].setPrecision(-2);
        }
    }

    public int[] getSelectPrecision() {
        int[] selectPrecision = new int[this.selectFields.length];
        for (int i = 0; i < selectPrecision.length; ++i) {
            selectPrecision[i] = this.selectFields[i].getPrecision();
        }
        return selectPrecision;
    }

    private void resizeSelectFields(int length) {
        int fillStartIndex = this.selectFields.length;
        this.selectFields = Arrays.copyOf(this.selectFields, length);
        for (int i = fillStartIndex; i < this.selectFields.length; ++i) {
            this.selectFields[i] = new SelectField();
            this.selectFields[i].setLength(-2);
            this.selectFields[i].setPrecision(-2);
        }
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrFields, int nrRemove, int nrMeta) {
        this.allocateSelect(nrFields);
        this.allocateRemove(nrRemove);
        this.allocateMeta(nrMeta);
    }

    private void allocateSelect(int nrFields) {
        this.selectFields = new SelectField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            this.selectFields[i] = new SelectField();
        }
    }

    private void allocateRemove(int nrRemove) {
        this.deleteName = new String[nrRemove];
    }

    private void allocateMeta(int nrMeta) {
        this.meta = new SelectMetadataChange[nrMeta];
        for (int i = 0; i < nrMeta; ++i) {
            this.meta[i] = new SelectMetadataChange(this);
        }
    }

    @Override
    public Object clone() {
        int i;
        SelectValuesMeta retval = (SelectValuesMeta)super.clone();
        int nrfields = this.selectFields == null ? 0 : this.selectFields.length;
        int nrremove = this.deleteName == null ? 0 : this.deleteName.length;
        int nrmeta = this.meta == null ? 0 : this.meta.length;
        retval.allocate(nrfields, nrremove, nrmeta);
        for (i = 0; i < nrfields; ++i) {
            retval.getSelectFields()[i] = this.selectFields[i].clone();
        }
        System.arraycopy(this.deleteName, 0, retval.deleteName, 0, nrremove);
        for (i = 0; i < nrmeta; ++i) {
            retval.getMeta()[i] = this.meta[i].clone();
        }
        return retval;
    }

    private void readData(Node step) throws KettleXMLException {
        try {
            Node line;
            int i;
            Node fields = XMLHandler.getSubNode((Node)step, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrremove = XMLHandler.countNodes((Node)fields, (String)"remove");
            int nrmeta = XMLHandler.countNodes((Node)fields, (String)"meta");
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                line = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.selectFields[i] = new SelectField();
                this.selectFields[i].setName(XMLHandler.getTagValue((Node)line, (String)"name"));
                this.selectFields[i].setRename(XMLHandler.getTagValue((Node)line, (String)"rename"));
                this.selectFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"length"), (int)-2));
                this.selectFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"precision"), (int)-2));
            }
            this.selectingAndSortingUnspecifiedFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fields, (String)"select_unspecified"));
            for (i = 0; i < nrremove; ++i) {
                line = XMLHandler.getSubNodeByNr((Node)fields, (String)"remove", (int)i);
                this.deleteName[i] = XMLHandler.getTagValue((Node)line, (String)"name");
            }
            for (i = 0; i < nrmeta; ++i) {
                Node metaNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"meta", (int)i);
                this.meta[i] = new SelectMetadataChange(this);
                this.meta[i].loadXML(metaNode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate(0, 0, 0);
    }

    public void getSelectFields(RowMetaInterface inputRowMeta, String name) throws KettleStepException {
        if (this.selectFields != null && this.selectFields.length > 0) {
            RowMeta row = new RowMeta();
            for (int i = 0; i < this.selectFields.length; ++i) {
                ValueMetaInterface v = inputRowMeta.searchValueMeta(this.selectFields[i].getName());
                if (v == null) continue;
                if (!(v = v.clone()).getName().equals(this.selectFields[i].getRename()) && this.selectFields[i].getRename() != null && this.selectFields[i].getRename().length() > 0) {
                    v.setName(this.selectFields[i].getRename());
                    v.setOrigin(name);
                }
                if (this.selectFields[i].getLength() != -2) {
                    v.setLength(this.selectFields[i].getLength());
                    v.setOrigin(name);
                }
                if (this.selectFields[i].getPrecision() != -2) {
                    v.setPrecision(this.selectFields[i].getPrecision());
                    v.setOrigin(name);
                }
                row.addValueMeta(v);
            }
            if (this.selectingAndSortingUnspecifiedFields) {
                ArrayList<String> extra = new ArrayList<String>();
                for (int i = 0; i < inputRowMeta.size(); ++i) {
                    String fieldName = inputRowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])this.getSelectName()) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    ValueMetaInterface extraValue = inputRowMeta.searchValueMeta(fieldName);
                    row.addValueMeta(extraValue);
                }
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((RowMetaInterface)row);
        }
    }

    public void getDeleteFields(RowMetaInterface inputRowMeta) throws KettleStepException {
        if (this.deleteName != null && this.deleteName.length > 0) {
            for (int i = 0; i < this.deleteName.length; ++i) {
                try {
                    inputRowMeta.removeValueMeta(this.deleteName[i]);
                    continue;
                }
                catch (KettleValueException e) {
                    throw new KettleStepException((Throwable)e);
                }
            }
        }
    }

    public void getMetadataFields(RowMetaInterface inputRowMeta, String name) throws KettlePluginException {
        if (this.meta != null && this.meta.length > 0) {
            for (int i = 0; i < this.meta.length; ++i) {
                SelectMetadataChange metaChange = this.meta[i];
                int idx = inputRowMeta.indexOfValue(metaChange.getName());
                if (idx < 0) continue;
                ValueMetaInterface v = inputRowMeta.getValueMeta(idx);
                if (!v.getName().equals(metaChange.getRename()) && !Utils.isEmpty((CharSequence)metaChange.getRename())) {
                    v.setName(metaChange.getRename());
                    v.setOrigin(name);
                }
                if (metaChange.getType() != 0 && v.getType() != metaChange.getType()) {
                    v = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)v, (int)metaChange.getType());
                    inputRowMeta.setValueMeta(idx, v);
                    v.setStorageType(0);
                }
                if (metaChange.getLength() != -2) {
                    v.setLength(metaChange.getLength());
                    v.setOrigin(name);
                }
                if (metaChange.getPrecision() != -2) {
                    v.setPrecision(metaChange.getPrecision());
                    v.setOrigin(name);
                }
                if (metaChange.getStorageType() >= 0) {
                    v.setStorageType(metaChange.getStorageType());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getConversionMask())) {
                    v.setConversionMask(metaChange.getConversionMask());
                    v.setOrigin(name);
                }
                v.setDateFormatLenient(metaChange.isDateFormatLenient());
                v.setDateFormatLocale(EnvUtil.createLocale((String)metaChange.getDateFormatLocale()));
                v.setDateFormatTimeZone(EnvUtil.createTimeZone((String)metaChange.getDateFormatTimeZone()));
                v.setLenientStringToNumber(metaChange.isLenientStringToNumber());
                if (!Utils.isEmpty((CharSequence)metaChange.getEncoding())) {
                    v.setStringEncoding(metaChange.getEncoding());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getDecimalSymbol())) {
                    v.setDecimalSymbol(metaChange.getDecimalSymbol());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getGroupingSymbol())) {
                    v.setGroupingSymbol(metaChange.getGroupingSymbol());
                    v.setOrigin(name);
                }
                if (Utils.isEmpty((CharSequence)metaChange.getCurrencySymbol())) continue;
                v.setCurrencySymbol(metaChange.getCurrencySymbol());
                v.setOrigin(name);
            }
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            RowMetaInterface rowMeta = inputRowMeta.clone();
            inputRowMeta.clear();
            inputRowMeta.addRowMeta(rowMeta);
            this.getSelectFields(inputRowMeta, name);
            this.getDeleteFields(inputRowMeta);
            this.getMetadataFields(inputRowMeta, name);
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <fields>");
        for (i = 0; i < this.selectFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_NAME"), (String)this.selectFields[i].getName()));
            if (this.selectFields[i].getRename() != null) {
                retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_RENAME"), (String)this.selectFields[i].getRename()));
            }
            if (this.selectFields[i].getPrecision() > 0) {
                retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_LENGTH"), (int)this.selectFields[i].getLength()));
            }
            if (this.selectFields[i].getPrecision() > 0) {
                retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_PRECISION"), (int)this.selectFields[i].getPrecision()));
            }
            retval.append("      </field>");
        }
        retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("SELECT_UNSPECIFIED"), (boolean)this.selectingAndSortingUnspecifiedFields));
        for (i = 0; i < this.deleteName.length; ++i) {
            retval.append("      <remove>");
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("REMOVE_NAME"), (String)this.deleteName[i]));
            retval.append("      </remove>");
        }
        for (i = 0; i < this.meta.length; ++i) {
            retval.append(this.meta[i].getXML());
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            int nrfields = rep.countNrStepAttributes(id_step, this.getRepCode("FIELD_NAME"));
            int nrremove = rep.countNrStepAttributes(id_step, this.getRepCode("REMOVE_NAME"));
            int nrmeta = rep.countNrStepAttributes(id_step, this.getRepCode("META_NAME"));
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                this.selectFields[i].setName(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_NAME")));
                this.selectFields[i].setRename(rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_RENAME")));
                this.selectFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("FIELD_LENGTH")));
                this.selectFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("FIELD_PRECISION")));
            }
            this.selectingAndSortingUnspecifiedFields = rep.getStepAttributeBoolean(id_step, this.getRepCode("SELECT_UNSPECIFIED"));
            for (i = 0; i < nrremove; ++i) {
                this.deleteName[i] = rep.getStepAttributeString(id_step, i, this.getRepCode("REMOVE_NAME"));
            }
            for (i = 0; i < nrmeta; ++i) {
                this.meta[i] = new SelectMetadataChange(this);
                this.meta[i].setName(rep.getStepAttributeString(id_step, i, this.getRepCode("META_NAME")));
                this.meta[i].setRename(rep.getStepAttributeString(id_step, i, this.getRepCode("META_RENAME")));
                this.meta[i].setType((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("META_TYPE")));
                this.meta[i].setLength((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("META_LENGTH")));
                this.meta[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("META_PRECISION")));
                this.meta[i].setStorageType(ValueMetaBase.getStorageType((String)rep.getStepAttributeString(id_step, i, this.getRepCode("META_STORAGE_TYPE"))));
                this.meta[i].setConversionMask(rep.getStepAttributeString(id_step, i, this.getRepCode("META_CONVERSION_MASK")));
                this.meta[i].setDateFormatLenient(Boolean.parseBoolean(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DATE_FORMAT_LENIENT"))));
                this.meta[i].setDateFormatLocale(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DATE_FORMAT_LOCALE")));
                this.meta[i].setDateFormatTimeZone(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DATE_FORMAT_TIMEZONE")));
                this.meta[i].setLenientStringToNumber(Boolean.parseBoolean(rep.getStepAttributeString(id_step, i, this.getRepCode("META_LENIENT_STRING_TO_NUMBER"))));
                this.meta[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DECIMAL")));
                this.meta[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("META_GROUPING")));
                this.meta[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("META_CURRENCY")));
                this.meta[i].setEncoding(rep.getStepAttributeString(id_step, i, this.getRepCode("META_ENCODING")));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.selectFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_NAME"), this.selectFields[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_RENAME"), this.selectFields[i].getRename());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_LENGTH"), this.selectFields[i].getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_PRECISION"), this.selectFields[i].getPrecision());
            }
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("SELECT_UNSPECIFIED"), this.selectingAndSortingUnspecifiedFields);
            for (i = 0; i < this.deleteName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("REMOVE_NAME"), this.deleteName[i]);
            }
            for (i = 0; i < this.meta.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_NAME"), this.meta[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_RENAME"), this.meta[i].getRename());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_TYPE"), this.meta[i].getType());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_LENGTH"), this.meta[i].getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_PRECISION"), this.meta[i].getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_STORAGE_TYPE"), ValueMetaBase.getStorageTypeCode((int)this.meta[i].getStorageType()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_CONVERSION_MASK"), this.meta[i].getConversionMask());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DATE_FORMAT_LENIENT"), Boolean.toString(this.meta[i].isDateFormatLenient()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DATE_FORMAT_LOCALE"), this.meta[i].getDateFormatLocale() == null ? null : this.meta[i].getDateFormatLocale().toString());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DATE_FORMAT_TIMEZONE"), this.meta[i].getDateFormatTimeZone() == null ? null : this.meta[i].getDateFormatTimeZone().toString());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_LENIENT_STRING_TO_NUMBER"), Boolean.toString(this.meta[i].isLenientStringToNumber()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DECIMAL"), this.meta[i].getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_GROUPING"), this.meta[i].getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_CURRENCY"), this.meta[i].getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_ENCODING"), this.meta[i].getEncoding());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean error_found;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            int i;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            error_found = false;
            for (i = 0; i < this.selectFields.length; ++i) {
                int idx = prev.indexOfValue(this.selectFields[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.selectFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.SelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (this.selectFields.length > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    ValueMetaInterface pv = prev.getValueMeta(i);
                    int idx = Const.indexOfString((String)pv.getName(), (String[])this.getSelectName());
                    if (idx >= 0) continue;
                    error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    error_found = true;
                }
                if (error_found) {
                    error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                    cr = new CheckResult(2, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.deleteName.length; ++i) {
                int idx = prev.indexOfValue(this.deleteName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.deleteName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DeSelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllDeSelectedFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.meta.length; ++i) {
                int idx = prev.indexOfValue(this.meta[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.meta[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.MetadataFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllMetadataFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        int[] cnt = new int[this.selectFields.length];
        error_found = false;
        String error_message = "";
        for (int i = 0; i < this.selectFields.length; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < this.selectFields.length; ++j) {
                if (!this.selectFields[i].getName().equals(this.selectFields[j].getName())) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DuplicateFieldsSpecified", (String[])new String[0]) + Const.CR;
            } else {
                error_found = true;
            }
            error_message = error_message + BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.OccurentRow", (String[])new String[]{i + " : " + this.selectFields[i].getName() + "  (" + cnt[i]}) + Const.CR;
            error_found = true;
        }
        if (error_found) {
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SelectValues(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SelectValuesData();
    }

    public boolean isSelectingAndSortingUnspecifiedFields() {
        return this.selectingAndSortingUnspecifiedFields;
    }

    public void setSelectingAndSortingUnspecifiedFields(boolean selectingAndSortingUnspecifiedFields) {
        this.selectingAndSortingUnspecifiedFields = selectingAndSortingUnspecifiedFields;
    }

    public SelectMetadataChange[] getMeta() {
        return this.meta;
    }

    public void setMeta(SelectMetadataChange[] meta) {
        this.meta = meta == null ? new SelectMetadataChange[]{} : meta;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public SelectField[] getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(SelectField[] selectFields) {
        this.selectFields = selectFields == null ? new SelectField[]{} : selectFields;
    }

    public List<FieldnameLineage> getFieldnameLineage() {
        String output;
        String input;
        int i;
        ArrayList<FieldnameLineage> lineages = new ArrayList<FieldnameLineage>();
        for (i = 0; i < this.selectFields.length; ++i) {
            input = this.selectFields[i].getName();
            output = this.selectFields[i].getRename();
            if (Utils.isEmpty((CharSequence)output) || input.equalsIgnoreCase(output)) continue;
            lineages.add(new FieldnameLineage(input, output));
        }
        for (i = 0; i < this.getMeta().length; ++i) {
            input = this.getMeta()[i].getName();
            output = this.getMeta()[i].getRename();
            if (Utils.isEmpty((CharSequence)output) || input.equalsIgnoreCase(output)) continue;
            int idx = Const.indexOfString((String)input, (String[])this.getSelectRename());
            if (idx < 0) {
                lineages.add(new FieldnameLineage(input, output));
                continue;
            }
            FieldnameLineage lineage = FieldnameLineage.findFieldnameLineageWithInput(lineages, input);
            lineage.setOutputFieldname(output);
        }
        return lineages;
    }

    public static class SelectField
    implements Cloneable {
        @Injection(name="FIELD_NAME", group="FIELDS")
        private String name;
        @Injection(name="FIELD_RENAME", group="FIELDS")
        private String rename;
        @Injection(name="FIELD_LENGTH", group="FIELDS")
        private int length;
        @Injection(name="FIELD_PRECISION", group="FIELDS")
        private int precision;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRename() {
            return this.rename;
        }

        public void setRename(String rename) {
            this.rename = rename;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public SelectField clone() {
            try {
                return (SelectField)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

