/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.tableinput.TableInput;
import org.pentaho.di.trans.steps.tableinput.TableInputData;
import org.pentaho.di.trans.steps.tableinput.TableInputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TableInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = TableInputMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private String rowLimit;
    private boolean executeEachInputRow;
    private boolean variableReplacementActive;
    private boolean lazyConversionActive;

    public boolean isExecuteEachInputRow() {
        return this.executeEachInputRow;
    }

    public void setExecuteEachInputRow(boolean oncePerRow) {
        this.executeEachInputRow = oncePerRow;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableInputMeta retval = (TableInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.rowLimit = XMLHandler.getTagValue((Node)stepnode, (String)"limit");
            String lookupFromStepname = XMLHandler.getTagValue((Node)stepnode, (String)"lookup");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.executeEachInputRow = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"execute_each_row"));
            this.variableReplacementActive = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"variables_active"));
            this.lazyConversionActive = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"lazy_conversion_active"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "SELECT <values> FROM <table name> WHERE <conditions>";
        this.rowLimit = "0";
    }

    protected Database getDatabase() {
        return new Database(loggingObject, this.databaseMeta);
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaInterface v;
        if (this.databaseMeta == null) {
            return;
        }
        boolean param = false;
        Database db = this.getDatabase();
        this.databases = new Database[]{db};
        String sNewSQL = this.sql;
        if (this.isVariableReplacementActive()) {
            sNewSQL = db.environmentSubstitute(this.sql);
            if (space != null) {
                sNewSQL = space.environmentSubstitute(sNewSQL);
            }
        }
        RowMetaInterface add = null;
        try {
            add = db.getQueryFields(sNewSQL, param);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleStepException("Unable to get queryfields for SQL: " + Const.CR + sNewSQL, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                v = add.getValueMeta(i);
                v.setOrigin(origin);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                RowMetaInterface paramRowMeta = null;
                Object[] paramData = null;
                StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
                if (!Utils.isEmpty((CharSequence)infoStream.getStepname())) {
                    param = true;
                    if (info.length >= 0 && info[0] != null) {
                        paramRowMeta = info[0];
                        paramData = RowDataUtil.allocateRowData((int)paramRowMeta.size());
                    }
                }
                if ((add = db.getQueryFields(sNewSQL, param, paramRowMeta, paramData)) == null) {
                    return;
                }
                for (int i = 0; i < add.size(); ++i) {
                    ValueMetaInterface v2 = add.getValueMeta(i);
                    v2.setOrigin(origin);
                }
                row.addRowMeta(add);
            }
            catch (KettleException ke) {
                throw new KettleStepException("Unable to get queryfields for SQL: " + Const.CR + sNewSQL, (Throwable)ke);
            }
            finally {
                db.disconnect();
            }
        }
        if (this.isLazyConversionActive()) {
            for (int i = 0; i < row.size(); ++i) {
                v = row.getValueMeta(i);
                try {
                    if (v.getType() != 2) continue;
                    ValueMetaInterface storageMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)v);
                    storageMeta.setStorageType(0);
                    v.setStorageMetadata(storageMeta);
                    v.setStorageType(1);
                    continue;
                }
                catch (KettlePluginException e) {
                    throw new KettleStepException("Unable to clone meta for lazy conversion: " + Const.CR + v, (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (String)this.rowLimit));
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        retval.append("    " + XMLHandler.addTagValue((String)"lookup", (String)infoStream.getStepname()));
        retval.append("    " + XMLHandler.addTagValue((String)"execute_each_row", (boolean)this.executeEachInputRow));
        retval.append("    " + XMLHandler.addTagValue((String)"variables_active", (boolean)this.variableReplacementActive));
        retval.append("    " + XMLHandler.addTagValue((String)"lazy_conversion_active", (boolean)this.lazyConversionActive));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.rowLimit = rep.getStepAttributeString(id_step, "limit");
            if (this.rowLimit == null) {
                this.rowLimit = Long.toString(rep.getStepAttributeInteger(id_step, "limit"));
            }
            String lookupFromStepname = rep.getStepAttributeString(id_step, "lookup");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.executeEachInputRow = rep.getStepAttributeBoolean(id_step, "execute_each_row");
            this.variableReplacementActive = rep.getStepAttributeBoolean(id_step, "variables_active");
            this.lazyConversionActive = rep.getStepAttributeBoolean(id_step, "lazy_conversion_active");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            rep.saveStepAttribute(id_transformation, id_step, "lookup", infoStream.getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "execute_each_row", this.executeEachInputRow);
            rep.saveStepAttribute(id_transformation, id_step, "variables_active", this.variableReplacementActive);
            rep.saveStepAttribute(id_transformation, id_step, "lazy_conversion_active", this.lazyConversionActive);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, "Connection to database OK", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, "SQL statement is entered", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                cr = new CheckResult(4, "SQL statement is missing.", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        if (!Utils.isEmpty((CharSequence)infoStream.getStepname())) {
            boolean found = false;
            for (int i = 0; i < input.length; ++i) {
                if (!infoStream.getStepname().equalsIgnoreCase(input[i])) continue;
                found = true;
            }
            if (found) {
                cr = new CheckResult(1, "Previous step to read info from [" + infoStream.getStepname() + "] is found.", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, "Previous step to read info from [" + infoStream.getStepname() + "] is not found.", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            int count = 0;
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if (c == '\'') {
                    while ((c = this.sql.charAt(++i)) != '\'') {
                    }
                }
                if (c != '?') continue;
                ++count;
            }
            if (info != null) {
                if (count == info.size()) {
                    cr = new CheckResult(1, "This step is expecting and receiving " + info.size() + " fields of input from the previous step.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, "This step is receiving " + info.size() + " but not the expected " + count + " fields of input from the previous step.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                cr = new CheckResult(4, "Input step name is not recognized!", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, "Step is not expecting info from input steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "No input expected, no input provided.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableInputData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (stepMeta.getName().equalsIgnoreCase("cdc_cust")) {
            System.out.println("HERE!");
        }
        RowMeta out = new RowMeta();
        this.getFields((RowMetaInterface)out, stepMeta.getName(), new RowMetaInterface[]{info}, null, transMeta, repository, metaStore);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                ValueMetaInterface outvalue = out.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), stepMeta.getName(), this.sql, "read from one or more database tables via SQL statement");
                impact.add(ii);
            }
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isVariableReplacementActive() {
        return this.variableReplacementActive;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.variableReplacementActive = variableReplacementActive;
    }

    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"TableInputMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            this.ioMeta.addStream(stream);
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    public void setLookupFromStep(StepMeta stepMeta) {
        this.getStepIOMeta().getInfoStreams().get(0).setStepMeta(stepMeta);
    }

    public StepMeta getLookupFromStep() {
        return this.getStepIOMeta().getInfoStreams().get(0).getStepMeta();
    }

    @Override
    public TableInputMetaInjection getStepMetaInjectionInterface() {
        return new TableInputMetaInjection(this);
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return this.getStepMetaInjectionInterface().extractStepMetadataEntries();
    }
}

