/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.userdefinedjavaclass;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.regex.Pattern;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class FieldHelper {
    private int index = -1;
    private ValueMetaInterface meta;
    private static final Pattern validJavaIdentifier = Pattern.compile("^[\\w&&\\D]\\w*");

    public FieldHelper(RowMetaInterface rowMeta, String fieldName) {
        this.meta = rowMeta.searchValueMeta(fieldName);
        this.index = rowMeta.indexOfValue(fieldName);
        if (this.index == -1) {
            throw new IllegalArgumentException(String.format("FieldHelper could not be initialized. The field named '%s' not found in RowMeta: %s", fieldName, rowMeta.toStringMeta()));
        }
    }

    public Object getObject(Object[] dataRow) {
        return dataRow[this.index];
    }

    public BigDecimal getBigNumber(Object[] dataRow) throws KettleValueException {
        return this.meta.getBigNumber(dataRow[this.index]);
    }

    public byte[] getBinary(Object[] dataRow) throws KettleValueException {
        return this.meta.getBinary(dataRow[this.index]);
    }

    public Boolean getBoolean(Object[] dataRow) throws KettleValueException {
        return this.meta.getBoolean(dataRow[this.index]);
    }

    public Date getDate(Object[] dataRow) throws KettleValueException {
        return this.meta.getDate(dataRow[this.index]);
    }

    public Long getInteger(Object[] dataRow) throws KettleValueException {
        return this.meta.getInteger(dataRow[this.index]);
    }

    public Double getNumber(Object[] dataRow) throws KettleValueException {
        return this.meta.getNumber(dataRow[this.index]);
    }

    public Serializable getSerializable(Object[] dataRow) throws KettleValueException {
        return (Serializable)dataRow[this.index];
    }

    public String getString(Object[] dataRow) throws KettleValueException {
        return this.meta.getString(dataRow[this.index]);
    }

    public ValueMetaInterface getValueMeta() {
        return this.meta;
    }

    public int indexOfValue() {
        return this.index;
    }

    public void setValue(Object[] dataRow, Object value) {
        dataRow[this.index] = value;
    }

    public static String getAccessor(boolean isIn, String fieldName) {
        StringBuilder sb = new StringBuilder("get(Fields.");
        sb.append(isIn ? "In" : "Out");
        sb.append(String.format(", \"%s\")", fieldName.replace("\\", "\\\\").replace("\"", "\\\"")));
        return sb.toString();
    }

    public static String getGetSignature(String accessor, ValueMetaInterface v) {
        StringBuilder sb = new StringBuilder();
        switch (v.getType()) {
            case 6: {
                sb.append("BigDecimal ");
                break;
            }
            case 8: {
                sb.append("byte[] ");
                break;
            }
            case 4: {
                sb.append("Boolean ");
                break;
            }
            case 3: {
                sb.append("Date ");
                break;
            }
            case 5: {
                sb.append("Long ");
                break;
            }
            case 1: {
                sb.append("Double ");
                break;
            }
            case 2: {
                sb.append("String ");
                break;
            }
            default: {
                sb.append("Object ");
            }
        }
        if (validJavaIdentifier.matcher(v.getName()).matches()) {
            sb.append(v.getName());
        } else {
            sb.append("value");
        }
        String typeDesc = v.getTypeDesc();
        sb.append(" = ").append(accessor).append(".get").append("-".equals(typeDesc) ? "Object" : typeDesc).append("(r);");
        return sb.toString();
    }
}

