/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.valuemapper;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.valuemapper.ValueMapper;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="ValueMapper.Injection.", groups={"VALUES"})
public class ValueMapperMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ValueMapperMeta.class;
    @Injection(name="FIELDNAME")
    private String fieldToUse;
    @Injection(name="TARGET_FIELDNAME")
    private String targetField;
    @Injection(name="NON_MATCH_DEFAULT")
    private String nonMatchDefault;
    @Injection(name="SOURCE", group="VALUES")
    private String[] sourceValue;
    @Injection(name="TARGET", group="VALUES")
    private String[] targetValue;

    public String[] getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(String[] fieldName) {
        this.sourceValue = fieldName;
    }

    public String[] getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String[] fieldValue) {
        this.targetValue = fieldValue;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.sourceValue = new String[count];
        this.targetValue = new String[count];
    }

    @Override
    public Object clone() {
        ValueMapperMeta retval = (ValueMapperMeta)super.clone();
        int count = this.sourceValue.length;
        retval.allocate(count);
        System.arraycopy(this.sourceValue, 0, retval.sourceValue, 0, count);
        System.arraycopy(this.targetValue, 0, retval.targetValue, 0, count);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.fieldToUse = XMLHandler.getTagValue((Node)stepnode, (String)"field_to_use");
            this.targetField = XMLHandler.getTagValue((Node)stepnode, (String)"target_field");
            this.nonMatchDefault = XMLHandler.getTagValue((Node)stepnode, (String)"non_match_default");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_value");
                this.targetValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"target_value");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ValueMapperMeta.RuntimeError.UnableToReadXML.VALUEMAPPER0004", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.sourceValue[i] = "field" + i;
            this.targetValue[i] = "";
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValueMetaString extra = null;
        if (!Utils.isEmpty((CharSequence)this.getTargetField())) {
            extra = new ValueMetaString(this.getTargetField());
            int maxlen = -1;
            for (int i = 0; i < this.targetValue.length; ++i) {
                if (this.targetValue[i] == null || this.targetValue[i].length() <= maxlen) continue;
                maxlen = this.targetValue[i].length();
            }
            if (this.nonMatchDefault != null && this.nonMatchDefault.length() > maxlen) {
                maxlen = this.nonMatchDefault.length();
            }
            extra.setLength(maxlen);
            extra.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)extra);
        } else if (!Utils.isEmpty((CharSequence)this.getFieldToUse())) {
            extra = r.searchValueMeta(this.getFieldToUse());
        }
        if (extra != null) {
            extra.setStorageType(0);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)"field_to_use", (String)this.fieldToUse));
        retval.append("    ").append(XMLHandler.addTagValue((String)"target_field", (String)this.targetField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"non_match_default", (String)this.nonMatchDefault));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.sourceValue.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_value", (String)this.sourceValue[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_value", (String)this.targetValue[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.fieldToUse = rep.getStepAttributeString(id_step, "field_to_use");
            this.targetField = rep.getStepAttributeString(id_step, "target_field");
            this.nonMatchDefault = rep.getStepAttributeString(id_step, "non_match_default");
            int nrfields = rep.countNrStepAttributes(id_step, "source_value");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.sourceValue[i] = rep.getStepAttributeString(id_step, i, "source_value");
                this.targetValue[i] = rep.getStepAttributeString(id_step, i, "target_value");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ValueMapperMeta.RuntimeError.UnableToReadRepository.VALUEMAPPER0005", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "field_to_use", this.fieldToUse);
            rep.saveStepAttribute(id_transformation, id_step, "target_field", this.targetField);
            rep.saveStepAttribute(id_transformation, id_step, "non_match_default", this.nonMatchDefault);
            for (int i = 0; i < this.sourceValue.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "source_value", this.getNullOrEmpty(this.sourceValue[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "target_value", this.getNullOrEmpty(this.targetValue[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ValueMapperMeta.RuntimeError.UnableToSaveRepository.VALUEMAPPER0006", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    private String getNullOrEmpty(String str) {
        return str == null ? "" : str;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.NotReceivingFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.ReceivingFieldsFromPreviousSteps", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.NotReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ValueMapper(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ValueMapperData();
    }

    public String getFieldToUse() {
        return this.fieldToUse;
    }

    public void setFieldToUse(String fieldToUse) {
        this.fieldToUse = fieldToUse;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getNonMatchDefault() {
        return this.nonMatchDefault;
    }

    public void setNonMatchDefault(String nonMatchDefault) {
        this.nonMatchDefault = nonMatchDefault;
    }
}

