/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.TransformationMap;

public class GetStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/status";

    public GetStatusServlet() {
    }

    public GetStatusServlet(TransformationMap transformationMap, JobMap jobMap) {
        super(transformationMap, jobMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetStatusServlet.StatusRequested", (String[])new String[0]));
        }
        response.setStatus(200);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        List<CarteObjectEntry> transEntries = this.getTransformationMap().getTransformationObjects();
        List<CarteObjectEntry> jobEntries = this.getJobMap().getJobObjects();
        if (useXML) {
            String status;
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            SlaveServerStatus serverStatus = new SlaveServerStatus();
            serverStatus.setStatusDescription("Online");
            GetStatusServlet.getSystemInfo(serverStatus);
            for (CarteObjectEntry carteObjectEntry : transEntries) {
                Trans trans = this.getTransformationMap().getTransformation(carteObjectEntry);
                status = trans.getStatus();
                SlaveServerTransStatus sstatus = new SlaveServerTransStatus(carteObjectEntry.getName(), carteObjectEntry.getId(), status);
                sstatus.setLogDate(trans.getLogDate());
                sstatus.setPaused(trans.isPaused());
                serverStatus.getTransStatusList().add(sstatus);
            }
            for (CarteObjectEntry carteObjectEntry : jobEntries) {
                Job job = this.getJobMap().getJob(carteObjectEntry);
                status = job.getStatus();
                SlaveServerJobStatus jobStatus = new SlaveServerJobStatus(carteObjectEntry.getName(), carteObjectEntry.getId(), status);
                jobStatus.setLogDate(job.getLogDate());
                serverStatus.getJobStatusList().add(jobStatus);
            }
            try {
                out.println(serverStatus.getXML());
            }
            catch (KettleException e) {
                throw new ServletException("Unable to get the server status in XML format", (Throwable)e);
            }
        }
        out.println("<HTML>");
        out.println("<HEAD><TITLE>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.KettleSlaveServerStatus", (String[])new String[0]) + "</TITLE>");
        out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        out.println("</HEAD>");
        out.println("<BODY>");
        out.println("<H1>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TopStatus", (String[])new String[0]) + "</H1>");
        try {
            out.println("<table border=\"1\">");
            out.print("<tr> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TransName", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.CarteId", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogDate", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Remove", (String[])new String[0]) + "</th> </tr>");
            Comparator<CarteObjectEntry> transComparator = new Comparator<CarteObjectEntry>(){

                @Override
                public int compare(CarteObjectEntry o1, CarteObjectEntry o2) {
                    int logDateCompare;
                    Trans t1 = GetStatusServlet.this.getTransformationMap().getTransformation(o1);
                    Trans t2 = GetStatusServlet.this.getTransformationMap().getTransformation(o2);
                    Date d1 = t1.getLogDate();
                    Date d2 = t2.getLogDate();
                    if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                        return logDateCompare;
                    }
                    return o1.compareTo(o2);
                }
            };
            Collections.sort(transEntries, transComparator);
            for (CarteObjectEntry carteObjectEntry : transEntries) {
                String name = carteObjectEntry.getName();
                String id = carteObjectEntry.getId();
                Trans trans = this.getTransformationMap().getTransformation(carteObjectEntry);
                String status = trans.getStatus();
                String removeText = "";
                if (trans.isFinished() || trans.isStopped() || !trans.isInitializing() && !trans.isRunning()) {
                    removeText = "<a href=\"" + this.convertContextPath("/kettle/removeTrans") + "?name=" + URLEncoder.encode(name, "UTF-8") + "&id=" + id + "\"> Remove </a>";
                }
                out.print("<tr>");
                out.print("<td><a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(name, "UTF-8") + "&id=" + id + "\">" + name + "</a></td>");
                out.print("<td>" + id + "</td>");
                out.print("<td>" + status + "</td>");
                out.print("<td>" + (trans.getLogDate() == null ? "-" : XMLHandler.date2string((Date)trans.getLogDate())) + "</td>");
                out.print("<td>" + removeText + "</td>");
                out.print("</tr>");
            }
            out.print("</table><p>");
            out.println("<table border=\"1\">");
            out.print("<tr> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.JobName", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.CarteId", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogDate", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Remove", (String[])new String[0]) + "</th> </tr>");
            Comparator<CarteObjectEntry> jobComparator = new Comparator<CarteObjectEntry>(){

                @Override
                public int compare(CarteObjectEntry o1, CarteObjectEntry o2) {
                    int logDateCompare;
                    Job t1 = GetStatusServlet.this.getJobMap().getJob(o1);
                    Job t2 = GetStatusServlet.this.getJobMap().getJob(o2);
                    Date d1 = t1.getLogDate();
                    Date d2 = t2.getLogDate();
                    if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                        return logDateCompare;
                    }
                    return o1.compareTo(o2);
                }
            };
            Collections.sort(jobEntries, jobComparator);
            for (CarteObjectEntry entry : jobEntries) {
                String name = entry.getName();
                String id = entry.getId();
                Job job = this.getJobMap().getJob(entry);
                String status = job.getStatus();
                String removeText = job.isFinished() || job.isStopped() ? "<a href=\"" + this.convertContextPath("/kettle/removeJob") + "?name=" + URLEncoder.encode(name, "UTF-8") + "&id=" + id + "\"> Remove </a>" : "";
                out.print("<tr>");
                out.print("<td><a href=\"" + this.convertContextPath("/kettle/jobStatus") + "?name=" + URLEncoder.encode(name, "UTF-8") + "&id=" + id + "\">" + name + "</a></td>");
                out.print("<td>" + id + "</td>");
                out.print("<td>" + status + "</td>");
                out.print("<td>" + (job.getLogDate() == null ? "-" : XMLHandler.date2string((Date)job.getLogDate())) + "</td>");
                out.print("<td>" + removeText + "</td>");
                out.print("</tr>");
            }
            out.print("</table>");
        }
        catch (Exception ex) {
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        out.println("<p>");
        out.println("<H1>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Title", (String[])new String[0]) + "</H1><p>");
        out.println("<table border=\"1\">");
        out.print("<tr> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.Title", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Value.Title", (String[])new String[0]) + "</th> </tr>");
        SlaveServerConfig serverConfig = this.getTransformationMap().getSlaveServerConfig();
        if (serverConfig != null) {
            String repositoryName;
            void var9_21;
            String maxLines = "";
            maxLines = serverConfig.getMaxLogLines() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogLines() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Lines", (String[])new String[0]);
            out.print("<tr> <td>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLines", (String[])new String[0]) + "</td> <td>" + maxLines + "</td> </tr>");
            String string = "";
            if (serverConfig.getMaxLogTimeoutMinutes() == 0) {
                String string2 = BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]);
            } else {
                String string3 = serverConfig.getMaxLogTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
            }
            out.print("<tr> <td>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLinesAge", (String[])new String[0]) + "</td> <td>" + (String)var9_21 + "</td> </tr>");
            String maxObjAge = "";
            maxObjAge = serverConfig.getObjectTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getObjectTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
            out.print("<tr> <td>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxObjectsAge", (String[])new String[0]) + "</td> <td>" + maxObjAge + "</td> </tr>");
            try {
                repositoryName = serverConfig.getRepository() != null ? serverConfig.getRepository().getName() : "";
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName.UnableToConnect", (String[])new String[]{serverConfig.getRepositoryId()}), e);
                repositoryName = BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName.UnableToConnect", (String[])new String[]{serverConfig.getRepositoryId()});
            }
            out.print("<tr> <td>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName", (String[])new String[0]) + "</td> <td>" + repositoryName + "</td> </tr>");
            out.print("</table>");
            String filename = serverConfig.getFilename();
            if (filename == null) {
                filename = BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.UsingDefaults", (String[])new String[0]);
            }
            out.println("<i>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Advice", (String[])new String[]{filename}) + "</i><br>");
        }
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private static void getSystemInfo(SlaveServerStatus serverStatus) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int cores = Runtime.getRuntime().availableProcessors();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        String osArch = operatingSystemMXBean.getArch();
        String osName = operatingSystemMXBean.getName();
        String osVersion = operatingSystemMXBean.getVersion();
        double loadAvg = operatingSystemMXBean.getSystemLoadAverage();
        int threadCount = threadMXBean.getThreadCount();
        long allThreadsCpuTime = 0L;
        long[] threadIds = threadMXBean.getAllThreadIds();
        for (int i = 0; i < threadIds.length; ++i) {
            allThreadsCpuTime += threadMXBean.getThreadCpuTime(threadIds[i]);
        }
        long uptime = runtimeMXBean.getUptime();
        serverStatus.setCpuCores(cores);
        serverStatus.setCpuProcessTime(allThreadsCpuTime);
        serverStatus.setUptime(uptime);
        serverStatus.setThreadCount(threadCount);
        serverStatus.setLoadAvg(loadAvg);
        serverStatus.setOsName(osName);
        serverStatus.setOsVersion(osVersion);
        serverStatus.setOsArchitecture(osArch);
        serverStatus.setMemoryFree(freeMemory);
        serverStatus.setMemoryTotal(totalMemory);
    }

    public String toString() {
        return "Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/status (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

