/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.solution;

import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.util.PentahoCheckedChainedException;

public class ActionInfo {
    private String solutionName;
    private String path;
    private String actionName;

    public ActionInfo(String solutionName, String path, String actionName) {
        this.solutionName = solutionName;
        this.path = path;
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getPath() {
        return this.path;
    }

    public String getSolutionName() {
        return this.solutionName;
    }

    public static ActionInfo parseActionString(String actionString) {
        return ActionInfo.parseActionString(actionString, true);
    }

    public static ActionInfo parseActionString(String actionString, boolean mustBeComplete) {
        if (StringUtils.isEmpty((String)actionString)) {
            return null;
        }
        if ((actionString = actionString.replace('\\', "/".charAt(0))).charAt(0) == "/".charAt(0)) {
            actionString = actionString.substring(1);
        }
        String path = "";
        int idx1 = actionString.indexOf("/".charAt(0));
        int idx2 = actionString.lastIndexOf("/".charAt(0));
        if (idx1 == -1) {
            if (mustBeComplete) {
                return null;
            }
            return new ActionInfo(actionString, null, null);
        }
        String solution = actionString.substring(0, idx1);
        String name = actionString.substring(idx2 + 1);
        if (idx2 > idx1) {
            path = actionString.substring(idx1 + 1, idx2);
        }
        if (!mustBeComplete && name.indexOf(46) == -1) {
            path = StringUtils.isEmpty((String)path) ? name : path + "/" + name;
            name = null;
        }
        return new ActionInfo(solution, path, name);
    }

    public String toString() {
        return ActionInfo.buildSolutionPath(this.solutionName, this.path, this.actionName);
    }

    public static String buildSolutionPath(String solution, String path, String filename) {
        StringBuffer buf = new StringBuffer();
        if (solution != null && solution.equals(filename) && "".equals(path)) {
            filename = "";
        }
        if (path != null && path.equalsIgnoreCase("/")) {
            path = "";
        }
        if (StringUtils.isEmpty((String)path)) {
            if (!StringUtils.isEmpty((String)filename) && filename.charAt(0) == "/".charAt(0)) {
                return buf.append(solution).append(filename).toString();
            }
            return buf.append(solution).append("/".charAt(0)).append(filename).toString();
        }
        if (path.charAt(0) == "/".charAt(0)) {
            if (!StringUtils.isEmpty((String)filename) && filename.charAt(0) == "/".charAt(0)) {
                return buf.append(solution).append(path).append(filename).toString();
            }
            return buf.append(solution).append(path).append("/".charAt(0)).append(filename).toString();
        }
        if (!StringUtils.isEmpty((String)filename) && filename.charAt(0) == "/".charAt(0)) {
            return buf.append(solution).append("/".charAt(0)).append(path).append(filename).toString();
        }
        return buf.append(solution).append("/".charAt(0)).append(path).append("/".charAt(0)).append(filename).toString();
    }

    public static class ActionInfoParseException
    extends PentahoCheckedChainedException {
        private static final long serialVersionUID = 420L;

        public ActionInfoParseException(String message, Throwable reas) {
            super(message, reas);
        }

        public ActionInfoParseException(String message) {
            super(message);
        }

        public ActionInfoParseException(Throwable reas) {
            super(reas);
        }

        public ActionInfoParseException() {
        }
    }
}

