/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;

public abstract class PentahoBase
implements ILogger,
Serializable {
    private static final long serialVersionUID = 1376440889763516196L;
    protected int loggingLevel = PentahoSystem.loggingLevel;
    public static final String LOGID_MASK1 = "{0}:{1}:{2}: ";
    public static final String LOGID_MASK2 = "{0}:{1}:{2}:{3} ";
    public static final String LOGID_SEPARATOR = ":";
    public String EMPTYLOGID;
    private String logId = this.EMPTYLOGID = "::: ";

    public abstract Log getLogger();

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String lId) {
        this.logId = lId;
    }

    public void genLogIdFromSession(IPentahoSession sess) {
        this.genLogIdFromInfo(sess.getId(), sess.getProcessId(), sess.getActionName());
    }

    public void genLogIdFromInfo(String sessId, String procId, String actName) {
        Object[] args = new Object[]{sessId, procId, actName};
        this.setLogId(MessageFormat.format(LOGID_MASK1, this.noNulls(args)));
    }

    public void genLogIdFromInfo(String sessId, String procId, String actName, String instId) {
        Object[] args = new Object[]{sessId, procId, actName, instId};
        this.setLogId(MessageFormat.format(LOGID_MASK2, this.noNulls(args)));
    }

    private Object[] noNulls(Object[] inStr) {
        for (int i = 0; i < inStr.length; ++i) {
            if (inStr[i] != null) continue;
            inStr[i] = "";
        }
        return inStr;
    }

    public String getObjectName() {
        return this.getClass().getName();
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(int logLevel) {
        this.loggingLevel = logLevel;
    }

    public void trace(String message) {
        if (this.loggingLevel <= 1) {
            this.getLogger().trace((Object)(this.getLogId() + message));
        }
    }

    public void debug(String message) {
        if (this.loggingLevel <= 2) {
            this.getLogger().debug((Object)(this.getLogId() + message));
        }
    }

    public void info(String message) {
        if (this.loggingLevel <= 3) {
            this.getLogger().info((Object)(this.getLogId() + message));
        }
    }

    public void warn(String message) {
        if (this.loggingLevel <= 4) {
            this.getLogger().warn((Object)(this.getLogId() + message));
        }
    }

    public void error(String message) {
        if (this.loggingLevel <= 5) {
            this.getLogger().error((Object)(this.getLogId() + message));
        }
    }

    public void fatal(String message) {
        if (this.loggingLevel <= 6) {
            this.getLogger().fatal((Object)(this.getLogId() + message));
        }
    }

    public void trace(String message, Throwable error) {
        if (this.loggingLevel <= 1) {
            this.getLogger().trace((Object)(this.getLogId() + message), error);
            Logger.addException(error);
        }
    }

    public void debug(String message, Throwable error) {
        if (this.loggingLevel <= 2) {
            this.getLogger().debug((Object)(this.getLogId() + message), error);
            Logger.addException(error);
        }
    }

    public void info(String message, Throwable error) {
        if (this.loggingLevel <= 3) {
            this.getLogger().info((Object)(this.getLogId() + message), error);
            Logger.addException(error);
        }
    }

    public void warn(String message, Throwable error) {
        if (this.loggingLevel <= 4) {
            this.getLogger().warn((Object)(this.getLogId() + message), error);
            Logger.addException(error);
        }
    }

    public void error(String message, Throwable error) {
        if (this.loggingLevel <= 5) {
            IVersionHelper helper = PentahoSystem.get(IVersionHelper.class, null);
            if (helper != null) {
                this.getLogger().error((Object)("Error Start: Pentaho " + helper.getVersionInformation(PentahoSystem.class)));
            } else {
                this.getLogger().error((Object)"Error Start: Pentaho ");
            }
            this.getLogger().error((Object)(this.getLogId() + message), error);
            this.getLogger().error((Object)"Error end:");
            Logger.addException(error);
        }
    }

    public void fatal(String message, Throwable error) {
        if (this.loggingLevel <= 6) {
            IVersionHelper helper = PentahoSystem.get(IVersionHelper.class, null);
            if (helper != null) {
                this.getLogger().error((Object)("Error Start: Pentaho " + helper.getVersionInformation(PentahoSystem.class)));
            } else {
                this.getLogger().error((Object)"Error Start: Pentaho ");
            }
            this.getLogger().fatal((Object)(this.getLogId() + message), error);
            this.getLogger().error((Object)"Error end:");
            Logger.addException(error);
        }
    }
}

