/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoRequestContextHolderStrategy;
import org.pentaho.platform.engine.core.system.BasePentahoRequestContext;
import org.pentaho.platform.engine.core.system.GlobalPentahoRequestContextHolderStrategy;
import org.pentaho.platform.engine.core.system.InheritableThreadLocalPentahoRequestContextHolderStrategy;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PentahoRequestContextHolder {
    private static final Log logger = LogFactory.getLog(PentahoRequestContextHolder.class);
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String SYSTEM_PROPERTY = "pentaho.requestContextHolder.strategy";
    private static String strategyName = System.getProperty("pentaho.requestContextHolder.strategy");
    private static IPentahoRequestContextHolderStrategy strategy;

    public static void setRequestContext(IPentahoRequestContext requestContext) {
        strategy.setRequestContext(requestContext);
    }

    public static IPentahoRequestContext getRequestContext() {
        if (strategy != null && strategy.getRequestContext() != null) {
            return strategy.getRequestContext();
        }
        if (PentahoSystem.getInitializedOK()) {
            return new BasePentahoRequestContext(PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        }
        try {
            logger.debug((Object)("Something went wrong. Trying to proceed. System is in status " + PentahoSystem.getInitializedStatus()));
            if (PentahoSystem.getApplicationContext() != null && PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() != null) {
                return new BasePentahoRequestContext(PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Restore attempt failed ", (Throwable)ex);
        }
        return null;
    }

    public static void removeRequestContext() {
        strategy.removeRequestContext();
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = MODE_INHERITABLETHREADLOCAL;
        }
        if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new InheritableThreadLocalPentahoRequestContextHolderStrategy();
        } else if (strategyName.equals(MODE_GLOBAL)) {
            strategy = new GlobalPentahoRequestContextHolderStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (IPentahoRequestContextHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug((Object)("PentahoRequestContextHolder initialized: strategy=" + strategyName));
    }

    public static void setStrategyName(String strategyName) {
        PentahoRequestContextHolder.strategyName = strategyName;
        PentahoRequestContextHolder.initialize();
    }

    static {
        PentahoRequestContextHolder.initialize();
    }
}

