/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemEntryPoint;
import org.pentaho.platform.api.engine.IPentahoSystemExitPoint;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;

public class StandaloneApplicationContext
implements IApplicationContext {
    private String solutionRootPath;
    private String fullyQualifiedServerUrl;
    private String applicationPath;
    private Object context;
    private Properties properties = new Properties();
    private final List<IPentahoSystemEntryPoint> entryPointsList = new ArrayList<IPentahoSystemEntryPoint>();
    private final List<IPentahoSystemExitPoint> exitPointsList = new ArrayList<IPentahoSystemExitPoint>();

    public StandaloneApplicationContext(String solutionRootPath, String applicationPath, Object context) {
        this(solutionRootPath, applicationPath);
        this.context = context;
    }

    public StandaloneApplicationContext(String solutionRootPath, String applicationPath) {
        this.solutionRootPath = solutionRootPath;
        this.applicationPath = applicationPath;
        this.fullyQualifiedServerUrl = null;
    }

    public void setFullyQualifiedServerURL(String fullyQualifiedServerUrl) {
        this.fullyQualifiedServerUrl = fullyQualifiedServerUrl;
    }

    public String getFileOutputPath(String path) {
        return this.solutionRootPath + File.separator + path;
    }

    public String getSolutionPath(String path) {
        return this.solutionRootPath + File.separator + path;
    }

    public void setSolutionRootPath(String solutionRootPath) {
        this.solutionRootPath = solutionRootPath;
    }

    public File createTempFile(IPentahoSession session, String prefix, String extn, boolean trackFile) throws IOException {
        return this.createTempFile(session, prefix, extn, new File(this.getSolutionPath("system/tmp")), trackFile);
    }

    public File createTempFile(IPentahoSession session, String prefix, String extn, File parentDir, boolean trackFile) throws IOException {
        ITempFileDeleter fileDeleter = null;
        if (session == null) {
            return null;
        }
        if (trackFile) {
            fileDeleter = (ITempFileDeleter)session.getAttribute("PENTAHO_TMP_DELETER");
        }
        String name = session.getName();
        String newPrefix = prefix + name.substring(0, name.length() > 10 ? 10 : name.length()) + '-';
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        File file = File.createTempFile(newPrefix, extn, parentDir);
        if (fileDeleter != null) {
            fileDeleter.trackTempFile(file);
        } else {
            file.deleteOnExit();
        }
        return file;
    }

    public String getPentahoServerName() {
        return "";
    }

    public int getServerPort() {
        return 0;
    }

    @Deprecated
    public void setBaseUrl(String baseUrl) {
    }

    @Deprecated
    public String getBaseUrl() {
        return PentahoRequestContextHolder.getRequestContext().getContextPath();
    }

    public String getFullyQualifiedServerURL() {
        return this.fullyQualifiedServerUrl;
    }

    public String getApplicationPath(String path) {
        return this.applicationPath + File.separator + path;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public void addEntryPointHandler(IPentahoSystemEntryPoint entryPoint) {
        this.entryPointsList.add(entryPoint);
    }

    public void removeEntryPointHandler(IPentahoSystemEntryPoint entryPoint) {
        this.entryPointsList.remove(entryPoint);
    }

    public void addExitPointHandler(IPentahoSystemExitPoint exitPoint) {
        this.exitPointsList.add(exitPoint);
    }

    public void removeExitPointHandler(IPentahoSystemExitPoint exitPoint) {
        this.exitPointsList.remove(exitPoint);
    }

    public void invokeEntryPoints() {
        for (int i = 0; i < this.entryPointsList.size(); ++i) {
            this.entryPointsList.get(i).systemEntryPoint();
        }
    }

    public void invokeExitPoints() {
        for (int i = 0; i < this.exitPointsList.size(); ++i) {
            this.exitPointsList.get(i).systemExitPoint();
        }
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public String getSolutionRootPath() {
        return this.solutionRootPath;
    }
}

