/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoDefinableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;

public class StandaloneObjectFactory
implements IPentahoDefinableObjectFactory {
    private Map<String, ObjectCreator> creators = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> instanceMap = new HashMap<String, Object>();
    private String name;

    public StandaloneObjectFactory() {
    }

    public StandaloneObjectFactory(String name) {
        this.name = name;
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(interfaceClass, interfaceClass.getSimpleName(), session);
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        return (T)this.retreiveObject(key, session);
    }

    public Class getImplementingClass(String key) {
        if (!this.objectDefined(key)) {
            return null;
        }
        ObjectCreator creator = this.creators.get(key);
        try {
            return creator.createClass();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load implementing class for " + key, e);
        }
    }

    public void init(String arg0, Object arg1) {
        this.creators.clear();
    }

    public boolean objectDefined(String key) {
        return this.instanceMap.containsKey(key) || this.creators.get(key) != null;
    }

    public void defineObject(String key, String className, IPentahoDefinableObjectFactory.Scope scope) {
        this.defineObject(key, className, scope, this.getClass().getClassLoader());
    }

    public void defineObject(String key, String className, IPentahoDefinableObjectFactory.Scope scope, ClassLoader loader) {
        ObjectCreator creator = new ObjectCreator(className, scope, loader);
        this.creators.put(key, creator);
    }

    protected Object retreiveObject(String key, IPentahoSession session) throws ObjectFactoryException {
        Object o = this.instanceMap.get(key);
        if (o != null) {
            return o;
        }
        ObjectCreator creator = this.creators.get(key);
        if (creator == null) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_CREATE_OBJECT", key);
            throw new ObjectFactoryException(msg);
        }
        Object instance = creator.getInstance(key, session);
        return instance;
    }

    public void defineInstance(String key, Object instance) {
        this.instanceMap.put(key, instance);
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return Collections.singletonList(this.get(interfaceClass, curSession));
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        return this.getAll(interfaceClass, curSession);
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> clazz, IPentahoSession curSession) throws ObjectFactoryException {
        T obj = this.get(clazz, curSession);
        return new SingletonPentahoObjectReference<T>(clazz, obj);
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        return this.get(interfaceClass, session);
    }

    public boolean objectDefined(Class<?> clazz) {
        return this.instanceMap.containsKey(clazz.getSimpleName()) || this.creators.get(clazz.getSimpleName()) != null;
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        T obj = this.get(interfaceClass, curSession);
        return new SingletonPentahoObjectReference<T>(interfaceClass, obj);
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, null);
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        T obj = this.get(interfaceClass, curSession);
        ArrayList<IPentahoObjectReference<T>> refs = new ArrayList<IPentahoObjectReference<T>>();
        refs.add(new SingletonPentahoObjectReference<T>(interfaceClass, obj));
        return refs;
    }

    public String getName() {
        return this.name;
    }

    private class ObjectCreator {
        private IPentahoDefinableObjectFactory.Scope scope = null;
        private String className = null;
        private ThreadLocal<Object> threadLocalInstance = null;
        private Object globalInstance = null;
        private ClassLoader loader;

        public ObjectCreator(String className, IPentahoDefinableObjectFactory.Scope scope, ClassLoader loader) {
            this.className = className.trim();
            this.scope = scope;
            this.loader = loader;
            if (scope == IPentahoDefinableObjectFactory.Scope.THREAD) {
                this.threadLocalInstance = new ThreadLocal();
            }
        }

        public Object getInstance(String key, IPentahoSession session) throws ObjectFactoryException {
            if (this.scope == IPentahoDefinableObjectFactory.Scope.GLOBAL) {
                return this.getGlobalInstance(key, session);
            }
            if (this.scope == IPentahoDefinableObjectFactory.Scope.SESSION) {
                return this.getSessionInstance(key, session);
            }
            if (this.scope == IPentahoDefinableObjectFactory.Scope.LOCAL) {
                return this.getLocalInstance(key, session);
            }
            if (this.scope == IPentahoDefinableObjectFactory.Scope.THREAD) {
                return this.getThreadInstance(key, session);
            }
            return null;
        }

        protected Object createObject() throws ObjectFactoryException {
            Object instance = null;
            Class classObject = this.createClass();
            try {
                instance = classObject.newInstance();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ObjectFactoryException((Throwable)e);
            }
            return instance;
        }

        protected Class createClass() throws ObjectFactoryException {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ObjectFactoryException((Throwable)e);
            }
        }

        public Object getGlobalInstance(String key, IPentahoSession session) throws ObjectFactoryException {
            if (null == this.globalInstance) {
                this.globalInstance = this.createObject();
                if (this.globalInstance instanceof IPentahoInitializer) {
                    ((IPentahoInitializer)this.globalInstance).init(session);
                }
            }
            return this.globalInstance;
        }

        public Object getSessionInstance(String key, IPentahoSession session) throws ObjectFactoryException {
            if (null == session) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("SessionObjectCreator.ERROR_0001_INVALID_SESSION"));
            }
            Object instance = session.getAttribute(key);
            if (instance == null) {
                instance = this.createObject();
                if (instance instanceof IPentahoInitializer) {
                    ((IPentahoInitializer)instance).init(session);
                }
                session.setAttribute(key, instance);
            }
            return instance;
        }

        public Object getLocalInstance(String key, IPentahoSession session) throws ObjectFactoryException {
            Object instance = this.createObject();
            if (instance instanceof IPentahoInitializer) {
                ((IPentahoInitializer)instance).init(session);
            }
            return instance;
        }

        public Object getThreadInstance(String key, IPentahoSession session) throws ObjectFactoryException {
            Object instance = this.threadLocalInstance.get();
            if (instance == null) {
                instance = this.createObject();
                if (instance instanceof IPentahoInitializer) {
                    ((IPentahoInitializer)instance).init(session);
                }
                this.threadLocalInstance.set(instance);
            }
            return instance;
        }
    }
}

