/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.objfac.AbstractSpringPentahoObjectFactory;
import org.pentaho.platform.engine.core.system.objfac.spring.PentahoBeanScopeValidatorPostProcessor;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringScopeSessionHolder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class StandaloneSpringPentahoObjectFactory
extends AbstractSpringPentahoObjectFactory {
    private static Map<ApplicationContext, StandaloneSpringPentahoObjectFactory> factoryMap = new HashMap<ApplicationContext, StandaloneSpringPentahoObjectFactory>();

    public StandaloneSpringPentahoObjectFactory() {
    }

    public StandaloneSpringPentahoObjectFactory(String name) {
        super(name);
    }

    public void init(String configFile, Object context) {
        if (context == null) {
            FileSystemXmlApplicationContext appCtx = new FileSystemXmlApplicationContext(configFile);
            appCtx.refresh();
            appCtx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PentahoBeanScopeValidatorPostProcessor());
            ThreadLocalScope requestScope = new ThreadLocalScope();
            appCtx.getBeanFactory().registerScope("request", (Scope)requestScope);
            ThreadLocalScope sessionScope = new ThreadLocalScope();
            appCtx.getBeanFactory().registerScope("session", (Scope)sessionScope);
            this.beanFactory = appCtx;
        } else {
            if (!(context instanceof ConfigurableApplicationContext)) {
                String msg = Messages.getInstance().getErrorString("StandalonePentahoObjectFactory.ERROR_0001_CONTEXT_NOT_SUPPORTED", this.getClass().getSimpleName(), "GenericApplicationContext", context.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
            ConfigurableApplicationContext configAppCtx = (ConfigurableApplicationContext)context;
            if (configAppCtx.getBeanFactory().getRegisteredScope("request") == null) {
                ThreadLocalScope requestScope = new ThreadLocalScope();
                configAppCtx.getBeanFactory().registerScope("request", (Scope)requestScope);
            }
            if (configAppCtx.getBeanFactory().getRegisteredScope("session") == null) {
                ThreadLocalScope sessionScope = new ThreadLocalScope();
                configAppCtx.getBeanFactory().registerScope("session", (Scope)sessionScope);
            }
            this.setBeanFactory(configAppCtx);
        }
    }

    public static StandaloneSpringPentahoObjectFactory getInstance(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("ApplicationContext cannot be null");
        }
        StandaloneSpringPentahoObjectFactory retVal = factoryMap.get(applicationContext);
        if (retVal == null) {
            retVal = new StandaloneSpringPentahoObjectFactory();
            retVal.init(null, applicationContext);
            factoryMap.put(applicationContext, retVal);
        }
        return retVal;
    }

    private static class ThreadLocalScope
    implements Scope {
        private ThreadLocalScope() {
        }

        public Object get(String name, ObjectFactory objectFactory) {
            IPentahoSession session = SpringScopeSessionHolder.SESSION.get();
            if (session == null) {
                return null;
            }
            Object object = session.getAttribute(name);
            if (object == null) {
                object = objectFactory.getObject();
                session.setAttribute(name, object);
            }
            return object;
        }

        public Object remove(String name) {
            IPentahoSession session = SpringScopeSessionHolder.SESSION.get();
            return session.removeAttribute(name);
        }

        public void registerDestructionCallback(String name, Runnable callback) {
            AbstractSpringPentahoObjectFactory.logger.warn((Object)"SimpleThreadScope does not support descruction callbacks. Consider using a RequestScope in a Web environment.");
        }

        public String getConversationId() {
            return SpringScopeSessionHolder.SESSION.get().getId();
        }

        public Object resolveContextualObject(String arg0) {
            return null;
        }
    }
}

