/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.util.Set;
import org.pentaho.platform.engine.core.system.objfac.spring.BarrierBeanProcessor;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.api.IServiceBarrierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BarrierBeanPostProcessor
implements BeanPostProcessor {
    static IServiceBarrierManager serviceBarrierManager;
    private static Logger logger;
    private static BarrierBeanPostProcessor barrierBeanPostProcessor;

    private BarrierBeanPostProcessor() {
        serviceBarrierManager = IServiceBarrierManager.LOCATOR.getManager();
    }

    public static BarrierBeanPostProcessor getInstance() {
        if (barrierBeanPostProcessor == null) {
            barrierBeanPostProcessor = new BarrierBeanPostProcessor();
        }
        return barrierBeanPostProcessor;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        logger.debug("beforeInitialization: " + beanName);
        Set<String> barriers = BarrierBeanProcessor.getInstance().getBeanBarriers().get(beanName);
        if (barriers != null) {
            for (String barrierName : barriers) {
                IServiceBarrier barrier = serviceBarrierManager.getServiceBarrier(barrierName);
                barrier.hold();
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        logger.debug("AfterInitialization: " + beanName);
        Set<String> barriers = BarrierBeanProcessor.getInstance().getBeanBarriers().get(beanName);
        if (barriers != null) {
            for (String barrierName : barriers) {
                IServiceBarrier barrier = serviceBarrierManager.getServiceBarrier(barrierName);
                barrier.release();
            }
        }
        return bean;
    }

    static {
        logger = LoggerFactory.getLogger(BarrierBeanPostProcessor.class);
    }
}

