/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;

public class DefaultLdapRoleMapper
implements IAuthenticationRoleMapper,
Serializable {
    Map<String, String> roleMap;
    private static final String DEFAULT_ROLE_ATTRIBUTE_VALUE = "cn";
    private static final String ROLE_ATTRIBUTE_PROPERTY = "allAuthoritiesSearch.roleAttribute";
    private static final String LDAP_PROPERTIES_FILENAME = "applicationContext-security-ldap.properties";

    public DefaultLdapRoleMapper() {
    }

    public DefaultLdapRoleMapper(Map<String, String> newRoleMap) {
        String roleAttribute = this.getRoleAttributeFromProperties();
        this.roleMap = new HashMap<String, String>();
        for (Map.Entry<String, String> roleEntry : newRoleMap.entrySet()) {
            this.roleMap.put(this.ldapParseString(roleEntry.getKey(), roleAttribute), roleEntry.getValue());
        }
    }

    public DefaultLdapRoleMapper(Map<String, String> newRoleMap, String roleAttribute) {
        this.roleMap = new HashMap<String, String>();
        for (Map.Entry<String, String> roleEntry : newRoleMap.entrySet()) {
            this.roleMap.put(this.ldapParseString(roleEntry.getKey(), roleAttribute), roleEntry.getValue());
        }
    }

    public String toPentahoRole(String thirdPartyRole) {
        if (this.roleMap.containsKey(thirdPartyRole)) {
            return this.roleMap.get(thirdPartyRole);
        }
        return thirdPartyRole;
    }

    private String ldapParseString(String ldapString, String key) {
        String[] tokens = ldapString.split(",");
        if (tokens.length > 0) {
            for (String token : tokens) {
                if (!token.split("=")[0].toLowerCase().equals(key.toLowerCase())) continue;
                return token.split("=")[1];
            }
        }
        return "";
    }

    public String fromPentahoRole(String pentahoRole) {
        if (this.roleMap.containsValue(pentahoRole)) {
            for (Map.Entry<String, String> roleEntry : this.roleMap.entrySet()) {
                if (!roleEntry.getValue().equals(pentahoRole)) continue;
                return roleEntry.getKey();
            }
        }
        return pentahoRole;
    }

    private String getRoleAttributeFromProperties() {
        Properties ldapProperties = new Properties();
        try {
            String roleAttribute;
            File propertiesFile = new File(System.getProperty("PentahoSystemPath") + System.getProperty("line.separator") + LDAP_PROPERTIES_FILENAME);
            FileInputStream propertiesInputFile = new FileInputStream(propertiesFile);
            ldapProperties.load(propertiesInputFile);
            if (ldapProperties != null && (roleAttribute = ldapProperties.getProperty(ROLE_ATTRIBUTE_PROPERTY)) != null) {
                return roleAttribute;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DEFAULT_ROLE_ATTRIBUTE_VALUE;
    }
}

