/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceSystemListener;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class DynamicallyPooledDatasourceSystemListener
extends PooledDatasourceSystemListener {
    private IDBDatasourceService datasourceService;

    public IDBDatasourceService getDatasourceService() {
        if (this.datasourceService == null) {
            this.datasourceService = PentahoSystem.get(IDBDatasourceService.class, null);
        }
        return this.datasourceService;
    }

    @Override
    protected DataSource getDataSource(IDatabaseConnection connection) {
        DataSource ds = null;
        try {
            ds = this.getDatasourceService().getDataSource(connection.getName());
        }
        catch (DBDatasourceServiceException e) {
            Logger.error(this, Messages.getInstance().getErrorString("DatasourceSystemListener.ERROR_0003_UNABLE_TO_POOL_DATASOURCE", connection.getName(), e.getMessage()));
        }
        return ds;
    }
}

