/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.pool.ObjectPool;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.NonPooledDatasourceSystemListener;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class PooledDatasourceSystemListener
extends NonPooledDatasourceSystemListener {
    @Override
    protected DataSource getDataSource(IDatabaseConnection connection) {
        Object ds = null;
        try {
            ds = !connection.getAccessType().equals((Object)DatabaseAccessType.JNDI) ? PooledDatasourceHelper.setupPooledDataSource(connection) : PooledDatasourceHelper.getJndiDataSource(connection.getDatabaseName());
        }
        catch (DBDatasourceServiceException e) {
            Logger.error(this, Messages.getInstance().getErrorString("DatasourceSystemListener.ERROR_0003_UNABLE_TO_POOL_DATASOURCE", connection.getName(), e.getMessage()));
        }
        return ds;
    }

    @Override
    protected ICacheManager addCacheRegions() {
        ICacheManager cacheManager = super.addCacheRegions();
        if (!cacheManager.cacheEnabled("JDBC_POOL")) {
            cacheManager.addCacheRegion("JDBC_POOL");
        }
        return cacheManager;
    }

    @Override
    public void shutdown() {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        List objectPools = null;
        objectPools = cacheManager.getAllValuesFromRegionCache("JDBC_POOL");
        Logger.debug(this, "DatasourceSystemListener: Called for shutdown ...");
        try {
            if (objectPools != null) {
                for (ObjectPool objectPool : objectPools) {
                    if (null == objectPool) continue;
                    objectPool.clear();
                }
            }
        }
        catch (Throwable ignored) {
            Logger.error(this, "Failed to clear connection pool: " + ignored.getMessage(), ignored);
        }
        cacheManager.removeRegionCache("JDBC_POOL");
        cacheManager.removeRegionCache("DataSource");
        Logger.debug(this, "DatasourceSystemListener: Completed shutdown.");
    }
}

