/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.output.SimpleContentItem;
import org.pentaho.platform.engine.core.solution.SystemSettingsParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PojoComponent
extends ComponentBase {
    private static final long serialVersionUID = 7064470160805918218L;
    protected Object pojo;
    Map<String, Method> getMethods = new HashMap<String, Method>();
    Map<String, List<Method>> setMethods = new HashMap<String, List<Method>>();
    Method executeMethod = null;
    Method validateMethod = null;
    Method doneMethod = null;
    Method resourcesMethod = null;
    Method runtimeInputsMethod = null;
    Method runtimeOutputsMethod = null;
    Method loggerMethod = null;
    Method sessionMethod = null;
    Method configureMethod = null;

    @Override
    public Log getLogger() {
        return LogFactory.getLog(PojoComponent.class);
    }

    @Override
    public void done() {
        if (this.doneMethod != null && this.pojo != null) {
            try {
                this.doneMethod.invoke(this.pojo, (Object[])null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void callMethod(Method method, Object value) throws Throwable {
        List<Method> methods = Arrays.asList(method);
        this.callMethods(methods, value);
    }

    protected void callMethods(List<Method> methods, Object value) throws Throwable {
        if (value instanceof String) {
            this.callMethodWithString(methods, value.toString());
            return;
        }
        boolean done = false;
        for (Method method : methods) {
            Class<?>[] paramClasses = method.getParameterTypes();
            if (paramClasses.length != 1) {
                throw new GenericSignatureFormatError();
            }
            Class<?> paramclass = paramClasses[0];
            if (value instanceof IPentahoResultSet && paramclass.equals(IPentahoResultSet.class)) {
                done = true;
                method.invoke(this.pojo, (IPentahoResultSet)value);
                break;
            }
            if (value instanceof Boolean && (paramclass.equals(Boolean.class) || paramclass.equals(Boolean.TYPE))) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof Integer && (paramclass.equals(Integer.class) || paramclass.equals(Integer.TYPE))) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof Long && (paramclass.equals(Long.class) || paramclass.equals(Long.TYPE))) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof Double && (paramclass.equals(Double.class) || paramclass.equals(Double.TYPE))) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof Float && (paramclass.equals(Float.class) || paramclass.equals(Float.TYPE))) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof IPentahoStreamSource && paramclass.equals(IPentahoStreamSource.class)) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof Date && paramclass.equals(Date.class)) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof BigDecimal && paramclass.equals(BigDecimal.class)) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof IContentItem && paramclass.equals(IContentItem.class)) {
                done = true;
                method.invoke(this.pojo, value);
                break;
            }
            if (value instanceof IContentItem && paramclass.equals(String.class)) {
                done = true;
                method.invoke(this.pojo, value.toString());
                break;
            }
            if (paramclass.equals(IPentahoSession.class)) {
                done = true;
                method.invoke(this.pojo, (IPentahoSession)value);
                break;
            }
            if (!paramclass.equals(Log.class)) continue;
            done = true;
            method.invoke(this.pojo, (Log)value);
            break;
        }
        if (!done) {
            try {
                methods.get(0).invoke(this.pojo, value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("No implementation of method \"" + Method.class.getName() + "\" takes a " + value.getClass());
            }
        }
    }

    protected void callMethodWithString(List<Method> methodList, String value) throws Throwable {
        Class<?> paramclass;
        Class<?>[] paramClasses;
        boolean done = false;
        value = this.applyInputsToFormat(value);
        for (Method method : methodList) {
            paramClasses = method.getParameterTypes();
            if (paramClasses.length != 1) {
                throw new GenericSignatureFormatError();
            }
            paramclass = paramClasses[0];
            if (!paramclass.equals(String.class)) continue;
            done = true;
            method.invoke(this.pojo, value);
            break;
        }
        if (!done) {
            for (Method method : methodList) {
                paramClasses = method.getParameterTypes();
                if (paramClasses.length != 1) {
                    throw new GenericSignatureFormatError();
                }
                paramclass = paramClasses[0];
                if (paramclass.equals(Boolean.class) || paramclass.equals(Boolean.TYPE)) {
                    done = true;
                    method.invoke(this.pojo, new Boolean(value));
                    break;
                }
                if (paramclass.equals(Integer.class) || paramclass.equals(Integer.TYPE)) {
                    done = true;
                    method.invoke(this.pojo, new Integer(value));
                    break;
                }
                if (paramclass.equals(Long.class) || paramclass.equals(Long.TYPE)) {
                    done = true;
                    method.invoke(this.pojo, new Long(value));
                    break;
                }
                if (paramclass.equals(Double.class) || paramclass.equals(Double.TYPE)) {
                    done = true;
                    method.invoke(this.pojo, new Double(value));
                    break;
                }
                if (paramclass.equals(Float.class) || paramclass.equals(Float.TYPE)) {
                    done = true;
                    method.invoke(this.pojo, new Float(value));
                    break;
                }
                if (!paramclass.equals(BigDecimal.class)) continue;
                done = true;
                method.invoke(this.pojo, new BigDecimal(value));
                break;
            }
        }
        if (!done) {
            throw new GenericSignatureFormatError();
        }
    }

    @Override
    protected boolean executeAction() throws Throwable {
        Boolean ok;
        Object obj;
        Object value;
        List<Method> methods;
        Object value2;
        Set inputNames = this.getInputNames();
        Element defnNode = (Element)this.getComponentDefinition();
        if (this.getMethods.containsKey("CONFIGSETTINGSPATHS") && this.configureMethod != null) {
            Method method = this.getMethods.get("CONFIGSETTINGSPATHS");
            Set settingsPaths = (Set)method.invoke(this.pojo, new Object[0]);
            Iterator keys = settingsPaths.iterator();
            HashMap<String, String> settings = new HashMap<String, String>();
            SystemSettingsParameterProvider params = new SystemSettingsParameterProvider();
            while (keys.hasNext()) {
                String path = (String)keys.next();
                value2 = params.getStringParameter(path, null);
                if (value2 == null) continue;
                settings.put(path, (String)value2);
            }
            this.configureMethod.invoke(this.pojo, settings);
        }
        if (this.sessionMethod != null) {
            this.callMethods(Arrays.asList(this.sessionMethod), this.getSession());
        }
        if (this.loggerMethod != null) {
            this.callMethods(Arrays.asList(this.loggerMethod), this.getLogger());
        }
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        List nodes = defnNode.selectNodes("*");
        for (int idx = 0; idx < nodes.size(); ++idx) {
            Element node = (Element)nodes.get(idx);
            String name = node.getName().replace("-", "").toUpperCase();
            if (name.equals("CLASS") || name.equals("OUTPUTSTREAM")) continue;
            String value3 = node.getText();
            List<Method> method = this.setMethods.get(name);
            if (method != null) {
                this.callMethodWithString(method, value3);
                continue;
            }
            if (this.runtimeInputsMethod != null) {
                inputMap.put(name, value3);
                continue;
            }
            this.getLogger().warn((Object)Messages.getInstance().getString("PojoComponent.UNUSED_INPUT", name));
        }
        Iterator it = null;
        Set resourceNames = this.getResourceNames();
        HashMap<String, IActionSequenceResource> resourceMap = new HashMap<String, IActionSequenceResource>();
        if (resourceNames != null && resourceNames.size() > 0) {
            for (String name : resourceNames) {
                IActionSequenceResource resource = this.getResource(name);
                name = name.replace("-", "");
                resourceMap.put(name, resource);
                methods = this.setMethods.get(name.toUpperCase());
                if (methods == null) continue;
                for (Method method : methods) {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) continue;
                    value = null;
                    if (paramTypes[0] == InputStream.class) {
                        value = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
                    } else if (paramTypes[0] == IActionSequenceResource.class) {
                        value = resource;
                    } else if (paramTypes[0] == String.class) {
                        value = this.getRuntimeContext().getResourceAsString(resource);
                    } else if (paramTypes[0] == Document.class) {
                        value = this.getRuntimeContext().getResourceAsDocument(resource);
                    }
                    this.callMethod(method, value);
                }
            }
        }
        for (String name : inputNames) {
            value2 = this.getInputValue(name);
            methods = this.setMethods.get((name = name.replace("-", "")).toUpperCase());
            if (methods != null) {
                this.callMethods(methods, value2);
                continue;
            }
            if (this.runtimeInputsMethod != null) {
                inputMap.put(name, value2);
                continue;
            }
            this.getLogger().warn((Object)Messages.getInstance().getString("PojoComponent.UNUSED_INPUT", name));
        }
        if (resourceMap.size() > 0 && this.resourcesMethod != null) {
            this.resourcesMethod.invoke(this.pojo, resourceMap);
        }
        if (inputMap.size() > 0 && this.runtimeInputsMethod != null) {
            this.runtimeInputsMethod.invoke(this.pojo, inputMap);
        }
        if (this.getOutputNames().contains("outputstream") && this.setMethods.containsKey("OUTPUTSTREAM") && this.getMethods.containsKey("MIMETYPE")) {
            IContentItem contentItem;
            Method method = this.getMethods.get("MIMETYPE");
            String mimeType = (String)method.invoke(this.pojo, new Object[0]);
            String mappedOutputName = "outputstream";
            if (this.getActionDefinition() != null && this.getActionDefinition().getOutput("outputstream") != null) {
                mappedOutputName = this.getActionDefinition().getOutput("outputstream").getPublicName();
            }
            if (!((contentItem = this.getOutputContentItem(mappedOutputName, mimeType)) instanceof SimpleContentItem)) {
                this.setOutputValue("outputstream", contentItem);
            }
            OutputStream out = contentItem.getOutputStream(this.getActionName());
            method = this.setMethods.get("OUTPUTSTREAM").get(0);
            method.invoke(this.pojo, out);
        }
        if (this.validateMethod != null && (obj = this.validateMethod.invoke(this.pojo, (Object[])null)) instanceof Boolean && !(ok = (Boolean)obj).booleanValue()) {
            return false;
        }
        Boolean result = Boolean.FALSE;
        result = this.executeMethod != null ? (Boolean)this.executeMethod.invoke(this.pojo, new Object[0]) : Boolean.TRUE;
        Set outputNames = this.getOutputNames();
        Map outputMap = new HashMap();
        if (this.runtimeOutputsMethod != null) {
            outputMap = (Map)this.runtimeOutputsMethod.invoke(this.pojo, new Object[0]);
        }
        for (String name : outputNames) {
            if (name.equals("outputstream")) continue;
            IActionParameter param = this.getOutputItem(name);
            Method method = this.getMethods.get(name.toUpperCase());
            if (method != null) {
                value = method.invoke(this.pojo, new Object[0]);
                param.setValue(value);
                continue;
            }
            value = outputMap.get(name);
            if (value != null) {
                param.setValue(value);
                continue;
            }
            throw new NoSuchMethodException(name);
        }
        return result;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    protected boolean validateAction() {
        boolean ok = false;
        if (this.pojo == null && this.isDefinedInput("class")) {
            String className = this.getInputStringValue("class");
            IPluginManager pluginMgr = PentahoSystem.get(IPluginManager.class, this.getSession());
            if (pluginMgr != null && pluginMgr.isBeanRegistered(className)) {
                try {
                    this.pojo = pluginMgr.getBean(className);
                }
                catch (PluginBeanException e) {
                    this.error("Could not load bean class from plugin", e);
                    return false;
                }
            }
            if (this.pojo == null) {
                try {
                    Class<?> aClass = this.getClass().getClassLoader().loadClass(className);
                    this.pojo = aClass.newInstance();
                }
                catch (Exception ex) {
                    this.error("Could not load bean class", ex);
                    return false;
                }
            }
        }
        if (this.pojo != null) {
            try {
                Method[] methods;
                for (Method method : methods = this.pojo.getClass().getMethods()) {
                    String name = method.getName();
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (name.equals("getOutputs")) {
                        this.runtimeOutputsMethod = method;
                        continue;
                    }
                    if (name.equals("setInputs")) {
                        this.runtimeInputsMethod = method;
                        continue;
                    }
                    if (name.equals("setResources")) {
                        this.resourcesMethod = method;
                        continue;
                    }
                    if (name.equals("setLogger")) {
                        if (paramTypes.length != 1 || paramTypes[0] != Log.class) continue;
                        this.loggerMethod = method;
                        continue;
                    }
                    if (name.equals("setSession")) {
                        if (paramTypes.length != 1 || paramTypes[0] != IPentahoSession.class) continue;
                        this.sessionMethod = method;
                        continue;
                    }
                    if (name.equalsIgnoreCase("configure")) {
                        this.configureMethod = method;
                        continue;
                    }
                    if (name.startsWith("set")) {
                        if ((name = name.substring(3).toUpperCase()).equals("CLASS")) {
                            this.warn(Messages.getInstance().getString("PojoComponent.CANNOT_USE_SETCLASS"));
                            continue;
                        }
                        if (!this.setMethods.containsKey(name)) {
                            this.setMethods.put(name, new ArrayList());
                        }
                        this.setMethods.get(name).add(method);
                        continue;
                    }
                    if (name.startsWith("get")) {
                        name = name.substring(3).toUpperCase();
                        this.getMethods.put(name, method);
                        continue;
                    }
                    if (name.equalsIgnoreCase("execute")) {
                        this.executeMethod = method;
                        continue;
                    }
                    if (name.equalsIgnoreCase("validate")) {
                        this.validateMethod = method;
                        continue;
                    }
                    if (!name.equalsIgnoreCase("done")) continue;
                    this.doneMethod = method;
                }
                ok = true;
            }
            catch (Throwable ex) {
                this.error("Could not load object class", ex);
            }
        }
        return ok;
    }

    @Override
    protected boolean validateSystemSettings() {
        return true;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }
}

