/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.uifoundation.chart.CategoryDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;

public class BarLineChartDefinition
extends CategoryDatasetChartDefinition {
    private static final String SERIES_NODE_NAME = "series";
    private static final String BAR_SERIES_NODE_NAME = "bar-series";
    private static final String LINE_SERIES_NODE_NAME = "line-series";
    private static final String LINES_RANGE_TITLE_NODE_NAME = "lines-range-title";
    private static final String LINES_RANGE_TITLE_FONT_NODE_NAME = "lines-range-title-font";
    private static final String LINES_RANGE_TICK_FORMAT_NODE_NAME = "lines-range-tick-format";
    private static final String LINES_RANGE_TICK_FONT_NODE_NAME = "lines-range-tick-font";
    private static final String LINES_RANGE_MINIMUM_NODE_NAME = "lines-range-minimum";
    private static final String LINES_RANGE_MAXIMUM_NODE_NAME = "lines-range-maximum";
    private String[] barColumns;
    private String[] lineColumns;
    private Node chartAttributes;
    private String linesRangeTitle = null;
    private Font linesRangeTitleFont = null;
    private NumberFormat linesRangeTickFormat = null;
    private Font linesRangeTickFont = null;
    private double linesRangeMinimum = 0.0;
    private double linesRangeMaximum = 1.0;
    private static final long serialVersionUID = 1955883428823312855L;

    public BarLineChartDefinition(IPentahoResultSet data, boolean byRow, Node chartAttributes, IPentahoSession session) {
        super(data, byRow, chartAttributes, session);
        this.setChartAttributes(chartAttributes);
        this.setBarSeries(chartAttributes.selectSingleNode(BAR_SERIES_NODE_NAME));
        this.setLineSeries(chartAttributes.selectSingleNode(LINE_SERIES_NODE_NAME));
        this.setLinesRangeTitle(chartAttributes.selectSingleNode(LINES_RANGE_TITLE_NODE_NAME));
        this.setLinesRangeTitleFont(chartAttributes.selectSingleNode(LINES_RANGE_TITLE_FONT_NODE_NAME));
        this.setLinesRangeTickFormat(chartAttributes.selectSingleNode(LINES_RANGE_TICK_FORMAT_NODE_NAME));
        this.setLinesRangeTickFont(chartAttributes.selectSingleNode(LINES_RANGE_TICK_FONT_NODE_NAME));
        this.setLinesRangeMinimum(chartAttributes.selectSingleNode(LINES_RANGE_MINIMUM_NODE_NAME));
        this.setLinesRangeMaximum(chartAttributes.selectSingleNode(LINES_RANGE_MAXIMUM_NODE_NAME));
    }

    public String[] getBarColumns() {
        return this.barColumns;
    }

    public void setBarColumns(String[] barColumns) {
        this.barColumns = barColumns;
    }

    public String[] getLineColumns() {
        return this.lineColumns;
    }

    public void setLineColumns(String[] lineColumns) {
        this.lineColumns = lineColumns;
    }

    public void setBarSeries(Node barSeriesNode) {
        if (barSeriesNode != null) {
            List barNodes = barSeriesNode.selectNodes(SERIES_NODE_NAME);
            String[] bars = new String[barNodes.size()];
            for (int i = 0; i < barNodes.size(); ++i) {
                Node barNode = (Node)barNodes.get(i);
                bars[i] = barNode.getText();
            }
            this.setBarColumns(bars);
        }
    }

    public void setLineSeries(Node lineSeriesNode) {
        if (lineSeriesNode != null) {
            List lineNodes = lineSeriesNode.selectNodes(SERIES_NODE_NAME);
            String[] lines = new String[lineNodes.size()];
            for (int i = 0; i < lineNodes.size(); ++i) {
                Node lineNode = (Node)lineNodes.get(i);
                lines[i] = lineNode.getText();
            }
            this.setLineColumns(lines);
        }
    }

    public Node getChartAttributes() {
        return this.chartAttributes;
    }

    public void setChartAttributes(Node chartAttributes) {
        this.chartAttributes = chartAttributes;
    }

    public String getLinesRangeTitle() {
        return this.linesRangeTitle;
    }

    public void setLinesRangeTitle(Node titleNode) {
        if (titleNode != null) {
            this.setLinesRangeTitle(titleNode.getText());
        }
    }

    public void setLinesRangeTitle(String linesRangeTitle) {
        this.linesRangeTitle = linesRangeTitle;
    }

    public Font getLinesRangeTitleFont() {
        return this.linesRangeTitleFont;
    }

    public void setLinesRangeTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setLinesRangeTitleFont(font);
        }
    }

    public void setLinesRangeTitleFont(Font linesRangeTitleFont) {
        this.linesRangeTitleFont = linesRangeTitleFont;
    }

    public NumberFormat getLinesRangeTickFormat() {
        return this.linesRangeTickFormat;
    }

    public void setLinesRangeTickFormat(NumberFormat linesRangeTickFormat) {
        this.linesRangeTickFormat = linesRangeTickFormat;
    }

    public void setLinesRangeTickFormat(Node tickFormatFontNode) {
        DecimalFormat format;
        if (tickFormatFontNode != null && (format = new DecimalFormat(tickFormatFontNode.getText())) != null) {
            this.setLinesRangeTickFormat(format);
        }
    }

    public Font getLinesRangeTickFont() {
        return this.linesRangeTickFont;
    }

    public void setLinesRangeTickFont(Font linesRangeTickFont) {
        this.linesRangeTickFont = linesRangeTickFont;
    }

    public void setLinesRangeTickFont(Node linesRangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(linesRangeTickFontNode);
        if (font != null) {
            this.setLinesRangeTickFont(font);
        }
    }

    public double getLinesRangeMinimum() {
        return this.linesRangeMinimum;
    }

    public void setLinesRangeMinimum(Node linesRangeMinimumNode) {
        if (linesRangeMinimumNode != null) {
            this.setLinesRangeMinimum(Double.parseDouble(linesRangeMinimumNode.getText()));
        }
    }

    public void setLinesRangeMinimum(double linesRangeMinimum) {
        this.linesRangeMinimum = linesRangeMinimum;
    }

    public double getLinesRangeMaximum() {
        return this.linesRangeMaximum;
    }

    public void setLinesRangeMaximum(Node linesRangeMaximumNode) {
        if (linesRangeMaximumNode != null) {
            this.setLinesRangeMaximum(Double.parseDouble(linesRangeMaximumNode.getText()));
        }
    }

    public void setLinesRangeMaximum(double linesRangeMaximum) {
        this.linesRangeMaximum = linesRangeMaximum;
    }

    public void setNoDataMessage(String msg) {
        this.noDataMessage = msg;
    }
}

