/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.commons.connection.DataUtilities;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.chart.AbstractJFreeChartComponent;
import org.pentaho.platform.uifoundation.chart.CategoryDatasetChartComponent;
import org.pentaho.platform.uifoundation.chart.DashboardWidgetComponent;
import org.pentaho.platform.uifoundation.chart.DialChartComponent;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.PieDatasetChartComponent;
import org.pentaho.platform.uifoundation.chart.TimeSeriesCollectionChartComponent;
import org.pentaho.platform.uifoundation.chart.XYSeriesCollectionChartComponent;
import org.pentaho.platform.uifoundation.chart.XYZSeriesCollectionChartComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;

@Deprecated
public class ChartHelper {
    private static void deprecateWarning() {
        String key = "PentahoSystem.WARN_DEPRECATED_CLASS";
        org.pentaho.platform.engine.core.messages.Messages messages = org.pentaho.platform.engine.core.messages.Messages.getInstance();
        String message = messages.getErrorString(key, ChartHelper.class.getCanonicalName());
        String stackTrace = StringUtils.join((Object[])Thread.currentThread().getStackTrace(), (String)"\n\t");
        Logger.warn(ChartHelper.class, message + "\n\t" + stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean doChart(String actionPath, IParameterProvider parameterProvider, StringBuffer outputStream, IPentahoSession userSession, ArrayList messages, ILogger logger) {
        ChartHelper.deprecateWarning();
        boolean result = true;
        String content = null;
        StringBuffer messageBuffer = new StringBuffer();
        if (logger == null) {
            logger = userSession;
        }
        String outerParams = parameterProvider.getStringParameter("outer-params", null);
        String innerParam = parameterProvider.getStringParameter("inner-param", null);
        String urlDrillTemplate = parameterProvider.getStringParameter("drill-url", null);
        String imageUrl = parameterProvider.getStringParameter("image-url", null);
        String dialValue = parameterProvider.getStringParameter("value", null);
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        if (imageUrl == null) {
            imageUrl = requestContext.getContextPath();
        }
        if (urlDrillTemplate == null) {
            urlDrillTemplate = "";
        }
        int width = (int)parameterProvider.getLongParameter("image-width", 150L);
        int height = (int)parameterProvider.getLongParameter("image-height", 150L);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(urlDrillTemplate);
        String chartTypeStr = parameterProvider.getStringParameter("chart-type", null);
        String datasetType = "CategoryDataset";
        if (chartTypeStr == null || chartTypeStr.length() == 0) {
            try {
                ActionSequenceJCRHelper jcrHelper = new ActionSequenceJCRHelper(userSession);
                Document chartDefinition = jcrHelper.getSolutionDocument(actionPath, RepositoryFilePermission.READ);
                Node chartAttributes = chartDefinition.selectSingleNode("//chart");
                chartTypeStr = chartAttributes.selectSingleNode("chart-type").getText();
                Node datasetTypeNode = chartAttributes.selectSingleNode("dataset-type");
                if (datasetTypeNode != null) {
                    datasetType = datasetTypeNode.getText();
                }
            }
            catch (Exception e) {
                logger.error(Messages.getInstance().getErrorString("ChartHelper.ERROR_0001_IO_PROBLEM_GETTING_CHART_TYPE"), (Throwable)e);
                PentahoSystem.get(IMessageFormatter.class, userSession).formatErrorMessage("text/html", Messages.getInstance().getString("ChartHelper.ERROR_0001_IO_PROBLEM_GETTING_CHART_TYPE"), (List)messages, messageBuffer);
                content = messageBuffer.toString();
                result = false;
            }
        }
        if (chartTypeStr == null || chartTypeStr.length() == 0) {
            logger.error(Messages.getInstance().getString("ChartHelper.ERROR_0002_COULD_NOT_DETERMINE_CHART_TYPE"));
            PentahoSystem.get(IMessageFormatter.class, userSession).formatErrorMessage("text/html", Messages.getInstance().getString("ChartHelper.ERROR_0002_COULD_NOT_DETERMINE_CHART_TYPE"), (List)messages, messageBuffer);
            content = messageBuffer.toString();
            result = false;
        }
        if (!result) {
            outputStream.append(content);
            return result;
        }
        int chartType = JFreeChartEngine.getChartType(chartTypeStr);
        AbstractChartComponent chartComponent = null;
        try {
            if (datasetType.equalsIgnoreCase("TimeSeriesCollection")) {
                chartComponent = new TimeSeriesCollectionChartComponent(chartType, actionPath, width, height, urlFactory, messages);
            } else if (datasetType.equalsIgnoreCase("XYSeriesCollection")) {
                chartComponent = new XYSeriesCollectionChartComponent(chartType, actionPath, width, height, urlFactory, messages);
            } else if (datasetType.equalsIgnoreCase("XYZSeriesCollection")) {
                chartComponent = new XYZSeriesCollectionChartComponent(chartType, actionPath, width, height, urlFactory, messages);
            }
            if (chartComponent == null) {
                switch (chartType) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        chartComponent = new CategoryDatasetChartComponent(chartType, actionPath, width, height, urlFactory, messages);
                        break;
                    }
                    case 2: {
                        chartComponent = new PieDatasetChartComponent(chartType, actionPath, width, height, urlFactory, messages);
                        break;
                    }
                    case 0: {
                        chartComponent = new DialChartComponent(chartType, actionPath, width, height, urlFactory, messages);
                        if (dialValue == null) break;
                        Number numericDialValue = DataUtilities.toNumber((Object)dialValue, (NumberFormat[])new NumberFormat[]{LocaleHelper.getCurrencyFormat(), LocaleHelper.getNumberFormat()});
                        ((DialChartComponent)chartComponent).setValue(numericDialValue.doubleValue());
                        break;
                    }
                    case 12: {
                        chartComponent = new XYZSeriesCollectionChartComponent(chartType, actionPath, width, height, urlFactory, messages);
                        break;
                    }
                    default: {
                        logger.error(Messages.getInstance().getString("ChartHelper.ERROR_0003_INVALID_CHART_TYPE", chartTypeStr, Integer.toString(chartType)));
                        PentahoSystem.get(IMessageFormatter.class, userSession).formatErrorMessage("text/html", Messages.getInstance().getString("ChartHelper.ERROR_0003_INVALID_CHART_TYPE", chartTypeStr, Integer.toString(chartType)), (List)messages, messageBuffer);
                        content = messageBuffer.toString();
                        result = false;
                    }
                }
            }
            if (result && chartComponent != null) {
                try {
                    chartComponent.setLoggingLevel(logger.getLoggingLevel());
                    chartComponent.validate(userSession, null);
                    ((AbstractJFreeChartComponent)chartComponent).setDataAction(actionPath);
                    chartComponent.setUrlTemplate(urlDrillTemplate);
                    String seriesName = parameterProvider.getStringParameter("series-name", null);
                    if (chartComponent instanceof CategoryDatasetChartComponent) {
                        ((CategoryDatasetChartComponent)chartComponent).setSeriesName(seriesName);
                    }
                    String connectionName = parameterProvider.getStringParameter("connection", null);
                    String query = parameterProvider.getStringParameter("query", null);
                    String dataAction = parameterProvider.getStringParameter("data-process", null);
                    try (IPentahoConnection connection = null;){
                        chartComponent.setParamName(innerParam);
                        chartComponent.setParameterProvider("request", parameterProvider);
                        if (connectionName != null && query != null) {
                            connection = PentahoConnectionFactory.getConnection("SQL", connectionName, userSession, logger);
                            try {
                                query = TemplateUtil.applyTemplate(query, TemplateUtil.parametersToProperties(parameterProvider), null);
                                IPentahoResultSet results = connection.executeQuery(query);
                                chartComponent.setValues(results);
                            }
                            finally {
                                boolean results = true;
                            }
                            chartComponent.setUrlTemplate(urlDrillTemplate);
                            if (outerParams != null) {
                                StringTokenizer tokenizer = new StringTokenizer(outerParams, ";");
                                while (tokenizer.hasMoreTokens()) {
                                    chartComponent.addOuterParamName(tokenizer.nextToken());
                                }
                            }
                        } else if (dataAction != null) {
                            ((AbstractJFreeChartComponent)chartComponent).setDataAction(dataAction);
                        }
                        content = chartComponent.getContent("text/html");
                    }
                }
                catch (Throwable e) {
                    logger.error(Messages.getInstance().getErrorString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), e);
                }
            }
            try {
                if (content == null) {
                    PentahoSystem.get(IMessageFormatter.class, userSession).formatErrorMessage("text/html", Messages.getInstance().getErrorString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), (List)messages, messageBuffer);
                    content = messageBuffer.toString();
                    result = false;
                }
                outputStream.append(content);
            }
            catch (Exception e) {
                logger.error(Messages.getInstance().getErrorString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), (Throwable)e);
            }
        }
        finally {
            if (chartComponent != null) {
                chartComponent.dispose();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean doPieChart(String actionPath, IParameterProvider parameterProvider, StringBuffer outputStream, IPentahoSession userSession, ArrayList messages, ILogger logger) {
        ChartHelper.deprecateWarning();
        boolean result = true;
        String outerParams = parameterProvider.getStringParameter("outer-params", null);
        String innerParam = parameterProvider.getStringParameter("inner-param", null);
        String urlDrillTemplate = parameterProvider.getStringParameter("drill-url", null);
        String imageUrl = parameterProvider.getStringParameter("image-url", null);
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        if (imageUrl == null) {
            imageUrl = requestContext.getContextPath();
        }
        if (urlDrillTemplate == null) {
            urlDrillTemplate = "";
        }
        int width = (int)parameterProvider.getLongParameter("image-width", 150L);
        int height = (int)parameterProvider.getLongParameter("image-height", 150L);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(urlDrillTemplate);
        AbstractChartComponent chartComponent = null;
        try {
            chartComponent = new PieDatasetChartComponent(2, actionPath, width, height, urlFactory, messages);
            if (logger != null) {
                chartComponent.setLoggingLevel(logger.getLoggingLevel());
            }
            chartComponent.validate(userSession, null);
            chartComponent.setUrlTemplate(urlDrillTemplate);
            if (outerParams != null) {
                StringTokenizer tokenizer = new StringTokenizer(outerParams, ";");
                while (tokenizer.hasMoreTokens()) {
                    chartComponent.addOuterParamName(tokenizer.nextToken());
                }
            }
            chartComponent.setParamName(innerParam);
            ((AbstractJFreeChartComponent)chartComponent).setDataAction(actionPath);
            chartComponent.setParameterProvider("request", parameterProvider);
            String content = chartComponent.getContent("text/html");
            if (content == null || content.equals("")) {
                content = "&nbsp;";
            }
            outputStream.append(content);
        }
        finally {
            if (chartComponent != null) {
                chartComponent.dispose();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean doDial(String solutionName, String actionPath, String chartName, IParameterProvider parameterProvider, StringBuffer outputStream, IPentahoSession userSession, ArrayList messages, ILogger logger) {
        ChartHelper.deprecateWarning();
        boolean result = true;
        String linkUrl = parameterProvider.getStringParameter("drill-url", null);
        String imageUrl = parameterProvider.getStringParameter("image-url", null);
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        if (imageUrl == null) {
            imageUrl = requestContext.getContextPath();
        }
        if (linkUrl == null) {
            linkUrl = "";
        }
        int width = (int)parameterProvider.getLongParameter("image-width", 150L);
        int height = (int)parameterProvider.getLongParameter("image-height", 150L);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(linkUrl);
        DashboardWidgetComponent widget = null;
        try {
            widget = new DashboardWidgetComponent(1, solutionName + File.separator + actionPath + File.separator + chartName, width, height, urlFactory, messages);
            if (logger != null) {
                widget.setLoggingLevel(logger.getLoggingLevel());
            }
            widget.validate(userSession, null);
            widget.setParameterProvider("request", parameterProvider);
            String value = parameterProvider.getStringParameter("value", "0");
            Number numericValue = DataUtilities.toNumber((Object)value, (NumberFormat[])new NumberFormat[]{LocaleHelper.getCurrencyFormat(), LocaleHelper.getNumberFormat()});
            widget.setValue(numericValue.doubleValue());
            String title = parameterProvider.getStringParameter("title", "");
            widget.setTitle(title);
            String content = widget.getContent("text/html");
            if (content == null) {
                StringBuffer buffer = new StringBuffer();
                PentahoSystem.get(IMessageFormatter.class, userSession).formatErrorMessage("text/html", Messages.getInstance().getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), (List)messages, buffer);
                content = buffer.toString();
                result = false;
            }
            if (content == null || content.equals("")) {
                content = "&nbsp;";
            }
            outputStream.append(content);
        }
        finally {
            if (widget != null) {
                widget.dispose();
            }
        }
        return result;
    }
}

