/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.XYChartDefinition;
import org.pentaho.platform.uifoundation.messages.Messages;

public class XYSeriesCollectionChartDefinition
extends XYSeriesCollection
implements XYChartDefinition {
    private static final long serialVersionUID = 1717509132920946530L;
    private int chartType = -1;
    private String noDataMessage = null;
    private String title = "";
    private RectangleEdge titlePosition = RectangleEdge.TOP;
    private Font titleFont = TextTitle.DEFAULT_FONT;
    private final List subTitles = new ArrayList();
    private Paint chartBackgroundPaint = Color.WHITE;
    private Image chartBackgroundImage = null;
    private boolean borderVisible = false;
    private Paint borderPaint = Color.BLACK;
    private int width = 200;
    private int height = 200;
    private int dotWidth = 5;
    private int dotHeight = 5;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private Paint plotBackgroundPaint = Color.WHITE;
    private Image plotBackgroundImage = null;
    private boolean legendIncluded = true;
    private boolean threeD = false;
    private boolean stacked = false;
    private boolean domainVerticalTickLabels = false;
    private boolean domainIncludesZero = true;
    private boolean domainStickyZero = true;
    private boolean rangeIncludesZero = true;
    private boolean rangeStickyZero = true;
    private Paint[] paintSequence = null;
    private String domainTitle = null;
    private Font domainTitleFont = TextTitle.DEFAULT_FONT;
    private Font domainTickFont = null;
    private NumberFormat domainTickFormat = null;
    private double domainMinimum = 0.0;
    private double domainMaximum = 1.0;
    private String rangeTitle = null;
    private Font rangeTitleFont = TextTitle.DEFAULT_FONT;
    private Font rangeTickFont = null;
    private NumberFormat rangeTickFormat = null;
    private double rangeMinimum = 0.0;
    private double rangeMaximum = 1.0;
    private Font legendFont = null;
    private boolean legendBorderVisible = true;
    private RectangleEdge legendPosition = RectangleEdge.BOTTOM;
    private String lineStyle = "solid";
    private float lineWidth = 1.0f;
    private boolean markersVisible = false;
    private Float backgroundAlpha;
    private Float foregroundAlpha;
    private String tooltipContent = "{1}, {2}";
    private String tooltipYFormat = "0";
    private String tooltipXFormat = "0";
    private IPentahoSession session;

    public XYSeriesCollectionChartDefinition(IPentahoSession session) {
        this.session = session;
    }

    public XYSeriesCollectionChartDefinition(int chartType, IPentahoResultSet data, boolean byRow, IPentahoSession session) {
        this(session);
        this.chartType = chartType;
        if (byRow) {
            this.setDataByRow(data);
        } else {
            this.setDataByColumn(data);
        }
    }

    public XYSeriesCollectionChartDefinition(IPentahoResultSet data, boolean byRow, Node chartAttributes, IPentahoSession session) {
        this(-1, data, byRow, session);
        this.setChartAttributes(chartAttributes);
    }

    public static Log getLogger() {
        return LogFactory.getLog(XYSeriesCollectionChartDefinition.class);
    }

    private void setChartAttributes(Node chartAttributes) {
        List subtitles;
        if (chartAttributes == null) {
            return;
        }
        this.setChartType(chartAttributes.selectSingleNode("chart-type"));
        this.setChartBackground(chartAttributes.selectSingleNode("chart-background"));
        this.setPlotBackground(chartAttributes.selectSingleNode("plot-background"));
        this.setOrientation(chartAttributes.selectSingleNode("orientation"));
        this.setLegendIncluded(chartAttributes.selectSingleNode("include-legend"));
        this.setTitle(chartAttributes.selectSingleNode("title"));
        Node backgroundAlphaNode = chartAttributes.selectSingleNode("background-alpha");
        Node foregroundAlphaNode = chartAttributes.selectSingleNode("foreground-alpha");
        if (backgroundAlphaNode != null) {
            this.setBackgroundAlpha(chartAttributes.selectSingleNode("background-alpha"));
        }
        if (foregroundAlphaNode != null) {
            this.setForegroundAlpha(chartAttributes.selectSingleNode("foreground-alpha"));
        }
        if ((subtitles = chartAttributes.selectNodes("subtitle")) == null || subtitles.isEmpty()) {
            Node subTitlesNode = chartAttributes.selectSingleNode("subtitles");
            if (subTitlesNode != null) {
                subtitles = subTitlesNode.selectNodes("subtitle");
            }
        } else {
            XYSeriesCollectionChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", "subtitle", "subtitles"));
            XYSeriesCollectionChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "subtitle"));
        }
        if (subtitles != null) {
            this.addSubTitles(subtitles);
        }
        this.setPaintSequence(chartAttributes.selectSingleNode("color-palette"));
        this.setStacked(chartAttributes.selectSingleNode("is-stacked"));
        this.setThreeD(chartAttributes.selectSingleNode("is-3D"));
        this.setWidth(chartAttributes.selectSingleNode("width"));
        this.setHeight(chartAttributes.selectSingleNode("height"));
        this.setDotWidth(chartAttributes.selectSingleNode("dot-width"));
        this.setDotHeight(chartAttributes.selectSingleNode("dot-height"));
        this.setDomainVerticalTickLabels(chartAttributes.selectSingleNode("domain-vertical-tick-labels"));
        this.setBorderVisible(chartAttributes.selectSingleNode("border-visible"));
        this.setBorderPaint(JFreeChartEngine.getPaint(chartAttributes.selectSingleNode("border-paint")));
        this.setTitlePosition(chartAttributes.selectSingleNode("title-position"));
        this.setTitleFont(chartAttributes.selectSingleNode("title-font"));
        this.setDomainTitle(chartAttributes.selectSingleNode("domain-title"));
        this.setDomainTitleFont(chartAttributes.selectSingleNode("domain-title-font"));
        this.setDomainTickFont(chartAttributes.selectSingleNode("domain-tick-font"));
        this.setDomainTickFormat(chartAttributes.selectSingleNode("domain-tick-format"));
        this.setRangeTitle(chartAttributes.selectSingleNode("range-title"));
        this.setRangeTitleFont(chartAttributes.selectSingleNode("range-title-font"));
        this.setRangeTickFont(chartAttributes.selectSingleNode("range-tick-font"));
        this.setRangeTickFormat(chartAttributes.selectSingleNode("range-tick-format"));
        this.setDomainMinimum(chartAttributes.selectSingleNode("domain-minimum"));
        this.setDomainMaximum(chartAttributes.selectSingleNode("domain-maximum"));
        this.setRangeMinimum(chartAttributes.selectSingleNode("range-minimum"));
        this.setRangeMaximum(chartAttributes.selectSingleNode("range-maximum"));
        this.setDomainIncludesZero(chartAttributes.selectSingleNode("domain-includes-zero"));
        this.setDomainStickyZero(chartAttributes.selectSingleNode("domain-sticky-zero"));
        this.setRangeIncludesZero(chartAttributes.selectSingleNode("range-includes-zero"));
        this.setRangeStickyZero(chartAttributes.selectSingleNode("range-sticky-zero"));
        this.setLineStyle(chartAttributes.selectSingleNode("line-style"));
        this.setLineWidth(chartAttributes.selectSingleNode("line-width"));
        this.setMarkersVisible(chartAttributes.selectSingleNode("markers-visible"));
        this.setLegendFont(chartAttributes.selectSingleNode("legend-font"));
        this.setLegendBorderVisible(chartAttributes.selectSingleNode("legend-border-visible"));
        this.setLegendPosition(chartAttributes.selectSingleNode("legend-position"));
        this.setTooltipContent(chartAttributes.selectSingleNode("tooltip-content"));
        this.setTooltipYFormat(chartAttributes.selectSingleNode("tooltip-y-format"));
        this.setTooltipXFormat(chartAttributes.selectSingleNode("tooltip-x-format"));
    }

    private void setDataByColumn(IPentahoResultSet data) {
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        boolean firstPass = true;
        String lastSeries = "";
        String seriesName = "";
        Object[] rowData = data.next();
        XYSeries wrkSeries = new XYSeries((Comparable)((Object)seriesName));
        while (rowData != null) {
            seriesName = rowData[0].toString();
            if (firstPass || !seriesName.equalsIgnoreCase(lastSeries)) {
                if (!firstPass) {
                    this.addSeries(wrkSeries);
                }
                wrkSeries = new XYSeries((Comparable)((Object)seriesName));
                lastSeries = seriesName;
                firstPass = false;
            }
            if (rowData[1] instanceof Number && rowData[2] instanceof Number) {
                wrkSeries.add(((Number)rowData[1]).doubleValue(), ((Number)rowData[2]).doubleValue());
            }
            rowData = data.next();
        }
        if (!firstPass) {
            this.addSeries(wrkSeries);
        }
        if (data.getRowCount() > 0 && this.getSeriesCount() <= 0) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT");
        }
    }

    private void setDataByRow(IPentahoResultSet data) {
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        Object[] rowData = data.next();
        while (rowData != null) {
            String seriesName = (String)rowData[0];
            XYSeries wrkSeries = new XYSeries((Comparable)((Object)seriesName));
            for (int column = 1; column < rowData.length - 1; column += 2) {
                wrkSeries.add(((Number)rowData[column]).doubleValue(), ((Number)rowData[column + 1]).doubleValue());
            }
            this.addSeries(wrkSeries);
            rowData = data.next();
        }
        if (data.getRowCount() > 0 && this.getSeriesCount() <= 0) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT");
        }
    }

    public void setChartBackgroundPaint(Paint chartBackgroundPaint) {
        if (chartBackgroundPaint != null) {
            this.chartBackgroundPaint = chartBackgroundPaint;
        }
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setTitleFont(font);
        }
    }

    @Override
    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public int getChartType() {
        return this.chartType;
    }

    public static int getChartType(String typeStr) {
        if (typeStr != null) {
            if ("LineChart".equalsIgnoreCase(typeStr)) {
                return 5;
            }
            if ("AreaChart".equalsIgnoreCase(typeStr)) {
                return 6;
            }
            if ("StepChart".equalsIgnoreCase(typeStr)) {
                return 7;
            }
            if ("StepAreaChart".equalsIgnoreCase(typeStr)) {
                return 8;
            }
            if ("DifferenceChart".equalsIgnoreCase(typeStr)) {
                return 9;
            }
            if ("DotChart".equalsIgnoreCase(typeStr)) {
                return 10;
            }
        }
        return -1;
    }

    public void setChartType(Node chartTypeNode) {
        if (chartTypeNode != null) {
            String typeStr = chartTypeNode.getText();
            this.setChartType(XYSeriesCollectionChartDefinition.getChartType(typeStr));
        }
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    @Override
    public boolean isThreeD() {
        return this.threeD;
    }

    public void setThreeD(Node threeDNode) {
        if (threeDNode != null) {
            String boolStr = threeDNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setThreeD(booleanValue);
        }
    }

    public void setThreeD(boolean threeD) {
        this.threeD = threeD;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(Node stackedNode) {
        if (stackedNode != null) {
            String boolStr = stackedNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setStacked(booleanValue);
        }
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isDomainVerticalTickLabels() {
        return this.domainVerticalTickLabels;
    }

    public void setDomainVerticalTickLabels(Node domainVerticalTickLabelsNode) {
        if (domainVerticalTickLabelsNode != null) {
            String boolStr = domainVerticalTickLabelsNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDomainVerticalTickLabels(booleanValue);
        }
    }

    public void setDomainVerticalTickLabels(boolean domainVerticalTickLabels) {
        this.domainVerticalTickLabels = domainVerticalTickLabels;
    }

    public boolean isDomainIncludesZero() {
        return this.domainIncludesZero;
    }

    public void setDomainIncludesZero(Node domainIncludesZeroNode) {
        if (domainIncludesZeroNode != null) {
            String boolStr = domainIncludesZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDomainIncludesZero(booleanValue);
        }
    }

    public void setDomainIncludesZero(boolean domainIncludesZero) {
        this.domainIncludesZero = domainIncludesZero;
    }

    public boolean isDomainStickyZero() {
        return this.domainStickyZero;
    }

    public void setDomainStickyZero(Node domainStickyZeroNode) {
        if (domainStickyZeroNode != null) {
            String boolStr = domainStickyZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDomainStickyZero(booleanValue);
        }
    }

    public void setDomainStickyZero(boolean domainStickyZero) {
        this.domainStickyZero = domainStickyZero;
    }

    public boolean isRangeIncludesZero() {
        return this.rangeIncludesZero;
    }

    public void setRangeIncludesZero(Node rangeIncludesZeroNode) {
        if (rangeIncludesZeroNode != null) {
            String boolStr = rangeIncludesZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setRangeIncludesZero(booleanValue);
        }
    }

    public void setRangeIncludesZero(boolean rangeIncludesZero) {
        this.rangeIncludesZero = rangeIncludesZero;
    }

    public boolean isRangeStickyZero() {
        return this.rangeStickyZero;
    }

    public void setRangeStickyZero(Node rangeStickyZeroNode) {
        if (rangeStickyZeroNode != null) {
            String boolStr = rangeStickyZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setRangeStickyZero(booleanValue);
        }
    }

    public void setRangeStickyZero(boolean rangeStickyZero) {
        this.rangeStickyZero = rangeStickyZero;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(Node heightNode) {
        if (heightNode != null) {
            this.setHeight(Integer.parseInt(heightNode.getText()));
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(Node widthNode) {
        if (widthNode != null) {
            this.setWidth(Integer.parseInt(widthNode.getText()));
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getDotHeight() {
        return this.dotHeight;
    }

    public void setDotHeight(Node heightNode) {
        if (heightNode != null) {
            this.setDotHeight(Integer.parseInt(heightNode.getText()));
        }
    }

    public void setDotHeight(int height) {
        this.dotHeight = height;
    }

    public int getDotWidth() {
        return this.dotWidth;
    }

    public void setDotWidth(Node widthNode) {
        if (widthNode != null) {
            this.setDotWidth(Integer.parseInt(widthNode.getText()));
        }
    }

    public void setDotWidth(int width) {
        this.dotWidth = width;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(Node chartTitleNode) {
        if (chartTitleNode != null) {
            this.setTitle(chartTitleNode.getText());
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Paint[] getPaintSequence() {
        return this.paintSequence;
    }

    public void setPaintSequence(Node paletteNode) {
        if (paletteNode != null) {
            List colorNodes = paletteNode.selectNodes("color");
            Paint[] paints = new Paint[colorNodes.size()];
            for (int i = 0; i < colorNodes.size(); ++i) {
                paints[i] = JFreeChartEngine.getPaint((Node)colorNodes.get(i));
            }
            this.setPaintSequence(paints);
        }
    }

    public void setPaintSequence(Paint[] paintSequence) {
        this.paintSequence = paintSequence;
    }

    @Override
    public List getSubtitles() {
        return this.subTitles;
    }

    public void addSubTitles(List subTitleNodes) {
        if (subTitleNodes != null) {
            Iterator iter = subTitleNodes.iterator();
            while (iter.hasNext()) {
                this.addSubTitle(((Node)iter.next()).getText());
            }
        }
    }

    public void addSubTitle(String subTitle) {
        this.subTitles.add(subTitle);
    }

    @Override
    public Image getChartBackgroundImage() {
        return this.chartBackgroundImage;
    }

    public void setChartBackgroundImage(Node chartBackgroundImageNode) {
        this.setChartBackgroundImage(JFreeChartEngine.getImage(chartBackgroundImageNode, this.getSession()));
    }

    public void setChartBackgroundImage(Image chartBackgroundImage) {
        this.chartBackgroundImage = chartBackgroundImage;
    }

    @Override
    public boolean isLegendIncluded() {
        return this.legendIncluded;
    }

    public void setLegendIncluded(Node legendNode) {
        if (legendNode != null) {
            String boolStr = legendNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setLegendIncluded(booleanValue);
        }
    }

    public void setLegendIncluded(boolean legendIncluded) {
        this.legendIncluded = legendIncluded;
    }

    public void setPlotBackgroundPaint(Paint plotBackgroundPaint) {
        if (plotBackgroundPaint != null) {
            this.plotBackgroundPaint = plotBackgroundPaint;
        }
    }

    @Override
    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    @Override
    public Image getPlotBackgroundImage() {
        return this.plotBackgroundImage;
    }

    public void setPlotBackgroundImage(Node plotBackgroundImageNode) {
        this.setPlotBackgroundImage(JFreeChartEngine.getImage(plotBackgroundImageNode, this.getSession()));
    }

    public void setPlotBackgroundImage(Image plotBackgroundImage) {
        this.plotBackgroundImage = plotBackgroundImage;
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Node orientationNode) {
        if (orientationNode != null) {
            String orientationStr = orientationNode.getText();
            if ("Vertical".equalsIgnoreCase(orientationStr)) {
                this.setOrientation(PlotOrientation.VERTICAL);
            } else if ("Horizontal".equalsIgnoreCase(orientationStr)) {
                this.setOrientation(PlotOrientation.HORIZONTAL);
            }
        }
    }

    public void setOrientation(PlotOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(Node borderVisibleNode) {
        if (borderVisibleNode != null) {
            String boolStr = borderVisibleNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setBorderVisible(booleanValue);
        }
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    @Override
    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.borderPaint = borderPaint;
    }

    private RectangleEdge getPosition(Node positionNode) {
        if (positionNode != null) {
            String positionStr = positionNode.getText();
            if ("top".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.TOP;
            }
            if ("left".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.LEFT;
            }
            if ("bottom".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.BOTTOM;
            }
            if ("right".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.RIGHT;
            }
        }
        return null;
    }

    public void setTitlePosition(Node titlePositionNode) {
        RectangleEdge position = this.getPosition(titlePositionNode);
        if (position != null) {
            this.setTitlePosition(position);
        }
    }

    @Override
    public RectangleEdge getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(RectangleEdge titlePosition) {
        this.titlePosition = titlePosition;
    }

    public void setLegendPosition(Node legendPositionNode) {
        RectangleEdge position = this.getPosition(legendPositionNode);
        if (position != null) {
            this.setLegendPosition(position);
        }
    }

    @Override
    public RectangleEdge getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(RectangleEdge legendPosition) {
        this.legendPosition = legendPosition;
    }

    public void setChartBackground(Node chartBackgroundNode) {
        Node backgroundTypeNode;
        if (chartBackgroundNode != null && (backgroundTypeNode = chartBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getPaint(chartBackgroundNode));
                this.setChartBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundImage(chartBackgroundNode);
                this.setChartBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getTexturePaint(chartBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setChartBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getGradientPaint(chartBackgroundNode, this.getWidth(), this.getHeight()));
                this.setChartBackgroundImage((Image)null);
            }
        }
    }

    public void setPlotBackground(Node plotBackgroundNode) {
        Node backgroundTypeNode;
        if (plotBackgroundNode != null && (backgroundTypeNode = plotBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getPaint(plotBackgroundNode));
                this.setPlotBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundImage(plotBackgroundNode);
                this.setPlotBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getTexturePaint(plotBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setPlotBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getGradientPaint(plotBackgroundNode, this.getWidth(), this.getHeight()));
                this.setPlotBackgroundImage((Image)null);
            }
        }
    }

    public void setDomainTitle(Node titleNode) {
        if (titleNode != null) {
            this.setDomainTitle(titleNode.getText());
        }
    }

    public String getDomainTitle() {
        return this.domainTitle;
    }

    public void setDomainTitle(String domainTitle) {
        this.domainTitle = domainTitle;
    }

    public void setRangeTitle(Node titleNode) {
        if (titleNode != null) {
            this.setRangeTitle(titleNode.getText());
        }
    }

    public String getRangeTitle() {
        return this.rangeTitle;
    }

    public void setRangeTitle(String rangeTitle) {
        this.rangeTitle = rangeTitle;
    }

    public void setDomainTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setDomainTitleFont(font);
        }
    }

    public Font getDomainTitleFont() {
        return this.domainTitleFont;
    }

    public void setDomainTitleFont(Font domainTitleFont) {
        this.domainTitleFont = domainTitleFont;
    }

    public Font getDomainTickFont() {
        return this.domainTickFont;
    }

    public void setDomainTickFont(Font domainTickFont) {
        this.domainTickFont = domainTickFont;
    }

    public void setDomainTickFont(Node rangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(rangeTickFontNode);
        if (font != null) {
            this.setDomainTickFont(font);
        }
    }

    public NumberFormat getDomainTickFormat() {
        return this.domainTickFormat;
    }

    public void setDomainTickFormat(NumberFormat domainTickFormat) {
        this.domainTickFormat = domainTickFormat;
    }

    public void setDomainTickFormat(Node tickFormatFontNode) {
        DecimalFormat format;
        if (tickFormatFontNode != null && (format = new DecimalFormat(tickFormatFontNode.getText())) != null) {
            this.setDomainTickFormat(format);
        }
    }

    public void setRangeTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setRangeTitleFont(font);
        }
    }

    public Font getRangeTitleFont() {
        return this.rangeTitleFont;
    }

    public void setRangeTitleFont(Font rangeTitleFont) {
        this.rangeTitleFont = rangeTitleFont;
    }

    public NumberFormat getRangeTickFormat() {
        return this.rangeTickFormat;
    }

    public void setRangeTickFormat(NumberFormat rangeTickFormat) {
        this.rangeTickFormat = rangeTickFormat;
    }

    public void setRangeTickFormat(Node tickFormatFontNode) {
        DecimalFormat format;
        if (tickFormatFontNode != null && (format = new DecimalFormat(tickFormatFontNode.getText())) != null) {
            this.setRangeTickFormat(format);
        }
    }

    public Font getRangeTickFont() {
        return this.rangeTickFont;
    }

    public void setRangeTickFont(Font rangeTickFont) {
        this.rangeTickFont = rangeTickFont;
    }

    public void setRangeTickFont(Node rangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(rangeTickFontNode);
        if (font != null) {
            this.setRangeTickFont(font);
        }
    }

    @Override
    public boolean isDisplayLabels() {
        return false;
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setLineStyle(Node lineStyleNode) {
        if (lineStyleNode != null) {
            this.setLineStyle(lineStyleNode.getText());
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineWidth(Node lineWidthNode) {
        if (lineWidthNode != null) {
            this.setLineWidth(Float.parseFloat(lineWidthNode.getText()));
        }
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    public boolean isMarkersVisible() {
        return this.markersVisible;
    }

    public void setMarkersVisible(boolean markersVisible) {
        this.markersVisible = markersVisible;
    }

    public void setMarkersVisible(Node markersVisibleNode) {
        if (markersVisibleNode != null) {
            String boolStr = markersVisibleNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setMarkersVisible(booleanValue);
        }
    }

    @Override
    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public void setLegendFont(Node legendFontNode) {
        Font font = JFreeChartEngine.getFont(legendFontNode);
        if (font != null) {
            this.setLegendFont(font);
        }
    }

    public void setLegendBorderVisible(Node legendBorderVisibleNode) {
        if (legendBorderVisibleNode != null) {
            boolean legBorderVisible = new Boolean(legendBorderVisibleNode.getText());
            this.setLegendBorderVisible(legBorderVisible);
        }
    }

    public void setLegendBorderVisible(boolean legendBorderVisible) {
        this.legendBorderVisible = legendBorderVisible;
    }

    @Override
    public boolean isLegendBorderVisible() {
        return this.legendBorderVisible;
    }

    public double getRangeMinimum() {
        return this.rangeMinimum;
    }

    public void setRangeMinimum(Node rangeMinimumNode) {
        if (rangeMinimumNode != null) {
            this.setRangeMinimum(Double.parseDouble(rangeMinimumNode.getText()));
        }
    }

    public void setRangeMinimum(double rangeMinimum) {
        this.rangeMinimum = rangeMinimum;
    }

    public double getRangeMaximum() {
        return this.rangeMaximum;
    }

    public void setRangeMaximum(Node rangeMaximumNode) {
        if (rangeMaximumNode != null) {
            this.setRangeMaximum(Double.parseDouble(rangeMaximumNode.getText()));
        }
    }

    public void setRangeMaximum(double rangeMaximum) {
        this.rangeMaximum = rangeMaximum;
    }

    public double getDomainMinimum() {
        return this.domainMinimum;
    }

    public void setDomainMinimum(Node domainMinimumNode) {
        if (domainMinimumNode != null) {
            this.setDomainMinimum(Double.parseDouble(domainMinimumNode.getText()));
        }
    }

    public void setDomainMinimum(double domainMinimum) {
        this.domainMinimum = domainMinimum;
    }

    public double getDomainMaximum() {
        return this.domainMaximum;
    }

    public void setDomainMaximum(Node domainMaximumNode) {
        if (domainMaximumNode != null) {
            this.setDomainMaximum(Double.parseDouble(domainMaximumNode.getText()));
        }
    }

    public void setDomainMaximum(double domainMaximum) {
        this.domainMaximum = domainMaximum;
    }

    @Override
    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public String getTooltipContent() {
        return this.tooltipContent;
    }

    public void setTooltipContent(String tooltipContent) {
        this.tooltipContent = tooltipContent;
    }

    public String getTooltipXFormat() {
        return this.tooltipXFormat;
    }

    public void setTooltipXFormat(String tooltipXFormat) {
        this.tooltipXFormat = tooltipXFormat;
    }

    public String getTooltipYFormat() {
        return this.tooltipYFormat;
    }

    public void setTooltipYFormat(String tooltipYFormat) {
        this.tooltipYFormat = tooltipYFormat;
    }

    public void setTooltipContent(Node node) {
        if (node != null) {
            this.setTooltipContent(node.getText());
        }
    }

    public void setTooltipXFormat(Node node) {
        if (node != null) {
            this.setTooltipXFormat(node.getText());
        }
    }

    public void setTooltipYFormat(Node node) {
        if (node != null) {
            this.setTooltipYFormat(node.getText());
        }
    }

    @Override
    public Float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(Node backgroundAlphaNode) {
        if (backgroundAlphaNode != null) {
            Float backgroundAlphaValue;
            this.backgroundAlpha = backgroundAlphaValue = new Float(backgroundAlphaNode.getText());
        }
    }

    @Override
    public Float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(Node foregroundAlphaNode) {
        if (foregroundAlphaNode != null) {
            Float foregroundAlphaValue;
            this.foregroundAlpha = foregroundAlphaValue = new Float(foregroundAlphaNode.getText());
        }
    }
}

