/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.connection;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;

public class JdbcConnectionDefinitionManager {
    private static final Log log = LogFactory.getLog(JdbcConnectionDefinitionManager.class);
    private static final JdbcConnectionDefinition SAMPLE_DATA_JNDI_SOURCE = new JndiConnectionDefinition("SampleData", "SampleData", "Hypersonic", null, null);
    private static final JdbcConnectionDefinition SAMPLE_DATA_DRIVER_SOURCE = new DriverConnectionDefinition("SampleData (Hypersonic)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost:9001/sampledata", "pentaho_user", "password");
    private static final JdbcConnectionDefinition SAMPLE_DATA_MEMORY_SOURCE = new DriverConnectionDefinition("SampleData (Memory)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:SampleData", "pentaho_user", "password");
    private static final JdbcConnectionDefinition LOCAL_SAMPLE_DATA_DRIVER_SOURCE = new DriverConnectionDefinition("SampleData (Local)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:./resources/sampledata/sampledata", "pentaho_user", "password");
    private static final JdbcConnectionDefinition MYSQL_SAMPLE_DATA_DRIVER_SOURCE = new DriverConnectionDefinition("SampleData (MySQL)", "com.mysql.jdbc.Driver", "jdbc:mysql://localhost:3306/sampledata", "pentaho_user", "password");
    private static final String DATASOURCE_PREFERENCES_NODE = "org/pentaho/reporting/ui/datasources/jdbc/Settings";
    private TreeMap<String, JdbcConnectionDefinition> connectionDefinitions = new TreeMap();
    private final Preferences userPreferences;
    private static final String TYPE_KEY = "type";
    private static final String DRIVER_KEY = "driver";
    private static final String URL_KEY = "url";
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String PORT_KEY = "port";
    private static final String DATABASE_TYPE_KEY = "database_type";
    private static final String DATABASE_NAME_KEY = "database_name";
    private static final String JNDI_LOCATION = "jndi-location";

    public JdbcConnectionDefinitionManager() {
        this(DATASOURCE_PREFERENCES_NODE);
    }

    public JdbcConnectionDefinitionManager(String node) {
        this(Preferences.userRoot().node(node), node);
    }

    JdbcConnectionDefinitionManager(Preferences externalPreferences, String node) {
        this.userPreferences = externalPreferences;
        try {
            String[] childNodeNames = this.userPreferences.childrenNames();
            for (int i = 0; i < childNodeNames.length; ++i) {
                String name = childNodeNames[i];
                Preferences p = this.userPreferences.node(name);
                String type = p.get(TYPE_KEY, null);
                if (type == null) {
                    p.removeNode();
                    continue;
                }
                if (type.equals("local")) {
                    Properties props = new Properties();
                    if (p.nodeExists("properties")) {
                        Preferences preferences = p.node("properties");
                        String[] strings = preferences.keys();
                        for (int j = 0; j < strings.length; ++j) {
                            String string = strings[j];
                            String value = preferences.get(string, null);
                            if (value != null) {
                                props.setProperty(string, value);
                                continue;
                            }
                            props.remove(string);
                        }
                    }
                    DriverConnectionDefinition driverConnection = new DriverConnectionDefinition(name, p.get(DRIVER_KEY, null), p.get(URL_KEY, null), p.get(USERNAME_KEY, null), p.get(PASSWORD_KEY, null), p.get(HOSTNAME_KEY, null), p.get(DATABASE_NAME_KEY, null), p.get(DATABASE_TYPE_KEY, null), p.get(PORT_KEY, null), props);
                    this.connectionDefinitions.put(name, driverConnection);
                    continue;
                }
                if (type.equals("jndi")) {
                    JndiConnectionDefinition connectionDefinition = new JndiConnectionDefinition(name, p.get(JNDI_LOCATION, null), p.get(DATABASE_TYPE_KEY, null), p.get(USERNAME_KEY, null), p.get(PASSWORD_KEY, null));
                    this.connectionDefinitions.put(name, connectionDefinition);
                    continue;
                }
                p.removeNode();
            }
        }
        catch (BackingStoreException e) {
            log.warn((Object)"Could not access the user prefererences while loading the JNDI connection information - using default JNDI connection entries", (Throwable)e);
        }
        catch (Exception e) {
            log.warn((Object)"Configuration information was invalid.", (Throwable)e);
        }
        if (this.connectionDefinitions.isEmpty() && DATASOURCE_PREFERENCES_NODE.equals(node)) {
            if (this.userPreferences.getBoolean("sample-data-created", false)) {
                return;
            }
            this.updateSourceList(SAMPLE_DATA_JNDI_SOURCE);
            this.updateSourceList(SAMPLE_DATA_DRIVER_SOURCE);
            this.updateSourceList(SAMPLE_DATA_MEMORY_SOURCE);
            this.updateSourceList(LOCAL_SAMPLE_DATA_DRIVER_SOURCE);
            this.updateSourceList(MYSQL_SAMPLE_DATA_DRIVER_SOURCE);
            this.userPreferences.putBoolean("sample-data-created", true);
            try {
                this.userPreferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    public JdbcConnectionDefinition[] getSources() {
        return this.connectionDefinitions.values().toArray(new JdbcConnectionDefinition[this.connectionDefinitions.size()]);
    }

    public void removeSource(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The provided name is invalid");
        }
        this.connectionDefinitions.remove(name);
        try {
            Preferences node = this.userPreferences.node(name);
            if (node != null) {
                node.removeNode();
                this.userPreferences.flush();
            }
        }
        catch (BackingStoreException e) {
            log.error((Object)("Could not remove JNDI connection entry [" + name + ']'), (Throwable)e);
        }
    }

    public boolean updateSourceList(JdbcConnectionDefinition source) {
        if (source == null) {
            throw new IllegalArgumentException("The provided source is null");
        }
        if (source instanceof DriverConnectionDefinition) {
            return this.updateSourceList((DriverConnectionDefinition)source);
        }
        if (source instanceof JndiConnectionDefinition) {
            return this.updateSourceList((JndiConnectionDefinition)source);
        }
        throw new IllegalArgumentException("The provided source is not a supported type");
    }

    private boolean updateSourceList(DriverConnectionDefinition source) throws IllegalArgumentException {
        if (source == null) {
            throw new IllegalArgumentException("The provided source is null");
        }
        boolean updateExisting = this.connectionDefinitions.put(source.getName(), source) != null;
        try {
            Preferences node = this.userPreferences.node(source.getName());
            JdbcConnectionDefinitionManager.put(node, TYPE_KEY, "local");
            JdbcConnectionDefinitionManager.put(node, DRIVER_KEY, source.getDriverClass());
            JdbcConnectionDefinitionManager.put(node, URL_KEY, source.getConnectionString());
            JdbcConnectionDefinitionManager.put(node, USERNAME_KEY, source.getUsername());
            JdbcConnectionDefinitionManager.put(node, PASSWORD_KEY, source.getPassword());
            JdbcConnectionDefinitionManager.put(node, HOSTNAME_KEY, source.getHostName());
            JdbcConnectionDefinitionManager.put(node, PORT_KEY, source.getPort());
            JdbcConnectionDefinitionManager.put(node, DATABASE_TYPE_KEY, source.getDatabaseType());
            JdbcConnectionDefinitionManager.put(node, DATABASE_NAME_KEY, source.getDatabaseName());
            Preferences preferences = node.node("properties");
            Properties properties = source.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                JdbcConnectionDefinitionManager.put(preferences, String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            node.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)("Could not add/update connection entry [" + source.getName() + ']'), (Throwable)e);
        }
        return updateExisting;
    }

    private static void put(Preferences node, String key, String value) {
        if (value == null) {
            node.remove(key);
        } else {
            node.put(key, value);
        }
    }

    private boolean updateSourceList(JndiConnectionDefinition source) throws IllegalArgumentException {
        if (source == null) {
            throw new IllegalArgumentException("The provided source is null");
        }
        boolean updateExisting = this.connectionDefinitions.put(source.getName(), source) != null;
        try {
            Preferences node = this.userPreferences.node(source.getName());
            JdbcConnectionDefinitionManager.put(node, TYPE_KEY, "jndi");
            JdbcConnectionDefinitionManager.put(node, JNDI_LOCATION, source.getJndiName());
            JdbcConnectionDefinitionManager.put(node, USERNAME_KEY, null);
            JdbcConnectionDefinitionManager.put(node, PASSWORD_KEY, null);
            JdbcConnectionDefinitionManager.put(node, DATABASE_TYPE_KEY, source.getDatabaseType());
            node.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)("Could not add/update connection entry [" + source.getName() + ']'), (Throwable)e);
        }
        return updateExisting;
    }
}

